/*
 *   Trans92 - programme de communication Linux-TI92
 *
 *   copyright (c) 1998  Emmanuel Beffara
 *
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <iostream.h>
#include <iomanip.h>
#include <fstream.h>
#include <strstream.h>
#include <string.h>

#include "ti92.h"
#include "tifile.h"


//// classe spcifique Trans92, drivant de TI92

class Trans92 : public TI92 {
  char *fmtNom;
  bool quiet;
public:
  long tbkp;

  Trans92(char *dev,char *fmt,bool q) : TI92(dev)
    { fmtNom=fmt; quiet=q; tbkp=0; }
  ~Trans92() { /*delete str*/ }
  int entreeDir(char*,Type,unsigned short);
  int recepVar(Variable&);
  void etapeRecBkp(long);
  void finRecBkp();
  void etapeEnvBkp(long);
  void finEnvBkp();
};

int Trans92::entreeDir(char *nom,Type tp,unsigned short tv)
{
  if (tp==Rep)
    cout << "  " << nom << "\\\n";
  else {
    int j; bool v;
    cout << "    ";
    v=false;
    for (j=0;j<8;j++) {
      if (nom[j]==0) v=true;
      if (v) cout.put(' ');
      else cout.put(nom[j]);
    }
    if ((int)tp>0x1F) { cout << endl; return 1; }
    cout << "  " << tTypes[tp] << " " << setw(5) << tv << " octet" <<
      (tv==1?(char)0:'s') << endl;
  }
  return 0;
}

int Trans92::recepVar(Variable &v)
{
  strstream nf;
  char *pf,*p,*pNom,*pRep;

  if (!quiet)
    cout << v.nom;
  
  pRep=pNom=v.nom;
  while (*pNom!='\\' && *pNom!=0) pNom++;
  if (*pNom=='\\') pNom++;
  else { pRep=pNom; pNom=v.nom; }

  for (pf=fmtNom;*pf!=0;pf++)
    if (*pf=='%')
      switch (*(++pf)) {
      case 'n' : nf << pNom; break;
      case 'r' : for (p=pRep;*p!='\\' && *p!=0;p++) nf<<(*p); break;
      case 't' : nf << tSuff[v.type]; break;
      case 'T' : nf << tTypes[v.type]; break;
      case '%' : nf << '%'; break;
      default : nf << '%' << *pf;
      }
    else
      nf << *pf;
  nf << ends;
  nf.freeze(1);
  if (!quiet)
    cout << " => " << nf.str() << endl;
  ofstream f(nf.str());
  if (!f) return 1;
  
  TIFile().ecris(v,f);
  if (!f) return 2;
  return 0;
}

void Trans92::etapeRecBkp(long t)
{
  if (!quiet)
    cout << "\rreception de backup : " << t << " octets";
}

void Trans92::finRecBkp()
{
  if (!quiet)
    cout << endl;
}

void Trans92::etapeEnvBkp(long t)
{
  if (!quiet)
    cout << "\renvoi de backup : " << t << " octets sur " << tbkp;
}

void Trans92::finEnvBkp()
{
  if (!quiet)
    cout << endl;
}



//// programme principal

enum Commande { RIEN=-1, HELP,
		TEST, VERSION, LS, GET, PUT, SYNCGET, SYNCPUT,
		GETBKP, PUTBKP,
		NBCOM };
const char *nCom[]={ "help", "test", "version", "ls", "get", "put",
		     "syncget", "syncput", "getbkp", "putbkp" };

int main(int argc,char *argv[])
{
  char *dev="/dev/cua1",*fmt="%n.92%t";
  bool quiet=false,nrep=true,vrom=true;
  Commande com=RIEN;

  int i,j,r;
  
  for (j=1;j<argc && argv[j][0]=='-';j++)
    switch (argv[j][1]) {
    case 'd' : dev=argv[j]+2; break;
    case 'f' : fmt=argv[j]+2; break;
    case 'R' : nrep=false; break;
    case 'V' : vrom=false; break;
    case 'q' : quiet=true; break;
    default :
      cerr << argv[0] << ": option `" << argv[j] << "' inconnue\n";
    }
  
  if (argc==j) {
    cerr << argv[0] << "\
: commande obligatoire\n\
pour un descriptif, `" << argv[0] << " help'\n";
    return -1;
  }

  for (i=0;i<NBCOM && com==RIEN;i++)
    if (!strcmp(argv[j],nCom[i]))
      com=(Commande)i;
  if (com==RIEN) {
    cerr << argv[0] << ": commande `" << argv[1] << "' inconnue\n";
    return 1;
  }
  j++;

  if (com==HELP) {
    cout << "\
Ceci est Trans92 version 1.0
Syntaxe : " << argv[0] << " [options] <commande> [fichiers]\n\
commandes : \n\
    help : ceci\n\
    test : test de connexion\n\
    version : lecture de la version de la ROM\n\
    ls : liste le contenu de la TI\n\
    get : lecture de variables (remote control)\n\
    put : criture de variables (remote control)\n\
    syncget : lecture de variables (transmission synchronise)\n\
    syncput : criture de variables (transmission synchronise)\n\
    getbkp : rception de backup\n\
    putbkp : envoi de backup\n\
options :
    -d<dev> : spcifie le port de communication (par dfaut /dev/cua1)\n\
    -f<fmt> : spcifie le formatage des noms de fichiers\n\
              (pour get / syncget, par dfaut `%n.92%t')\n\
    -R : ne pas spcifier de rpertoire (en envoi synchronis)\n\
    -V : ne pas vrifier la version de la ROM (en envoi de backup)\n\
    -q : quiet mode (c'est--dire sans affichage)\n";
    return 0;
  }

  Trans92 ti(dev,fmt,quiet);
  if (!ti) {
    cerr << argv[0] << ": impossible d'ouvrir `" << dev << "'\n";
    return 4;
  }

  switch (com) {
  case TEST :
    if (argc>j) cerr << argv[0] << ": trop d'options\n";
    if (!quiet)
      cout << "test de connexion ... ";
    r=ti.testLink();
    if (r) {
      if (!quiet)
	cout << "erreur " << r << endl;
      return r;
    }
    if (!quiet)
      cout << "ok\n";
    return 0;

  case VERSION : {
    char *nv;
    if (argc>j) cerr << argv[0] << ": trop d'options\n";
    r=ti.version(nv);
    if (r) {
      cerr << "erreur " << r << endl;
      return r;
    }
    if (!quiet)
      cout << "version de la ROM : ";
    cout << nv << endl;
    return 0; }

  case LS :
    if (argc>j) cerr << argv[0] << ": trop d'options\n";
    r=ti.contenu();
    if (r) {
      cerr << "erreur " << r << endl;
      return r;
    }
    return 0;

  case GET : {
    TI92::Variable v;
    for (;j<argc;j++) {
      r=ti.prends(argv[j],v);
      if (r) {
	cerr << argv[0] << ": erreur de transmission " << r << '\n';
	return r;
      }
      r=ti.recepVar(v);
      if (r) {
	cerr << argv[0] << ": erreur de transmission " << r << '\n';
	return r;
      }
    }
    return 0; }

  case SYNCGET :
    if (argc>j) cerr << argv[0] << ": trop d'options\n";
    if (!quiet)
      cout << "rception :\n";
    r=ti.reception();
    if (r) {
      cerr << argv[0] << ": erreur de rception " << r << '\n';
      return r;
    }
    return 0;
    
  case PUT :
  case SYNCPUT : {
    TI92::Variable v;
    for (;j<argc;j++) {
      ifstream f(argv[j]);
      if (!f) {
	cerr << argv[0] << ": erreur de lecture sur `"
	     << argv[j] << "'\n";
	return 2;
      }
      if (!quiet) cout << argv[j];
      r=TIFile().lis(f,v,nrep);
      if (r) {
	cerr << "\r" << argv[0] << ": erreur de format " << r << endl;
	return r;
      }
      if (v.type==TI92::Backup) {
	if (!quiet)
	  cout << " : pour envoyer un backup, utiliser putbkp\n";
      } else if (v.type==TI92::Groupe) {
	if (!quiet)
	  cout << " : les groupes ne sont pas supports actuellement\n";
      } else {
	if (!quiet)
	  cout << " (" << v.nom << ")\n";
	if (com==PUT)
	  r=ti.mets(v);
	else
	  r=ti.envoi(v);
	if (r) {
	  cerr << argv[0] << ": erreur de transmission " << r << endl;
	  return r;
	}
      }
    }
    if (com==SYNCPUT) {
      r=ti.finEnvoi();
      if (r) cerr << argv[0] << ": erreur de transmission "
		  << r << endl;
    }
    return r; }

  case GETBKP :
    if (j==argc) {
      cerr << argv[0] << ": nom de fichier ncessaire\n";
      return 1;
    }
    if (j>argc+1) cerr << argv[0] << ": trop d'options\n";
    { TI92::Variable v;
    r=ti.recBackup(v);
    if (r) {
      cerr << argv[0] << ": erreur de transmission " << r << endl;
      return r;
    }
    if (!quiet)
      cout << "backup reu, ROM version " << v.nom << endl;
    ofstream f(argv[j]);
    if (!f) {
      cerr << argv[0] << ": erreur d'criture sur `" << argv[j] << "'\n";
      return 2;
    }
    TIFile().ecris(v,f);
    if (!f) {
      cerr << argv[0] << ": erreur d'criture sur `" << argv[j] << "'\n";
      return 3;
    }
    return 0; }

  case PUTBKP :
    if (j==argc) {
      cerr << argv[0] << ": nom de fichier ncessaire\n";
      return 1;
    }
    if (j>argc+1) cerr << argv[0] << ": trop d'options\n";
    { ifstream f(argv[j]);
    if (!f) {
      cerr << argv[0] << ": erreur de lecture sur `" << argv[j] << "'\n";
      return 2;
    }
    TI92::Variable v;
    TIFile().lis(f,v);
    if (!f) {
      cerr << argv[0] << ": erreur de lecture sur `" << argv[j] << "'\n";
      return 3;
    }
    if (!quiet)
      cout << argv[j] << " : ROM version " << v.nom << endl;
    if (vrom) {
      char *nver;
      int i;
      r=ti.version(nver);
      if (r) {
	cerr << argv[0] << ": erreur de transmission " << r << endl;
	return r;
      }
      for (i=0;nver[i]!=0 && v.nom[i]!=0;i++)
	if (nver[i]!=v.nom[i]) {
	  cerr << argv[0] << ": mauvaise version de la ROM (" << nver
	       << " voulue)\n";
	  return 4;
	}
      if (nver[i]!=0 || v.nom[i]!=0) {
	cerr << argv[0] << ": mauvaise version de la ROM (" << nver
	     << " voulue)\n";
	return 4;
      }
    }
    ti.tbkp=v.taille;
    r=ti.envBackup(v);
    if (r) {
      cerr << argv[0] << ": erreur de transmission " << r << endl;
      return r;
    }
    if (!quiet)
      cout << "backup envoy\n";
    return 0; }
  }
}
