/*
 *   Trans92 - programme de communication Linux-TI92
 *
 *   copyright (c) 1998  Emmanuel Beffara
 *
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <iostream.h>
#include <fstream.h>
#include "ti92.h"
#include "tifile.h"

void TIFile::constantes()
{
  for (int i=0;i<8;i++)
    sign[i]="**TI92**"[i];
  _1=1;
  _2=1;
  _3=0x52;
  _4=0x5AA5;
  for (int i=0;i<4;i++)
    _5[i]=0;
}

bool TIFile::operator!()
{
  for (int i=0;i<8;i++)
    if (sign[i]!="**TI92**"[i])
      return true;
  if (_1!=1) return true;
  if (_2!=1) return true;
  if (_3!=0x52) return true;
  if (type<0 || type>0x20) return true;
  if (_4!=0x5AA5) return true;

  if (type==(long)TI92::Backup) {
    if (rep[0]!=0x10) return true;
    if (rep[1]!=0) return true;
  } else {
    for (int i=0;i<4;i++)
      if (_5[i]!=0) return true;
  }
  return false;
}

void TIFile::ecris(TI92::Variable &v,ostream &s)
{
  int tnr=0;
  char *p,*nv,*nr;

  if (v.type!=TI92::Backup) {
    for (p=v.nom;*p!='\\' && *p!=0;p++) tnr++;
    if (*p=='\\') {
      nr=v.nom;
      nv=p+1;
    } else {
      nr="main";
      nv=v.nom;
    }
  } else {
    for (p=v.nom;*p!=0;p++) tnr++;
    nr="\x10";
    nv=v.nom;
  }

  int i;
  for (i=0;i<tnr;i++)
    rep[i]=nr[i];
  rep[i]=0;
  for (i=0;nv[i]!=0;i++)
    nom[i]=nv[i];
  nom[i]=0;
  for (i=0;i<40;i++)
    comm[i]=0;
  if (v.type!=TI92::Backup) {
    tvar[0]=(unsigned char)(v.taille>>8);
    tvar[1]=(unsigned char)(v.taille&0xFF);
  }

  type=(long)v.type;
  if (v.type==TI92::Backup) {
    taille=v.taille+sizeof(TIFile)-4;
    s.write(this,sizeof(TIFile)-6);
  } else {
    taille=v.taille+sizeof(TIFile)+2;
    s.write(this,sizeof(TIFile));
  }

  unsigned short somme;
  if (v.type==TI92::Backup) somme=0;
  else somme=(unsigned short)tvar[0]+(unsigned short)tvar[1];
  for (long j=0;j<v.taille;j++) {
    s.put(v.data[j]);
    somme+=(unsigned short)v.data[j];
  }

  s.write(&somme,2);
}


int TIFile::lis(istream &s,TI92::Variable &V,bool nrep)
{
  s.read(this,sizeof(TIFile));
  if (!s) return 1;
  if (!(*this)) return 2;

  char *p,*q;
  int i;

  p=V.nom;
  if (type!=(long)TI92::Backup && nrep) {
    for (q=rep,i=0;*q!=0 && i<8;q++,i++)
      *(p++)=*q;
    *(p++)='\\';
  }
  for (q=nom,i=0;*q!=0 && i<8;q++,i++)
    *(p++)=*q;
  *p=0;

  V.type=(TI92::Type)type;
  if (V.type==TI92::Backup)
    V.taille=taille-84;
  else
    V.taille=((unsigned short)tvar[0] << 8) | tvar[1];

  V.data=new unsigned char[V.taille];
  if (!V.data) return 3;
  if (V.type!=TI92::Backup)
    s.read(V.data,V.taille);
  else {
    for (i=0;i<6;i++) V.data[i]=_5[i];
    s.read(V.data+6,V.taille-6);
  }
  if (!s) return 4;
  short somme,chk;
  if (V.type==TI92::Backup)
    somme=0;
  else
    somme=(short)tvar[0]+(short)tvar[1];
  for (i=0;i<V.taille;i++)
    somme+=(short)V.data[i];
  s.read(&chk,2);
  if (!s) return 5;
  if (somme!=chk) return 6;
  return 0;
}
