/*
 *   Trans92 - programme de communication Linux-TI92
 *
 *   copyright (c) 1998  Emmanuel Beffara
 *
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <iostream.h>
#include <iomanip.h>
#include <fstream.h>

#include "ti92.h"

// TRANSMISSION SYNCHRONISE - RECEPTION
//
//  syntaxe : ret = reception ( fonc )
//    int ret = code de retour, 0 en cas de succs
//    int fonc(TI92::Variable &V) = fonction appele  la rception de
//                                  chaque variable

int TI92::reception()
{
  bloc B;
  int ret;

  for (;;) {
    ret=rec_bloc(B);
    if (ret) return ret;
    switch (B.entete) {
    case Tr_VARIABLE : {
      Variable V;
      short tnom;

      V.taille=peekBE_us(B.data)-2;
      if (B.data[2]!=0 || B.data[3]!=0) return 201;
      V.type=(Type)B.data[4];
      tnom=B.data[5];
      if (B.taille!=tnom+6) return 202;
      for (short i=0;i<tnom;i++) V.nom[i]=B.data[i+6];
      V.nom[tnom]=0;
      
      env_sgn(Tr_OK);
      env_sgn(Tr_VAZY);

      ret=rec_bloc(B);
      if (ret) return ret+300;
      if (B.entete!=Tr_OK || B.taille!=0) return 401;

      ret=rec_bloc(B);
      if (ret) return ret+500;
      if (B.entete!=Tr_DONNEES) return 601;
      if (B.taille!=V.taille+6) return 602;
      if (B.data[0]!=0 || B.data[1]!=0 || B.data[2]!=0 ||
	  B.data[3]!=0) return 603;
      if (peekLE_s(B.data+4) != V.taille) return 604;
      V.data=new unsigned char[V.taille];
      if (!V.data) return 605;
      for (short i=0;i<V.taille;i++) V.data[i]=B.data[i+6];

      env_sgn(Tr_OK);

      ret=recepVar(V);
      if (ret) return 700+ret;
      break; }

    case Tr_FINI :
      env_sgn(Tr_OK);
      return 0;
    default :
      return 101;
    }
  }
}

int TI92::recepVar(Variable &)
{ return 0; }



// TRANSMISSION SYNCHRONISE - ENVOI
//
// syntaxe : ret = envoi ( V )
//   int ret = code de retour, 0 en cas de succs
//   Variable &V = variable  envoyer

int TI92::envoi(Variable &V)
{
  bloc B;
  int ret;

  short tnom;
  tnom=0;
  for (char *p=V.nom;*p!=0;p++) tnom++;
  
  unsigned char *db;
  db=new unsigned char[tnom+6];
  if (!db) return 101;
  pokeBE(db,(long)V.taille+2);
  db[4]=(char)V.type;
  db[5]=(char)tnom;
  for (int i=0;i<tnom;i++)
    db[6+i]=V.nom[i];
  env_bloc(B=bloc(Tr_VARIABLE,tnom+6,db));
  delete db;

  ret=rec_bloc(B);
  if (ret) return ret+200;
  if (B.entete!=Tr_OK || B.taille!=0) return 301;

  ret=rec_bloc(B);
  if (ret) return ret+400;
  if (B.entete!=Tr_VAZY || B.taille!=0) return 501;

  env_sgn(Tr_OK);

  db=new unsigned char[V.taille+6];
  if (!db) return 601;
  for (int i=0;i<4;i++) db[i]=0;
  pokeLE(db+4,(unsigned short)V.taille);
  for (int i=0;i<V.taille;i++) db[6+i]=V.data[i];
  env_bloc(B=bloc(Tr_DONNEES,V.taille+6,db));

  ret=rec_bloc(B);
  if (ret) return ret+700;
  if (B.entete!=Tr_OK || B.taille!=0) return 801;

  return 0;
}



// TRANSMISSION SYNCHRONISE - FIN DE SQUENCE

int TI92::finEnvoi()
{
  bloc B;
  int ret;

  env_sgn(Tr_FINI);
  ret=rec_bloc(B);
  if (ret) return ret;
  if (B.entete!=Tr_OK || B.taille!=0) return 99;
  return 0;
}
