/*
 *   Trans92 - programme de communication Linux-TI92
 *
 *   copyright (c) 1998  Emmanuel Beffara
 *
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <termbits.h>
#include <termios.h>
#include <fcntl.h>
#include <iostream.h>
#include <iomanip.h>
#include <fstream.h>

#include "ti92.h"

// lecture / criture portable en Little/Big Endian

short peekLE_s(unsigned char *p)
{ return (((short)p[0])<<8) | p[1]; }
unsigned short peekLE_us(unsigned char *p)
{ return (((unsigned short)p[0])<<8) | p[1]; }
long peekLE_l(unsigned char *p)
{ return (((long)p[0])<<24) | (((long)p[1])<<16)
    | (((long)p[2])<<8) | p[3]; }
unsigned long peekLE_ul(unsigned char *p)
{ return (((unsigned long)p[0])<<24) | (((unsigned long)p[1])<<16)
    | (((unsigned long)p[2])<<8) | p[3]; }

short peekBE_s(unsigned char *p)
{ return (((short)p[1])<<8) | p[0]; }
unsigned short peekBE_us(unsigned char *p)
{ return (((unsigned short)p[1])<<8) | p[0]; }
long peekBE_l(unsigned char *p)
{ return (((long)p[3])<<24) | (((long)p[2])<<16)
    | (((long)p[1])<<8) | p[0]; }
unsigned long peekBE_ul(unsigned char *p)
{ return (((unsigned long)p[3])<<24) | (((unsigned long)p[2])<<16)
    | (((unsigned long)p[1])<<8) | p[0]; }

void pokeLE(unsigned char *p,short v)
{ p[0]=(unsigned char)(v>>8); p[1]=(unsigned char)v; }
void pokeLE(unsigned char *p,unsigned short v)
{ p[0]=(unsigned char)(v>>8); p[1]=(unsigned char)v; }
void pokeLE(unsigned char *p,long v)
{ p[0]=(unsigned char)(v>>24); p[1]=(unsigned char)(v>>16);
  p[2]=(unsigned char)(v>>8);  p[3]=(unsigned char)v; }
void pokeLE(unsigned char *p,unsigned long v)
{ p[0]=(unsigned char)(v>>24); p[1]=(unsigned char)(v>>16);
  p[2]=(unsigned char)(v>>8);  p[3]=(unsigned char)v; }

void pokeBE(unsigned char *p,short v)
{ p[1]=(unsigned char)(v>>8); p[0]=(unsigned char)v; }
void pokeBE(unsigned char *p,unsigned short v)
{ p[1]=(unsigned char)(v>>8); p[0]=(unsigned char)v; }
void pokeBE(unsigned char *p,long v)
{ p[3]=(unsigned char)(v>>24); p[2]=(unsigned char)(v>>16);
  p[1]=(unsigned char)(v>>8);  p[0]=(unsigned char)v; }
void pokeBE(unsigned char *p,unsigned long v)
{ p[3]=(unsigned char)(v>>24); p[2]=(unsigned char)(v>>16);
  p[1]=(unsigned char)(v>>8);  p[0]=(unsigned char)v; }


// constructeur avec initialisation des communications

TI92::TI92(const char *dev)
{
  fd=open(dev,O_RDWR|O_SYNC);
  if (fd==-1) {
    str=0;
    return;
  }

  struct termios param;
  param.c_iflag=0;
  param.c_oflag=0;
  param.c_cflag=CS8|CLOCAL|CREAD;
  param.c_lflag=0;
  param.c_cc[VMIN]=0;
  param.c_cc[VTIME]=100;
  cfsetospeed(&param,B9600);
  cfsetispeed(&param,B9600);
  tcsetattr(fd,TCSANOW,&param);

  str=new fstream(fd);
}

// fonctions lmentaires


void TI92::ecris_wi(unsigned short w)
{
  str->put((char)(w&0xFF));
  str->put((char)(w>>8));
}

void TI92::ecris_wm(unsigned short w)
{
  str->put((char)(w>>8));
  str->put((char)(w&0xFF));
}

void TI92::ecris_sg(TI92::SIGNAL S)
{
  ecris_wm((unsigned short)S);
}

unsigned short TI92::lis_wi()
{
  short t; t=str->get(); 
  return t|((unsigned short)str->get()<<8);
}

unsigned short TI92::lis_wm()
{
  short t; t=(unsigned short)str->get()<<8;
  return t|str->get();
}



// envoi d'un bloc lmentaire
//   (format : en-tte taille.wi donnes somme.wi)

void TI92::env_bloc(bloc &B)
{
  ecris_sg(B.entete);
  ecris_wi(B.taille);

  if (B.taille!=0) {
    str->write(B.data,B.taille);
    unsigned short somme=0;
    short i;
    for (i=0;i<B.taille;i++) somme+=B.data[i];
    ecris_wi(somme);
  }
}


// rception d'un bloc lmentaire

int TI92::rec_bloc(bloc &B)
{
  //delete B.data;
  B.data=0;
  if (!*str) return 1;
  B.entete=(SIGNAL)lis_wm();  if (!*str) return 2;
  B.taille=lis_wi();  if (!*str) return 3;

  if (B.taille!=0) {
    B.data=new unsigned char [B.taille];
    if (!B.data) return 4;
    str->read(B.data,B.taille);
    if (!*str) { delete B.data; return 5; }

    unsigned short somme=0;
    unsigned short i,sl;
    for (i=0;i<B.taille;i++) somme+=B.data[i];
    if ((sl=lis_wi())!=somme) {
      delete B.data;
      return 6;
    }
  }

  return 0;
}


// envoi d'un bloc spcial (signal)

void TI92::env_spec(TI92::SIGNAL S,short val)
{
  ecris_sg(S);
  ecris_wi(val);
}

// rception d'un bloc spcial

int TI92::rec_spec(TI92::SIGNAL &S,short &val)
{
  if (!*str) return 1;
  S=(SIGNAL)lis_wm();
  if (!*str) return 2;
  val=lis_wi();
  return 0;
}



// table des suffixes

const char TI92::tSuff[]="e...l.m...ctsda.i.pfx...h....b.g";

// table des types

const char *TI92::tTypes[]={ "EXPR", "(01)", "(02)", "(03)", "LIST",
			     "(05)", "MAT ", "(07)", "(08)", "(09)",
			     "DATA", "TEXT", "STR ", "GDB ", "FIG ",
			     "(0F)", "PIC ", "(11)", "PRGM", "FUNC",
			     "MAC ", "(15)", "(16)", "(17)", "? H ",
			     "(19)", "(1A)", "(1B)", "(1C)", "backup",
			     "(1E)", "groupe" };
