/* --------------------------------------------------------------------
   Project: Communication package Linux-HPx00LX Filer
   Module:  lxrmdir.c
   Author:  A. Garzotto
   Started: 30. Nov. 95
   Subject: Delete a directory on the LX
   -------------------------------------------------------------------- */

/* --------------------------------------------------------------------
                             includes
   -------------------------------------------------------------------- */
#include <stdio.h>
#include <stdlib.h>

/* --------------------------------------------------------------------
                         local includes
   -------------------------------------------------------------------- */

#include "pal.h"
#include "palpriv.h"
#include "config.h"


/* --------------------------------------------------------------------
                        display help
   -------------------------------------------------------------------- */

static void help(void)
{
   printf("USAGE: lxrmdir [options] <directory name>\n");
   printf("  options: -<n> sets comm port <n>\n");
   printf("           -b <baud> sets baud rate to <baud>\n");
   exit(1);
}

/* --------------------------------------------------------------------
                        make DOS directory string
   -------------------------------------------------------------------- */

static void makedir(char *dir)
{
   char *p = dir;
   
   while (*p)
   {
      if (*p == '/') *p = '\\';
      p++;
   }
}

/* --------------------------------------------------------------------
                               M A I N
   -------------------------------------------------------------------- */

void main (int argc, char **argv)
{
   int   stat;
   int port = 1;
   int speed = DEF_BAUD;
   FILERCOM *pFiler;
   char dir[256] = "";
   int i = 1, num = 0;
   int ret;
   
   printf("LXRMDIR 1.0 by A. Garzotto\n\n");

   while (i < argc)
   {
      if (argv[i][0] == '-')
      {
	 switch (argv[i][1])
	 {
	  case '1': port = 1; break;
	  case '2': port = 2; break;
	  case '3': port = 3; break;
	  case '4': port = 4; break;
	  case 'B':
	  case 'b': speed = atoi(argv[++i]); break;
	  default: help(); break;
	 }
      }
      else
	 strcpy(dir, argv[i]);
      i++;      
   }
   if (!*dir) help();
   makedir(dir);
   
   if(!(pFiler = FilerConnect(port, speed, &FlCb))) {
      printf("\nUnable to connect to palmtop!\n");
      exit(3);
   }

   stat = FilerAskDir(pFiler, dir);
   if(stat== NO_RESPONSE) printf("\nServer Not responding.\n");

   while (1)
   {
      if (FilerGetDir(pFiler) == CANNOT_GET_ENTRY) break;
      if (pFiler->Attribute & 0x10) num++;
   }
   if (!num)
   {
      printf("Directory not found: '%s'.\n", dir);
      ret = 1;
   }
   else if (num > 1)
   {
      printf("Can only delete one directory at once.\n");
      ret = 1;
   }
   else
   {
      stat = FilerDelDir(pFiler, dir);
      if(stat==CANNOT_DELETE_DIR)
      {
	 printf("\nCould not delete directory!\n");
	 ret = 1;
      }
      else
	 printf("Directory '%s' is deleted.\n", dir);
    }
   FilerDisconnect(pFiler);
   exit(ret);
}

