/* --------------------------------------------------------------------
   Project: Communication package Linux-HPx00LX Filer
   Module:  lxdir.c
   Author:  A. Garzotto
   Started: 28. Nov. 95
   Subject: Display directory contents
   -------------------------------------------------------------------- */

/* --------------------------------------------------------------------
                             includes
   -------------------------------------------------------------------- */
#include <stdio.h>
#include <stdlib.h>

/* --------------------------------------------------------------------
                         local includes
   -------------------------------------------------------------------- */

#include "pal.h"
#include "palpriv.h"
#include "config.h"


/* --------------------------------------------------------------------
                        display help
   -------------------------------------------------------------------- */

static void help(void)
{
   printf("USAGE: lxdir [options] <directory>\n");
   printf("  options: -<n> sets comm port <n>\n");
   printf("           -b <baud> sets baud rate to <baud>\n");
   exit(1);
}

/* --------------------------------------------------------------------
                        make DOS directory string
   -------------------------------------------------------------------- */

static void makedir(char *dir)
{
   char *p = dir;
   int hasdot = 0;
   int hasstar = 0;
   
   while (*p)
   {
      if (*p == '/') *p = '\\';
      if (*p == '.') hasdot = 1;
      if (*p == '*') hasstar = 1;
      p++;
   }
   if (!hasdot && !hasstar)
   {
      if (p[-1] == '\\')
	 strcat(dir, "*.*");
      else
	 strcat(dir, "\\*.*");
   }
}

/* --------------------------------------------------------------------
                               M A I N
   -------------------------------------------------------------------- */

void main (int argc, char **argv)
{
   int   stat;
   int port = 1;
   int speed = DEF_BAUD;
   FILERCOM *pFiler;
   char dir[256] = "";
   int i = 1;

   printf("LXDIR 1.0 by A. Garzotto\n\n");

   while (i < argc)
   {
      if (argv[i][0] == '-')
      {
	 switch (argv[i][1])
	 {
	  case '1': port = 1; break;
	  case '2': port = 2; break;
	  case '3': port = 3; break;
	  case '4': port = 4; break;
	  case 'B':
	  case 'b': speed = atoi(argv[++i]); break;
	  default: help(); break;
	 }
      }
      else
	 strcpy(dir, argv[i]);
      i++;      
   }
   if (!*dir) help();
   makedir(dir);
   
   if(!(pFiler = FilerConnect(port, speed, &FlCb))) {
      printf("\nUnable to connect to palmtop!\n");
      exit(3);
   }

   stat = FilerAskDir(pFiler, dir);
   if(stat== NO_RESPONSE) printf("\nServer Not responding.\n");

   printf(" Directory of %s:\n\n", dir);
   while (1)
   {
      if(FilerGetDir(pFiler) == CANNOT_GET_ENTRY) break;
      if (pFiler->Attribute & 0x10)
         printf("%-12s    <DIR>      %02d-%02d-%02d  %02d:%02d\n",
               pFiler->Name,
               pFiler->DateStamp.month, pFiler->DateStamp.day,
               pFiler->DateStamp.year+80,
               pFiler->DateStamp.hour, pFiler->DateStamp.min);
      else
         printf("%-12s %12lu  %02d-%02d-%02d  %02d:%02d\n",
               pFiler->Name, pFiler->FileSize,
               pFiler->DateStamp.month, pFiler->DateStamp.day,
               pFiler->DateStamp.year+80,
               pFiler->DateStamp.hour, pFiler->DateStamp.min);
   }
   
   FilerDisconnect(pFiler);
   exit(0);
}

