/*
 *
 *	SixPack is Copyright (C) 1996 Kaz Kylheku
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *	The author may be contacted at:
 *
 *	Kaz Kylheku
 *	2869 East 14th Avenue
 *	Vancouver, B.C.
 *	CANADA
 *	V5M 2H8
 *	email: kaz@cafe.net
 *
 */


#include "transmit.h"
#include "charset.h"
#include "sixbit.h"
#include "stream.h"

static unsigned char buf[STR_MAX_DGRAM + STR_MAX_DGRAM/2];

int dgram_transmit(bufio_t io, unsigned char *data, size_t size)

{
	size_t esize;
	unsigned char *p = buf;
	
	if (sixbit_bloat(size) > sizeof buf)
		return 0;

	buf_clrerror(io);

	esize = sixbit_encode(buf, data, size);

	while (esize--) {
		switch (*p) {
		case 63:
			buf_putchar(io, char_out[62]);
			buf_putchar(io, char_out[62]);
			break;
		case 62:
			buf_putchar(io, char_out[62]);
			if (esize&&(*(p+1)==0 || *(p+1)==62 || *(p+1)==63))
				buf_putchar(io, char_out[0]);
			break;
		default:
			buf_putchar(io, char_out[*p]);
			break;
		}
		p++;
		if (buf_error(io))
			return 0;
	}

	buf_putchar(io, char_out[63]);

	buf_flush(io);

	return 1;
}

int dgram_receive(bufio_t io, unsigned char *data, size_t size, size_t *nrecv)

{
	unsigned char *p = buf;
	size_t nchar = 0;
	int done = 0;

	while (nchar < sizeof buf && !done) {
		int ch = buf_getchar(io), ci;

		if (ch == B_EOF)
			return 0;

		if (ch >= sizeof char_in || char_in[ch] < 0)
			continue;

		ch = char_in[ch];


		switch (ch) {
		case 62:
			ci = buf_getchar(io);

			if (ci == B_EOF)
				return 0;

			if (ci >= sizeof char_in || char_in[ci] < 0)
				continue;

			ch = char_in[ci];
			switch (ch) {
			case 0:
				*p++ = 62;
				break;
			case 62:
				*p++ = 63;
				break;
			default:
				*p++ = 62;
				buf_ungetchar(io, ci);
				break;
			}
			break;
		case 63:
			done = 1;
			continue;
		default:
			*p++ = ch;
			break;
		}
		nchar++;
	}

	if (sixbit_shrink(nchar) > size)
		return 0;

	sixbit_decode(data, buf, nchar);

	*nrecv = nchar;

	return 1;
}
