/*
 *
 *	SixPack is Copyright (C) 1996 Kaz Kylheku
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *	The author may be contacted at:
 *
 *	Kaz Kylheku
 *	2869 East 14th Avenue
 *	Vancouver, B.C.
 *	CANADA
 *	V5M 2H8
 *	email: kaz@cafe.net
 *
 */


#include <stdio.h>
#include <stdarg.h>
#include "trace.h"

int tracelevel;

int tprintf(int minlevel, char *fmt, ...)

{
	int ret = 0;

	va_list args;
	va_start (args, fmt);
	if (minlevel <= tracelevel)
		ret = vfprintf(stderr, fmt, args);
	va_end (args);
	return ret;
}

int tputchar(int minlevel, int ch)

{
	if (minlevel <= tracelevel)
		return putc(ch, stderr);
	return ch;
}

void tflush(int minlevel)

{
	if (minlevel <= tracelevel)
		fflush(stderr);
}


