/*
 *
 *	SixPack is Copyright (C) 1996 Kaz Kylheku
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *	The author may be contacted at:
 *
 *	Kaz Kylheku
 *	2869 East 14th Avenue
 *	Vancouver, B.C.
 *	CANADA
 *	V5M 2H8
 *	email: kaz@cafe.net
 *
 */


#include <sys/time.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <unistd.h>
#include <fcntl.h>

#include <string.h>
#include <stdlib.h>

#include "device.h"
#include "tcpdev.h"

int tcp_init(struct driver_s *driver)

{
	return 1;
}

void tcp_deinit(struct driver_s *driver)

{
}

struct sockaddr_in *getaddr(char *addrport)

{
	static struct sockaddr_in addr;
	char *colon, *port = NULL;
	struct hostent *he;

	if ((colon = strchr(addrport, ':'))) {
		*colon = 0;
		port = colon + 1;

		he = gethostbyname(addrport);
		if (he == 0)
			return 0;
		addr.sin_family = AF_INET;
		addr.sin_port = htons(atoi(port));
		memcpy(&addr.sin_addr, he->h_addr, sizeof (struct in_addr));
	}

	return &addr;
}

int tcp_open(device_t dev, void *specific, va_list args)

{
	char *addrport = specific;
	struct sockaddr_in me, it;
	struct sockaddr_in *addr = getaddr(addrport);
	int fd, sz;

	if (!addr)
		return 0;

	me.sin_family = AF_INET;
	me.sin_port = addr->sin_port ? 0 : htons(atoi(addrport));
	me.sin_addr.s_addr = htons(INADDR_ANY);

	fd = socket(AF_INET, SOCK_STREAM, 0);

	if (fd < 0)
		return 0;

	if (bind(fd, (void *) &me, sizeof me) < 0)
		return 0;

	if (addr->sin_port != 0) {
		if (connect(fd, (void *) addr, sizeof *addr) < 0)
			return 0;
	} else {
		if (listen(fd, 1) < 0)
			return 0;
		fd = accept(fd, (void *) &it, &sz);
		if (fd < 0)
			return 0;
	}

	dev->handle.i = fd;

	return 1;
}

int tcp_close(device_t dev)

{
	close(dev->handle.i);

	return 1;
}

int tcp_read(device_t dev, void *buf, size_t nbytes, size_t *nread)

{
	struct timeval tv;
	fd_set rfd;

	if (dev->timeout) {
		int sel;

		tv.tv_sec = dev->timeout / 1000;
		tv.tv_usec = dev->timeout % 1000;
		FD_SET(dev->handle.i, &rfd);
		do {
			sel = select(dev->handle.i + 1, &rfd, NULL, NULL, &tv);
		} while (sel < 0 && errno == EINTR);
		if (sel == 0) {
			*nread = 0;
			return 1;
		}
	}

	if ((*nread = read(dev->handle.i, buf, nbytes)) < 0) {
		*nread = 0;
		return 0;
	}

	return 1;
}

int tcp_write(device_t dev, void *buf, size_t nbytes, size_t *nwrit)

{
	if ((*nwrit = write(dev->handle.i, buf, nbytes)) < 0) {
		*nwrit = 0;
		return 0;
	}

	return 1;
}
