/*
 *
 *	SixPack is Copyright (C) 1996 Kaz Kylheku
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *	The author may be contacted at:
 *
 *	Kaz Kylheku
 *	2869 East 14th Avenue
 *	Vancouver, B.C.
 *	CANADA
 *	V5M 2H8
 *	email: kaz@cafe.net
 *
 */


#ifndef STREAM_H
#define STREAM_H

#include "bufio.h"
#include "region.h"

#define	STR_MAX_DGRAM	60000
#define STR_CON_TIMEOUT	5000
#define STR_CON_RETRANS	12

typedef enum {
	SS_connected,
	SS_closed
} streamstate_t;

typedef struct {
	bufio_t iodev;
	device_t dev;
	region_t reg;
	streamstate_t state;
	unsigned char *buf;
	unsigned char *dgram;
	size_t bufsize;
	size_t dgrsize;
	size_t bufhead;
	size_t buftail;
	size_t bufcount;
	size_t lowater;
	size_t hiwater;
	size_t segsize;
	unsigned long position;
	unsigned long ackposition;
	int ackcount;
} *stream_t;

typedef enum {
	SC_connect,
	SC_accept,
	SC_close,
	SC_data,
	SC_data_ack
} streamcmd_t;

stream_t stream_connect(bufio_t iodev, size_t bufsize, size_t segsize);
stream_t stream_accept(bufio_t iodev, size_t bufsize);
void stream_close(stream_t str);
int stream_write(stream_t str, void *buf, size_t size);
int stream_drain(stream_t str);
int stream_read(stream_t str, void *buf, size_t size, size_t *nread);
int stream_process(stream_t str);
int stream_pause(stream_t str);
int stream_resume(stream_t str);

#endif
