/*
 *
 *	SixPack is Copyright (C) 1996 Kaz Kylheku
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *	The author may be contacted at:
 *
 *	Kaz Kylheku
 *	2869 East 14th Avenue
 *	Vancouver, B.C.
 *	CANADA
 *	V5M 2H8
 *	email: kaz@cafe.net
 *
 */


#include <limits.h>
#include "sixbit.h"

size_t sixbit_bloat(size_t orig)

{
	return orig + (orig + 2) / 3;
}

size_t sixbit_shrink(size_t orig)

{
	return orig - (orig + 2) / 4;
}

size_t sixbit_encode(unsigned char *dest, unsigned char *src, size_t size)

{
	size_t out = 0;
	unsigned char x, y;

	while (size > 2) {
		*dest++  = (x = *src++)  >> 2;
		*dest++  = (x & 3)       << 4  | (y = *src++) >> 4;
		*dest++  = (y & 15)      << 2  | (x = *src++) >> 6;
		*dest++  =  x & 63;

		size -= 3;
		out += 4;
	}

	switch (size) {
	case 2:
		*dest++  = (x = *src++)  >> 2;
		*dest++  = (x & 3)       << 4  | (y = *src) >> 4;
		*dest++  = (y & 15)      << 2;
		return out + 3;
	case 1:
		*dest++  = (x = *src++)  >> 2;
		*dest++  = (x & 3)       << 4;
		out += 2;
	default:
		return out;
	}
}

size_t sixbit_decode(unsigned char *dest, unsigned char *src, size_t size)

{
	size_t out = 0;
	unsigned char x, y;

	while (size > 3) {
		x        = *src++ << 2;
		*dest++  = x            | (y = *src++) >> 4;
		*dest++  = y << 4       | (x = *src++) >> 2;
		*dest++  = x << 6       | *src++;
		size -= 4;
		out += 3;
	}

	switch (size) {
	case 3:
		x        = *src++ << 2;
		*dest++  = x            | (y = *src++) >> 4;
		*dest++  = y << 4       | (x = *src++) >> 2;
		*dest++  = x << 6;
		return out + 3;
	case 2:
		x        = *src++ << 2;
		*dest++  = x            | (y = *src++) >> 4;
		*dest++  = y << 4;
		return out + 2;
	case 1:
		*dest    = *src++ << 2;
		out += 1;
	default:
		return out;
	}
}
