#
#
#	SixPack is Copyright (C) 1996 Kaz Kylheku
#
#	This program is free software; you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation; either version 2 of the License, or
#	(at your option) any later version.
#
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#
#	You should have received a copy of the GNU General Public License
#	along with this program; if not, write to the Free Software
#	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
#	The author may be contacted at:
#
#	Kaz Kylheku
#	2869 East 14th Avenue
#	Vancouver, B.C.
#	CANADA
#	V5M 2H8
#	email: kaz@cafe.net
#

#
# 80386 assembly language version of the maximally portable sixbit.c
#
# This is binary compatible with the interface of sixbit.h if you use GCC
# and GAS, and don't tinker with GCC's alignment of structure members,
# caller-saved registers, etc.
#
# It is assumed that assembly language symbols don't require any particular
# treatment (such as the addition of leading underscores) to be compatible
# with C.
#

		.file	"sixbit-i386.s"

ALIGN		= 16

arg1		= 4
arg2		= 8
arg3		= 12

		.text

		.globl	sixbit_bloat
sixbit_bloat:
		movl	arg1(%esp), %eax
		addl	$2, %eax
		xorl	%edx, %edx
		movl	$3, %ecx
		divl	%ecx
		movl	arg1(%esp), %ecx
		addl	%eax, %ecx
		movl	%ecx, %eax
		ret

		.globl	sixbit_shrink
sixbit_shrink:
		movl	arg1(%esp), %eax
		movl	%eax, %edx
		incl	%edx
		incl	%edx
		shrl	$2, %edx
		subl	%edx, %eax
		ret

		.globl	sixbit_encode
sixbit_encode:
		pushl	%edi
		pushl	%esi
		pushl 	%ebx
		movl	arg1+12(%esp), %edi
		movl	arg2+12(%esp), %esi
		movl	arg3+12(%esp), %ecx
		xorl	%edx, %edx
		cld

		cmpl	$2, %ecx
		je	encode_two
		jb	encode_one

		.align	ALIGN

encode_threes:
		lodsw	(%esi), %ax
		movb	%al, %bh
		andb	$3, %bh
		shrb	$2, %al
		shlb	$4, %bh
		movb	%ah, %bl
		shrb	$4, %ah
		orb	%bh, %ah
		shll	$16, %eax
		andb	$15, %bl
		lodsb	(%esi), %al
		shlb	$2, %bl	
		movb	%al, %bh
		shrb	$6, %al	
		orb	%bl, %al
		movb	%bh, %ah
		andb	$63, %ah
		roll	$16, %eax
		stosl	%eax, (%edi)

		addl	$4, %edx
		subl	$3, %ecx
		cmp	$2, %ecx
		ja	encode_threes
		jb	encode_one

encode_two:	
		lodsw	(%esi), %ax
		movb	%al, %bh
		shrb	$2, %al	
		andb	$3, %bh	
		shlb	$4, %bh

		movb	%ah, %bl
		shrb	$4, %ah	
		orb	%bh, %ah
		stosw	%ax, (%edi)

		andb	$15, %bl
		shlb	$2, %bl	
		movb	%bl, (%edi)

		addl	$3, %edx
		movl	%edx, %eax

		popl	%ebx
		popl	%esi
		popl	%edi
		ret

encode_one:	
		testl	%ecx, %ecx
		je	encode_done

		lodsb	(%esi), %al
		movb	%al, %ah
		shrb	$2, %al	
		andb	$3, %ah
		shlb	$4, %ah	
		movw	%ax, (%edi)

		addl	$2, %edx

encode_done:
		movl	%edx, %eax
		popl	%ebx
		popl	%esi
		popl	%edi
		ret

		.globl	sixbit_decode
sixbit_decode:
		pushl	%edi
		pushl	%esi
		pushl 	%ebx
		movl	arg1+12(%esp), %edi
		movl	arg2+12(%esp), %esi
		movl	arg3+12(%esp), %ecx
		xorl	%edx, %edx
		cld

		cmpl	$3, %ecx
		jbe	decode_jump

		.align	ALIGN
decode_fours:
		lodsl	(%esi), %eax
		movb	%ah, %bl
		shlb	$2, %al
		shrb	$4, %ah
		orb	%ah, %al
		stosb	%al, (%edi)
		shrl	$16, %eax
		shlb	$4, %bl	
		movb	%al, %bh
		shrb	$2, %al
		orb	%bl, %al
		shlb	$6, %bh	
		orb	%bh, %ah
		stosw	%ax, (%edi)

		addl	$3, %edx
		subl	$4, %ecx
		cmpl	$3, %ecx
		ja	decode_fours

decode_jump:
		jmp	*decode_jumptab(, %ecx, 4)

decode_jumptab:	.long	decode_done
		.long	decode_one
		.long	decode_two
		.long	decode_three

decode_three:
		lodsw	(%esi), %ax
		movb	%ah, %bl
		shlb	$2, %al
		shrb	$4, %ah
		orb	%ah, %al
		stosb	%al, (%edi)
		movb	(%esi), %al
		shlb	$4, %bl	
		movb	%al, %ah
		shrb	$2, %al
		orb	%bl, %al
		shlb	$6, %ah
		movw	%ax, (%edi)

		addl	$3, %edx
decode_done:
		movl	%edx, %eax
		popl	%ebx
		popl	%esi
		popl	%edi
		ret

decode_two:
		movw	(%esi), %ax
		movb	%ah, %bl
		shlb	$2, %al
		shrb	$4, %bl
		orb	%bl, %al
		shlb	$4, %ah
		movw	%ax, (%edi)

		addl	$2, %edx
		movl	%edx, %eax
		popl	%ebx
		popl	%esi
		popl	%edi
		ret
decode_one:
		movb	(%esi), %al
		shlb	$2, %al	
		movb	%al, (%edi)
		inc	%edx
		movl	%edx, %eax
		popl	%ebx
		popl	%esi
		popl	%edi
		ret
