/*
 *
 *	SixPack is Copyright (C) 1996 Kaz Kylheku
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *	The author may be contacted at:
 *
 *	Kaz Kylheku
 *	2869 East 14th Avenue
 *	Vancouver, B.C.
 *	CANADA
 *	V5M 2H8
 *	email: kaz@cafe.net
 *
 */


#ifndef REGION_H
#define REGION_H

#include <stdio.h>

#define REGIONS_MAX	32

typedef struct regent_s {
	unsigned long low;
	unsigned long high;
	struct regent_s *next;
} regent_t;

typedef struct {
	regent_t reg[REGIONS_MAX];
	regent_t *head;
	regent_t *free;
} region_t;

extern void reg_init(region_t *reg);
extern void reg_deinit(region_t *reg);
extern int reg_add(region_t *reg, unsigned long low, unsigned long high);
extern int reg_del(region_t *reg, unsigned long low, unsigned long high);
extern int reg_testhole(region_t *reg, unsigned long low, unsigned long high);
extern unsigned long reg_firsthole(region_t *reg);
extern unsigned long reg_lasthole(region_t *reg);
extern void reg_print(region_t *reg, FILE *f);

#endif
