/*
 *
 *	SixPack is Copyright (C) 1996 Kaz Kylheku
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *	The author may be contacted at:
 *
 *	Kaz Kylheku
 *	2869 East 14th Avenue
 *	Vancouver, B.C.
 *	CANADA
 *	V5M 2H8
 *	email: kaz@cafe.net
 *
 */


#include <stdlib.h>
#include <string.h>

#include "packet.h"
#include "exrep.h"
#include "crc.h"

void packet_encode(estream_t *e, unsigned size)

{
	ex_seek(e, 0);
	ex_put16u(e, size);
	ex_adjust(e, size);
	ex_put32u(e, getcrc(ex_getbuf(e), size + 2));
}

int packet_decode(estream_t *e, unsigned *size)

{
	unsigned long chksum;

	ex_seek(e, 0);
	if (!ex_get_verify(e, 2))
		return 0;
	*size = ex_get16u(e);
	if (!ex_get_verify(e, *size + 4))
		return 0;
	ex_adjust(e, *size);
	chksum = ex_get32u(e);

	return getcrc(ex_getbuf(e), *size + 2) == chksum;
}

#undef packet_headersize
#undef packet_trailersize

size_t packet_headersize(void)

{
	return 2;
}

size_t packet_trailersize(void)

{
	return 4;
}
