/*
 *
 *	SixPack is Copyright (C) 1996 Kaz Kylheku
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *	The author may be contacted at:
 *
 *	Kaz Kylheku
 *	2869 East 14th Avenue
 *	Vancouver, B.C.
 *	CANADA
 *	V5M 2H8
 *	email: kaz@cafe.net
 *
 */

#include "help.h"
#include "version.h"
#include "local.h"
#include "trace.h"
#include "driver.h"

char *license_context =
	"The following clauses are excerpts from the text contained in the" NL
	"LICENSE file which is a necessary part of the SixPack distribution" NL
	"and are to be understood in the larger context of that document." NL
	;

char *warranty_info =
	"  11. BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO WARRANTY" NL
	"FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE LAW.  EXCEPT WHEN" NL
	"OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES" NL
	"PROVIDE THE PROGRAM \"AS IS\" WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED" NL
	"OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF" NL
	"MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  THE ENTIRE RISK A" NL
	"TO THE QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU.  SHOULD THE" NL
	"PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY SERVICING," NL
	"REPAIR OR CORRECTION." NL
	NL
	"  12. IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN WRITING" NL
	"WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY AND/OR" NL
	"REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR DAMAGES," NL
	"INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING" NL
	"OUT OF THE USE OR INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT LIMITED" NL
	"TO LOSS OF DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY" NL
	"YOU OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY OTHER" NL
	"PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE" NL
	"POSSIBILITY OF SUCH DAMAGES." NL
	;

char *distrib_info =
	"  1. You may copy and distribute verbatim copies of the Program's" NL
	"source code as you receive it, in any medium, provided that you" NL
	"conspicuously and appropriately publish on each copy an appropriate" NL
	"copyright notice and disclaimer of warranty; keep intact all the" NL
	"notices that refer to this License and to the absence of any warranty;" NL
	"and give any other recipients of the Program a copy of this License" NL
	"along with the Program." NL NL
	"You may charge a fee for the physical act of transferring a copy, and" NL
	"you may at your option offer warranty protection in exchange for a fee." NL
	;

char *options =
	"options:" NL NL
	"-l                List available drivers and defaults." NL
	"-d <drivername>   Override the default choice for the driver." NL
	"-t <devicename>   Override the default choice for the device." NL
	"-w                Show warranty info and exit." NL
	"-c                Show copying info and exit." NL
	"-v                Increases diagnostic message level: more" NL
	"                  occurences of the option specify more detail." NL
	"-h                Show help text." NL NL
	"Options may be combined: for example \"-vvvt /dev/cua0\" selects" NL
	"trace level 3 (three v's) and the device /dev/cua0." NL
	;

char *sps_synopsis =
	NL "syntax:" NL NL
	"sps [options] <filename>" NL NL
	;

char *spr_synopsis =
	NL "syntax:" NL NL
	"spr [options]" NL NL
	;

char *title =
	"SixPack File Transfer Protocol v%s" NL
	"Copyright 1996 Kaz Kylheku" NL
	"This program comes with NO WARRANTY (see \"spr -w\")." NL
    	"This is free software, and you are welcome to redistribute " NL
	"it under certain conditions (for details run \"spr -c\")." NL
	;

void tprint_warranty(void)

{
	tprintf(0, title, version_string);
	tprintf(0, NL "%s%s", license_context, warranty_info);
}

void tprint_distrib(void)

{
	tprintf(0, title, version_string);
	tprintf(0, NL "%s%s", license_context, distrib_info);
}

void tprint_sps_help(void)

{
	tprintf(0, title, version_string);
	tprintf(0, "%s%s", sps_synopsis, options);
}

void tprint_spr_help(void)

{
	tprintf(0, title, version_string);
	tprintf(0, "s%s", spr_synopsis, options);
}

void tprint_title(void)

{
	tprintf(1, title, version_string);
}

void tprint_drivers(void)

{
	driver_t *d;
	drivscan_t ds = driver_scan();

	tprintf(0, "available drivers:" NL NL);

	while ((d = driver_next(&ds)))
		tprintf(0, "%-15.15s %-63.63s"NL, driver_name(d), driver_desc(d));

	tprintf(0, NL "The default driver is \"%s\"." NL, DEFAULT_DRIVER);
	tprintf(0, "The default device for sps is \"%s\"." NL, DEFAULT_SEND_DEVICE);
	tprintf(0, "The default device for spr is \"%s\"." NL, DEFAULT_RECEIVE_DEVICE);
}
