/*
 *
 *	SixPack is Copyright (C) 1996 Kaz Kylheku
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *	The author may be contacted at:
 *
 *	Kaz Kylheku
 *	2869 East 14th Avenue
 *	Vancouver, B.C.
 *	CANADA
 *	V5M 2H8
 *	email: kaz@cafe.net
 *
 */


#ifndef EXREP_H
#define EXREP_H

#include <stddef.h>
#include <limits.h>

#define EX_MARKS	16

typedef struct estream_s {
	unsigned char *buffer;
	size_t size;
	size_t pos;
	size_t mark[EX_MARKS];
} estream_t;

void ex_bindbuf(estream_t *e, unsigned char *buffer, size_t size);
void ex_adjust(estream_t *e, int increment);
void ex_seek(estream_t *e, size_t pos);
size_t ex_getpos(estream_t *e);
size_t ex_getsize(estream_t *e);
unsigned char *ex_getptr(estream_t *e);
unsigned char *ex_getbuf(estream_t *e);
void ex_savemark(estream_t *e, unsigned mark);
void ex_gotomark(estream_t *e, unsigned mark);
size_t ex_getmark(estream_t *e, unsigned mark);
int ex_put_verify(estream_t *e, size_t nbytes);
int ex_get_verify(estream_t *e, size_t nbytes);
void ex_put8(estream_t *e, unsigned char data);
unsigned char ex_get8(estream_t *e);
void ex_put8s(estream_t *e, signed char data);
signed char ex_get8s(estream_t *e);
void ex_put16u(estream_t *e, unsigned int data);
unsigned ex_get16u(estream_t *e);
void ex_put32u(estream_t *e, unsigned long data);
unsigned long ex_get32u(estream_t *e);
void ex_put16s(estream_t *e, int data);
int ex_get16s(estream_t *e);
void ex_put32s(estream_t *e, long data);
long ex_get32s(estream_t *e);
void ex_put8string(estream_t *e, const unsigned char *data, size_t count);
void ex_get8string(estream_t *e, unsigned char *data, size_t count);

#ifdef NDEBUG
#define ex_adjust(e,i)		((void) ((e)->pos += (i)))
#define ex_seek(e,i)		((void) ((e)->pos = (i)))
#define ex_getpos(e)		((e)->pos)
#define ex_getsize(e)		((e)->size)
#define ex_getptr(e)		((e)->buffer + (e)->pos)
#define ex_getbuf(e)		((e)->buffer)
#define ex_put_verify(e,n)	((e)->size - (e)->pos >= (n))
#define ex_get_verify(e,n)	((e)->size - (e)->pos >= (n))
#define ex_put8(e,d)		((e)->buffer[e->pos++] = (d))
#define ex_get8(e)		((e)->buffer[e->pos++])
#define ex_savemark(e,m)	((e)->mark[m] = (e)->pos)
#define ex_gotomark(e,m)	((e)->pos = (e)->mark[m])
#define ex_getmark(e,m)		((e)->mark[m])
#endif

#endif
