/*
 *
 *	SixPack is Copyright (C) 1996 Kaz Kylheku
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *	The author may be contacted at:
 *
 *	Kaz Kylheku
 *	2869 East 14th Avenue
 *	Vancouver, B.C.
 *	CANADA
 *	V5M 2H8
 *	email: kaz@cafe.net
 *
 */


#include <string.h>
#include "exrep.h"

void ex_bindbuf(estream_t *e, unsigned char *buffer, size_t size)

{
	e->buffer = buffer;
	e->size = size;
	e->pos = 0;
	memset(e->mark, 0, sizeof e->mark);
}

void ex_put16u(estream_t *e, unsigned int data)

{
	ex_put8(e, data >> 8);
	ex_put8(e, data & 255);
}

unsigned ex_get16u(estream_t *e)

{
	unsigned char hi, lo;

	hi = ex_get8(e);
	lo = ex_get8(e);

	return (unsigned) hi << 8 | lo;
}

void ex_put32u(estream_t *e, unsigned long data)

{
	ex_put8(e, data >> 24);
	ex_put8(e, (data >> 16) & 255);
	ex_put8(e, (data >> 8) & 255);
	ex_put8(e, data & 255);
}

unsigned long ex_get32u(estream_t *e)

{
	unsigned char buf[4], *p = buf;

	*p++ = ex_get8(e);
	*p++ = ex_get8(e);
	*p++ = ex_get8(e);
	*p++ = ex_get8(e);

	return (unsigned long) buf[0] << 24
	   | (unsigned long) buf[1] << 16
	   | (unsigned) buf[2] << 8
	   | buf[3];
}

void ex_put8s(estream_t *e, signed char data)

{
	ex_put8(e, (unsigned char) data);
}

signed char ex_get8s(estream_t *e)

{
	unsigned int udata;

	udata = ex_get8(e);

	if (udata & 0x80)
		return - (signed char) ((udata ^ 0xff) + 1);
	else 
		return udata;

}

void ex_put16s(estream_t *e, int data)

{
	ex_put16u(e, (unsigned int) data);
}

int ex_get16s(estream_t *e)

{
	unsigned int udata;

	udata = ex_get16u(e);

	if (udata & 0x8000)
		return - (int) ((udata ^ 0xffff) + 1);
	else 
		return udata;
}

void ex_put32s(estream_t *e, long data)

{
	ex_put32u(e, (unsigned long) data);
}

long ex_get32s(estream_t *e)

{
	unsigned long udata;

	udata = ex_get32u(e);

	if (udata & 0x80000000ul)
		return - (long) ((udata ^ 0xfffffffful) + 1);
	else 
		return udata;
}

void ex_put8string(estream_t *e, const unsigned char *data, size_t count)

{
	size_t newpos = e->pos + count;

	memcpy(e->buffer + e->pos, data, count);
	e->pos = newpos;
}

void ex_get8string(estream_t *e, unsigned char *data, size_t count)

{
	size_t newpos = e->pos + count;

	memcpy(data, e->buffer + e->pos, count);
	e->pos = newpos;
}

#undef ex_adjust
#undef ex_seek
#undef ex_getpos
#undef ex_getsize
#undef ex_getptr
#undef ex_getbuf
#undef ex_put_verify
#undef ex_get_verify
#undef ex_put8
#undef ex_get8
#undef ex_savemark
#undef ex_gotomark
#undef ex_getmark

void ex_adjust(estream_t *e, int increment)

{
	e->pos += increment;
}

void ex_seek(estream_t *e, size_t pos)

{
	e->pos = pos;
}

size_t ex_getpos(estream_t *e)

{
	return e->pos;
}

size_t ex_getsize(estream_t *e)

{
	return e->size;
}

unsigned char *ex_getptr(estream_t *e)

{
	return e->buffer + e->pos;
}

unsigned char *ex_getbuf(estream_t *e)

{
	return e->buffer;
}

void ex_savemark(estream_t *e, unsigned mark)

{
	e->mark[mark] = e->pos;
}

void ex_gotomark(estream_t *e, unsigned mark)

{
	e->pos = e->mark[mark];
}

size_t ex_getmark(estream_t *e, unsigned mark)

{
	return e->mark[mark];
}

int ex_put_verify(estream_t *e, size_t nbytes)

{
	return e->size - e->pos >= nbytes;
}

int ex_get_verify(estream_t *e, size_t nbytes)

{
	return e->size - e->pos >= nbytes;
}

void ex_put8(estream_t *e, unsigned char data)

{
	e->buffer[e->pos++] = data;
}

unsigned char ex_get8(estream_t *e)

{
	return e->buffer[e->pos++];
}

