#
#
#	SixPack is Copyright (C) 1996 Kaz Kylheku
#
#	This program is free software; you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation; either version 2 of the License, or
#	(at your option) any later version.
#
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#
#	You should have received a copy of the GNU General Public License
#	along with this program; if not, write to the Free Software
#	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
#	The author may be contacted at:
#
#	Kaz Kylheku
#	2869 East 14th Avenue
#	Vancouver, B.C.
#	CANADA
#	V5M 2H8
#	email: kaz@cafe.net
#



#
# 80386 assembly language version of the maximally portable exrep.c
#
# This is binary compatible with the interface of exrep.h if you use GCC
# and GAS, and don't tinker with GCC's alignment of structure members,
# caller-saved registers, etc.
#
# It is assumed that assembly language symbols don't require any particular
# treatment (such as the addition of leading underscores) to be compatible
# with C.
#

		.file	"exrep-i386.s"

ALIGN		= 16

EX_MARKS	= 16
e_size		= 4
e_pos		= 8
e_mark		= 12

arg1		= 4
arg2		= 8
arg3		= 12

		.text

#
# Many of the following trivial routines are no better than what is
# achieved with gcc -O2 -fomit-frame-pointer, but are included for
# the sake of completeness. The modest savings are achieved in the actual
# encoding and decoding routines.
#

		.globl	ex_bindbuf
ex_bindbuf:
		pushl	%edi
		movl	arg1+4(%esp), %edi	# get pointer to estream_t
		movl	arg2+4(%esp), %eax	# get buffer pointer
		movl	%eax, (%edi)		# store in e->buffer
		movl	arg3+4(%esp), %eax	# get size
		movl	%eax, e_size(%edi)	# store in e->size
		xorl	%eax, %eax		# clear %eax
		movl	%eax, e_pos(%edi)	# clear e->pos
		addl	$e_mark, %edi
		movl	$EX_MARKS, %ecx		# get number of marks
		cld
		rep
		stosl	%eax, (%edi)		# clear e->mark array
		popl	%edi
		ret

		.globl	ex_adjust
ex_adjust:
		movl	arg1(%esp), %edx	# get pointer to estream_t
		movl	arg2(%esp), %eax	# get increment
		addl	%eax, e_pos(%edx)	# add to e->pos
		ret

		.globl	ex_seek
ex_seek:
		movl	arg1(%esp), %edx	# get pointer to estream_t
		movl	arg2(%esp), %eax	# get pos parameter
		movl	%eax, e_pos(%edx)	# store to e->pos
		ret

		.globl	ex_getpos
ex_getpos:
		movl	arg1(%esp), %edx
		movl	e_pos(%edx), %eax
		ret

		.globl	ex_getsize
ex_getsize:
		movl	arg1(%esp), %edx
		movl	e_size(%edx), %eax
		ret

		.globl	ex_getptr
ex_getptr:
		movl	arg1(%esp), %edx
		movl	(%edx), %eax
		addl	e_pos(%edx), %eax
		ret

		.globl	ex_getbuf
ex_getbuf:
		movl	arg1(%esp), %edx
		movl	(%edx), %eax
		ret

		.globl	ex_savemark
ex_savemark:
		movl	arg1(%esp), %edx
		movl	arg2(%esp), %ecx
		movl	e_pos(%edx), %eax
		movl	%eax, e_mark(%edx, %ecx, 4)
		ret

		.globl	ex_gotomark
ex_gotomark:
		movl	arg1(%esp), %edx
		movl	arg2(%esp), %ecx
		movl	e_mark(%edx, %ecx, 4), %eax
		movl	%eax, e_pos(%edx)
		ret

		.globl	ex_getmark
ex_getmark:
		movl	arg1(%esp), %edx
		movl	arg2(%esp), %ecx
		movl	e_mark(%edx, %ecx, 4), %eax
		ret

		.globl	ex_put_verify, ex_get_verify
ex_put_verify:
ex_get_verify:
		xorl	%eax, %eax
		movl	arg1(%esp), %edx
		movl	e_pos(%edx), %ecx
		subl	e_size(%edx), %ecx
		cmpl	%ecx, arg2(%esp)
		setbe	%al
		ret

		.align	ALIGN
		.globl	ex_put8, ex_put8s
ex_put8:
ex_put8s:
		movl	arg1(%esp), %edx
		movb	arg2(%esp), %al
		movl	e_pos(%edx), %ecx
		incl	%ecx
		movl	%ecx, e_pos(%edx)
		decl	%ecx
		movl	(%edx), %edx
		movb	%al, (%edx, %ecx, 1)
		ret


		.align	ALIGN
		.globl	ex_get8
ex_get8:
		xorl	%eax, %eax
		movl	arg1(%esp), %edx
		movl	e_pos(%edx), %ecx
		incl	%ecx
		movl	%ecx, e_pos(%edx)
		movl	(%edx), %edx
		movzbl	-1(%edx, %ecx, 1), %eax
		ret


		.align	ALIGN
		.globl	ex_get8s
ex_get8s:
		xorl	%eax, %eax
		movl	arg1(%esp), %edx
		movl	e_pos(%edx), %ecx
		incl	%ecx
		movl	%ecx, e_pos(%edx)
		movl	(%edx), %edx
		movsbl	-1(%edx, %ecx, 1), %eax
		ret

		.align	ALIGN
		.globl	ex_put16u, ex_put16s
ex_put16u:
ex_put16s:
		movl	arg1(%esp), %edx
		movw	arg2(%esp), %ax
		movl	e_pos(%edx), %ecx
		incl	%ecx
		incl	%ecx
		movl	%ecx, e_pos(%edx)
		movl	(%edx), %edx
		xchgb	%ah, %al
		movw	%ax, -2(%edx, %ecx, 1)
		ret

		.align	ALIGN
		.globl	ex_get16u
ex_get16u:
		movl	arg1(%esp), %edx
		movl	e_pos(%edx), %ecx
		incl	%ecx
		incl	%ecx
		movl	%ecx, e_pos(%edx)
		movl	(%edx), %edx
		movzwl	-2(%edx, %ecx, 1), %eax
		xchgb	%al, %ah
		ret

		.align	ALIGN
		.globl	ex_get16s
ex_get16s:
		movl	arg1(%esp), %edx
		movl	e_pos(%edx), %ecx
		incl	%ecx
		incl	%ecx
		movl	%ecx, e_pos(%edx)
		movl	(%edx), %edx
		movw	-2(%edx, %ecx, 1), %dx
		xchgb	%dl, %dh
		movswl	%dx, %eax
		ret

		.align	ALIGN
		.globl	ex_put32u, ex_put32s
ex_put32u:
ex_put32s:
		movl	arg1(%esp), %edx
		movl	arg2(%esp), %eax
		movl	e_pos(%edx), %ecx
		addl	$4, %ecx
		movl	%ecx, e_pos(%edx)
		movl	(%edx), %edx
		xchgb	%al, %ah
		roll	$16, %eax
		xchgb	%al, %ah
		movl	%eax, -4(%edx, %ecx, 1)
		ret

		.align	ALIGN
		.globl	ex_get32u, ex_get32s
ex_get32u:
ex_get32s:
		movl	arg1(%esp), %edx
		movl	e_pos(%edx), %ecx
		addl	$4, %ecx
		movl	%ecx, e_pos(%edx)
		movl	(%edx), %edx
		movl	-4(%edx, %ecx, 1), %eax
		xchgb	%al, %ah
		roll	$16, %eax
		xchgb	%al, %ah
		ret


		.align	ALIGN
		.globl	ex_put8string
ex_put8string:
		pushl	%edi
		pushl	%esi
		movl	arg1+8(%esp), %edx
		movl	arg2+8(%esp), %esi
		movl	arg3+8(%esp), %ecx
		movl	(%edx), %edi
		addl	%ecx, e_pos(%edx)
		cld
		rep
		movsb	(%esi), (%edi)
		popl	%esi
		popl	%edi
		ret

		.align	ALIGN
		.globl	ex_get8string
ex_get8string:
		pushl	%edi
		pushl	%esi
		movl	arg1+8(%esp), %edx
		movl	arg2+8(%esp), %edi
		movl	arg3+8(%esp), %ecx
		movl	(%edx), %esi
		addl	%ecx, e_pos(%edx)
		cld
		rep
		movsb	(%esi), (%edi)
		popl	%esi
		popl	%edi
		ret

