/*
 *
 *	SixPack is Copyright (C) 1996 Kaz Kylheku
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *	The author may be contacted at:
 *
 *	Kaz Kylheku
 *	2869 East 14th Avenue
 *	Vancouver, B.C.
 *	CANADA
 *	V5M 2H8
 *	email: kaz@cafe.net
 *
 */


#include "driver.h"
#include "posixtty.h"
#include "testdev.h"
#include "tcpdev.h"

driver_t driver_table[] = {
	{
		"posix_tty",
		"interface to POSIX-compliant UNIX(r)-style terminal driver",
		posix_init,
		posix_deinit,
		posix_ttyopen,
		posix_ttyclose,
		posix_ttyread,
		posix_ttywrite,
	},
	{
		"testdev",
		"dummy test device built over standard C I/O facilities",
		testdev_init,
		testdev_deinit,
		testdev_open,
		testdev_close,
		testdev_read,
		testdev_write,
	},
	{
		"tcp",
		"interface to socket-based TCP/IP",
		tcp_init,
		tcp_deinit,
		tcp_open,
		tcp_close,
		tcp_read,
		tcp_write,
	}
};

int driver_count = sizeof driver_table / sizeof *driver_table;
