/*
 *
 *	SixPack is Copyright (C) 1996 Kaz Kylheku
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *	The author may be contacted at:
 *
 *	Kaz Kylheku
 *	2869 East 14th Avenue
 *	Vancouver, B.C.
 *	CANADA
 *	V5M 2H8
 *	email: kaz@cafe.net
 *
 */


#ifndef DRIVER_H
#define DRIVER_H

#include <stddef.h>
#include <stdarg.h>

typedef union handle_u {
	void *p;
	long i;
} handle_t;

typedef struct devblk_s *device_t;

typedef struct driver_s {
	char name[16];
	char desc[64];
	int (* init)(struct driver_s *);
	void (* deinit)(struct driver_s *);
	int (* open)(device_t dev, void *specific, va_list args);
	int (* close)(device_t);
	int (* read)(device_t, void *, size_t, size_t *);
	int (* write)(device_t, void *, size_t, size_t *);
} driver_t;

#define driver_name(d) ((d)->name)
#define driver_desc(d) ((d)->desc)

extern driver_t driver_table[];
extern int driver_count;

void driver_init(void);
void driver_deinit(void);
driver_t *driver_register(driver_t *driver);
driver_t *driver_lookup(char *name);

typedef driver_t *drivscan_t;

drivscan_t driver_scan(void);
driver_t *driver_next(drivscan_t *pds);
void driver_endscan(drivscan_t ds);

#endif
