/*
 *
 *	SixPack is Copyright (C) 1996 Kaz Kylheku
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *	The author may be contacted at:
 *
 *	Kaz Kylheku
 *	2869 East 14th Avenue
 *	Vancouver, B.C.
 *	CANADA
 *	V5M 2H8
 *	email: kaz@cafe.net
 *
 */


#include "driver.h"

driver_t *driver_register(driver_t *driver);

driver_t *driver_lookup(char *name)

{
	int i;

	for (i = 0; i < driver_count; i++) {
		if (!strcmp(name, driver_table[i].name))
			return driver_table + i;
	}

	return 0;
}

void driver_init(void)

{
	int i;

	for (i = 0; i < driver_count; i++) {
		if (*driver_table[i].name)
			driver_table[i].init(driver_table + i);
	}
}

void driver_deinit(void)

{
	int i;

	for (i = 0; i < driver_count; i++) {
		if (*driver_table[i].name)
			driver_table[i].deinit(driver_table + i);
	}
}

drivscan_t driver_scan(void)

{
	return 0;
}

driver_t *driver_next(drivscan_t *pds)

{
	if (*pds == 0)
		return (*pds = driver_table);

	if (*pds < driver_table + driver_count - 1)
		return ++(*pds);

	return (*pds = 0);
}

void driver_endscan(drivscan_t ds)

{
	return;
}
