/*
 *
 *	SixPack is Copyright (C) 1996 Kaz Kylheku
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *	The author may be contacted at:
 *
 *	Kaz Kylheku
 *	2869 East 14th Avenue
 *	Vancouver, B.C.
 *	CANADA
 *	V5M 2H8
 *	email: kaz@cafe.net
 *
 */


#include <stdlib.h>
#include <string.h>
#include "device.h"

device_t device_open(driver_t *driver, void *specific, ...)

{
	va_list args;
	device_t device;

	if ((device = malloc(sizeof *device)) == 0)
		goto open_fail_1;

	va_start(args, specific);

	if (driver->open(device, specific, args) == 0)
		goto open_fail_2;

	device->driver = driver;
	device->timeout = 0;

	va_end(args);
	return device;

open_fail_2:
	free(device);
open_fail_1:
	va_end(args);

	return 0;
}

int device_read(device_t dev, void *data, size_t nbytes, size_t *nread)

{
	return dev->driver->read(dev, data, nbytes, nread);
}

int device_write(device_t dev, void *data, size_t nbytes, size_t *nwrit)

{
	return dev->driver->write(dev, data, nbytes, nwrit);
}

int device_close(device_t dev)

{
	if (dev->driver->close(dev)) {
		free(dev);
		return 1;
	}

	return 0;
}

void device_timeout(device_t dev, timeout_t t)

{
	dev->timeout = t;
}


