/*  CRC-32 version 1.04 by Craig Bruce, 05-Dec-1994
**
**  Based on "File Verification Using CRC" by Mark R. Nelson in Dr. Dobb's
**  Journal, May 1992, pp. 64-67.  This program DOES generate the same CRC
**  values as ZMODEM and PKZIP
**
**  v1.00: original release.
**  v1.01: fixed printf formats.
**  v1.02: fixed something else.
**  v1.03: replaced CRC constant table by generator function.
**  v1.04: reformatted code, made ANSI C.  05-Dec-1994.
**
*/

#include "crc.h"

unsigned long crcTable[256];

unsigned long getcrc(unsigned char *buf, size_t len)
{
	register unsigned long crc;
	unsigned char *c, *end;
	static long init = 0;

	if (!init) {
		init = 1;
		crcgen();
	}	

	crc = 0xFFFFFFFFLU;
	c = buf;
	end = buf + len;
	while( c < end ) {
		crc = ((crc>>8) & 0x00FFFFFFL) ^ crcTable[ (crc^(*c)) & 0xFF ];
		c++;
	}
	return( crc^0xFFFFFFFFLU );
}

void crcgen(void)
{
	unsigned long crc, poly;
	unsigned i, j;

	poly = 0xEDB88320L;
	for (i = 0; i < 256; i++) {
		crc = i;
		for (j = 8; j > 0; j--) {
			if (crc & 1) {
				crc = (crc >> 1) ^ poly;
			} else {
				crc >>= 1;
			}
		}
		crcTable[i] = crc;
	}
}
