/*
 *
 *	SixPack is Copyright (C) 1996 Kaz Kylheku
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *	The author may be contacted at:
 *
 *	Kaz Kylheku
 *	2869 East 14th Avenue
 *	Vancouver, B.C.
 *	CANADA
 *	V5M 2H8
 *	email: kaz@cafe.net
 *
 */


#ifndef BUFIO_H
#define BUFIO_H

#include "device.h"

#define B_EOF	-1

typedef enum {
	bufe_ok,
	bufe_error,
	bufe_timeout
} buferr_t;

typedef struct bufio_s {
	device_t dev;
	char *inbuf;
	char *outbuf;
	size_t cur_in;
	size_t cur_out;
	size_t avail_in;
	size_t max_in;
	size_t max_out;
	buferr_t error;
} *bufio_t;

bufio_t buf_create(device_t dev, size_t max_in, size_t max_out);
void buf_dispose(bufio_t buf);

device_t buf_getdev(bufio_t buf);
int buf_replenish(bufio_t buf);
int buf_getchar(bufio_t buf);
int buf_putchar(bufio_t buf, int ch);
int buf_ungetchar(bufio_t buf, int ch);
int buf_write(bufio_t buf, void *data, size_t nbyte);
int buf_read(bufio_t buf, void *data, size_t nbyte);
int buf_flush(bufio_t buf);
buferr_t buf_error(bufio_t buf);
void buf_clrerror(bufio_t buf);

#ifdef NDEBUG
#define buf_error(b) ((b)->error)
#define buf_getchar(b) (((b)->avail_in <= (b)->cur_in) ?		\
	(buf_replenish(b)) ?						\
		(b)->inbuf[(b)->cur_in++]				\
	:	B_EOF							\
:	(b)->inbuf[(b)->cur_in++])
#define buf_putchar(b, c) (((b)->cur_out == (b)->max_out) ?		\
	(buf_flush(b)) ?						\
		((b)->outbuf[(b)->cur_out++]				\
			= (c), 1)					\
	:	0							\
: ((b)->outbuf[(b)->cur_out++] = (c)))
#define buf_ungetchar(b, c) (((b)->cur_in > 0) ?			\
	((b)->inbuf[--(b)->cur_in] = (c), 1)				\
:	0)
#endif

#endif
