/* tryfax.c: A simple program to see if a fax number is handled by TPC.INT. */
/* Copyright (C) 1993, 1996  Brendan Kehoe,  Shyamal Somaroo. */

/* This program is free software; you can redistribute it and/or */
/* modify it under the terms of the GNU General Public License */
/* as published by the Free Software Foundation; either version 2 */
/* of the License, or (at your option) any later version. */

/* This program is distributed in the hope that it will be useful, */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the */
/* GNU General Public License for more details. */

/* You should have received a copy of the GNU General Public License */
/* along with this program; if not, write to the Free Software */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. */

/* This Program has been edited for use with FaxMail with the kind 
   permission of Brendan Kehoe, the original author.
   Compilation should be easy eg. on most machines one would execute
   
   cc tryfax.c -lresolv -o tryfax

   On linux it should be even simpler:
   
   cc tryfax.c -o tryfax

   Its as easy as that.

   Shyamal Somaroo (sss1001@cam.ac.uk) 9 Feb 1996.
*/

/* A simple program to see if a fax number is handled by TPC.INT.
   Note you may need to link with `-lresolv' for this to work
   correctly.  I've verified that it works on:

	Machine		OS
	-------		--
	sparc		SunOS, Solaris-2
	alpha		OSF/1
	m68k		NeXTOS
	rs6000		AIX
	hp700		HP/UX
	hp300		HP/UX
	mips		Ultrix, IRIX
	i386		SVR4.2, 386BSD, SCO-3.2[-lsocket]

   by Brendan Kehoe (brendan@zen.org), 10/1/93.  */

#include <stdio.h>
#include <sys/types.h>
#ifdef _AIX
/* The RS6000 needs this to get BYTE_ORDER for arpa/nameser.h.  */
#include <sys/machine.h>
#endif
#include <arpa/nameser.h>
#include <netdb.h>
#include <sys/socket.h>
#ifdef sun
#include <sys/stream.h>
#endif /* sun */
#undef NOERROR			/* Solaris has this in sys/stream.h */
#include <netinet/in.h>
#include <resolv.h>
#include <sys/param.h>

typedef union {
	HEADER qb1;
	char qb2[PACKETSZ];
} querybuf;

char *programname;

void
fatal (s, x)
     char *s;
     int x;
{
  if (x)
    fprintf (stderr, "%s\n", s);
  else
    fprintf (stderr, "%s: %s\n", programname, s);
  exit (1);
}

/* Given a phone number in N, like `415/903-1234', return the reverse-dot
   notation used by TPC, e.g., `4.3.2.1.3.0.9.5.1.4.1.tpc.int.'.  Note it
   includes the trailing dot needed for DNS resolving.  */
char *
translate (n)
     char *n;
{
  int i, j, k;
  static char buf[MAXDNAME];


  memset (buf, 0, MAXDNAME);

  i = strlen (n);
  for (j = i - 1, k = 0; j != -1; j--)
    {
      if (n[j] == '(' || n[j] == ')'
	  || n[j] == '-' || n[j] == '/'
	  || n[j] == '+' || n[j] == ' ')
	continue;
      buf[k++] = n[j];
      buf[k++] = '.';
    }

  /* This has been changed to allow for more than US numbers. SSS 11/2/96
   */
   strcat (buf, "tpc.int.");
  return buf;
}

int
main (argc, argv)
     int argc;
     char **argv;
{
  HEADER *hp;
  register char *bp;
  querybuf repl;
  int n, buflen, qdcount;
  unsigned short type;
  char *hptr, *reversed, *eom;
  char name[MAXDNAME];

  if (argc == 1)
    {
      fprintf (stderr, "usage: %s fax-number\n", argv[0]);
      exit (1);
    }
  programname = argv[0];

  /* Put the phone number in the form of a TPC address.  */ 
  reversed = translate (argv[1]);

  if ((_res.options & RES_INIT) == 0
      && res_init() == -1)
    fatal ("res_init failed", 0);

  _res.retrans = 5;
  _res.options &= ~RES_DEFNAMES;
  n = res_search (reversed, C_IN, T_MX, (char *)&repl, sizeof(repl));
  if (n < 0)
    { printf("res_search failed\n");
    exit(0);
    }

  hp = (HEADER *) &repl;
  hptr = (char *)&repl + sizeof(HEADER);
  eom = (char *)&repl + n;

  for (qdcount = ntohs(hp->qdcount); qdcount--; hptr += n + QFIXEDSZ)
    if ((n = dn_skipname(hptr, eom)) < 0)
      fatal ("died running through the questions", 0);

  buflen = sizeof (name) - 1;
  bp = name;
  n = dn_expand((char *)&repl, eom, hptr,
		(char *)bp, buflen);
  if (n < 0)
    fatal ("dn_expand on the first name", 0);
  hptr += n;
  GETSHORT (type, hptr);
  hptr += sizeof (unsigned short) + sizeof (unsigned int);
  GETSHORT (n, hptr);
  if (type != T_MX)
    fatal ("unxpected answer", 0);

  /* Skip the preference.  */
  hptr += sizeof (unsigned short);

  /* Get the full name of the host we found.  Each entry in TPC.INT should
     ONLY have one MX record, so we go with the first.  */
  n = dn_expand ((char *)&repl, eom, hptr,
		 (char *)bp, buflen);
  if (n < 0)
    fatal ("dn_expand on the MX name failed", 0);

  /* If it's sinkhole.town.hall.org, that means the number isn't yet
     covered---it's the wildcard match in the DNS zones for all unhandled
     areas.  */
  if (strncasecmp (name, "sinkhole", 8) == 0)
    printf("Number not covered yet!\n");
  else

  /* Produce positive reult if number is found.  */

  printf ("Number covered!\n", argv[1]);

  exit (0);
}
