#!/usr/bin/wish -f

# FaxMail lets you send faxes for free via email.  See http://www.tpc.int/
# Copyright (C) 1996, 1997, 1998 David Burns, Shyamal Somaroo, Matthew Davey.

# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

# Program: FaxMail
# Tcl version: 7.5 (Tcl/Tk/XF)
# Tk version: 4.1
# XF version: 4.0

# FaxMail is based on the faxtool program written by David Burns and
# Shyamal Somaroo.  Faxtool became FaxMail in 1997 when the address book
# and postscript file browser were added by Matthew Davey, the name was
# changed to avoid a clash with a different package.

# Maintained by  Matt Davey at mcdavey@@mrao.cam.ac.uk.


if {$tk_version < 4.0} {
    puts stderr "\nSorry: wrong TK version: need at least 4.0\n"
    destroy .
}

if {[info exists tcl_platform]} {
    if {$tcl_platform(platform) != "unix"} {
	puts stderr " Sorry, FaxMail is a UNIX program.  \n\
		Try checking out http://www-usa.tpc.int/clients.html" 
        destroy .
    }
}


# procedure to show window ShowWindow.address
proc ShowWindow.address { args} {

# build widget .address
  catch "destroy .address"
  toplevel .address   -relief {raised}

  # Window manager configurations
  wm positionfrom .address program
  wm sizefrom .address program
  wm maxsize .address 1000 1000
  wm minsize .address 10 10
  wm protocol .address WM_DELETE_WINDOW {addr_close}
  wm title .address {FaxMail Address Book}


  # build widget .address.frame11
  frame .address.frame11  -borderwidth {2}  -height {30}  -relief {raised}  -width {30}

  # build widget .address.frame11.country
  label .address.frame11.country  -text {COUNTRY CODE:}

  # build widget .address.frame11.local
  label .address.frame11.local  -text {LOCAL CODE:}

  # build widget .address.frame11.number
  label .address.frame11.number  -text {FAX NUMBER:}

  # build widget .address.frame11.recipient
  label .address.frame11.recipient  -foreground {black}  -text {RECIPIENT'S NAME:}

  # build widget .address.frame11.org
  label .address.frame11.org  -text {ORGANISATION:}

  # build widget .address.frame11.email
  label .address.frame11.email  -text {EMAIL:}

  # build widget .address.frame11.entry23
  entry .address.frame11.entry23  -width {4}
  # bindings
  bind .address.frame11.entry23 <FocusIn> {set addr_book(modified) 1}

  # build widget .address.frame11.entry24
  entry .address.frame11.entry24 -width {4}
  # bindings
  bind .address.frame11.entry24 <FocusIn> {set addr_book(modified) 1}

  # build widget .address.frame11.entry25
  entry .address.frame11.entry25 -width {30}
  # bindings
  bind .address.frame11.entry25 <FocusIn> {set addr_book(modified) 1}

  # build widget .address.frame11.entry26
  entry .address.frame11.entry26 -width {30}
  bind .address.frame11.entry26 <FocusIn> {set addr_book(modified) 1}

  # build widget .address.frame11.entry27
  entry .address.frame11.entry27 -width {30}
  bind .address.frame11.entry27 <FocusIn> {set addr_book(modified) 1}

  # build widget .address.frame11.entry28
  entry .address.frame11.entry28 -width {30}
  # bindings
  bind .address.frame11.entry28 <FocusIn> {set addr_book(modified) 1}

  # build widget .address.frame11.addr_buttons
  frame .address.frame11.addr_buttons  -borderwidth {2}

  # build widget .address.frame11.addr_buttons.button32
  button .address.frame11.addr_buttons.button32  -command {addr_clear}  -foreground {Blue}  -padx {9}  -pady {3}  -text {CLEAR}

  # build widget .address.frame11.addr_title_frame
  frame .address.frame11.addr_title_frame

  # build widget .address.frame11.addr_title_frame.label1
  label .address.frame11.addr_title_frame.label1  -text {Alias:}

  # build widget .address.frame11.addr_title_frame.alias
  message .address.frame11.addr_title_frame.alias  -aspect {1500}  -padx {5}  -pady {2}

  # build widget .address.frame12
  frame .address.frame12  -borderwidth {2}  -height {30}  -relief {raised}  -width {30}

  # build widget .address.frame12.frame
  frame .address.frame12.frame

  # build widget .address.frame12.frame.scrollbar3
  scrollbar .address.frame12.frame.scrollbar3  -command {.address.frame12.frame.listbox1 xview}  -orient {horizontal}  -relief {raised}

  # build widget .address.frame12.frame.scrollbar2
  scrollbar .address.frame12.frame.scrollbar2  -command {.address.frame12.frame.listbox1 yview}  -relief {raised}

  # build widget .address.frame12.frame.listbox1
  listbox .address.frame12.frame.listbox1  -exportselection {0}  -relief {raised}  -xscrollcommand {.address.frame12.frame.scrollbar3 set}  -yscrollcommand {.address.frame12.frame.scrollbar2 set}
  # bindings
  bind .address.frame12.frame.listbox1 <B1-Motion> {%W select anchor [%W nearest %y]}
  bind .address.frame12.frame.listbox1 <ButtonRelease-1> {addr_set}
  bind .address.frame12.frame.listbox1 <Shift-B1-Motion> {%W select anchor [%W nearest %y]}
  bind .address.frame12.frame.listbox1 <Shift-Button-1> {%W select anchor [%W nearest %y]}

  # build widget .address.frame12.buttons
  frame .address.frame12.buttons  -borderwidth {2}

  # build widget .address.frame12.buttons.new
  button .address.frame12.buttons.new  -command {addr_new}  -foreground {Blue}  -padx {9}  -pady {3}  -text {NEW}

  # build widget .address.frame12.buttons.button6
  button .address.frame12.buttons.button6  -command {addr_delete}  -foreground {Blue}  -padx {9}  -pady {3}  -text {DELETE}

  # build widget .address.frame12.buttons.select
  button .address.frame12.buttons.select  -command {addr_name}  -foreground {Blue}  -padx {9}  -pady {3}  -text {RENAME}

  # build widget .address.frame12.buttons.close
  button .address.frame12.buttons.close  -command {addr_close}  -foreground {Red}  -padx {9}  -pady {3}  -text {CLOSE}

  # build widget .address.frame12.buttons.use
  button .address.frame12.buttons.use  -command {addr_select}  -foreground {Blue}  -padx {9}  -pady {3}  -text {USE}

  # build widget .address.frame12.title
  label .address.frame12.title  -text {Entries in address book:}

  # pack master .address.frame11
  pack configure .address.frame11.addr_title_frame  -expand 1  -fill x
  pack configure .address.frame11.country  -anchor w
  pack configure .address.frame11.entry23  -anchor w
  pack configure .address.frame11.local  -anchor w
  pack configure .address.frame11.entry24  -anchor w
  pack configure .address.frame11.number  -anchor w
  pack configure .address.frame11.entry25  -anchor w
  pack configure .address.frame11.recipient  -anchor w
  pack configure .address.frame11.entry26  -anchor w
  pack configure .address.frame11.org  -anchor w
  pack configure .address.frame11.entry27  -anchor w
  pack configure .address.frame11.email  -anchor w
  pack configure .address.frame11.entry28  -anchor w
  pack configure .address.frame11.addr_buttons

  # pack master .address.frame11.addr_buttons
  pack configure .address.frame11.addr_buttons.button32  -side left

  # pack master .address.frame11.addr_title_frame
  pack configure .address.frame11.addr_title_frame.label1  -anchor w  -side left
  pack configure .address.frame11.addr_title_frame.alias  -side left

  # pack master .address.frame12
  pack configure .address.frame12.title  -anchor w
  pack configure .address.frame12.frame  -expand 1  -fill both
  pack configure .address.frame12.buttons  -side bottom

  # pack master .address.frame12.frame
  pack configure .address.frame12.frame.scrollbar2  -fill y  -side left
  pack configure .address.frame12.frame.listbox1  -expand 1  -fill both
  pack configure .address.frame12.frame.scrollbar3  -fill x  -side bottom

  # pack master .address.frame12.buttons
  pack configure .address.frame12.buttons.new  -side left
  pack configure .address.frame12.buttons.button6  -side left
  pack configure .address.frame12.buttons.select  -side left
  pack configure .address.frame12.buttons.use  -side left
  pack configure .address.frame12.buttons.close  -side left

  # pack master .address
  pack configure .address.frame12  -anchor s  -expand 1  -fill both  -side left
  pack configure .address.frame11  -expand 1  -fill both

}

proc DestroyWindow.address {} {# xf ignore me 7
    catch "destroy .address"
    update
}


# procedure to show window ShowWindow.entry
proc ShowWindow.entry { args} {

  # build widget .entry
    catch "destroy .entry"

  toplevel .entry   -relief {raised}

  # Window manager configurations
  wm positionfrom .entry ""
  wm sizefrom .entry ""
  wm maxsize .entry 1265 994
  wm minsize .entry 1 1
  wm title .entry {FaxMail: entry}


  # build widget .entry.m
  message .entry.m  -aspect {1500}  -padx {5}  -pady {2}  -text {Enter alias name:}

  # build widget .entry.entry
  entry .entry.entry  -textvariable {prompt(result)}
  # bindings
  bind .entry.entry <Key-Return> {set prompt(ok) 1}

  # build widget .entry.b1
  button .entry.b1  -command {set prompt(ok) 1}  -padx {9}  -pady {3}  -text {OK}

  # build widget .entry.b2
  button .entry.b2  -command {set prompt(ok) 0}  -padx {9}  -pady {3}  -text {CANCEL}

  # pack master .entry
  pack configure .entry.m
  pack configure .entry.entry
  pack configure .entry.b1  -anchor s  -side left
  pack configure .entry.b2  -anchor s  -side right
}

proc DestroyWindow.entry {} {# xf ignore me 7
    catch "destroy .entry"
    update
}


# procedure to show window ShowWindow.yesno
proc ShowWindow.yesno { args} {

  # build widget .yesno
    catch "destroy .yesno"
  toplevel .yesno   -relief {raised}

  # Window manager configurations
  wm positionfrom .yesno ""
  wm sizefrom .yesno user
  wm maxsize .yesno 1265 994
  wm minsize .yesno 1 1
  wm title .yesno {FaxMail: dialogue}


  # build widget .yesno.message
  message .yesno.message  -aspect {1500}  -foreground {red}  -padx {5}  -pady {2}  -text {Save changes to address book?}

  # build widget .yesno.yes
  button .yesno.yes  -command {global yesno
set yesno(result) "yes"
destroy .yesno}  -padx {9}  -pady {3}  -text {YES}

  # build widget .yesno.no
  button .yesno.no  -command {global yesno
set yesno(result) "no"
destroy .yesno}  -padx {9}  -pady {3}  -text {NO}

  # pack master .yesno
  pack configure .yesno.message
  pack configure .yesno.yes  -anchor w  -padx 3  -pady 4  -side left
  pack configure .yesno.no  -anchor e  -padx 12  -pady 12  -side right
}

proc DestroyWindow.yesno {} {# xf ignore me 7
    catch "destroy .yesno"
    update
}

# procedure to show window .
proc ShowWindow. {args} {# xf ignore me 7

  global images

  # Window manager configurations
  wm positionfrom . ""
  wm sizefrom . user
  wm maxsize . 1265 994
  wm minsize . 1 1
  wm protocol . WM_DELETE_WINDOW {XFProcError {Application windows can not be destroyed.
Please use the "Current widget path:" to show/hide windows.}}
  wm title . {FaxMail-2.3}


  # build widget .b
  frame .b

  # build widget .b.b1
  button .b.b1 \
	  -command {fax} \
	  -foreground {blue} \
	  -padx {9} \
	  -pady {3} \
	  -text {FAX}
  
  # build widget .b.b4
  button .b.b4 \
	  -command {clear} \
	  -foreground {blue} \
	  -padx {9} \
	  -pady {3} \
	  -text {RESET}
  
  # build widget .b.b3
  button .b.b3 \
	  -command {preferences} \
	  -foreground {blue} \
	  -padx {9} \
	  -pady {3} \
	  -text {PERSONAL}
  
  # build widget .b.b6
  button .b.b6 \
	  -command {coverage} \
	  -foreground {blue} \
	  -padx {9} \
	  -pady {3} \
	  -text {COVERAGE}
  
  # build widget .b.b5
  button .b.b5 \
	  -command {about} \
	  -foreground {blue} \
	  -padx {9} \
	  -pady {3} \
	  -text {ABOUT}
  
  # build widget .b.b7
  button .b.b7 \
	  -command {addresses} \
	  -foreground {blue} \
	  -padx {9} \
	  -pady {3} \
	  -text {ADDRESSES}
  
  # build widget .b.b2
  button .b.b2 \
	  -command {quit} \
	  -foreground {Red} \
	  -padx {9} \
	  -pady {3} \
	  -text {QUIT}


  # build widget .www
  frame .www

  # build widget .www.label9
  label .www.label9 \
    -text {SUBJECT:}

  # build widget .www.entry16
  entry .www.entry16 \
    -textvariable {recipient(subject)} \
    -width {70}

  # build widget .p
  frame .p
  frame .p.list

#  scrollbar .p.list.sx  -command {.p.list.box xview}  -orient {horizontal}  -relief {raised}
  scrollbar .p.list.sy  -command {.p.list.box yview}  -relief {raised}
#  listbox .p.list.box  -height 3 -width 46 -exportselection {0}  -relief {raised}  -xscrollcommand {.p.list.sx set}  -yscrollcommand {.p.list.sy set}
  listbox .p.list.box  -height 3 -width 46 -exportselection {0}  -relief {raised}  -yscrollcommand {.p.list.sy set}

  frame .p.buttons  -borderwidth {2}

  # build widget .address.frame12.buttons.button6
  button .p.buttons.del  -command {.p.list.box delete active}  -foreground {Blue}  -padx {9}  -pady {3}  -text {DELETE}

  # build widget .p.label1
  label .p.label1 \
    -text {FILES TO INCLUDE:}

  # build widget .p.button0
  menubutton .p.buttons.add \
    -menu .p.buttons.add.menu0 \
    -padx {9} \
    -pady {3} \
    -foreground {Blue} \
    -relief raised \
    -text {ADD}

  # build file add menu
  menu .p.buttons.add.menu0 -tearoff 0
  .p.buttons.add.menu0 add command \
    -command {file_add "(postscript)" "ps"} \
    -foreground {Blue} \
    -label {Postscript}
  .p.buttons.add.menu0 add command \
    -command {file_add "(plain text)" "*" } \
    -foreground {Blue} \
    -label {Plain text}
  if { $images } {
  .p.buttons.add.menu0 add command \
    -command {file_add "(image)" "*"} \
    -foreground {Blue} \
    -label {Image}
  }
  # build widget .tt
  frame .tt \
    -borderwidth {4} \
    -relief {ridge}

  # build widget .tt.f
  frame .tt.f \
    -borderwidth {2}

  # build widget .tt.f.b2
  button .tt.f.b2 \
    -command {.tt.t delete 1.0 end} \
    -foreground {Blue} \
    -padx {9} \
    -pady {3} \
    -text {CLEAR}

  # build widget .tt.f.label3
  label .tt.f.label3 \
    -borderwidth {4} \
    -text {Email-Fax Text Message:}

  # build widget .tt.t
  text .tt.t \
    -highlightthickness {1} \
    -yscrollcommand {.tt.scroll set} \
    -height {15}

  # build widget .tt.scroll
  scrollbar .tt.scroll \
    -command {.tt.t yview}

  # build widget .w
  frame .w
  frame .w.top
  frame .w.top.left
  frame .w.top.right
  frame .w.bot
  # build widget .w.top.left.label
  label .w.top.left.label \
    -text {COUNTRY CODE:}

  # build widget .w.topright.label
  label .w.top.right.label \
    -text {LOCAL CODE:}

  # build widget .w.bot.label
  label .w.bot.label \
    -text {FAX NUMBER:}
  
  # build widget .w.bot.check
  button .w.bot.check \
    -command {checknum 1} \
    -foreground {blue} \
    -padx {9} \
    -pady {3} \
    -text {CHECK COVERAGE}

  # build widget .w.top.left.entry
  entry .w.top.left.entry \
    -textvariable {recipient(country)} \
    -width {4}

  # build widget .w.top.right.entry
  entry .w.top.right.entry \
    -textvariable {recipient(local)} \
    -width {4}

  # build widget .w.bot.entry
  entry .w.bot.entry \
    -textvariable {recipient(number)} \
    -width {40}

  # build widget .ww
  frame .ww

  # build widget .ww.label5
  label .ww.label5 \
    -text {RECIPIENT'S NAME:}

  # build widget .ww.label6
  label .ww.label6 \
    -text {ORGANISATION:}

  # build widget .ww.label7
  label .ww.label7 \
    -text {DEPARTMENT:}

  # build widget .ww.label8
  label .ww.label8 \
    -text {EMAIL:}

  # build widget .ww.entry5
  entry .ww.entry5 \
    -textvariable {recipient(name)} \
    -width {40}

  # build widget .ww.entry6
  entry .ww.entry6 \
    -textvariable {recipient(organisation)} \
    -width {40}

  # build widget .ww.entry7
  entry .ww.entry7 \
    -textvariable {recipient(department)} \
    -width {40}

  # build widget .ww.entry8
  entry .ww.entry8 \
    -textvariable {recipient(email)} \
    -width {40}

  # build widget .label0
  label .label0

  # pack master .b
  pack configure .b.b1 \
    -side left
  pack configure .b.b4 \
    -side left
  pack configure .b.b3 \
    -side left
  pack configure .b.b6 \
    -side left
  pack configure .b.b5 \
    -side left
  pack configure .b.b2 \
    -side right
  pack configure .b.b7 \
    -side left

  # pack child .p.buttons
  pack configure .p.buttons.add \
    -side top -fill x
  pack configure .p.buttons.del \
    -side top

  # pack child .p.list
#  pack configure .p.list.sx -side bottom -fill x
  pack configure .p.list.sy -side right -fill y
  pack configure .p.list.box -side left -fill both -expand true

  # pack master .p
  pack configure .p.label1 \
    -anchor w \
    -side left
  pack configure .p.list \
    -anchor w \
    -side left
  pack configure .p.buttons \
    -anchor e \
    -side right

  # pack master .tt
  pack configure .tt.f \
    -expand 1 \
    -fill x
  pack configure .tt.scroll \
    -fill y \
    -side right
  pack configure .tt.t \
    -anchor w

  # pack master .tt.f
  pack configure .tt.f.b2 \
    -side right
  pack configure .tt.f.label3 \
    -anchor w \
    -side left

  # pack master .w
  pack configure .w.top.left.label \
    -side top \
    -anchor w 
  pack configure .w.top.left.entry \
    -side top \
    -anchor w
  pack configure .w.top.right.label \
    -side top \
    -anchor w
  pack configure .w.top.right.entry \
    -side top \
    -anchor w
  pack configure .w.bot.label \
    -side top \
    -anchor w
  pack configure .w.bot.entry \
    -side top \
    -anchor w
  pack configure .w.bot.check \
    -side top \
    -fill y \
    -anchor center
  pack .w.top.left .w.top.right -side left -expand true -fill x
  pack .w.top -side top -fill x
  pack .w.bot -side top -fill y

  # pack master .ww
  pack configure .ww.label5 \
    -anchor w
  pack configure .ww.entry5 \
    -anchor w
  pack configure .ww.label6 \
    -anchor w
  pack configure .ww.entry6 \
    -anchor w
  pack configure .ww.label8 \
    -anchor w
  pack configure .ww.entry8 \
    -anchor w

  # pack master .www
  pack configure .www.label9 \
    -side left
  pack configure .www.entry16 \
    -side left

  # pack master .
  pack configure .b
  pack configure .www \
    -expand 1 \
    -fill x \
    -padx 8
  pack configure .p \
    -expand 1 \
    -fill x \
    -padx 9
  pack configure .tt
  pack configure .w \
    -side left -fill y
  pack configure .ww \
    -side right
  pack configure .label0

  .tt.t insert end {}



  if {"[info procs XFEdit]" != ""} {
    catch "XFMiscBindWidgetTree ."
    after 2 "catch {XFEditSetShowWindows}"
  }
}


# User defined procedures


# Procedure: FSBox
proc FSBox { {fsBoxMessage "Select file:"} {fsBoxFileName ""} {fsBoxActionOk ""} {fsBoxActionCancel ""}} {
# xf ignore me 5
##########
# Procedure: FSBox
# Description: show file selector box
# Arguments: fsBoxMessage - the text to display
#            fsBoxFileName - a file name that should be selected
#            fsBoxActionOk - the action that should be performed on ok
#            fsBoxActionCancel - the action that should be performed on cancel
# Returns: the filename that was selected, or nothing
# Sideeffects: none
##########
# 
# global fsBox(activeBackground) - active background color
# global fsBox(activeForeground) - active foreground color
# global fsBox(background) - background color
# global fsBox(font) - text font
# global fsBox(foreground) - foreground color
# global fsBox(extensions) - scan directory for extensions
# global fsBox(scrollActiveForeground) - scrollbar active background color
# global fsBox(scrollBackground) - scrollbar background color
# global fsBox(scrollForeground) - scrollbar foreground color
# global fsBox(scrollSide) - side where scrollbar is located

  global fsBox

  set tmpButtonOpt ""
  set tmpFrameOpt ""
  set tmpMessageOpt ""
  set tmpScaleOpt ""
  set tmpScrollOpt ""
  if {"$fsBox(activeBackground)" != ""} {
    append tmpButtonOpt "-activebackground \"$fsBox(activeBackground)\" "
  }
  if {"$fsBox(activeForeground)" != ""} {
    append tmpButtonOpt "-activeforeground \"$fsBox(activeForeground)\" "
  }
  if {"$fsBox(background)" != ""} {
    append tmpButtonOpt "-background \"$fsBox(background)\" "
    append tmpFrameOpt "-background \"$fsBox(background)\" "
    append tmpMessageOpt "-background \"$fsBox(background)\" "
  }
  if {"$fsBox(font)" != ""} {
    append tmpButtonOpt "-font \"$fsBox(font)\" "
    append tmpMessageOpt "-font \"$fsBox(font)\" "
  }
  if {"$fsBox(foreground)" != ""} {
    append tmpButtonOpt "-foreground \"$fsBox(foreground)\" "
    append tmpMessageOpt "-foreground \"$fsBox(foreground)\" "
  }
  if {"$fsBox(scrollActiveForeground)" != ""} {
    append tmpScrollOpt "-activeforeground \"$fsBox(scrollActiveForeground)\" "
  }
  if {"$fsBox(scrollBackground)" != ""} {
    append tmpScrollOpt "-background \"$fsBox(scrollBackground)\" "
  }
  if {"$fsBox(scrollForeground)" != ""} {
    append tmpScrollOpt "-foreground \"$fsBox(scrollForeground)\" "
  }

  if {[file exists [file tail $fsBoxFileName]] &&
      [IsAFile [file tail $fsBoxFileName]]} {
    set fsBox(name) [file tail $fsBoxFileName]
  } {
    set fsBox(name) ""
  }
  if {[file exists $fsBoxFileName] && [IsADir $fsBoxFileName]} {
    set fsBox(path) $fsBoxFileName
  } {
    if {"[file dirname $fsBoxFileName]" != "."} {
      set fsBox(path) [file dirname $fsBoxFileName]
    }
  }
  if {$fsBox(showPixmap)} {
    set fsBox(path) [string trimleft $fsBox(path) @]
  }
  if {"$fsBox(path)" != "" && [file exists $fsBox(path)] &&
      [IsADir $fsBox(path)]} {
    set fsBox(internalPath) $fsBox(path)
  } {
    if {"$fsBox(internalPath)" == "" ||
        ![file exists $fsBox(internalPath)]} {
      set fsBox(internalPath) [pwd]
    }
  }
  # build widget structure

  # start build of toplevel
  if {"[info commands XFDestroy]" != ""} {
    catch {XFDestroy .fsBox}
  } {
    catch {destroy .fsBox}
  }
  toplevel .fsBox  -borderwidth 0
  catch ".fsBox config $tmpFrameOpt"
  wm geometry .fsBox 350x300 
  wm title .fsBox {File select box}
  wm maxsize .fsBox 1000 1000
  wm minsize .fsBox 100 100
  # end build of toplevel

  label .fsBox.message1  -anchor c  -relief raised  -text "$fsBoxMessage"
  catch ".fsBox.message1 config $tmpMessageOpt"

  frame .fsBox.frame1  -borderwidth 0  -relief raised
  catch ".fsBox.frame1 config $tmpFrameOpt"

  button .fsBox.frame1.ok  -text "OK"  -command "
      global fsBox
      set fsBox(name) \[.fsBox.file.file get\]
      if {$fsBox(showPixmap)} {
        set fsBox(path) @\[.fsBox.path.path get\]
      } {
        set fsBox(path) \[.fsBox.path.path get\]
      }
      set fsBox(internalPath) \[.fsBox.path.path get\]
      $fsBoxActionOk
      if {\"\[info commands XFDestroy\]\" != \"\"} {
        catch {XFDestroy .fsBox}
      } {
        catch {destroy .fsBox}
      }"
  catch ".fsBox.frame1.ok config $tmpButtonOpt"

  button .fsBox.frame1.rescan  -text "Rescan"  -command {
      global fsBox
      FSBoxFSShow [.fsBox.path.path get]  [.fsBox.pattern.pattern get] $fsBox(all)}
  catch ".fsBox.frame1.rescan config $tmpButtonOpt"

  button .fsBox.frame1.cancel  -text "Cancel"  -command "
      global fsBox
      set fsBox(name) {}
      set fsBox(path) {}
      $fsBoxActionCancel
      if {\"\[info commands XFDestroy\]\" != \"\"} {
        catch {XFDestroy .fsBox}
      } {
        catch {destroy .fsBox}
      }"
  catch ".fsBox.frame1.cancel config $tmpButtonOpt"

  if {$fsBox(showPixmap)} {
    frame .fsBox.frame2  -borderwidth 0  -relief raised
    catch ".fsBox.frame2 config $tmpFrameOpt"

    scrollbar .fsBox.frame2.scrollbar3  -command {.fsBox.frame2.canvas2 xview}  -orient {horizontal}  -relief {raised}
    catch ".fsBox.frame2.scrollbar3 config $tmpScrollOpt"

    scrollbar .fsBox.frame2.scrollbar1  -command {.fsBox.frame2.canvas2 yview}  -relief {raised}
    catch ".fsBox.frame2.scrollbar1 config $tmpScrollOpt"

    canvas .fsBox.frame2.canvas2  -confine {true}  -relief {raised}  -scrollregion {0c 0c 20c 20c}  -width {100}  -xscrollcommand {.fsBox.frame2.scrollbar3 set}  -yscrollcommand {.fsBox.frame2.scrollbar1 set}
    catch ".fsBox.frame2.canvas2 config $tmpFrameOpt"

    .fsBox.frame2.canvas2 addtag currentBitmap withtag [.fsBox.frame2.canvas2 create bitmap 5 5 -anchor nw]
  }

  frame .fsBox.path  -borderwidth 0  -relief raised
  catch ".fsBox.path config $tmpFrameOpt"

  frame .fsBox.path.paths  -borderwidth 2  -relief raised
  catch ".fsBox.path.paths config $tmpFrameOpt"

  menubutton .fsBox.path.paths.paths  -borderwidth 0  -menu ".fsBox.path.paths.paths.menu"  -relief flat  -text "Pathname:"
  catch ".fsBox.path.paths.paths config $tmpButtonOpt"

  menu .fsBox.path.paths.paths.menu -tearoff 0
  catch ".fsBox.path.paths.paths.menu config $tmpButtonOpt"

  .fsBox.path.paths.paths.menu add command  -label "[string trimright $fsBox(internalPath) {/@}]"  -command "
       global fsBox
       FSBoxFSShow \[.fsBox.path.path get\]  \[.fsBox.pattern.pattern get\] \$fsBox(all)
       .fsBox.path.path delete 0 end
       .fsBox.path.path insert 0 [string trimright $fsBox(internalPath) {/@}]"

  entry .fsBox.path.path  -relief sunken
  catch ".fsBox.path.path config $tmpMessageOpt"

  if {![IsADir $fsBox(internalPath)]} {
    set $fsBox(internalPath) [pwd]
  }
  .fsBox.path.path insert 0 $fsBox(internalPath)

  frame .fsBox.pattern  -borderwidth 0  -relief raised
  catch ".fsBox.pattern config $tmpFrameOpt"

  frame .fsBox.pattern.patterns  -borderwidth 2  -relief raised
  catch ".fsBox.pattern.patterns config $tmpFrameOpt"

  menubutton .fsBox.pattern.patterns.patterns  -borderwidth 0  -menu ".fsBox.pattern.patterns.patterns.menu"  -relief flat  -text "Selection pattern:"
  catch ".fsBox.pattern.patterns.patterns config $tmpButtonOpt"

  menu .fsBox.pattern.patterns.patterns.menu -tearoff 0
  catch ".fsBox.pattern.patterns.patterns.menu config $tmpButtonOpt"

  .fsBox.pattern.patterns.patterns.menu add checkbutton  -label "Scan extensions"  -variable fsBox(extensions)  -command {
      global fsBox
      FSBoxFSShow [.fsBox.path.path get]  [.fsBox.pattern.pattern get] $fsBox(all)}

  entry .fsBox.pattern.pattern  -relief sunken
  catch ".fsBox.pattern.pattern config $tmpMessageOpt"

  .fsBox.pattern.pattern insert 0 $fsBox(pattern)
  
  frame .fsBox.files  -borderwidth 0  -relief raised
  catch ".fsBox.files config $tmpFrameOpt"

  scrollbar .fsBox.files.vscroll  -relief raised  -command ".fsBox.files.files yview"
  catch ".fsBox.files.vscroll config $tmpScrollOpt"

  scrollbar .fsBox.files.hscroll  -orient horiz  -relief raised  -command ".fsBox.files.files xview"
  catch ".fsBox.files.hscroll config $tmpScrollOpt"

  listbox .fsBox.files.files  -exportselection false  -relief raised  -xscrollcommand ".fsBox.files.hscroll set"  -yscrollcommand ".fsBox.files.vscroll set"
  catch ".fsBox.files.files config $tmpMessageOpt"

  frame .fsBox.file  -borderwidth 0  -relief raised
  catch ".fsBox.file config $tmpFrameOpt"

  label .fsBox.file.labelfile  -relief raised  -text "Filename:"
  catch ".fsBox.file.labelfile config $tmpMessageOpt"

  entry .fsBox.file.file  -relief sunken
  catch ".fsBox.file.file config $tmpMessageOpt"

  .fsBox.file.file delete 0 end
  .fsBox.file.file insert 0 $fsBox(name)
  
  checkbutton .fsBox.pattern.all  -offvalue 0  -onvalue 1  -text "Show all files"  -variable fsBox(all)  -command {
      global fsBox
      FSBoxFSShow [.fsBox.path.path get]  [.fsBox.pattern.pattern get] $fsBox(all)}
  catch ".fsBox.pattern.all config $tmpButtonOpt"

  FSBoxFSShow $fsBox(internalPath) $fsBox(pattern) $fsBox(all)

  # bindings
  bindtags .fsBox.files.files {.fsBox.files.files "" "" "" }
  bind .fsBox.files.files <Double-Button-1> "
    FSBoxFSFileSelectDouble %W $fsBox(showPixmap) \{$fsBoxActionOk\} %y"
  bind .fsBox.files.files <ButtonPress-1> "
    FSBoxFSFileSelect %W $fsBox(showPixmap) %y"
  bind .fsBox.files.files <Button1-Motion> "
    FSBoxFSFileSelect %W $fsBox(showPixmap) %y"
  bind .fsBox.files.files <Shift-Button1-Motion> "
    FSBoxFSFileSelect %W $fsBox(showPixmap) %y"
  bind .fsBox.files.files <Shift-ButtonPress-1> "
    FSBoxFSFileSelect %W $fsBox(showPixmap) %y"

  bind .fsBox.path.path <Tab> {
    FSBoxFSNameComplete path}
  bind .fsBox.path.path <Return> {
    global fsBox
    FSBoxFSShow [.fsBox.path.path get]  [.fsBox.pattern.pattern get] $fsBox(all)
    FSBoxFSInsertPath
    .fsBox.file.file icursor end
    focus .fsBox.file.file}
  catch "bind .fsBox.path.path <Up> {}"
  bind .fsBox.path.path <Down> {
    .fsBox.file.file icursor end
    focus .fsBox.file.file}

  bind .fsBox.file.file <Tab> {
    FSBoxFSNameComplete file}
  bind .fsBox.file.file <Return> "
    global fsBox
    set fsBox(name) \[.fsBox.file.file get\]
    if {$fsBox(showPixmap)} {
      set fsBox(path) @\[.fsBox.path.path get\]
    } {
      set fsBox(path) \[.fsBox.path.path get\]
    }
    set fsBox(internalPath) \[.fsBox.path.path get\]
    $fsBoxActionOk
    if {\"\[info commands XFDestroy\]\" != \"\"} {
      catch {XFDestroy .fsBox}
    } {
      catch {destroy .fsBox}
    }"
  bind .fsBox.file.file <Up> {
    .fsBox.path.path icursor end
    focus .fsBox.path.path}
  bind .fsBox.file.file <Down> {
    .fsBox.pattern.pattern icursor end
    focus .fsBox.pattern.pattern}

  bind .fsBox.pattern.pattern <Return> {
    global fsBox
    FSBoxFSShow [.fsBox.path.path get]  [.fsBox.pattern.pattern get] $fsBox(all)}
  bind .fsBox.pattern.pattern <Up> {
    .fsBox.file.file icursor end
    focus .fsBox.file.file}
  catch "bind .fsBox.pattern.pattern <Down> {}"

  # packing
  pack append .fsBox.files  .fsBox.files.vscroll "$fsBox(scrollSide) filly"  .fsBox.files.hscroll {bottom fillx}  .fsBox.files.files {left fill expand}
  pack append .fsBox.file  .fsBox.file.labelfile {left}  .fsBox.file.file {left fill expand}
  pack append .fsBox.frame1  .fsBox.frame1.ok {left fill expand}  .fsBox.frame1.rescan {left fill expand}  .fsBox.frame1.cancel {left fill expand}
  pack append .fsBox.path.paths  .fsBox.path.paths.paths {left}
  pack append .fsBox.pattern.patterns  .fsBox.pattern.patterns.patterns {left}
  pack append .fsBox.path  .fsBox.path.paths {left}  .fsBox.path.path {left fill expand}
  pack append .fsBox.pattern  .fsBox.pattern.patterns {left}  .fsBox.pattern.all {right fill}  .fsBox.pattern.pattern {left fill expand}
  if {$fsBox(showPixmap)} {
    pack append .fsBox.frame2  .fsBox.frame2.scrollbar1 {left filly}  .fsBox.frame2.canvas2 {top expand fill}  .fsBox.frame2.scrollbar3 {top fillx} 

    pack append .fsBox  .fsBox.message1 {top fill}  .fsBox.frame1 {bottom fill}  .fsBox.pattern {bottom fill}  .fsBox.file {bottom fill}  .fsBox.path {bottom fill}  .fsBox.frame2 {right fill}  .fsBox.files {left fill expand}
  } {
    pack append .fsBox  .fsBox.message1 {top fill}  .fsBox.frame1 {bottom fill}  .fsBox.pattern {bottom fill}  .fsBox.file {bottom fill}  .fsBox.path {bottom fill}  .fsBox.files {left fill expand}
  }

  if {"$fsBoxActionOk" == "" && "$fsBoxActionCancel" == ""} {
    # wait for the box to be destroyed
    update idletask
    grab .fsBox
    tkwait window .fsBox

    if {"[string trim $fsBox(path)]" != "" ||
        "[string trim $fsBox(name)]" != ""} {
      if {"[string trimleft [string trim $fsBox(name)] /]" == ""} {
        return [string trimright [string trim $fsBox(path)] /]
      } {
        return [string trimright [string trim $fsBox(path)] /]/[string trimleft [string trim $fsBox(name)] /]
      }
    }
  }
}


# Procedure: FSBoxBindSelectOne
proc FSBoxBindSelectOne { fsBoxW fsBoxY} {
# xf ignore me 6

  set fsBoxNearest [$fsBoxW nearest $fsBoxY]
  if {$fsBoxNearest >= 0} {
    $fsBoxW select clear 0 end
    $fsBoxW select set $fsBoxNearest
  }
}


# Procedure: FSBoxFSFileSelect
proc FSBoxFSFileSelect { fsBoxW fsBoxShowPixmap fsBoxY} {
# xf ignore me 6
  global fsBox

  FSBoxBindSelectOne $fsBoxW $fsBoxY
  set fsBoxNearest [$fsBoxW nearest $fsBoxY]
  if {$fsBoxNearest >= 0} {
    set fsBoxTmpEntry [$fsBoxW get $fsBoxNearest]
    if {"[string index $fsBoxTmpEntry  [expr [string length $fsBoxTmpEntry]-1]]" == "/" ||
        "[string index $fsBoxTmpEntry  [expr [string length $fsBoxTmpEntry]-1]]" == "@"} {
      set fsBoxFileName [string range $fsBoxTmpEntry 0  [expr [string length $fsBoxTmpEntry]-2]]
      if {![IsADir [string trimright $fsBox(internalPath)/$fsBoxFileName @]] &&
          ![IsASymlink [string trimright $fsBox(internalPath)/$fsBoxFileName @]]} {
        set fsBoxFileName $fsBoxTmpEntry
      }
    } {
      if {"[string index $fsBoxTmpEntry  [expr [string length $fsBoxTmpEntry]-1]]" == "*"} {
        set fsBoxFileName [string range $fsBoxTmpEntry 0  [expr [string length $fsBoxTmpEntry]-2]]
        if {![file executable $fsBox(internalPath)/$fsBoxFileName]} {
          set fsBoxFileName $fsBoxTmpEntry
        }
      } {
        set fsBoxFileName $fsBoxTmpEntry
      }
    }
    if {![IsADir [string trimright $fsBox(internalPath)/$fsBoxFileName @]]} {
      set fsBox(name) $fsBoxFileName
      .fsBox.file.file delete 0 end
      .fsBox.file.file insert 0 $fsBox(name)
      if {$fsBoxShowPixmap} {
        catch ".fsBox.frame2.canvas2 itemconfigure currentBitmap -bitmap \"@$fsBox(internalPath)/$fsBox(name)\""
      }
    }
  }
}


# Procedure: FSBoxFSFileSelectDouble
proc FSBoxFSFileSelectDouble { fsBoxW fsBoxShowPixmap fsBoxAction fsBoxY} {
# xf ignore me 6
  global fsBox

  FSBoxBindSelectOne $fsBoxW $fsBoxY
  set fsBoxNearest [$fsBoxW nearest $fsBoxY]
  if {$fsBoxNearest >= 0} {
    set fsBoxTmpEntry [$fsBoxW get $fsBoxNearest]
    if {"$fsBoxTmpEntry" == "../"} {
      set fsBoxTmpEntry [string trimright [string trim $fsBox(internalPath)] "@/"]
      if {"$fsBoxTmpEntry" == ""} {
        return
      }
      FSBoxFSShow [file dirname $fsBoxTmpEntry]  [.fsBox.pattern.pattern get] $fsBox(all)
      .fsBox.path.path delete 0 end
      .fsBox.path.path insert 0 $fsBox(internalPath)
    } {
      if {"[string index $fsBoxTmpEntry  [expr [string length $fsBoxTmpEntry]-1]]" == "/" ||
          "[string index $fsBoxTmpEntry  [expr [string length $fsBoxTmpEntry]-1]]" == "@"} {
        set fsBoxFileName [string range $fsBoxTmpEntry 0  [expr [string length $fsBoxTmpEntry]-2]]
        if {![IsADir [string trimright $fsBox(internalPath)/$fsBoxFileName @]] &&
            ![IsASymlink [string trimright $fsBox(internalPath)/$fsBoxFileName @]]} {
          set fsBoxFileName $fsBoxTmpEntry
        }
      } {
        if {"[string index $fsBoxTmpEntry  [expr [string length $fsBoxTmpEntry]-1]]" == "*"} {
          set fsBoxFileName [string range $fsBoxTmpEntry 0  [expr [string length $fsBoxTmpEntry]-2]]
          if {![file executable $fsBox(internalPath)/$fsBoxFileName]} {
            set fsBoxFileName $fsBoxTmpEntry
          }
        } {
          set fsBoxFileName $fsBoxTmpEntry
        }
      }
      if {[IsADir [string trimright $fsBox(internalPath)/$fsBoxFileName @]]} {
        set fsBox(internalPath) "[string trimright $fsBox(internalPath) {/@}]/$fsBoxFileName"
        FSBoxFSShow $fsBox(internalPath)  [.fsBox.pattern.pattern get] $fsBox(all)
        .fsBox.path.path delete 0 end
        .fsBox.path.path insert 0 $fsBox(internalPath)
      } {
        set fsBox(name) $fsBoxFileName
        if {$fsBoxShowPixmap} {
          set fsBox(path) @$fsBox(internalPath)
        } {
          set fsBox(path) $fsBox(internalPath)
        }
        if {"$fsBoxAction" != ""} {
          eval "global fsBox; $fsBoxAction"
        }
        if {"[info commands XFDestroy]" != ""} {
          catch {XFDestroy .fsBox}
        } {
          catch {destroy .fsBox}
        }
      }
    }
  }
}


# Procedure: FSBoxFSInsertPath
proc FSBoxFSInsertPath {} {
# xf ignore me 6
  global fsBox

  set fsBoxLast [.fsBox.path.paths.paths.menu index last]
  set fsBoxNewEntry [string trimright [.fsBox.path.path get] "/@"]
  for {set fsBoxCounter 0} {$fsBoxCounter <= $fsBoxLast} {incr fsBoxCounter 1} {
    if {"$fsBoxNewEntry" ==  "[lindex [.fsBox.path.paths.paths.menu entryconfigure  $fsBoxCounter -label] 4]"} {
      return
    }
  }
  if {$fsBoxLast < 9} {
    .fsBox.path.paths.paths.menu add command  -label "$fsBoxNewEntry"  -command "
        global fsBox
        FSBoxFSShow $fsBoxNewEntry  \[.fsBox.pattern.pattern get\] \$fsBox(all)
        .fsBox.path.path delete 0 end
        .fsBox.path.path insert 0 $fsBoxNewEntry"
  } {
    for {set fsBoxCounter 0} {$fsBoxCounter < $fsBoxLast} {incr fsBoxCounter 1} {
      .fsBox.path.paths.paths.menu entryconfigure  $fsBoxCounter -label  [lindex [.fsBox.path.paths.paths.menu entryconfigure  [expr $fsBoxCounter+1] -label] 4]
      .fsBox.path.paths.paths.menu entryconfigure $fsBoxCounter  -command "
          global fsBox
          FSBoxFSShow [lindex [.fsBox.path.paths.paths.menu entryconfigure  [expr $fsBoxCounter+1] -label] 4]  \[.fsBox.pattern.pattern get\] \$fsBox(all)
          .fsBox.path.path delete 0 end
          .fsBox.path.path insert 0 [lindex  [.fsBox.path.paths.paths.menu entryconfigure  [expr $fsBoxCounter+1] -label] 4]"
    }
    .fsBox.path.paths.paths.menu entryconfigure $fsBoxLast  -label "$fsBoxNewEntry"
    .fsBox.path.paths.paths.menu entryconfigure $fsBoxCounter  -command "
        global fsBox
        FSBoxFSShow \[.fsBox.path.path get\]  \[.fsBox.pattern.pattern get\] \$fsBox(all)
        .fsBox.path.path delete 0 end
        .fsBox.path.path insert 0 $fsBoxNewEntry"
  }
}


# Procedure: FSBoxFSNameComplete
proc FSBoxFSNameComplete { fsBoxType} {
# xf ignore me 6
  global fsBox

  set fsBoxNewFile ""
  if {"$fsBoxType" == "path"} {
    set fsBoxDirName [file dirname [.fsBox.path.path get]]
    set fsBoxFileName [file tail [.fsBox.path.path get]]
  } {
    set fsBoxDirName [file dirname [.fsBox.path.path get]/]
    set fsBoxFileName [file tail [.fsBox.file.file get]]
  }

  set fsBoxNewFile ""
  if {[IsADir [string trimright $fsBoxDirName @]]} {
    catch "glob -nocomplain $fsBoxDirName/${fsBoxFileName}*" fsBoxResult
    foreach fsBoxCounter $fsBoxResult {
      if {"$fsBoxNewFile" == ""} {
        set fsBoxNewFile [file tail $fsBoxCounter]
      } {
        if {"[string index [file tail $fsBoxCounter] 0]" !=
            "[string index $fsBoxNewFile 0]"} {
          set fsBoxNewFile ""
          break
        }
        set fsBoxCounter1 0
        set fsBoxTmpFile1 $fsBoxNewFile
        set fsBoxTmpFile2 [file tail $fsBoxCounter]
        set fsBoxLength1 [string length $fsBoxTmpFile1]
        set fsBoxLength2 [string length $fsBoxTmpFile2]
        set fsBoxNewFile ""
        if {$fsBoxLength1 > $fsBoxLength2} {
          set fsBoxLength1 $fsBoxLength2
        }
        while {$fsBoxCounter1 < $fsBoxLength1} {
          if {"[string index $fsBoxTmpFile1 $fsBoxCounter1]" ==  "[string index $fsBoxTmpFile2 $fsBoxCounter1]"} {
            append fsBoxNewFile [string index $fsBoxTmpFile1 $fsBoxCounter1]
          } {
            break
          }
          incr fsBoxCounter1 1
        }
      }
    }
  }
  if {"$fsBoxNewFile" != ""} {
    if {[IsADir [string trimright $fsBoxDirName/$fsBoxNewFile @]] ||
        ![IsAFile [string trimright $fsBoxDirName/$fsBoxNewFile @]]} {
      if {[IsADir [string trimright $fsBoxDirName/$fsBoxNewFile @]]} {
        if {"$fsBoxDirName" == "/"} {
          .fsBox.path.path delete 0 end
          .fsBox.path.path insert 0 "/[string trimright [string trim $fsBoxNewFile /] @]/"
        } {
          .fsBox.path.path delete 0 end
          .fsBox.path.path insert 0 "[string trimright $fsBoxDirName /]/[string trimright [string trim $fsBoxNewFile /] @]/"
        }
        FSBoxFSShow [.fsBox.path.path get]  [.fsBox.pattern.pattern get] $fsBox(all)
        FSBoxFSInsertPath
      } {
        .fsBox.path.path delete 0 end
        .fsBox.path.path insert 0 "[string trimright $fsBoxDirName /]/[string trimright [string trim $fsBoxNewFile /] @]"
      }
    } {
      .fsBox.path.path delete 0 end
      .fsBox.path.path insert 0 "[string trimright $fsBoxDirName {@/}]/"
      .fsBox.file.file delete 0 end
      .fsBox.file.file insert 0 $fsBoxNewFile
      .fsBox.file.file icursor end
      focus .fsBox.file.file
    }
  }
}


# Procedure: FSBoxFSShow
proc FSBoxFSShow { fsBoxPath fsBoxPattern fsBoxAll} {
# xf ignore me 6
  global fsBox

  set tmpButtonOpt ""
  if {"$fsBox(activeBackground)" != ""} {
    append tmpButtonOpt "-activebackground \"$fsBox(activeBackground)\" "
  }
  if {"$fsBox(activeForeground)" != ""} {
    append tmpButtonOpt "-activeforeground \"$fsBox(activeForeground)\" "
  }
  if {"$fsBox(background)" != ""} {
    append tmpButtonOpt "-background \"$fsBox(background)\" "
  }
  if {"$fsBox(font)" != ""} {
    append tmpButtonOpt "-font \"$fsBox(font)\" "
  }
  if {"$fsBox(foreground)" != ""} {
    append tmpButtonOpt "-foreground \"$fsBox(foreground)\" "
  }

  set fsBox(pattern) $fsBoxPattern
  if {[file exists $fsBoxPath] && [file readable $fsBoxPath] &&
      [IsADir $fsBoxPath]} {
    set fsBox(internalPath) $fsBoxPath
  } {
    if {[file exists $fsBoxPath] && [file readable $fsBoxPath] &&
        [IsAFile $fsBoxPath]} {
      set fsBox(internalPath) [file dirname $fsBoxPath]
      .fsBox.file.file delete 0 end
      .fsBox.file.file insert 0 [file tail $fsBoxPath]
      set fsBoxPath $fsBox(internalPath)
    } {
      while {"$fsBoxPath" != "" && "$fsBoxPath" != "/" &&
             ![file isdirectory $fsBoxPath]} {
        set fsBox(internalPath) [file dirname $fsBoxPath]
         set fsBoxPath $fsBox(internalPath)
      }
    }
  }
  if {"$fsBoxPath" == ""} {
    set fsBoxPath "/"
    set fsBox(internalPath) "/"
  }
  .fsBox.path.path delete 0 end
  .fsBox.path.path insert 0 $fsBox(internalPath)

  if {[.fsBox.files.files size] > 0} {
    .fsBox.files.files delete 0 end
  }
  if {$fsBoxAll} {
    if {[catch "Ls -F -a $fsBoxPath" fsBoxResult]} {
      puts stderr "$fsBoxResult"
    }
  } {
    if {[catch "Ls -F $fsBoxPath" fsBoxResult]} {
      puts stderr "$fsBoxResult"
    }
  }
  set fsBoxElementList [lsort $fsBoxResult]

  foreach fsBoxCounter [winfo children .fsBox.pattern.patterns.patterns] {
    if {[string length [info commands XFDestroy]] > 0} {
      catch {XFDestroy $fsBoxCounter}
    } {
      catch {destroy $fsBoxCounter}
    }
  }
  menu .fsBox.pattern.patterns.patterns.menu
  catch ".fsBox.pattern.patterns.patterns.menu config $tmpButtonOpt"

  if {$fsBox(extensions)} {
    .fsBox.pattern.patterns.patterns.menu add command  -label "*"  -command {
        global fsBox
        set fsBox(pattern) "*"
        .fsBox.pattern.pattern delete 0 end
        .fsBox.pattern.pattern insert 0 $fsBox(pattern)
        FSBoxFSShow [.fsBox.path.path get] $fsBox(pattern)  $fsBox(all)}
  }

  if {"$fsBoxPath" != "/"} {
    .fsBox.files.files insert end "../"
  }
  foreach fsBoxCounter $fsBoxElementList {
    if {[string match $fsBoxPattern $fsBoxCounter] ||
        [IsADir [string trimright $fsBoxPath/$fsBoxCounter "/@"]]} {
      if {"$fsBoxCounter" != "../" &&
          "$fsBoxCounter" != "./"} {
        .fsBox.files.files insert end $fsBoxCounter
      }
    }

    if {$fsBox(extensions)} {
      catch "file rootname $fsBoxCounter" fsBoxRootName
      catch "file extension $fsBoxCounter" fsBoxExtension
      set fsBoxExtension [string trimright $fsBoxExtension "/*@"]
      if {"$fsBoxExtension" != "" && "$fsBoxRootName" != ""} {
        set fsBoxInsert 1
        set fsBoxLast [.fsBox.pattern.patterns.patterns.menu index last]
        for {set fsBoxCounter1 0} {$fsBoxCounter1 <= $fsBoxLast} {incr fsBoxCounter1 1} {
          if {"*$fsBoxExtension" ==  "[lindex [.fsBox.pattern.patterns.patterns.menu entryconfigure  $fsBoxCounter1 -label] 4]"} {
            set fsBoxInsert 0
          }
        }
	if {$fsBoxInsert} {
          .fsBox.pattern.patterns.patterns.menu add command  -label "*$fsBoxExtension"  -command "
              global fsBox
              set fsBox(pattern) \"*$fsBoxExtension\"
              .fsBox.pattern.pattern delete 0 end
              .fsBox.pattern.pattern insert 0 \$fsBox(pattern)
              FSBoxFSShow \[.fsBox.path.path get\] \$fsBox(pattern)  \$fsBox(all)"
        }
      }
    }
  }
  if {$fsBox(extensions)} {
    .fsBox.pattern.patterns.patterns.menu add separator
  }
  if {$fsBox(extensions) || 
      "[.fsBox.pattern.patterns.patterns.menu index last]" == "none"} {
    .fsBox.pattern.patterns.patterns.menu add checkbutton  -label "Scan extensions"  -variable "fsBox(extensions)"  -command {
        global fsBox
        FSBoxFSShow [.fsBox.path.path get]  [.fsBox.pattern.pattern get] $fsBox(all)}
  }
}


# Procedure: IsADir
proc IsADir { pathName} {
# xf ignore me 5
##########
# Procedure: IsADir
# Description: check if name is a directory (including symbolic links)
# Arguments: pathName - the path to check
# Returns: 1 if its a directory, otherwise 0
# Sideeffects: none
##########

  if {[file isdirectory $pathName]} {
    return 1
  } {
    catch "file type $pathName" fileType
    if {"$fileType" == "link"} {
      if {[catch "file readlink $pathName" linkName]} {
        return 0
      }
      catch "file type $linkName" fileType
      while {"$fileType" == "link"} {
        if {[catch "file readlink $linkName" linkName]} {
          return 0
        }
        catch "file type $linkName" fileType
      }
      return [file isdirectory $linkName]
    }
  }
  return 0
}


# Procedure: IsAFile
proc IsAFile { fileName} {
# xf ignore me 5
##########
# Procedure: IsAFile
# Description: check if filename is a file (including symbolic links)
# Arguments: fileName - the filename to check
# Returns: 1 if its a file, otherwise 0
# Sideeffects: none
##########

  if {[file isfile $fileName]} {
    return 1
  } {
    catch "file type $fileName" fileType
    if {"$fileType" == "link"} {
      if {[catch "file readlink $fileName" linkName]} {
        return 0
      }
      catch "file type $linkName" fileType
      while {"$fileType" == "link"} {
        if {[catch "file readlink $linkName" linkName]} {
          return 0
        }
        catch "file type $linkName" fileType
      }
      return [file isfile $linkName]
    }
  }
  return 0
}


# Procedure: IsASymlink
proc IsASymlink { fileName} {
# xf ignore me 5
##########
# Procedure: IsASymlink
# Description: check if filename is a symbolic link
# Arguments: fileName - the path/filename to check
# Returns: none
# Sideeffects: none
##########

  catch "file type $fileName" fileType
  if {"$fileType" == "link"} {
    return 1
  }
  return 0
}


# Procedure: about
proc about {} {
    toplevel .about
    label .about.msg -text "FaxMail Ver 2.3"
    label .about.msg2 -text ""
    label .about.msg3 -text "By David Burns, Shyamal Somaroo, Matthew Davey."
    label .about.msg4 -text "Copyright (c) 1995 - 1998"
    label .about.msg5 -text ""
    label .about.msg6 -text "Homepage: http://wol.ra.phy.cam.ac.uk/FaxMail/"
    wm title .about "About FaxMail"
    button .about.b -text "EXIT" -command {destroy .about} -foreground red
    pack .about.msg .about.msg2 .about.msg3 .about.msg4 .about.msg5 .about.msg6 .about.b
    grab set .about
    tkwait window .about
}


# Procedure: addr_clear
proc addr_clear {} {
global addr_book

set w .address.frame11
set addr_book(modified) 1

$w.entry23 delete 0 end
$w.entry24 delete 0 end
$w.entry25 delete 0 end
$w.entry26 delete 0 end
$w.entry27 delete 0 end
$w.entry28 delete 0 end
}


# Procedure: addr_close
proc addr_close {} {
global addr_book
global yesno

if { $addr_book(modified) == 1 } {
  ShowWindow.yesno
  .yesno.message configure -text "Save changes to address book?"
   tkwait variable yesno(result)
   if {$yesno(result) == "yes"} {
     addr_write }
}
   destroy .address
}


# Procedure: addr_delete
proc addr_delete {} {
global addr_book

set lbox .address.frame12.frame.listbox1
if {[$lbox curselect] == ""} return
set addr_book(modified) 1
for {set ix [$lbox curselect]} {$ix < [expr [$lbox index end] - 1]} {incr ix 1} {
   set iy [expr $ix + 1]
   set addr_book($ix,alias) $addr_book($iy,alias)
   set addr_book($ix,country) $addr_book($iy,country)
   set addr_book($ix,local) $addr_book($iy,local)
   set addr_book($ix,fax) $addr_book($iy,fax)
   set addr_book($ix,name) $addr_book($iy,name)
   set addr_book($ix,org) $addr_book($iy,org)
   set addr_book($ix,email) $addr_book($iy,email)
}
   unset addr_book($ix,alias) 
   unset addr_book($ix,country) 
   unset addr_book($ix,local) 
   unset addr_book($ix,fax) 
   unset addr_book($ix,name)
   unset addr_book($ix,org) 
   unset addr_book($ix,email)
set ix [$lbox curselection]
$lbox delete $ix
$lbox select set [expr $ix - 1]
if {[$lbox index end]} {
 addr_set
} else {
 set w .address.frame11
 addr_clear
 $w.addr_title_frame.alias configure -text ""
 $w.entry23 configure -state disabled
 $w.entry24 configure -state disabled
 $w.entry25 configure -state disabled
 $w.entry26 configure -state disabled
 $w.entry27 configure -state disabled
 $w.entry28 configure -state disabled
}
}


# Procedure: addr_name
proc addr_name {} {
global addr_book
global prompt

set alist .address.frame12.frame.listbox1
if {[$alist curselection] == ""} return
ShowWindow.entry
set ix [$alist curselection]
.entry.m configure -text "Enter alias name:"
.entry.entry delete 0 end
.entry.entry insert 0 $addr_book($ix,alias)
focus .entry.entry
grab .entry
tkwait variable prompt(ok)
destroy .entry
if {$prompt(ok)} {
 set addr_book(modified) 1
 set addr_book($ix,alias) $prompt(result)
 $alist delete $ix
 $alist insert $ix $prompt(result)
 $alist select set $ix
 .address.frame11.addr_title_frame.alias configure -text $prompt(result)
}
}


# Procedure: addr_new
proc addr_new {} {
global prompt
global addr_book

ShowWindow.entry
.entry.m configure -text "Enter alias name:"
.entry.entry delete 0 end
focus .entry.entry
grab .entry
tkwait variable prompt(ok)
destroy .entry
set alist .address.frame12.frame.listbox1
if {$prompt(ok)} {
    set addr_book(modified) 1
    $alist insert end $prompt(result)
    $alist select clear 0 end
    $alist select set end
    set ix_end [expr [$alist index end] - 1]
    set addr_book($ix_end,alias) $prompt(result)
    set addr_book($ix_end,country) ""
    set addr_book($ix_end,local) ""
    set addr_book($ix_end,fax) ""
    set addr_book($ix_end,name) ""
    set addr_book($ix_end,org) ""
    set addr_book($ix_end,email) ""
    if {$ix_end == 0} {
	set w .address.frame11
	$w.entry23 configure -state normal
	$w.entry24 configure -state normal
	$w.entry25 configure -state normal
	$w.entry26 configure -state normal
	$w.entry27 configure -state normal
	$w.entry28 configure -state normal
    }
    addr_set
}
}


# Procedure: addr_select
proc addr_select {} {
global addr_book
global recipient

set ix [.address.frame12.frame.listbox1 curselection]
if {$ix == ""} return
set recipient(country) $addr_book($ix,country)
set recipient(local) $addr_book($ix,local)
set recipient(number) $addr_book($ix,fax)
set recipient(name) $addr_book($ix,name)
set recipient(organisation) $addr_book($ix,org)
set recipient(email) $addr_book($ix,email)
checknum 0
}


# Procedure: addr_set
proc addr_set {} {
global address
global addr_book

set alist .address.frame12.frame.listbox1
set index [$alist curselection]
if {$index >= 0} {
 .address.frame11.addr_title_frame.alias configure -text $addr_book($index,alias)
 .address.frame11.entry23 configure -textvariable addr_book($index,country)
 .address.frame11.entry24 configure -textvariable addr_book($index,local)
 .address.frame11.entry25 configure -textvariable addr_book($index,fax)
 .address.frame11.entry26 configure -textvariable addr_book($index,name)
 .address.frame11.entry27 configure -textvariable addr_book($index,org)
 .address.frame11.entry28 configure -textvariable addr_book($index,email)
# addr_select
}
}


# Procedure: addr_write
proc addr_write {} {
global addr_book

set f [open ~/.fax_addr w]
for {set i 0} {$i < [.address.frame12.frame.listbox1 index end]} {incr i 1} {
puts $f [list $addr_book($i,alias) $addr_book($i,country)  $addr_book($i,local) $addr_book($i,fax)  $addr_book($i,name) $addr_book($i,org)  $addr_book($i,email) ]
}
 close $f
}


# Procedure: addresses
proc addresses {} {
global address
global addr_book

set addr_book(modified) 0
if { [file exists ~/.fax_addr ] == 0 } {
   set f [open ~/.fax_addr w]
#  puts $f ""
   close $f
}
set count 0
set f [open ~/.fax_addr r]
while { [gets $f addr_line ] >= 0 } {
   set addr_book($count,alias) [lindex $addr_line 0]
   set addr_book($count,country) [lindex $addr_line 1]
   set addr_book($count,local) [lindex $addr_line 2]
   set addr_book($count,fax) [lindex $addr_line 3]
   set addr_book($count,name) [lindex $addr_line 4]
   set addr_book($count,org) [lindex $addr_line 5]
   set addr_book($count,email) [lindex $addr_line 6]
   set count [expr {$count + 1} ]
}
close $f
ShowWindow.address
tkwait visibility .address
set alist .address.frame12.frame.listbox1 
$alist delete 0 end
for {set i 0} {$i < $count} {incr i 1} {
  $alist insert end $addr_book($i,alias)
}
$alist select clear 0 end
$alist select set 0
if {$count > 0} {
 addr_set
} else {   
 set addr_book($count,alias) ""
 set addr_book($count,country) ""
 set addr_book($count,local) ""
 set addr_book($count,fax) ""
 set addr_book($count,name) ""
 set addr_book($count,org) "" 
 set addr_book($count,email) ""
 $alist insert end $addr_book($i,alias)
 $alist select clear 0 end
 $alist select set 0 
 addr_delete
 set addr_book(modified) 0
}
}


# Procedure: clear
proc clear {} {
    global recipient

    .tt.t delete 1.0 end
    .p.list.box delete 0 end
    set recipient(country) ""
    set recipient(local) ""
    set recipient(number) ""
    set recipient(name) ""
    set recipient(organisation) ""
    set recipient(department) ""
    set recipient(email) ""
    set recipient(subject) ""

#     pack .b.b1 .b.b4 .b.b3 .b.b6 .b.b5 .b.b7 -side left
#     pack .b.b2 -side right
#     pack .b .label0 
    
#     pack .www.label9 .www.entry16 -side left
#     pack .www -after .b
    
#     pack .p.buttons.add .p.buttons.del -side top -fill x
#     pack .p.list.sy -side right -fill y
#     pack .p.list.box -side left -fill both -expand true

#     pack .p.label1 .p.list -side left
#     pack configure .p.buttons -anchor e  -side right
#     pack .p -after .www
    
#     pack .tt.f.b2 -side right
#     pack .tt.f.label3 -anchor w -side left
#     pack .tt.f -expand 1 -fill x
#     pack .tt.scroll -fill y -side right
#     pack .tt.t -anchor w
#     pack .tt -after .p
    
#     pack .w.top.left.label .w.top.left.entry -side top -anchor w
#     pack .w.top.right.label .w.top.right.entry -side top -anchor w
#     pack .w.bot.label .w.bot.entry -side top -anchor w
#     pack configure .w.bot.check -side top -fill y -anchor center
#     pack .w.top.left .w.top.right -side left -expand true -fill x
#     pack .w.top -side top -fill x
#     pack .w.bot -side top -fill y
    
#     pack .ww.label5 .ww.entry5 .ww.label6 .ww.entry6 .ww.label8 .ww.entry8 -anchor w
    
#     pack .w -side left -after .tt
#     pack .ww -side right -after .w

    update idletasks
}


# Procedure: coverage
proc coverage {} {
    global recipient
    global covfile
    global valprog

    toplevel .cov
    frame .cov.f
    message .cov.msg -text "COVERAGE LIST" -width 10i
    button .cov.f.b -text "EXIT" -command {destroy .cov} -foreground red
    set num $recipient(country)$recipient(local)$recipient(number)
    set num2 $recipient(country)-$recipient(local)-$recipient(number)   

    wm title .cov "Coverage and Number Validation"
    
    if { [string compare $recipient(number) ""] * [string compare $recipient(country) ""] * [string compare $recipient(local) ""] == 0} {
    set response " Incomplete number provided."
    } else {
    set ans [exec $valprog $num]
    if {$ans == "Number covered!"} {
    set response "Number $num2 is accessible!"
    } else {
    set response "Number $num2 is not covered at present."
    } 
    }
    message .cov.f.msg -relief raised -text $response -width 70i -foreground blue
    text .cov.doc -relief sunken -bd 2 -yscrollcommand ".cov.scroll set"
    scrollbar .cov.scroll -command ".cov.doc yview"
    pack .cov.msg
    pack .cov.f.msg -side left -fill x -expand 1
    pack .cov.f.b -side right 
    pack .cov.f -side top -expand 1 -fill x
    pack .cov.scroll -side right -fill y
    pack .cov.doc -side left
    bind .cov.doc <Button-1> {.cov.doc config -state normal} 
    set f [open $covfile]
    while {![eof $f]} { .cov.doc insert end [read $f 1000] }
    close $f
    grab set .cov
    tkwait window .cov
}


# Procedure: done
proc done {} {
 
    global user

    set f [open ~/.faxinit w]
    puts $f $user(fax)
    puts $f $user(tel)
    puts $f $user(name)
    puts $f $user(organisation)
    puts $f $user(department)
    puts $f $user(email)

    close $f
    destroy .pref
}


# Procedure: error
proc error { text} {
    toplevel .error
#    label .error.msg -text "File not found"
    message .error.msg2 -text $text -width 10i
#    label .error.msg3 -text "FAX NOT SENT"
    button .error.b -text "OK" -command {destroy .error}
    label .error.label -bitmap warning
#    pack .error.label .error.msg .error.msg2 .error.msg3 .error.b
    pack .error.label .error.msg2 .error.b 
    grab set .error
    tkwait window .error
}

# Procedure: checknum
proc checknum {mode} {
    global recipient
    
    set response ""
    if {$recipient(country) == ""} {
	set response "$response Must set COUNTRY CODE\n"
    } else {
	if {![regexp {^[0-9]+$} $recipient(country)]} {
	    set response "$response Remove punctuation from COUNTRY CODE\n"
	}
    }
    if {$recipient(local) == ""} {
	set response "$response Must set LOCAL CODE\n"
    } else {
	if {![regexp {^[0-9]+$} $recipient(local)]} {
	    set response "$response Remove punctuation from LOCAL CODE\n"
	}
    }
    if {[string compare $recipient(number) ""]==0} {
	set response "$response Must set FAX NUMBER\n"
    } else {
	if {![regexp {^[0-9]+$} $recipient(number)]} {
	    set response "$response Remove punctuation from FAX NUMBER\n"
	}
    }
    if { $response == "" } {
	if { $mode == 1 } {
	coverage
	}
	return 1
    } else {
	error $response
	return 0
    }
}
# Procedure: fax
proc fax {} {
    
    global recipient
    global user
    global mailer
    global tmp
    
    if { ![checknum 0] } return

    
    set addr remote-printer@$recipient(country)$recipient(local)$recipient(number).iddd.tpc.int
    
    set message [.tt.t get 1.0 end]
    
    if {$message == "\n"} {
	if {[.p.list.box index end] == 0} {
	    no {TEXT or POSTSCRIPT that you wish to send}
	    return
	}
    }
    set f [open "$tmp/.fax$user(name)" w]
    
    puts $f "Subject:      $recipient(subject)"
    puts $f "MIME-Version: 1.0"
    puts $f "Content-Type: Multipart/mixed; boundary=xxxDsZYb46dwyf6tr431jhbgxxx"
    puts $f ""
    puts $f ""
    puts $f "--xxxDsZYb46dwyf6tr431jhbgxxx"
    puts $f "Content-Type: application/remote-printing"
    puts $f ""
    puts $f "Recipient:    $recipient(name)"
    puts $f "Title:        "
    puts $f "Organization: $recipient(organisation)"
    puts $f "Address:      "
    puts $f "Telephone:     "
    puts $f "Facsimile:    +$recipient(country) $recipient(local) $recipient(number)"
    puts $f "Email:        $recipient(email)" 
    puts $f ""
    puts $f "Originator:   $user(name)"
    puts $f "Organization: $user(organisation)"
    puts $f "Telephone:    $user(tel)"
    puts $f "Facsimile:    $user(fax)"
    puts $f "Email:        $user(email)" 
    
    if {$message == "\n"} {
    } else {
	puts $f "--xxxDsZYb46dwyf6tr431jhbgxxx"
	puts $f "Content-Type: text/plain"
	puts $f ""
	puts $f $message
    }

    foreach attach [.p.list.box get 0 end] {
	set filename [lindex $attach end] 
	if [file exists $filename] {
	    if [regexp {^\(plain} $attach] {
		set mimetype "text/plain"
		set coding "7bit"
		set f2 [open $filename r]
	    } elseif [regexp {^\(postscript} $attach] {
		set mimetype "application/postscript"
		set coding "7bit"
		set f2 [open $filename r]
	    } elseif [regexp {^\(image} $attach] {
		set mimetype "application/postscript"
		set coding "7bit"
		if { [catch {exec convert $filename /tmp/faxtmp.ps} ] } {
		    error "FAX NOT SENT\nCouldn't recognise image file\n$filename, please check"
		    return  
		} else {
		    set f2 [open "/tmp/faxtmp.ps" r]
		}
	    } else {
		error "FAX NOT SENT\nProblem with file attachements, please check"
		return
	    }
	    puts $f "--xxxDsZYb46dwyf6tr431jhbgxxx"
	    puts $f "Content-Type: $mimetype"
	    puts $f "Content-Transfer-Encoding: $coding"
	    puts $f ""
	    while {[gets $f2 line] >= 0} {
		puts $f $line
	    }
	} else {
	    error "FAX NOT SENT\n File not found\n \"$element\""
	    return
	}
	close $f2
	puts $f ""
	puts $f ""
	if [regexp {^\(image} $attach] {
	    exec rm /tmp/faxtmp.ps
	}
    }

    puts $f "--xxxDsZYb46dwyf6tr431jhbgxxx--"
    close $f
    
    exec $mailer -oi $addr < $tmp/.fax$user(name)
    sent
}


# Procedure: init
proc init {} {
    global user
    global covfile
    global valprog
    global mailer
    global tmp
    global address
    global argv

    set mailer [lindex $argv 0]
    set valprog [lindex $argv 1]
    set covfile [lindex $argv 2]
    set tmp [lindex $argv 3]
    
    if [file exists ~/.faxinit] {
        set f [open ~/.faxinit r]
    gets $f user(fax)
    gets $f user(tel)
    gets $f user(name)
    gets $f user(organisation)
    gets $f user(department)
    gets $f user(email)
    close $f
    if {$user(fax) == "Your Fax Number"} {
         set user(fax) "Sender's Fax Number"
   	 set f [open ~/.faxinit w]
  	  puts $f $user(fax)
   	  puts $f $user(tel)
    	  puts $f $user(name)
    	  puts $f $user(organisation)
    	  puts $f $user(department)
   	  puts $f $user(email)
         close $f
         preferences
        }
    } else {
        preferences
    }
}


# Procedure: no
proc no { text} {
    toplevel .error
    label .error.msg -text "The $text must be set"
    label .error.msg2 -text "FAX NOT SENT"
    button .error.b -text "OK" -command {destroy .error}
    label .error.label -bitmap warning
    pack .error.label .error.msg .error.msg2 .error.b
    grab set .error
    tkwait window .error
}

# Procedure: punctuation
proc punctuation { text} {
    toplevel .error
    label .error.msg -text "No punctuation allowed in $text "
    label .error.msg2 -text "FAX NOT SENT"
    button .error.b -text "OK" -command {destroy .error}
    label .error.label -bitmap warning
    pack .error.label .error.msg .error.msg2 .error.b
    grab set .error
    tkwait window .error
}

# Procedure: preferences
proc preferences {} {
    global user

    if [file exists ~/.faxinit] {
	set f [open ~/.faxinit r]
	gets $f user(fax)
	gets $f user(tel)
	gets $f user(name)
	gets $f user(organisation)
	gets $f user(department)
	gets $f user(email)


	close $f
    }
    
    toplevel .pref
    label .pref.label0 -text "SENDER'S COVER-SHEET\n DETAILS"
    label .pref.label1 -text ""
    label .pref.label2 -text "FAX NUMBER:"
    label .pref.label3 -text "TEL NUMBER:"
    label .pref.label5 -text "NAME:"
    label .pref.label6 -text "ORGANISATION:"
    label .pref.label7 -text "DEPARTMENT:"
    label .pref.label8 -text "EMAIL:"

    wm title .pref "Sender's Cover Sheet Details"
    
    entry .pref.entry10 -width 40 -relief sunken -bd 2 -textvariable user(fax)
    entry .pref.entry11 -width 40 -relief sunken -bd 2 -textvariable user(tel)
    entry .pref.entry12 -width 40 -relief sunken -bd 2 -textvariable user(name)
    entry .pref.entry13 -width 40 -relief sunken -bd 2 -textvariable user(organisation)
    entry .pref.entry14 -width 40 -relief sunken -bd 2 -textvariable user(department)
    entry .pref.entry15 -width 40 -relief sunken -bd 2 -textvariable user(email)
    
    button .pref.b1 -command done -text "OK" -foreground red
    
    pack .pref.label0 
    pack .pref.label1 
    pack .pref.label5 .pref.entry12 -anchor w 
    pack .pref.label6 .pref.entry13 -anchor w
    pack .pref.label7 .pref.entry14 -anchor w
    pack .pref.label2 .pref.entry10 -anchor w
    pack .pref.label3 .pref.entry11 -anchor w
    pack .pref.label8 .pref.entry15 -anchor w
    
    pack .pref.b1 
    
    grab set .pref
    tkwait window .pref
}


# Procedure: ps_browse
proc file_add {type ext} {
    global {fsBox}
    
    set fsBox(pattern) "*$ext"
    set file_name [FSBox]
    if { $file_name == "" } return
    if { ![file readable $file_name] || ![file isfile $file_name] } {
	error "\"$file_name\" is not a readable file."
    } else {
	.p.list.box insert end "$type $file_name"
    }
}


# Procedure: quit
proc quit {} {
    destroy .
}


# Procedure: sent
proc sent {} {
    global user
    global mailer
    global tmp
    toplevel .sent
    
    frame .sent.bbb
    label .sent.msg -text "FAX SENT"
    label .sent.msg2 -text ""
    label .sent.msg3 -text "Copy to inbox?"

    button .sent.bbb.yes -text "YES" -command {
	exec $mailer -oi  $user(email) < $tmp/.fax$user(name)
	exec rm $tmp/.fax$user(name)
	destroy .sent
    }

    button .sent.bbb.no -text "NO" -command {
	exec rm $tmp/.fax$user(name)
	destroy .sent
    }

    label .sent.label -bitmap warning
    pack .sent.bbb.yes .sent.bbb.no
    pack .sent.label .sent.msg .sent.msg2 .sent.msg3 .sent.bbb
    grab set .sent
    tkwait window .sent
}


# User defined images


# Internal procedures

# Procedure: Ls
if {"[info procs Ls]" == ""} {
proc Ls { args} {
# xf ignore me 7
##########
# Procedure: Ls
# Description: emulate UNIX ls
# Arguments: like UNIX (switches authorized -F -a [-a is ignored])
# Returns: directory list
# Sideeffects: none
##########

eval exec ls $args
} 
}


# initialize bindings for all widgets
proc XFInitAllBindings {} {
  # bindings
  bind all <Alt-Key> {
    tkTraverseToMenu %W %A
}
  bind all <Key-F10> {
    tkFirstMenu %W
}
  bind all <Key-Tab> {focus [tk_focusNext %W]}
  bind all <Shift-Key-Tab> {focus [tk_focusPrev %W]}
}



# startup source
proc StartupSrc {args} {
init
}


# initialize global variables
proc InitGlobals {} {
  global {covfile}
  global {fsBox}
  set {fsBox(activeBackground)} {}
  set {fsBox(activeForeground)} {}
  set {fsBox(all)} {0}
  set {fsBox(background)} {}
  set {fsBox(button)} {0}
  set {fsBox(extensions)} {0}
  set {fsBox(font)} {}
  set {fsBox(foreground)} {}
  set {fsBox(internalPath)} {}
  set {fsBox(name)} {}
  set {fsBox(path)} {}
  set {fsBox(pattern)} {*}
  set {fsBox(scrollActiveForeground)} {}
  set {fsBox(scrollBackground)} {}
  set {fsBox(scrollForeground)} {}
  set {fsBox(scrollSide)} {left}
  set {fsBox(showPixmap)} {0}
  global {mailer}
  global {recipient}
  global {tmp}
  global {user}
  global {valprog}
  global {images}
  # check to see if 'convert' utility is present
  if { [catch {exec which convert}] } {
	set images 0
	puts "no images..."
  } else {
	set images 1
  }

  # please don't modify the following
  # variables. They are needed by xf.
  global {autoLoadList}
  set {autoLoadList(xffax.tcl)} {0}
  global {moduleList}
  set {moduleList(xffax.tcl)} {}
  global {preloadList}
  set {preloadList(xfInternal)} {}
  global {symbolicName}
  set {symbolicName(root)} {.}
  global {xfWmSetPosition}
  set {xfWmSetPosition} {}
  global {xfWmSetSize}
  set {xfWmSetSize} {}
  global {xfAppDefToplevels}
  set {xfAppDefToplevels} {}
}

# initialize global variables
InitGlobals

# display/remove toplevel windows.
ShowWindow.

tkwait visibility .

# startup source
StartupSrc



# initialize bindings for all widgets.
XFInitAllBindings


# eof
#

