/*
 * This function deals with bytes from the telnet end of the connection.
 * These are scanned for IAC messages and the IAC function called if so,
 * else the byte is passed into the output queue.
 */

#include "virtmodem.h"
#include "blocks.h"

extern struct block_list local;

void
telnet_byte(unsigned char c)
{
    static int iac= -1;
    static unsigned char ibytes[3];

    switch(iac) {
    case 0:
	if(c==255) {
	    add_char(&local,c);
	    iac= -1;
	} else {
	    ibytes[1]=c;
	    iac=1;
	}
	break;
    case 1:
	ibytes[2]=c;
	do_iac(ibytes);
	iac= -1;
	break;
    default:
	if(c==255)
	    iac=0;
	else
	    add_char(&local,c);
    }
}
