/*
 * This is an SGI specific version of the pty.c file which is
 * necessary because of the ugly way in which IRIX does it's
 * pty handling. For an explanation of what this function does
 * see pty_bsd.c
 */

#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <fcntl.h>
#include "virtmodem.h"

void
attach_pty(int daemon)
{
    char *ttname;
    int fd;

    ttname=_getpty(&fd, O_RDWR, 0644, 0);
    if(!ttname) {
	fprintf(stderr,"No free tty/pty pairs\n");
	exit(1);
    }

    if(daemon) {		/* possibly fork */
	if(fork()) {
	    puts(ttname);
	    exit(0);
	}
    } else
	fprintf(stderr,"Running on terminal %s\n",ttname);

    /* close terminal and dup descriptors */
    fclose(stdin);
    fclose(stdout);
    fclose(stderr);
    dup2(fd,0);
    dup2(fd,1);
    dup2(fd,2);
}
