/*
 * virtmodem - the idea of this program is to provide a virtual modem
 * on a pty/tty pair for making calls over tcp/ip telnet connections as
 * if they were from a modem attached to a serial port. This was written
 * to enable programs which normall use modems such as uucp to run over
 * telnet connections instead. The main function attaches to a tty and
 * then loops looking for AT commands to execute.
 *
 * P.French 5/4/95
 */

#include <stdio.h>
#include <fcntl.h>
#include "virtmodem.h"
#include "blocks.h"

struct block_list local;

void
main(int argc, char **argv)
{
    char pair[2], buffer[1000];
    int n, daemon=1;

    if(argc>1)
	if((argc>2) || (strcmp(argv[1],"-s"))) {
	    fprintf(stderr,"usage: %s [-s]\n",argv[0]);
	    return;
	} else {
	    daemon = 0;
	    stats_init();
	}

    attach_pty(daemon);
    pair[0]=pair[1]='\r';
    n= -1;
    block_init(&local,1);
    fcntl(0, F_SETFL, 0);	/* set blocking */
    while (read(0, &pair[1], 1) > 0) {
	fcntl(1, F_SETFL, 0);	/* set blocking */
	add_char(&local,pair[1]);
	flush_block(&local);
	if((n>=0) && ((pair[1]=='\r') || (pair[1]=='\n'))) {
	    buffer[n]='\0';
	    outstr("\n\r");

	    /* strip trailing spaces */
	    while(n>0 && buffer[n-1]==' ') {
		n--;
		buffer[n]='\0';
	    }
	    if(command(buffer))
		break;
	    n= -1;
	}
	if(n>=0)
	    buffer[n++]=pair[1];
	if(((pair[0]=='a')||(pair[0]=='A')) && ((pair[1]=='t')||(pair[1]=='T')))
	    n=0;
	pair[0]=pair[1];
	fcntl(0, F_SETFL, 0);	/* set blocking */
    }
}

/* outstr - write a string to the terminal and flush */
void
outstr(char *c)
{
    while(*c)
	add_char(&local,*c++);
    flush_block(&local);
}
