/*
 * functions provided by the blocks.c file
 */

#define DATA_LEN 1024

struct data_block {
    unsigned char data[DATA_LEN];
    int len;
    int offset;
    struct data_block *next;
};

struct block_list {
    struct data_block *first;
    struct data_block *last;
    int fd;
    long stored;
};

extern long block_size(struct block_list*);
extern void block_init(struct block_list*, int);
extern void add_char(struct block_list*, unsigned char);
extern int flush_block(struct block_list*);
