/*
    vt100.c -- VT100 emulation code. (probably very incomplete)
    Copyright (C) 1996  Nadav Cohen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "vt100.h"
#include "screen.h"
#include "modem.h"
#include <ncurses.h>
#include <stdlib.h>
#include <string.h>

#define ESC 0x1B
#define Brak '['

int InVT = 0, GotBraket = 0, InVT52 = 0;
int VTVal[10], ValCount = 0;
int saveX = 0, saveY = 0, SavePos;
int clean, SavefgCol, SavebgCol, Saveattr;
bool Scroll=TRUE;

void getVals()
{
 int i,startpos;
 char tempstr[10];
 
 ValCount = 0;
 for (i=SavePos+2, startpos=SavePos+2;i<Emupos;i++)
     if (Emu[i] == ';' || i+1 == Emupos)
     {
      if (i+1 == Emupos)
      {
         strncpy(tempstr,&Emu[startpos], i-startpos+1);
         tempstr[i-startpos+1]=0;
      }
      else
      {
         strncpy(tempstr,&Emu[startpos], i-startpos);
         tempstr[i-startpos]=0;
      }
      startpos=i+1;
      VTVal[ValCount++] = atoi(tempstr);
     }
 return;
}

int VT100(int ch)
{
 int i,j, x1, y1, row, col;
 char tempstr[10];
 
 clean = 0; 
 if (!InVT)
 {
  if (ch == ESC) InVT = 1;
  else
      return SEND;
 }
 else
 {
  if (!GotBraket)
  {
   if (ch == Brak)
   { 
     GotBraket = 1;
     SavePos = Emupos-1;
     return SAVE;
   }
   else
   {
    if (InVT52)
     switch(ch){
     case 'A':
       getyx(Screen, i ,j);
       if (i>0) swmove(Screen, i-1, j);
       break;
     case 'B':
       getyx(Screen, i ,j);
       if (i<LINES) swmove(Screen, i+1, j);
       break;
     case 'C':
       getyx(Screen, i, j);
       if (j<COLS) swmove(Screen, i, j+1);
       break;
     case 'D':
       getyx(Screen, i ,j);
       if (j>0) swmove(Screen, i , j-1);
       break;
     case 'H':
       swmove(Screen, 0 ,0);
       break;
     case 'K':
       swclrtoeol(Screen);
       break;
     case 'J':
       swclrtobot(Screen);
       break;
     case 'Z':
       msendchar(ESC);
       msendchar('/');
       msendchar('Z');
       break;
     default:break;
    }
    else
    switch(ch){
    case 'c':
      GlobalAttr = A_NORMAL;
      swmove(Screen, 0, 0);
      Emupos = SavePos; clean = 1;
      break;
    case 'D': 
      scrollok(Screen, TRUE);
      wscrl(Screen, 1); 
      scrollok(Screen, Scroll);
      Emupos = SavePos; clean = 1;
      break;
    case 'M': 
      scrollok(Screen, TRUE);
      wscrl(Screen, -1); 
      scrollok(Screen, Scroll);
      Emupos = SavePos; clean = 1;
      break;
    case 'E':
      getyx(Screen, i, j);
      swmove(Screen, i+1, j);
      Emupos = SavePos; clean = 1;
      break;
    case '5':
      msendchar(ESC);
      msendchar('0');
      msendchar('n');
      Emupos = SavePos; clean = 1;
      break;
    case '6':
      getyx(Screen, i, j);
      msendchar(ESC);
      sprintf(tempstr,"%d;%dR",i,j);
      mwriteblock(tempstr, strlen(tempstr));
      Emupos = SavePos; clean = 1;
      break;
    case '7':
      getyx(Screen, saveY, saveX);
      SavefgCol = fgCol;
      SavebgCol = bgCol;
      Saveattr = GlobalAttr;
      Emupos = SavePos; clean = 1;
      break;
    case '8':
      swmove(Screen, saveY, saveX);
      wattrset(Screen, Saveattr);
      textColor(Screen, SavefgCol);
      textBkgd(Screen, SavebgCol);
      GlobalAttr = Saveattr;
      Emupos = SavePos; clean = 1;
      break;
    case '<':
      InVT52 = ~InVT52 & 1;
      Emupos = SavePos; clean = 1;
      break;
    }
    InVT = 0;
   }
  }
  else
  {
    switch(ch){
    case 'h':
      strncpy(tempstr, &Emu[SavePos+1], 2);
      tempstr[2] = 0;
      if (tempstr=="?7"){ scrollok(Screen, TRUE); Scroll = TRUE; }
      InVT = 0; GotBraket = 0; Emupos = SavePos; clean = 1;
      break;
    case 'l':
      strncpy(tempstr, &Emu[SavePos+1], 2);
      tempstr[2] = 0;
      if (tempstr=="?2") Ansi = 1;
      if (tempstr=="?7"){ scrollok(Screen, FALSE); Scroll = FALSE; }
      InVT = 0; GotBraket = 0; Emupos = SavePos; clean = 1;
      break;
    case 'm':
      getVals();
      if (ValCount == 0){ wattrset(Screen, A_NORMAL); GlobalAttr = A_NORMAL;}
      if (ValCount > 0)
       switch(VTVal[0]) {
        case 0:
          wattrset(Screen, A_NORMAL | A_ALTCHARSET);
          GlobalAttr = A_NORMAL | A_ALTCHARSET;
          break;
        case 1: 
          break;
        case 2: 
//          wattron(Screen, A_DIM);
          GlobalAttr |= A_DIM;
          break;
        case 4: 
  //        wattron(Screen, A_UNDERLINE);
          GlobalAttr |= A_UNDERLINE;
          break;
        case 5: 
    //      wattron(Screen, A_BLINK);
          GlobalAttr |= A_BLINK;
          break;
        case 7: 
      //    wattron(Screen, A_REVERSE);
          GlobalAttr |= A_REVERSE;
          break;
        case 8: textColor(Screen, bgCol);break;
        default:break;
        }
       InVT = 0; GotBraket = 0; Emupos = SavePos; clean = 1;
      break;
    case 'H':
      SetCursor:
      getVals();
      if (ValCount > 0)
      {
       row = VTVal[0]-1;
       col = VTVal[1]-1;
      }
      else
      {
       row = 0; col = 0;
      }
      swmove(Screen, row, col);
      wrefresh(Screen);
      InVT = 0; GotBraket = 0; Emupos = SavePos; clean = 1;
      break;
    case 'f': goto SetCursor;break;
    case 'A':
      getVals();
      getyx(Screen,row, col);
      if (ValCount > 0)
      {
       row -= VTVal[0];
      }
      else row++;
      swmove(Screen, row, col);
      InVT = 0; GotBraket = 0; Emupos = SavePos; clean = 1;
      break;
    case 'B':
      getVals();
      getyx(Screen,row, col);
      if (ValCount > 0)
      {
       row += VTVal[0];
      }
      else row--;
      swmove(Screen, row, col);
      InVT = 0; GotBraket = 0; Emupos = SavePos; clean = 1;
      break;
    case 'C':
      getVals();
      getyx(Screen,row, col);
      if (ValCount > 0)
      {
       col += VTVal[0];
      }
      else col++;
      swmove(Screen, row, col);
      InVT = 0; GotBraket = 0; Emupos = SavePos; clean = 1;
      break;
    case 'D':
      getVals();
      getyx(Screen,row, col);
      if (ValCount > 0)
      {
       col -= VTVal[0];
      }
      else col--;
      swmove(Screen, row, col);
      InVT = 0; GotBraket = 0; Emupos = SavePos; clean = 1;
      break;
    case 'K':
      getVals();
      if (ValCount == 0) swclrtoeol(Screen);
      if (ValCount > 0 )
       switch(VTVal[0]){
        case 0:
          swclrtoeol(Screen);
          break;
        case 1:
          getyx(Screen, y1, x1);
          swmove(Screen, y1, 0);
          for (i=0;i<x1;i++)
           swaddch(Screen, ' ');
          swmove(Screen, y1, x1);
          break;
        case 2:
          getyx(Screen, y1, x1);
          swmove(Screen, y1, 0);
          swclrtoeol(Screen);
          swmove(Screen, y1, x1);
          break;
        default:break;
       }
      InVT = 0; GotBraket = 0; Emupos = SavePos; clean = 1;
      break;
    case 'J':
      getVals();
      if (ValCount == 0) swclrtobot(Screen);
      if (ValCount > 0) 
       switch(VTVal[0]){
        case 0:
          swclrtobot(Screen);
          break;
        case 1:
          getyx(Screen, y1, x1);
          for (i=0;i<y1;i++)
          {
           swmove(Screen, i, 0);
           swclrtoeol(Screen);
          }
          swmove(Screen, y1, 0);
          for (i=0;i<x1;i++)
           swaddch(Screen, ' ');
          break;
        case 2:
          swclear(Screen);
          break;
        }
       InVT = 0; GotBraket = 0; Emupos = SavePos; clean = 1;
       break;
    case 'c':
      getVals();
      msendchar(ESC);
      strcpy(tempstr, "[?1;");
      mwriteblock(tempstr, strlen(tempstr));
      if (ValCount == 1) msendchar('0');
      msendchar('0');
      msendchar('c');
      InVT = 0; GotBraket = 0; Emupos = SavePos; clean = 1;
      break;
    case '0':
    case '1':
    case '2':
    case '3':
    case '4':
    case '5':
    case '6':
    case '7':
    case '8':
    case '9':
    case ';':
    case '=':
    case '>':
    case '<': break;
    default:break;
  }
 }
 }
 if (clean) return DUMP;
 if (InVT) return SAVE;
 else return SEND;
}
