/*
    screen.h -- Header file for screen and output routines
    Copyright (C) 1996  Nadav Cohen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#ifndef __SCREEN_H_
#define __SCREEN_H_
#include <ncurses.h>

/* Color definitions */
#define BLACK  0
#define BLUE   1
#define GREEN  2
#define CYAN   3
#define RED    4
#define MAGENT 5
#define YELLOW 6
#define WHITE  7

/* Defines the codes for the single line frame */
#define SHLINE 196
#define SVLINE 179
#define SUL    218
#define SUR    191
#define SBR    217
#define SBL    192

/* Defines the codes for the double line frame */
#define DHLINE 205
#define DVLINE 186
#define DUL    201
#define DUR    187
#define DBR    188
#define DBL    200

extern WINDOW *Screen;
extern WINDOW *Status;
extern WINDOW *PhoneScreen;
extern WINDOW *FileScreen;
extern WINDOW *ScrollScreen;
extern int bgCol, fgCol, GlobalAttr;
extern char ValidEdit[47], FileEdit[46], NumberEdit[16], HexEdit[17];
extern chtype *ScrollBuffer, *ScrollPtr, *ScrollStart;
extern int ScrollY, ScrollX, ScrollBackLength;
extern int CaptureHandle, CaptureOn;
extern char *CapturePtr, *CaptureStart;
extern char *XCursesProgramName;

void initScreen();
void closeScreen();
void textAttr(WINDOW *Win, int color);
void textColor(WINDOW *Win, int color);
void textBkgd(WINDOW *Win, int color);
void swaddch(WINDOW *Window, chtype Ch);
void swaddstr(WINDOW *Window, char *Str);
void swmove(WINDOW *Window, int y, int x);
void smvwaddch(WINDOW *Window, int y, int x, chtype Ch);
void smvwaddstr(WINDOW *Window, int y, int x, char *Str);
void swclear(WINDOW *Window);
void swclrtoeol(WINDOW *Window);
void swclrtobot(WINDOW *Window);
int findCenter(int X1, int X2, int Len);
int colortoattr(int color);
char getstring(WINDOW *Win, int y,int x, char *instr,char *usestr,char *exitstr, int len, int pl, char *putin);
int getEscChar();
#endif
