/*
    phone.c -- Phonebook and dialing directory routines
    Copyright (C) 1996  Nadav Cohen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#include "phone.h"
#include "screen.h"
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <fcntl.h>
#include <stdio.h>
#include <string.h>
#include "list.h"
#include "config.h"
#include "menu.h"
#include "window.h"
#include "modem.h"
#include <time.h>
#include <ctype.h>
#include "terminal.h"
#include "log.h"
#include "utils.h"
#include "error.h"
#include "filemgr.h"

tTermPhoneHeadRec TermHeader;
tTelixPhoneHeadRec TelixHeader;
tList *PhoneBook;
tTermPhoneRec *TermCurrentPos, *TermLastPos;
int TermCurrentNumber, TermLastScrPos;
int DialRetries, WhichBook, DialerConnect;
char *CurrentPhonebook, PhonebookChanged, ConnectMatch;
tTermPhoneRec *CurrentEntry;

char TranslateToTerminate[17]={0,0,1,0,0,1,2,2,4,3,3,4,0,0,0,2};
char TranslateToTelix[6] = {4, 2, 3, 4, 1, 2};
long int TelixBaud[8] = {300, 2400, 4800, 9600, 19200, 38400, 57600, 115200};
char TelixParity[5] = {'N', 'E', 'O', 'M', ' '};


void CreateClearEntry(tTermPhoneRec *Entry)
{
 Entry->Name[0] = 0;
 Entry->Number[0] = 0;
 Entry->Device = 0;
 Entry->Baud = Integers[Bauds1];
 Entry->Parity = 78;
 Entry->Databits = 8;
 Entry->Stopbits = 1;
 Entry->Keyboard[0] = 0;
 Entry->Terminal = 0;
 Entry->DialSuffix = 1;
 Entry->DialPrefix = 1;
 Entry->Password[0] = 0;
 Entry->Open = 0;
 Entry->Closed = 0;
 Entry->User = 1;
 Entry->Comment1[0] = 0;
 Entry->Comment2[0] = 0;
 Entry->LoginScript = 0;
 Entry->Downloaddir = 0;
 Entry->Translate[0] = 0;
 Entry->Capture[0] = 0;
 Entry->Note[0] =0;
 Entry->LocalEcho = 0;
 Entry->StripHigh = 0;
 Entry->RcvdBSdest = 1;
 Entry->Color = 7;
 Entry->Juldate = 0;
 Entry->Calcmin = 0;
 Entry->Connects = 0;
 Entry->SecUsed = 0;
 Entry->UploadKb = 0;
 Entry->DownloadKb = 0;
 Entry->Costs = 0;
 Entry->LastCosts = 0;
 Entry->Tag = 0;
 Entry->Protocol = 'Z';
 Entry->Flags = 0;
}

int ReadTerminate(char *Filename, WINDOW *Window)
{
 int BookHandle, i;
 tTermPhoneRec *Tmp;
 char Temp[250];
 
 if ((BookHandle = open(Filename, O_RDONLY)) < 0)
  return EOPEN;
 
 read(BookHandle, &Temp, 101);
 TermHeader.Encrypted = Temp[0];
 if (TermHeader.Encrypted == 1) DisplayMessage(Window, "Phonebook is encrypted", 2);
 else{
  memcpy(&TermHeader.Seed, &Temp[1], 4);
  memcpy(&TermHeader.Version, &Temp[5], 6);
  memcpy(&TermHeader.Comment, &Temp[11], 31);
  memcpy(&TermHeader.Num, &Temp[42], 2);
  TermHeader.CurMonth = Temp[44];
  memcpy(&TermHeader.MonthCosts, &Temp[45], 4*12);
  memcpy(&TermHeader.PhonePos, &Temp[93], 2);
  TermHeader.ScrPos = Temp[95];
  TermHeader.WritePos = Temp[96];
  memcpy(&TermHeader.RangeStart, &Temp[97], 2);
  memcpy(&TermHeader.RangeStop, &Temp[99], 2);

  PhoneBook = new tList();
/*  CurrentPhonebook = (char *)malloc(strlen(Strings[Phonebook])+1);
  strcpy(CurrentPhonebook, Strings[Phonebook]);*/
  CurrentPhonebook = (char *)malloc(strlen(Filename)+1);
  strcpy(CurrentPhonebook, Filename);
 
  for (i=0; i<=TermHeader.Num; i++)
  {
   Tmp = new tTermPhoneRec;
   read(BookHandle, &Temp, 247);
   memcpy(&Tmp->Name, &Temp[0], 31);
   memcpy(&Tmp->Number, &Temp[31], 25);
   Tmp->Device = Temp[56];
   memcpy(&Tmp->Baud, &Temp[57], 4);
   Tmp->Parity = Temp[61];
   Tmp->Databits = Temp[62];
   Tmp->Stopbits = Temp[63];
   memcpy(&Tmp->Keyboard, &Temp[64], 9);
   Tmp->Terminal = Temp[73];
   Tmp->DialSuffix = Temp[74];
   Tmp->DialPrefix = Temp[75];
   memcpy(&Tmp->Password, &Temp[76], 25);
   memcpy(&Tmp->Open, &Temp[101], 2);
   memcpy(&Tmp->Closed, &Temp[103], 2);
   memcpy(&Tmp->User, &Temp[105], 1);
   memcpy(&Tmp->Comment1, &Temp[106], 41);
   memcpy(&Tmp->Comment2, &Temp[147], 41);
   Tmp->LoginScript = Temp[188];
   Tmp->Downloaddir = Temp[189];
   memcpy(&Tmp->Translate, &Temp[190], 9);
   memcpy(&Tmp->Capture, &Temp[199], 9);
   memcpy(&Tmp->Note, &Temp[208], 9);
   Tmp->LocalEcho = Temp[217];
   Tmp->StripHigh = Temp[218];
   Tmp->RcvdBSdest = Temp[219];
   Tmp->Color = Temp[220];
   memcpy(&Tmp->Juldate, &Temp[221], 2);
   memcpy(&Tmp->Calcmin, &Temp[223], 2);
   memcpy(&Tmp->Connects, &Temp[225], 2);
   memcpy(&Tmp->SecUsed, &Temp[227], 4);
   memcpy(&Tmp->UploadKb, &Temp[231], 4);
   memcpy(&Tmp->DownloadKb, &Temp[235], 4);
   memcpy(&Tmp->Costs, &Temp[239], 4);
   memcpy(&Tmp->LastCosts, &Temp[243], 4);
   Tmp->Tag = 0;
   PhoneBook->Add(Tmp);
  }
 
  if (Integers[StartInTop]){
   TermHeader.PhonePos = 1;
   TermCurrentPos = TermLastPos = (tTermPhoneRec *)PhoneBook->Base->Next;
   TermCurrentNumber = 1;
   TermHeader.ScrPos = 0;
   TermLastScrPos = 0;
  }
  else
  {
   TermCurrentPos = TermLastPos = (tTermPhoneRec *)PhoneBook->Base->Next;
   for (i=1;i<TermHeader.PhonePos-TermHeader.ScrPos;i++)
    TermCurrentPos = (tTermPhoneRec *)TermCurrentPos->Next;
   TermCurrentNumber = TermHeader.PhonePos-TermHeader.ScrPos+1;
   TermLastScrPos = --TermHeader.ScrPos;
  }
 }
 close(BookHandle);
 WhichBook = 0;
 return 0;
}

int WriteTerminate(char *Filename)
{
 int BookHandle, i;
 tTermPhoneRec *Tmp;
 char Temp[250];

 if (TermHeader.Encrypted == 0){ 
  if ((BookHandle = open(Filename, O_RDWR | O_CREAT | O_TRUNC)) < 0)
   return EOPEN;
 
  Temp[0] = TermHeader.Encrypted;
  memcpy(&Temp[1], &TermHeader.Seed, 4);
  memcpy(&Temp[5], &TermHeader.Version, 6);
  memcpy(&Temp[11], &TermHeader.Comment, 31);
  memcpy(&Temp[42], &TermHeader.Num, 2);
  Temp[44] = TermHeader.CurMonth;
  memcpy(&Temp[45], &TermHeader.MonthCosts, 4*12);
  memcpy(&Temp[93], &TermHeader.PhonePos, 2);
  Temp[95] = TermHeader.ScrPos;
  Temp[96] = TermHeader.WritePos;
  memcpy(&Temp[97], &TermHeader.RangeStart, 2);
  memcpy(&Temp[99], &TermHeader.RangeStop, 2);
  write(BookHandle, &Temp, 101);
  Tmp = (tTermPhoneRec *)PhoneBook->Base;
 
  for (i=0; i<=TermHeader.Num; i++)
  {
   memcpy(&Temp[0], &Tmp->Name, 31);
   memcpy(&Temp[31], &Tmp->Number, 25);
   Temp[56] = Tmp->Device;
   memcpy(&Temp[57], &Tmp->Baud, 4);
   Temp[61] = Tmp->Parity;
   Temp[62] = Tmp->Databits;
   Temp[63] = Tmp->Stopbits;
   memcpy(&Temp[64], &Tmp->Keyboard, 9);
   Temp[73] = Tmp->Terminal;
   Temp[74] = Tmp->DialSuffix;
   Temp[75] = Tmp->DialPrefix;
   memcpy(&Temp[76], &Tmp->Password, 25);
   memcpy(&Temp[101], &Tmp->Open, 2);
   memcpy(&Temp[103], &Tmp->Closed, 2);
   Temp[105] = Tmp->User;
   memcpy(&Temp[106], &Tmp->Comment1, 41);
   memcpy(&Temp[147], &Tmp->Comment2, 41);
   Temp[188] = Tmp->LoginScript;
   Temp[189] = Tmp->Downloaddir;
   memcpy(&Temp[190], &Tmp->Translate, 9);
   memcpy(&Temp[199], &Tmp->Capture, 9);
   memcpy(&Temp[208], &Tmp->Note, 9);
   Temp[217] = Tmp->LocalEcho;
   Temp[218] = Tmp->StripHigh;
   Temp[219] = Tmp->RcvdBSdest;
   Temp[220] = Tmp->Color;
   memcpy(&Temp[221], &Tmp->Juldate, 2);
   memcpy(&Temp[223], &Tmp->Calcmin, 2);
   memcpy(&Temp[225], &Tmp->Connects, 2);
   memcpy(&Temp[227], &Tmp->SecUsed, 4);
   memcpy(&Temp[231], &Tmp->UploadKb, 4);
   memcpy(&Temp[235], &Tmp->DownloadKb, 4);
   memcpy(&Temp[239], &Tmp->Costs, 4);
   memcpy(&Temp[243], &Tmp->LastCosts, 4);
   write(BookHandle, &Temp, 247);
   Tmp = (tTermPhoneRec *)Tmp->Next;
  }
 
  close(BookHandle);
 }
 return 0;
}

int ReadTelix(char *Filename)
{
 int BookHandle, i;
 tTelixPhoneRec *Tmp;
 tTermPhoneRec *Temp;
 char TempBuffer[250];
 
 if ((BookHandle = open(Filename, O_RDONLY)) < 0)
  return EOPEN;
  
/* CurrentPhonebook = (char *)malloc(strlen(Strings[Phonebook])+1);
 strcpy(CurrentPhonebook, Strings[Phonebook]);*/
  CurrentPhonebook = (char *)malloc(strlen(Filename)+1);
  strcpy(CurrentPhonebook, Filename);
 
 read(BookHandle, &TempBuffer, 64);
 memcpy(&TelixHeader.Reserved1, &TempBuffer, 6);
 memcpy(&TelixHeader.Num, &TempBuffer[6], 2);
 memcpy(&TelixHeader.Reserved2, &TempBuffer[8], 56);
 
 TermHeader.Num = TelixHeader.Num-1;
 TermHeader.RangeStart = 0;
 TermHeader.RangeStop = TelixHeader.Num;
 TermHeader.ScrPos = 1;
 TermHeader.PhonePos = 1;
 TermHeader.WritePos = 1;
 
 PhoneBook = new tList();
 Tmp = new tTelixPhoneRec;
 Temp = new tTermPhoneRec;
 memset(Temp, 0, sizeof(tTermPhoneRec));
 PhoneBook->Add(Temp);
 CreateClearEntry(Temp);
 
 for (i=0; i<=TermHeader.Num; i++)
 {
  Temp = new tTermPhoneRec;
  read(BookHandle, &TempBuffer, 86);
  
  memcpy(&Tmp->Name, &TempBuffer[0], 25);
  memcpy(&Tmp->Number, &TempBuffer[25], 17);
  Tmp->Baud = TempBuffer[42];
  Tmp->Parity = TempBuffer[43];
  Tmp->Databits = TempBuffer[44];
  Tmp->Stopbits = TempBuffer[45];
  memcpy(&Tmp->Script, &TempBuffer[46], 12);
  memcpy(&Tmp->LastCalled, &TempBuffer[58], 6);
  memcpy(&Tmp->Connects, &TempBuffer[64], 2);
  Tmp->Terminal = TempBuffer[66];
  Tmp->Protocol = TempBuffer[67];
  Tmp->Flags = TempBuffer[68];
  memcpy(&Tmp->Reserved, &TempBuffer[69], 2);
  Tmp->Prefix = TempBuffer[71];
  memcpy(&Tmp->Password, &TempBuffer[72], 14);
  
  memset(Temp, 0, sizeof(tTermPhoneRec));
  memcpy(&Temp->Name[1], Tmp->Name, sizeof(Tmp->Name));
  Temp->Name[0] = strlen(&Temp->Name[1]);
  memcpy(&Temp->Number[1], Tmp->Number, sizeof(Tmp->Number));
  Temp->Number[0] = strlen(&Temp->Number[1]);
  memcpy(&Temp->Password[1], Tmp->Password, sizeof(Tmp->Password));
  Temp->Password[0] = strlen(&Temp->Password[1]);
  Temp->Baud = TelixBaud[Tmp->Baud-1];
  Temp->Parity = TelixParity[Tmp->Parity];
  Temp->Databits = Tmp->Databits;
  Temp->Stopbits = Tmp->Stopbits;
  Temp->Terminal = Tmp->Terminal;
  Temp->Connects = Tmp->Connects;
  Temp->DialPrefix = Tmp->Prefix-1;
  Temp->Protocol = Tmp->Protocol;
  Temp->User = 1;
  Temp->LocalEcho = Tmp->Flags & 1;
  Temp->StripHigh = Tmp->Flags & 16;

  Temp->Tag = 0;
  PhoneBook->Add(Temp);
 }
 
 close(BookHandle);
 TermCurrentPos = TermLastPos = (tTermPhoneRec *)PhoneBook->Base->Next;
 for (i=1;i<TermHeader.PhonePos-TermHeader.ScrPos;i++)
  TermCurrentPos = (tTermPhoneRec *)TermCurrentPos->Next;
 TermCurrentNumber = TermHeader.PhonePos-TermHeader.ScrPos+1;
 TermLastScrPos = --TermHeader.ScrPos;
 WhichBook = 1;
 return 0;
}

int WriteTelix(char *Filename)
{
 int BookHandle, i, j;
 tTelixPhoneRec *Tmp;
 tTermPhoneRec *Temp;
 char TempBuffer[250];
 
 if ((BookHandle = open(Filename, O_RDWR | O_CREAT | O_TRUNC)) < 0)
  return EOPEN;
 TelixHeader.Num = TermHeader.Num+1;
 
 memcpy(&TempBuffer, &TelixHeader.Reserved1, 6);
 memcpy(&TempBuffer[6], &TelixHeader.Num, 2);
 memcpy(&TempBuffer[8], TelixHeader.Reserved2, 56);
 write(BookHandle, &TempBuffer, 64);
 
 Tmp = new tTelixPhoneRec;
 
 Temp = (tTermPhoneRec *)PhoneBook->Base->Next;
 for (i=0; i<=TermHeader.Num; i++)
 {
  memset(Tmp, 0, sizeof(tTelixPhoneRec));
  memcpy(Tmp->Name, &Temp->Name[1], Temp->Name[0]);
  memcpy(Tmp->Number, &Temp->Number[1], Temp->Number[0]);
  memcpy(Tmp->Password, &Temp->Password[1], Temp->Password[0]);
  for (j=0;j<8;j++)
   if (TelixBaud[j] == Temp->Baud) Tmp->Baud = j;
  for (j=0;j<5;j++)
   if (TelixParity[j] == Temp->Parity) Tmp->Parity = j;
  Tmp->Databits = Temp->Databits;
  Tmp->Stopbits = Temp->Stopbits;
  Tmp->Terminal = Temp->Terminal;
  Tmp->Connects = Temp->Connects;
  Tmp->Prefix = Temp->DialPrefix+1;
  Tmp->Protocol = Temp->Protocol;
  Tmp->Flags = Temp->Flags;
  if (Temp->LocalEcho) Tmp->Flags |= 1;
  else Tmp->Flags &= ~1;
  if (Temp->StripHigh) Tmp->Flags |= 16;
  else Tmp->Flags &= ~16;
  
  memcpy(&TempBuffer, &Tmp->Name, 25);
  memcpy(&TempBuffer[25], &Tmp->Number, 17);
  TempBuffer[42] = Tmp->Baud;
  TempBuffer[43] = Tmp->Parity;
  TempBuffer[44] = Tmp->Databits;
  TempBuffer[45] = Tmp->Stopbits;
  memcpy(&TempBuffer[46], &Tmp->Script, 12);
  memcpy(&TempBuffer[58], &Tmp->LastCalled, 6);
  memcpy(&TempBuffer[64], &Tmp->Connects, 2);
  TempBuffer[66] = Tmp->Terminal;
  TempBuffer[67] = Tmp->Protocol;
  TempBuffer[68] = Tmp->Flags;
  memcpy(&TempBuffer[69], &Tmp->Reserved, 2);
  TempBuffer[71] = Tmp->Prefix;
  memcpy(&TempBuffer[72], &Tmp->Password, 14);
  
  write(BookHandle, &TempBuffer, 86);
  Temp = (tTermPhoneRec *)Temp->Next;
 }
 
 delete Tmp;
 
 close(BookHandle);
 return 0;
}

void SavePhonebook()
{ 
 switch(WhichBook){
 case 0:
  if (WriteTerminate(CurrentPhonebook) < 0) 
   WindowError(PhoneScreen, "Unable to write phonebook");
  break;
 case 1:
  if (WriteTelix(CurrentPhonebook) < 0)
   WindowError(PhoneScreen, "Unable to write phonebook");
  break;
 default:break;
 }
}

void Dots(char *Pwd)
{
 int i;
 
 for (i=0;i<(int)strlen(Pwd);i++)
  Pwd[i]='.';
}

void Swap(tTermPhoneRec *First, tTermPhoneRec *Second)
{
 tTermPhoneRec *Next, *Prev;
 
 if (First->Next == Second){
   Next = (tTermPhoneRec *)Second->Next;
   
   Second->Next = First;
   Second->Prev = First->Prev;
   
   First->Next = Next;
   First->Prev = Second;
 }
 else if (Second->Next == First){
   Next = (tTermPhoneRec *)First->Next;
   
   First->Next = Second;
   First->Prev = Second->Prev;
   
   Second->Next = Next;
   Second->Prev = First;
 } 
 else{
  Prev = (tTermPhoneRec *)First->Prev;
  Next = (tTermPhoneRec *)First->Next;
 
  First->Next = Second->Next;
  First->Prev = Second->Prev;
 
  Second->Next = Next;
  Second->Prev = Prev;
 }
 if (First->Prev != NULL) First->Prev->Next = First;
 if (First->Next != NULL) First->Next->Prev = First;
 
 if (Second->Prev != NULL) Second->Prev->Next = Second;
 if (Second->Next != NULL) Second->Next->Prev = Second;
 
 if (PhoneBook->Base == First)
  PhoneBook->Base = Second;
 else
  if (PhoneBook->Base == Second)
   PhoneBook->Base = First;
   
 if (PhoneBook->Last == First)
  PhoneBook->Last = Second;
 else
  if (PhoneBook->Last == Second)
   PhoneBook->Last = First;
}
 
int NameCompare(tTermPhoneRec *I, tTermPhoneRec *J)
{
 char Temp[256], Tmp[256];
 PasToChar(I->Name, Temp);
 PasToChar(J->Name, Tmp);
 return (strcasecmp(Temp, Tmp));
}

int NumberCompare(tTermPhoneRec *I, tTermPhoneRec *J)
{
 char Temp[256], Tmp[256];
 PasToChar(I->Number, Temp);
 PasToChar(J->Number, Tmp);
 return (strcasecmp(Temp, Tmp));
}

int ConnectsCompare(tTermPhoneRec *I, tTermPhoneRec *J)
{
 int ReturnValue = 0;
 
 if (I->Connects < J->Connects) ReturnValue = -1;
 if (I->Connects == J->Connects) ReturnValue = 0;
 if (I->Connects > J->Connects) ReturnValue = 1;
 
 return ReturnValue;
}

int Comment1Compare(tTermPhoneRec *I, tTermPhoneRec *J)
{
 char Temp[256], Tmp[256];
 PasToChar(I->Comment1, Temp);
 PasToChar(J->Comment1, Tmp);
 return (strcasecmp(Temp, Tmp));
}

int Comment2Compare(tTermPhoneRec *I, tTermPhoneRec *J)
{
 char Temp[256], Tmp[256];
 PasToChar(I->Comment2, Temp);
 PasToChar(J->Comment2, Tmp);
 return (strcasecmp(Temp, Tmp));
}

void SortAscending(int Low, int High, int cmp(tTermPhoneRec *I, tTermPhoneRec *J))
{
 tTermPhoneRec *CurrentI, *CurrentJ, *Middle;
 tListObj *SaveI, *SaveJ;
 int i,j;
 
 CurrentI = (tTermPhoneRec *)PhoneBook->Base->Next;
 
 for (i=1;i<Low;i++)
  CurrentI = (tTermPhoneRec *)CurrentI->Next;
 Middle = (tTermPhoneRec *)PhoneBook->Base->Next;
 for (i=1;i<(High+Low)/2;i++)
  Middle = (tTermPhoneRec *)Middle->Next;
 CurrentJ = (tTermPhoneRec *)PhoneBook->Base->Next;
 for (i=1;i<High;i++)
  CurrentJ = (tTermPhoneRec *)CurrentJ->Next;
  
 i = Low;
 j = High;
 do
 {
  while (cmp(CurrentI, Middle)<0) {
   i++;
   CurrentI = (tTermPhoneRec *)CurrentI->Next;
  }
  while (cmp(CurrentJ, Middle)>0) {
   j--;
   CurrentJ = (tTermPhoneRec *)CurrentJ->Prev;
  }
  if (i<=j)
  {
   SaveI = CurrentI->Next;
   SaveJ = CurrentJ->Prev;
   Swap(CurrentI, CurrentJ);
   i++; j--;
   CurrentI = (tTermPhoneRec *)SaveI;
   CurrentJ = (tTermPhoneRec *)SaveJ;
  }
 }while(i<=j);
 if (Low<j) SortAscending(Low, j, cmp);
 if (i<High) SortAscending(i, High, cmp);
}

void SortDescending(int Low, int High, int cmp(tTermPhoneRec *I, tTermPhoneRec *J))
{
 tTermPhoneRec *CurrentI, *CurrentJ, *Middle;
 tListObj *SaveI, *SaveJ;
 int i,j;
 
 CurrentI = (tTermPhoneRec *)PhoneBook->Base->Next;
 
 for (i=1;i<Low;i++)
  CurrentI = (tTermPhoneRec *)CurrentI->Next;
 Middle = (tTermPhoneRec *)PhoneBook->Base->Next;
 for (i=1;i<(High+Low)/2;i++)
  Middle = (tTermPhoneRec *)Middle->Next;
 CurrentJ = (tTermPhoneRec *)PhoneBook->Base->Next;
 for (i=1;i<High;i++)
  CurrentJ = (tTermPhoneRec *)CurrentJ->Next;
  
 i = Low;
 j = High;
 do
 {
  while (cmp(CurrentI, Middle)>0) {
   i++;
   CurrentI = (tTermPhoneRec *)CurrentI->Next;
  }
  while (cmp(CurrentJ, Middle)<0) {
   j--;
   CurrentJ = (tTermPhoneRec *)CurrentJ->Prev;
  }
  if (i<=j)
  {
   SaveI = CurrentI->Next;
   SaveJ = CurrentJ->Prev;
   Swap(CurrentI, CurrentJ);
   i++; j--;
   CurrentI = (tTermPhoneRec *)SaveI;
   CurrentJ = (tTermPhoneRec *)SaveJ;
  }
 }while(i<=j);
 if (Low<j) SortDescending(Low, j, cmp);
 if (i<High) SortDescending(i, High, cmp);
}


void ShowLine(int Y, tTermPhoneRec *Entry, int Number)
{
 char Num[5], Temp[256];
 int fcol, bcol, i;
  
 fcol = fgCol;
 bcol = bgCol;

 textAttr(PhoneScreen, Integers[cPhoneText]);
 wmove(PhoneScreen, 1, 36);
 for (i=36;i<COLS;i++)
  waddch(PhoneScreen, ' ');
 
 textAttr(PhoneScreen, Entry->Color);
 
 wmove(PhoneScreen, Y, 0);
 for (i=0;i<COLS;i++)
  waddch(PhoneScreen, ' ');
 wmove(PhoneScreen, Y, 0);
 
 if (Entry->Tag)
  waddch(PhoneScreen, Integers[TagChar]);
 else
  waddch(PhoneScreen, ' ');
 sprintf(Num, "%03d  ", Number);
 waddstr(PhoneScreen, Num);
 PasToChar(Entry->Name, Temp);
 waddstr(PhoneScreen, Temp);
 textAttr(PhoneScreen, Integers[cPhoneText]);
 if (TermHeader.WritePos == 1) {
  wmove(PhoneScreen, 1, 36);
  waddstr(PhoneScreen, "Phone number");
  wmove(PhoneScreen, 1, 62);
  waddstr(PhoneScreen, "Baud");
  wmove(PhoneScreen, 1, 68);
  waddstr(PhoneScreen, "Comm.");
  textAttr(PhoneScreen, Entry->Color);
  wmove(PhoneScreen, Y, 36);
  PasToChar(Entry->Number, Temp);
  waddstr(PhoneScreen, Temp);
  wmove(PhoneScreen, Y, 61);
  sprintf(Temp, "%lu", Entry->Baud);
  waddstr(PhoneScreen, Temp);
  wmove(PhoneScreen, Y, 68);
  waddch(PhoneScreen, 48+Entry->Databits);
  waddch(PhoneScreen, '-');
  waddch(PhoneScreen, Entry->Parity);
  waddch(PhoneScreen, '-');
  waddch(PhoneScreen, 48+Entry->Stopbits);
 }
 if (TermHeader.WritePos == 2) {
  wmove(PhoneScreen, 1, 36);
  waddstr(PhoneScreen, "Comment1");
  wmove(PhoneScreen, Y, 36);
  textAttr(PhoneScreen, Entry->Color);
  PasToChar(Entry->Comment1, Temp);
  waddstr(PhoneScreen, Temp);
 }  
 if (TermHeader.WritePos == 3) {
  textAttr(PhoneScreen, Integers[cPhoneText]);
  wmove(PhoneScreen, 1, 36);
  waddstr(PhoneScreen, "Comment2");
  wmove(PhoneScreen, Y, 36);
  textAttr(PhoneScreen, Entry->Color);
  PasToChar(Entry->Comment2, Temp);
  waddstr(PhoneScreen, Temp);
 }  
 if (TermHeader.WritePos == 4) {
  wmove(PhoneScreen, 1, 36);
  waddstr(PhoneScreen, "Password");
  wmove(PhoneScreen, 1, 61);
  waddstr(PhoneScreen,"Opening hours");
  wmove(PhoneScreen, Y, 36);
  textAttr(PhoneScreen, Entry->Color);
  PasToChar(Entry->Password, Temp);
  if (Integers[HidePwds] == 1) Dots(Temp);
  waddstr(PhoneScreen, Temp);
  wmove(PhoneScreen, Y, 61);
  sprintf(Temp, "%02d:%02d-%02d:%02d",Entry->Open / 60,Entry->Open % 60, Entry->Closed / 60, Entry->Closed % 60);
  waddstr(PhoneScreen, Temp);
 }  
 if (TermHeader.WritePos == 5) {
  wmove(PhoneScreen, 1, 36);
  waddstr(PhoneScreen, "Username");
  wmove(PhoneScreen, 1, 61);
  waddstr(PhoneScreen, "Capture  Note");
  textAttr(PhoneScreen, Entry->Color);
  wmove(PhoneScreen, Y, 36);
  if (strlen(Strings[User1+Entry->User-1])>24)
  {
   strncpy(Temp, Strings[User1+Entry->User-1], 24);
   Temp[24]=0;
  }
  else strcpy(Temp, Strings[User1+Entry->User-1]);
  waddstr(PhoneScreen, Temp);
  wmove(PhoneScreen, Y, 61);
  PasToChar(Entry->Capture, Temp);
  waddstr(PhoneScreen, Temp);
  wmove(PhoneScreen, Y, 70);
  PasToChar(Entry->Note, Temp);
  waddstr(PhoneScreen, Temp);
 }
 if (TermHeader.WritePos == 6) {
  wmove(PhoneScreen, 1, 36);
  waddstr(PhoneScreen, "Prefix");
  wmove(PhoneScreen, 1, 61);
  waddstr(PhoneScreen, "Suffix");
  textAttr(PhoneScreen, Entry->Color);
  wmove(PhoneScreen, Y, 36);
  if (strlen(Strings[Prefix1+Entry->DialPrefix-1])>24)
  {
   strncpy(Temp, Strings[Prefix1+Entry->DialPrefix-1], 24);
   Temp[24]=0;
  }
  else strcpy(Temp, Strings[Prefix1+Entry->DialPrefix-1]);
  waddstr(PhoneScreen, Temp);
  wmove(PhoneScreen, Y, 61);
  if (strlen(Strings[Suffix1+Entry->DialSuffix-1])>24)
  {
   strncpy(Temp, Strings[Suffix1+Entry->DialSuffix-1], 24);
   Temp[24]=0;
  }
  else strcpy(Temp, Strings[Suffix1+Entry->DialSuffix-1]);
  waddstr(PhoneScreen, Temp);
 }
 if (TermHeader.WritePos == 7) {
  wmove(PhoneScreen, 1, 36);
  waddstr(PhoneScreen, "Last called");
  wmove(PhoneScreen, 1, 50);
  waddstr(PhoneScreen, "Total connects");
  textAttr(PhoneScreen, Entry->Color);
  wmove(PhoneScreen, Y, 36);
//  FromJulian(Entry->Juldate);
  sprintf(Temp, "%d-%d-%d", Day, Month, Year);
  waddstr(PhoneScreen, Temp);
  wmove(PhoneScreen, Y, 50);
  sprintf(Temp, "%d", Entry->Connects);
  waddstr(PhoneScreen, Temp);
 }
 if (TermHeader.WritePos == 8) {
  wmove(PhoneScreen, 1, 36);
  waddstr(PhoneScreen, "Time used");
  wmove(PhoneScreen, 1, 46);
  waddstr(PhoneScreen, "Cost");
  wmove(PhoneScreen, 1, 53);
  waddstr(PhoneScreen, "Download kb  Upload kb");
  wmove(PhoneScreen, Y, 36);
  textAttr(PhoneScreen, Entry->Color);
  sprintf(Temp,"%02lu:%02lu     %lu",Entry->SecUsed / 60, Entry->SecUsed % 60, Entry->Costs);
  waddstr(PhoneScreen, Temp);
  wmove(PhoneScreen, Y, 53);
  sprintf(Temp, "%lu", Entry->DownloadKb);
  waddstr(PhoneScreen, Temp);
  wmove(PhoneScreen, Y, 66);
  sprintf(Temp, "%lu", Entry->UploadKb);
  waddstr(PhoneScreen, Temp);
 }
 if (TermHeader.WritePos == 9) {
  wmove(PhoneScreen, 1, 36);
  waddstr(PhoneScreen, "Terminal emulation");
  wmove(PhoneScreen, 1, 60);
  waddstr(PhoneScreen, "Device");
  textAttr(PhoneScreen, Entry->Color);
  wmove(PhoneScreen, Y, 36);
  if (WhichBook == 0)
    waddstr(PhoneScreen, TermEmu[TranslateToTerminate[Entry->Terminal]]);
  if (WhichBook == 1)
    waddstr(PhoneScreen, TermEmu[TranslateToTelix[Entry->Terminal]]);
  wmove(PhoneScreen, Y, 60);
  i = Entry->Device;
  if (i == 0) i = Integers[DefaultDevice];
  if (i > 4) i = Integers[DefaultDevice];
  if (strlen(Strings[Device1+i-1])>24)
  {
   strncpy(Temp, Strings[Device1+i-1], 24);
   Temp[24]=0;
  }
  else strcpy(Temp, Strings[Device1+i-1]);
  waddstr(PhoneScreen, Temp);
 }
 textColor(PhoneScreen, fcol);
 textBkgd(PhoneScreen, bcol);
}

void PaintPhoneBar()
{
 int x, fcol, bcol, i;
 chtype ch;
 tTermPhoneRec *Tmp;
 
 fcol = fgCol;
 bcol = bgCol;
 textAttr(PhoneScreen, Integers[cPhoneBar]);
 
 for (x=0;x<COLS;x++)
 {
  ch=mvwinch(PhoneScreen, TermHeader.ScrPos+2, x);
  mvwaddch(PhoneScreen, TermHeader.ScrPos+2, x, ch & A_CHARTEXT); 
 }
 textColor(PhoneScreen, fcol);
 textBkgd(PhoneScreen, bcol);
}

void ShowTerm()
{
 int i, fcol, bcol;
 char Temp[256], s[30];
 
 fcol = fgCol;
 bcol = bgCol;
 
 textAttr(PhoneScreen, Integers[cPhoneText]);

 wclear(PhoneScreen); 
 for (i=0;i<COLS*2;i++)
  waddch(PhoneScreen, ' ');
 wmove(PhoneScreen, LINES-3, 0);
 for (i=0;i<COLS;i++)
  waddch(PhoneScreen, ' ');
 
 if (WhichBook == 0){ 
  strcpy(Temp, "Dialing directory - TERMINATE (");
  PasToChar(TermHeader.Comment, s);
  strcat(Temp, s);
  strcat(Temp, ")");
 }
 if (WhichBook == 1){
  strcpy(Temp, "Dialing directory - TELIX");
 }
 wmove(PhoneScreen, 0, findCenter(0,COLS,strlen(Temp)));
 waddstr(PhoneScreen, Temp);
 wmove(PhoneScreen, 1, 1);
 waddstr(PhoneScreen,"  #");
 wmove(PhoneScreen, 1, 6);
 waddstr(PhoneScreen,"Name");
 mvwaddstr(PhoneScreen, LINES-3, 1, "Edit  Find  Dial  Manual  Sort  Global  saVe  Phonebook  defAult");
 textColor(PhoneScreen, fcol);
 textBkgd(PhoneScreen, bcol);
}

void ShowTermBook(int which)
{
 int i, j, fcol, bcol;
 tTermPhoneRec *Tmp;
 
 i = 0;
 Tmp = TermCurrentPos;
 
 fcol = fgCol;
 bcol = bgCol;
 
 textAttr(PhoneScreen, Integers[cPhoneText]);

 if (which == 1){
 textAttr(PhoneScreen, WHITE);
 for (i=2;i<21;i++)
  for (j=0;j<COLS;j++)
   mvwaddch(PhoneScreen, i, j, ' ');
 i = 0;
 textAttr(PhoneScreen, Integers[cPhoneText]);
 while ((i<19) && (Tmp != NULL) && (i < PhoneBook->Total)){
  ShowLine(i+2, Tmp, i+TermCurrentNumber);
  Tmp = (tTermPhoneRec *)Tmp->Next;
  i++;
 }
 }
 if (which == 2){
  for (i=0;i<TermLastScrPos;i++)
   TermLastPos = (tTermPhoneRec *)TermLastPos->Next;
  if (TermLastPos != NULL) ShowLine(TermLastScrPos+2, TermLastPos, TermCurrentNumber+TermLastScrPos);
  else
  {
   textAttr(PhoneScreen, WHITE);
   for (j=0;j<COLS;j++)
    mvwaddch(PhoneScreen, i+2, j, ' ');
  }
 }
 PaintPhoneBar();
 TermLastPos = TermCurrentPos;
 TermLastScrPos  = TermHeader.ScrPos;
 textColor(PhoneScreen, fcol);
 textBkgd(PhoneScreen, bcol);
}

void SearchTerm()
{
 tWindow *Win;
 int Center, Exit, i;
 char Temp[20], TempStr[256];
 tTermPhoneRec *Tmp;

 Center = findCenter(1,COLS,22);
 Win = new tWindow(PhoneScreen, Center, (LINES/2)-1, Center+22, (LINES/2)+1,
           Integers[cInfoBold] >> 4,Integers[cInfoBold] % 16);
 Win->Frame(2, Integers[cInfoBold]);
 Win->Headline("Speed search", Integers[cInfoBold]);
 wrefresh(PhoneScreen);

 textAttr(PhoneScreen, Integers[cInfoBold]);
 Exit = 0;
 i = 0;
 Temp[0]=0;
 nl();
 while (!Exit)
   switch(getstring(PhoneScreen, LINES/2,Center+1,Temp,ValidEdit,"\n\e\t",21,-1,Temp)){
   case '\e': 
     Exit = 1;
     break;
   case '\n':
     Tmp = (tTermPhoneRec *)PhoneBook->Base->Next;
     for (i=0;i<TermHeader.Num;i++)
     {
      PasToChar(Tmp->Name, TempStr);
      if (nocasestrstr(TempStr, Temp) != NULL){
       TermCurrentPos = Tmp;
       TermCurrentNumber = i+1;
       TermHeader.ScrPos = 0;
       delete Win;
       ShowTermBook(1);
       Win = new tWindow(PhoneScreen, Center, (LINES/2)-1, Center+22, (LINES/2)+1,
                 Integers[cInfoBold] >> 4, Integers[cInfoBold] % 16);
       Win->Frame(2, Integers[cInfoBold]);
       Win->Headline("Speed search", Integers[cInfoBold]);
       wrefresh(PhoneScreen);
       break;
       }
       else Tmp = (tTermPhoneRec *)Tmp->Next;
     }
     break;
   case '\t':
     Tmp = (tTermPhoneRec *)TermCurrentPos->Next;
     for (i=TermCurrentNumber;i<TermHeader.Num;i++)
     {
      PasToChar(Tmp->Name, TempStr);
      if (nocasestrstr(TempStr, Temp) != NULL){
       TermCurrentPos = Tmp;
       TermCurrentNumber = i+1;
       TermHeader.ScrPos = 0;
       delete Win;
       ShowTermBook(1);
       Win = new tWindow(PhoneScreen, Center, (LINES/2)-1, Center+22, (LINES/2)+1,
                 Integers[cInfoBold] >> 4, Integers[cInfoBold] % 16);
       Win->Frame(2, Integers[cInfoBold]);
       Win->Headline("Speed search", Integers[cInfoBold]);
       clearok(PhoneScreen, TRUE);
       wrefresh(PhoneScreen);
       break;
      }
      else Tmp = (tTermPhoneRec *)Tmp->Next;
     }
     break;
   default:break;
 }
 
 
 delete Win;
}

void EnterPassword(char *Putin)
{
 tWindow *Win;
 int Center, Exit, i;
 char Temp[20];

 Center = findCenter(1,COLS,24);
 Win = new tWindow(PhoneScreen, Center, (LINES/2)-1, Center+25, (LINES/2)+1,
           Integers[cInfoBold] >> 4, Integers[cInfoBold] % 16);
 Win->Frame(2, Integers[cInfoBold]);
 Win->Headline("Enter password", Integers[cInfoBold]);
 wrefresh(PhoneScreen);

 textAttr(PhoneScreen, Integers[cInfoBold]);
 Exit = 0;
 i = 0;
 Temp[0]=0;
 switch(getstring(PhoneScreen, LINES/2,Center+1,Temp,ValidEdit,"\n\e\t",24,-1,Temp)){
 case '\e': 
   Exit = 1;
   break;
 case '\n':
   Exit = 2;
   break;
 default:break;
 }
 
 if (Exit == 2) strcpy(Putin, Temp);
 
 delete Win;
}

void TermGlobalDefs()
{
 int Key, i, j, x, OnlyTag;
 tTermPhoneRec *Tmp;
 char Temp[256];
 tWindow *Win;
 tMenu *Menu;

 Win = new tWindow(PhoneScreen, 40, 0, 70, 17, Integers[cMenu] >> 4, Integers[cMenu] % 16);
 Win->Frame(1, Integers[cMenu]);
 Win->Headline("Global definitions", Integers[cMenuTitle]);
 Menu = new tMenu(PhoneScreen, Integers[cMenuText], Integers[cMenuHot], Integers[cMenuBar], Integers[cMenuText],             ALIGNLEFT);
 Menu->Add("Set range", 41, 70, 1);
 Menu->Add("Only tagged", 41, 70, 2);
 Menu->Add("Find/Replace baud", 41, 70, 3);
 Menu->Add("Change bauds", 41, 70, 4);
 Menu->Add("Change device", 41, 70, 5);
 Menu->Add("Username", 41, 70, 6);
 Menu->Add("Colors", 41, 70, 7);
 Menu->Add("Terminal", 41, 70, 8);
 Menu->Add("Prefix", 41, 70, 9);
 Menu->Add("Suffix", 41, 70, 10);
 Menu->Add("Tag range", 41, 70, 11);
 Menu->Add("Tag all with password", 41, 70, 12);
 Menu->Add("Copy password", 41, 70, 13);
 Menu->Add("Clear costs", 41, 70, 14);
 Menu->Add("Clear time", 41, 70, 15);
 Menu->Add("Clear connects", 41, 70, 16);
 Menu->Show();
 sprintf(Temp, "%04d-%04d", TermHeader.RangeStart, TermHeader.RangeStop);
 textAttr(PhoneScreen, Integers[cMenuBar]);
 mvwaddstr(PhoneScreen, 1, 61, Temp);
 textAttr(PhoneScreen, Integers[cMenuOptions]);
 OnlyTag = 0;
 mvwaddstr(PhoneScreen, 2, 67, "No");
 wrefresh(PhoneScreen);
 Key = 0;
 nl();
 while (Key != '\e') {
  Key = getEscChar();
  if (Key == '\n')
    switch(Menu->Focus){
    case 0:
      Menu->Focus = 128;
      Menu->Show();
      textAttr(PhoneScreen, Integers[cEdit]);
      sprintf(Temp, "%04d", TermHeader.RangeStart);
      if (getstring(PhoneScreen, 1,61,Temp,NumberEdit,"\e\n",4,-1,Temp) == '\n')
       if (i=atoi(Temp), i >= 1 && i <=TermHeader.Num) TermHeader.RangeStart = atoi(Temp);
      sprintf(Temp, "%04d", TermHeader.RangeStop);
      if (getstring(PhoneScreen, 1,66,Temp,NumberEdit,"\e\n",4,-1,Temp) == '\n')
      if (i=atoi(Temp),i >=1 && i >= TermHeader.RangeStart && i <=TermHeader.Num)
       TermHeader.RangeStop = i;
      if (TermHeader.RangeStop > TermHeader.Num) TermHeader.RangeStop = TermHeader.Num;
      Menu->Focus = 0;
      Menu->Show();
      break;
    case 1:
      OnlyTag = OnlyTag ^ 1;
      break;
    case 2:
      x = ChooseBaud(PhoneScreen, 300);
      j = ChooseBaud(PhoneScreen, 300);
      if (ChooseYesno(PhoneScreen, "Do you want to change the baud?")){
        Tmp = (tTermPhoneRec *)PhoneBook->Base->Next;
        for (i=1;i<TermHeader.RangeStart;i++)
         Tmp = (tTermPhoneRec *)Tmp->Next;
        for (i=TermHeader.RangeStart;i<=TermHeader.RangeStop;i++){
         if (OnlyTag)
          if (Tmp->Baud == x && Tmp->Tag == 1) Tmp->Baud = j;
         if (!OnlyTag)
          if (Tmp->Baud == x) Tmp->Baud = j;
         Tmp = (tTermPhoneRec *)Tmp->Next;
        }
      }
      break;
    case 3:
      j = ChooseBaud(PhoneScreen, 300);
      if (ChooseYesno(PhoneScreen, "Do you want to change the baud?")){
        Tmp = (tTermPhoneRec *)PhoneBook->Base->Next;
        for (i=1;i<TermHeader.RangeStart;i++)
         Tmp = (tTermPhoneRec *)Tmp->Next;
        for (i=TermHeader.RangeStart;i<=TermHeader.RangeStop;i++){
         if (OnlyTag)
          if (Tmp->Tag == 1) Tmp->Baud = j;
         if (!OnlyTag) Tmp->Baud = j;
         Tmp = (tTermPhoneRec *)Tmp->Next;
        }
      }
      break;
    case 4:
      j = ChooseDevice(PhoneScreen, 0, 0);
      if (ChooseYesno(PhoneScreen, "Do you want to change the device?")){
        Tmp = (tTermPhoneRec *)PhoneBook->Base->Next;
        for (i=1;i<TermHeader.RangeStart;i++)
         Tmp = (tTermPhoneRec *)Tmp->Next;
        for (i=TermHeader.RangeStart;i<=TermHeader.RangeStop;i++){
         if (OnlyTag)
          if (Tmp->Tag == 1) Tmp->Device = j;
         if (!OnlyTag) Tmp->Device = j;
         Tmp = (tTermPhoneRec *)Tmp->Next;
        }
      }
      break;
    case 5:
      j = ChooseUser(PhoneScreen);
      if (ChooseYesno(PhoneScreen, "Do you want to change the user?")){
        Tmp = (tTermPhoneRec *)PhoneBook->Base->Next;
        for (i=1;i<TermHeader.RangeStart;i++)
         Tmp = (tTermPhoneRec *)Tmp->Next;
        for (i=TermHeader.RangeStart;i<=TermHeader.RangeStop;i++){
         if (OnlyTag)
          if (Tmp->Tag == 1) Tmp->User = j;
         if (!OnlyTag) Tmp->User = j;
         Tmp = (tTermPhoneRec *)Tmp->Next;
        }
      }
      break;
    case 6:
      j = ColorChoose(PhoneScreen, 0);
      if (ChooseYesno(PhoneScreen, "Do you want to change the color?")){
        Tmp = (tTermPhoneRec *)PhoneBook->Base->Next;
        for (i=1;i<TermHeader.RangeStart;i++)
         Tmp = (tTermPhoneRec *)Tmp->Next;
        for (i=TermHeader.RangeStart;i<=TermHeader.RangeStop;i++){
         if (OnlyTag)
          if (Tmp->Tag == 1) Tmp->Color = j;
         if (!OnlyTag) Tmp->Color = j;
         Tmp = (tTermPhoneRec *)Tmp->Next;
        }
      }
      break;
    case 7:
      j = ChooseTerminal(PhoneScreen, 0);
      if (ChooseYesno(PhoneScreen, "Do you want to change the terminal?")){
        Tmp = (tTermPhoneRec *)PhoneBook->Base->Next;
        for (i=1;i<TermHeader.RangeStart;i++)
         Tmp = (tTermPhoneRec *)Tmp->Next;
        for (i=TermHeader.RangeStart;i<=TermHeader.RangeStop;i++){
         if (OnlyTag)
          if (Tmp->Tag == 1) Tmp->Terminal = j;
         if (!OnlyTag) Tmp->Terminal = j;
         Tmp = (tTermPhoneRec *)Tmp->Next;
        }
      }
      break;
    case 8:
      j = ChoosePrefix(PhoneScreen, 0);
      if (ChooseYesno(PhoneScreen, "Do you want to change the prefix?")){
        Tmp = (tTermPhoneRec *)PhoneBook->Base->Next;
        for (i=1;i<TermHeader.RangeStart;i++)
         Tmp = (tTermPhoneRec *)Tmp->Next;
        for (i=TermHeader.RangeStart;i<=TermHeader.RangeStop;i++){
         if (OnlyTag)
          if (Tmp->Tag == 1) Tmp->DialPrefix = j;
         if (!OnlyTag) Tmp->DialPrefix = j;
         Tmp = (tTermPhoneRec *)Tmp->Next;
        }
      }
      break;
    case 9:
      j = ChooseSuffix(PhoneScreen, 0);
      if (ChooseYesno(PhoneScreen, "Do you want to change the suffix?")){
        Tmp = (tTermPhoneRec *)PhoneBook->Base->Next;
        for (i=1;i<TermHeader.RangeStart;i++)
         Tmp = (tTermPhoneRec *)Tmp->Next;
        for (i=TermHeader.RangeStart;i<=TermHeader.RangeStop;i++){
         if (OnlyTag)
          if (Tmp->Tag == 1) Tmp->DialSuffix = j;
         if (!OnlyTag) Tmp->DialSuffix = j;
         Tmp = (tTermPhoneRec *)Tmp->Next;
        }
      }
      break;
    case 10:
      Tmp = (tTermPhoneRec *)PhoneBook->Base->Next;
      for (i=1;i<TermHeader.RangeStart;i++)
       Tmp = (tTermPhoneRec *)Tmp->Next;
      for (i=TermHeader.RangeStart;i<=TermHeader.RangeStop;i++){
       Tmp->Tag = 1;
       Tmp = (tTermPhoneRec *)Tmp->Next;
      }
      break;
    case 11:
      Tmp = (tTermPhoneRec *)PhoneBook->Base->Next;
      for (i=1;i<TermHeader.RangeStart;i++)
       Tmp = (tTermPhoneRec *)Tmp->Next;
      for (i=TermHeader.RangeStart;i<=TermHeader.RangeStop;i++){
       if (Tmp->Password[0] != 0) Tmp->Tag = 1;
       Tmp = (tTermPhoneRec *)Tmp->Next;
      }
      break;
    case 12:
      Temp[0] = 0;
      EnterPassword(Temp);
      if (Temp[0] != 0){
      Tmp = (tTermPhoneRec *)PhoneBook->Base->Next;
      for (i=1;i<TermHeader.RangeStart;i++)
       Tmp = (tTermPhoneRec *)Tmp->Next;
      for (i=TermHeader.RangeStart;i<=TermHeader.RangeStop;i++){
       if (OnlyTag && Tmp->Tag == 1) CharToPas(Tmp->Password, Temp);
       if (!OnlyTag) CharToPas(Tmp->Password, Temp);
       Tmp = (tTermPhoneRec *)Tmp->Next;
      }
      }
      break;
    case 13:
      if (ChooseYesno(PhoneScreen, "Do you want to clear the costs?")){
        Tmp = (tTermPhoneRec *)PhoneBook->Base->Next;
        for (i=1;i<TermHeader.RangeStart;i++)
         Tmp = (tTermPhoneRec *)Tmp->Next;
        for (i=TermHeader.RangeStart;i<=TermHeader.RangeStop;i++){
         if (OnlyTag)
          if (Tmp->Tag == 1) {Tmp->Costs = 0; Tmp->LastCosts = 0;}
         if (!OnlyTag) {Tmp->Costs = 0; Tmp->LastCosts = 0;}
         Tmp = (tTermPhoneRec *)Tmp->Next;
        }
      }
      break;
    case 14:
      if (ChooseYesno(PhoneScreen, "Do you want to clear the times?")){
        Tmp = (tTermPhoneRec *)PhoneBook->Base->Next;
        for (i=1;i<TermHeader.RangeStart;i++)
         Tmp = (tTermPhoneRec *)Tmp->Next;
        for (i=TermHeader.RangeStart;i<=TermHeader.RangeStop;i++){
         if (OnlyTag)
          if (Tmp->Tag == 1) {Tmp->Calcmin = 0; Tmp->SecUsed = 0;}
         if (!OnlyTag) {Tmp->Calcmin = 0; Tmp->SecUsed = 0;}
         Tmp = (tTermPhoneRec *)Tmp->Next;
        }
      }
      break;
    case 15:
      if (ChooseYesno(PhoneScreen, "Do you want to clear the connects count?")){
        Tmp = (tTermPhoneRec *)PhoneBook->Base->Next;
        for (i=1;i<TermHeader.RangeStart;i++)
         Tmp = (tTermPhoneRec *)Tmp->Next;
        for (i=TermHeader.RangeStart;i<=TermHeader.RangeStop;i++){
         if (OnlyTag)
          if (Tmp->Tag == 1) Tmp->Connects = 0;
         if (!OnlyTag) Tmp->Connects = 0;
         Tmp = (tTermPhoneRec *)Tmp->Next;
        }
      }
      break;
    default:break;
  }
  Menu->GetInput(Key);
  if (Menu->Focus == 0){
    textAttr(PhoneScreen, Integers[cMenuBar]);
  }
  else
  {
    textAttr(PhoneScreen, Integers[cMenuOptions]);
  }
  sprintf(Temp, "%04d-%04d", TermHeader.RangeStart, TermHeader.RangeStop);
  mvwaddstr(PhoneScreen, 1, 61, Temp);
  if (Menu->Focus == 1){
    textAttr(PhoneScreen, Integers[cMenuBar]);
  }
  else
  {
    textAttr(PhoneScreen, Integers[cMenuOptions]);
  }
  if (!OnlyTag) mvwaddstr(PhoneScreen, 2, 67, "No ");
  else mvwaddstr(PhoneScreen, 2, 67, "Yes");
  wrefresh(PhoneScreen);
 }
 
 delete Menu; 
 delete Win;
 ShowTermBook(1);
 nonl();
}

void Sort()
{
 int Key, i, Exit;
 char Temp[256];
 tWindow *Win;
 tMenu *Menu;

 Win = new tWindow(PhoneScreen, 40, 0, 70, 10, Integers[cMenu] >> 4, Integers[cMenu] % 16);
 Win->Frame(1, Integers[cMenu]);
 Win->Headline("Sort phonebook", Integers[cMenuTitle]);
 Menu = new tMenu(PhoneScreen, Integers[cMenuText], Integers[cMenuHot], Integers[cMenuBar], Integers[cMenuText],             ALIGNLEFT);
 Menu->Add("Set range", 41, 70, 1);
 Menu->Add("Ascending names", 41, 70, 2);
 Menu->Add("Descending names", 41, 70, 3);
 Menu->Add("Ascending numbers", 41, 70, 4);
 Menu->Add("Descending numbers", 41, 70, 5);
 Menu->Add("Most connects", 41, 70, 6);
 Menu->Add("Last called", 41, 70, 7);
 Menu->Add("Comment 1", 41, 70, 8);
 Menu->Add("Comment 2", 41, 70, 9);
 Menu->Show();
 sprintf(Temp, "%04d-%04d", TermHeader.RangeStart, TermHeader.RangeStop);
 textAttr(PhoneScreen, Integers[cMenuBar]);
 mvwaddstr(PhoneScreen, 1, 61, Temp);
 wrefresh(PhoneScreen);
 Key = 0;
 Exit = 0;
 nl();
 while (Key != '\e' && !Exit) {
  Key = getEscChar();
  if (Key == '\n')
    switch(Menu->Focus){
    case 0:
      Menu->Focus = 128;
      Menu->Show();
      textAttr(PhoneScreen, Integers[cEdit]);
      sprintf(Temp, "%04d", TermHeader.RangeStart);
      if (getstring(PhoneScreen, 1,61,Temp,NumberEdit,"\e\n",4,-1,Temp) == '\n')
       if (i=atoi(Temp), i >= 1 && i <=TermHeader.Num) TermHeader.RangeStart = atoi(Temp);
      sprintf(Temp, "%04d", TermHeader.RangeStop);
      if (getstring(PhoneScreen, 1,66,Temp,NumberEdit,"\e\n",4,-1,Temp) == '\n')
      if (i=atoi(Temp),i >=1 && i >= TermHeader.RangeStart && i <=TermHeader.Num)
       TermHeader.RangeStop = i;
      if (TermHeader.RangeStop > TermHeader.Num) TermHeader.RangeStop = TermHeader.Num;
      Menu->Focus = 0;
      Menu->Show();
      break;
    case 1:
      SortAscending(TermHeader.RangeStart, TermHeader.RangeStop, NameCompare);
      Exit = 1;
      break;
    case 2:
      SortDescending(TermHeader.RangeStart, TermHeader.RangeStop, NameCompare);
      Exit = 1;
      break;
    case 3:
      SortAscending(TermHeader.RangeStart, TermHeader.RangeStop, NumberCompare);
      Exit = 1;
      break;
    case 4:
      SortDescending(TermHeader.RangeStart, TermHeader.RangeStop, NumberCompare);
      Exit = 1;
      break;
    case 5:
      SortDescending(TermHeader.RangeStart, TermHeader.RangeStop, ConnectsCompare);
      Exit = 1;
      break;
    case 6:
      break;
    case 7:
      SortAscending(TermHeader.RangeStart, TermHeader.RangeStop, Comment1Compare);
      Exit = 1;
      break;
    case 8:
      SortAscending(TermHeader.RangeStart, TermHeader.RangeStop, Comment2Compare);
      Exit = 1;
      break;
    default:break;
  }
  Menu->GetInput(Key);
  if (Menu->Focus == 0){
    textAttr(PhoneScreen, Integers[cMenuBar]);
  }
  else
  {
    textAttr(PhoneScreen, Integers[cMenuOptions]);
  }
  sprintf(Temp, "%04d-%04d", TermHeader.RangeStart, TermHeader.RangeStop);
  mvwaddstr(PhoneScreen, 1, 61, Temp);
  wrefresh(PhoneScreen);
 }
 ShowTerm();
 nonl();
}

void EditEntry(tTermPhoneRec *Tmp)
{
 tMenu *Edit;
 int Key, i, j;
 char Temp[256], *s;
 
 nl();
 wclear(PhoneScreen);
 textAttr(PhoneScreen, Integers[cMenu]);
 box(PhoneScreen, SVLINE, SHLINE);
 wmove(PhoneScreen, 1, 20);
 wvline(PhoneScreen, SVLINE, LINES-3);
 wmove(PhoneScreen, 0, 20);
 waddch(PhoneScreen, 194);
 wmove(PhoneScreen, LINES-2, 20);
 waddch(PhoneScreen, 193);
 Edit = new tMenu(PhoneScreen, Integers[cMenuText], Integers[cMenuHot], Integers[cMenuBar], Integers[cMenuText],             ALIGNLEFT);
 Edit->Add("~S~ystem name", 1, 20, 1);
 Edit->Add("~P~hone number", 1, 20, 2);
 Edit->Add("~D~evice", 1, 20, 3);
 Edit->Add("~U~ser profile", 1, 20, 4);
 Edit->Add("Pass~w~ord", 1, 20, 5);
 Edit->Add("~O~pening hours", 1, 20, 6);
 Edit->Add("~T~erminal", 1, 20, 7);
 Edit->Add("Dial prefi~x~", 1, 20, 8);
 Edit->Add("Dial su~f~fix", 1, 20, 9);
 Edit->Add("Comm. information", 1, 20, 10);
 Edit->Add("Comment ~1~", 1, 20, 11);
 Edit->Add("Comment ~2~", 1, 20, 12);
 Edit->Add("~C~apture file", 1, 20, 13);
 Edit->Add("~L~ocal Echo", 1, 20, 14);
 Edit->Add("Strip~H~igh", 1, 20, 15);
 Edit->Add("~B~ackspace erase", 1, 20, 16);
 Edit->Add("Colo~r~", 1, 20, 17);
 Edit->Show();
 wmove(PhoneScreen, 1, 22);
 textAttr(PhoneScreen, Integers[cMenuOptions]);
 PasToChar(Tmp->Name, Temp);
 waddstr(PhoneScreen, Temp);
 wmove(PhoneScreen, 2, 22);
 PasToChar(Tmp->Number, Temp);
 waddstr(PhoneScreen, Temp);
 wmove(PhoneScreen, 4, 22);
 waddstr(PhoneScreen, Strings[User1+Tmp->User-1]);
 wmove(PhoneScreen, 5, 22);
 PasToChar(Tmp->Password, Temp);
 if (Integers[HidePwds]) Dots(Temp);
 waddstr(PhoneScreen, Temp);
 wmove(PhoneScreen, 6, 22);
 sprintf(Temp, "%02d:%02d-%02d:%02d", Tmp->Open / 60, Tmp->Open % 60, Tmp->Closed / 60, Tmp->Closed % 60);
 waddstr(PhoneScreen, Temp);
 wmove(PhoneScreen, 10, 22);
 sprintf(Temp, "%lu ", Tmp->Baud);
 waddstr(PhoneScreen, Temp);
 waddch(PhoneScreen, 48+Tmp->Databits);
 waddch(PhoneScreen, '-');
 waddch(PhoneScreen, Tmp->Parity);
 waddch(PhoneScreen, '-');
 waddch(PhoneScreen, 48+Tmp->Stopbits);
 wmove(PhoneScreen, 11, 22);
 PasToChar(Tmp->Comment1, Temp);
 waddstr(PhoneScreen, Temp);
 wmove(PhoneScreen, 12, 22);
 PasToChar(Tmp->Comment2, Temp);
 waddstr(PhoneScreen, Temp);
 wmove(PhoneScreen, 13, 22);
 PasToChar(Tmp->Capture, Temp);
 waddstr(PhoneScreen, Temp);
 wmove(PhoneScreen, 14, 22);
 if (Tmp->LocalEcho) waddstr(PhoneScreen, "Yes");
 else waddstr(PhoneScreen, "No");
 wmove(PhoneScreen, 15, 22);
 if (Tmp->StripHigh) waddstr(PhoneScreen, "Yes");
 else waddstr(PhoneScreen, "No");
 wmove(PhoneScreen, 16, 22);
 if (Tmp->RcvdBSdest) waddstr(PhoneScreen, "Yes");
 else waddstr(PhoneScreen, "No");
 wmove(PhoneScreen, 17, 22);
 textAttr(PhoneScreen, Tmp->Color);
 waddch(PhoneScreen, 254);
 wrefresh(PhoneScreen);
 while (Key != '\e'){
  Key = getEscChar();
  if (Key == '\n'){
  textAttr(PhoneScreen, Integers[cMenuOptions]);
  switch(Edit->Focus){
  case 0:
    PasToChar(Tmp->Name, Temp);
    if (getstring(PhoneScreen, 1,22,Temp,ValidEdit,"\n\e",30,-1,Temp) == '\n'){
      CharToPas(Tmp->Name, Temp);
    }
    break;
  case 1:
    PasToChar(Tmp->Number, Temp);
    if (getstring(PhoneScreen, 2,22,Temp,NumberEdit,"\n\e",24,-1,Temp) == '\n'){
      CharToPas(Tmp->Number, Temp);
    }
    break;
  case 2:
    Tmp->Device = ChooseDevice(PhoneScreen, Tmp->Device, 0);
    i = Tmp->Device;
    if (i == 0) i = Integers[DefaultDevice];
    i--;
    Tmp->Parity = Integers[Parities1+i];
    Tmp->Stopbits = Integers[Stopbits1+i]+1;
    Tmp->Databits = Integers[Databits1+i];
    textAttr(PhoneScreen, Integers[cMenuOptions]);
    wmove(PhoneScreen, 10, 22);
    sprintf(Temp, "%lu ", Tmp->Baud);
    waddstr(PhoneScreen, Temp);
    waddch(PhoneScreen, 48+Tmp->Databits);
    waddch(PhoneScreen, '-');
    waddch(PhoneScreen, Tmp->Parity);
    waddch(PhoneScreen, '-');
    waddch(PhoneScreen, 48+Tmp->Stopbits);
    break;
  case 3:
    i = Tmp->User-1;
    Tmp->User = ChooseUser(PhoneScreen);
    memset(Temp, ' ', strlen(Strings[User1+i]));
    Temp[strlen(Strings[User1+i])] = 0;
    textAttr(PhoneScreen, Integers[cMenuOptions]);
    wmove(PhoneScreen, 4, 22);
    waddstr(PhoneScreen, Temp);
    wmove(PhoneScreen, 4, 22);
    waddstr(PhoneScreen, Strings[User1+Tmp->User-1]);
    break;
  case 4:
    PasToChar(Tmp->Password, Temp);
    if (getstring(PhoneScreen, 5,22,Temp,ValidEdit,"\n\e",24,-1,Temp) == '\n'){
      CharToPas(Tmp->Password, Temp);
    }
    PasToChar(Tmp->Password, Temp);
    if (Integers[HidePwds]) Dots(Temp);
    wmove(PhoneScreen, 5, 22);
    waddstr(PhoneScreen, Temp);
    break;
  case 5:
    sprintf(Temp,"%02d:%02d",Tmp->Open /60, Tmp->Open % 60);
    if (getstring(PhoneScreen, 6,22,Temp,NumberEdit,"\n\e",5,-1,Temp) == '\n'){
     s = index(Temp, ':');
     if (s != NULL){
      *s=0;
      i = atoi(Temp)*60+atoi(s+1);
      if (i < 24*60) Tmp->Open = i;
     }
    }
    sprintf(Temp,"%02d:%02d",Tmp->Closed /60, Tmp->Closed % 60);
    if (getstring(PhoneScreen, 6,28,Temp,NumberEdit,"\n\e",5,-1,Temp) == '\n'){
     s = index(Temp, ':');
     if (s != NULL){
      *s=0;
      i = atoi(Temp)*60+atoi(s+1);
      if (i < 24*60) Tmp->Closed = i;
     }
    }
    textAttr(PhoneScreen, Integers[cMenuOptions]);
    wmove(PhoneScreen, 6, 22);
    sprintf(Temp, "%02d:%02d-%02d:%02d", Tmp->Open / 60, Tmp->Open % 60, Tmp->Closed / 60, Tmp->Closed % 60);
    waddstr(PhoneScreen, Temp);
    break;
  case 6:
    switch(WhichBook){
    case 0:
      i = ChooseTerminal(PhoneScreen, TranslateToTerminate[Tmp->Terminal]);
      for (j = 0; j < 17 && i != 255; j++)
       if (TranslateToTerminate[j] == i) i = 255;
      Tmp->Terminal = j-1;
      break;
    case 1:
      i = ChooseTerminal(PhoneScreen, TranslateToTelix[Tmp->Terminal]);
      for (j = 0; j < 6 && i != 255; j++)
       if (TranslateToTelix[j] == i) i = 255;
      Tmp->Terminal = j-1;
      break;
    default:break;
    }
    break;
  case 7:
    Tmp->DialPrefix = ChoosePrefix(PhoneScreen, Tmp->DialPrefix);
    break;
  case 8:
    Tmp->DialSuffix = ChooseSuffix(PhoneScreen, Tmp->DialSuffix);
    break;
  case 9:
    Tmp->Baud = ChooseBaud(PhoneScreen, Tmp->Baud);
    textAttr(PhoneScreen, Integers[cMenuOptions]);
    wmove(PhoneScreen, 10, 22);
    sprintf(Temp, "%lu ", Tmp->Baud);
    waddstr(PhoneScreen, Temp);
    break;
  case 10:
    PasToChar(Tmp->Comment1, Temp);
    if (getstring(PhoneScreen, 11,22,Temp,ValidEdit,"\n\e",40,-1,Temp) == '\n'){
      CharToPas(Tmp->Comment1, Temp);
    }
    break;
  case 11:
    PasToChar(Tmp->Comment2, Temp);
    if (getstring(PhoneScreen, 12,22,Temp,ValidEdit,"\n\e",40,-1,Temp) == '\n'){
      CharToPas(Tmp->Comment2, Temp);
    }
    break;
  case 12:
    PasToChar(Tmp->Capture, Temp);
    if (getstring(PhoneScreen, 13,22,Temp,ValidEdit,"\n\e",8,-1,Temp) == '\n'){
      CharToPas(Tmp->Capture, Temp);
    }
    break;
  case 13:
    if (!Tmp->LocalEcho){
     Tmp->LocalEcho = 1;
     mvwaddstr(PhoneScreen, 14, 22, "Yes");
    }
    else{
     Tmp->LocalEcho = 0;
     mvwaddstr(PhoneScreen, 14, 22, "No ");
    }
    break;
  case 14:
    if (!Tmp->StripHigh){
     Tmp->StripHigh = 1;
     mvwaddstr(PhoneScreen, 15, 22, "Yes");
    }
    else{
     Tmp->StripHigh = 0;
     mvwaddstr(PhoneScreen, 15, 22, "No ");
    }
    break;
  case 15:
    if (!Tmp->RcvdBSdest){
     Tmp->RcvdBSdest = 1;
     mvwaddstr(PhoneScreen, 16, 22, "Yes");
    }
    else{
     Tmp->RcvdBSdest = 0;
     mvwaddstr(PhoneScreen, 16, 22, "No ");
    }
    break;
  case 16:
    Tmp->Color = ColorChoose(PhoneScreen, Tmp->Color);
    textAttr(PhoneScreen, Tmp->Color);
    mvwaddch(PhoneScreen, 17, 22, 254);
    break;
  default:break;
  }
  wrefresh(PhoneScreen);
  }
  Edit->GetInput(Key);
  textAttr(PhoneScreen, Integers[cMenuOptions]);
 }
 delete Edit;
 nonl();
}
void SystemNotOpen()
{
 tWindow *Win;
 int Center, Y, X, Attr;
 
 Attr = PhoneScreen->_attrs;
 getyx(PhoneScreen, Y, X); 
 Center = findCenter(0, COLS, 42);
 Win = new tWindow(PhoneScreen, Center-3, LINES/2-2, Center+42, LINES/2+2, Integers[cInfo] >> 4, 
           Integers[cInfo] % 16);
 Win->Frame(2, Integers[cInfo]);
 textAttr(PhoneScreen, Integers[cInfoBold]);
 mvwaddstr(PhoneScreen, LINES/2, Center, "System is not currently open, skipping...");
 wrefresh(PhoneScreen);
 sleep(1);

 delete Win;
 wmove(PhoneScreen, Y, X);
 PhoneScreen->_attrs = Attr;
}

int DialEntry(tTermPhoneRec *Entry)
{
 time_t start, current, t;
 int Key, dialTime, BufCount, Closed, CurrentTime;
 char Temp[256], c, Buffer[100];
 WINDOW *DialWin;
 tm *Time;
 
 DialWin = newwin(LINES-18, COLS-2, 16, 1);
 scrollok(DialWin, TRUE);
 werase(DialWin);
 dialTime = Integers[DialTime];
 time(&start);
 current = start;
 textAttr(PhoneScreen, Integers[cMenu]);
 wclear(PhoneScreen);
 box(PhoneScreen, SVLINE, SHLINE);
 wmove(PhoneScreen, 3, 1);
 whline(PhoneScreen, SHLINE, COLS-2);
 wmove(PhoneScreen, 4, 12);
 wvline(PhoneScreen, SVLINE, 9);
 wmove(PhoneScreen, 13, 1);
 whline(PhoneScreen, SHLINE, COLS-2);
 wmove(PhoneScreen, 15, 1);
 whline(PhoneScreen, SHLINE, COLS-2);
 textAttr(PhoneScreen, Integers[cMenuText]);
 mvwaddstr(PhoneScreen, 1, 1, "Start ");
 mvwaddstr(PhoneScreen, 2, 1, "Now ");
 strcpy(Temp, ctime(&start));
 Temp[strlen(Temp)-1]=0;
 mvwaddstr(PhoneScreen, 1, 8, Temp);
 mvwaddstr(PhoneScreen, 4, 1, "System");
 mvwaddstr(PhoneScreen, 5, 1, "Username");
 mvwaddstr(PhoneScreen, 6, 1, "Phone");
 mvwaddstr(PhoneScreen, 7, 1, "Password");
 mvwaddstr(PhoneScreen, 8, 1, "Comm. info");
 mvwaddstr(PhoneScreen, 9, 1, "Comment1");
 mvwaddstr(PhoneScreen, 10, 1, "Comment2");
 mvwaddstr(PhoneScreen, 11, 1, "Download");
 mvwaddstr(PhoneScreen, 12, 1, "Upload");
 mvwaddstr(PhoneScreen, 14, 1, " Add 15 secs  Untag  enter = abort  esc = abort+hangup  space = next");
 textAttr(PhoneScreen, Integers[cMenuOptions]);
 PasToChar(Entry->Name, Temp);
 mvwaddstr(PhoneScreen, 4, 14, Temp);
 mvwaddstr(PhoneScreen, 5, 14, Strings[User1+Entry->User-1]);
 PasToChar(Entry->Number, Temp);
 mvwaddstr(PhoneScreen, 6, 14, Temp);
 PasToChar(Entry->Password, Temp);
 if (Integers[HidePwds]) Dots(Temp);
 mvwaddstr(PhoneScreen, 7, 14, Temp);
 sprintf(Temp, "%lu %u%c%u",Entry->Baud,Entry->Databits,Entry->Parity,Entry->Stopbits);
 mvwaddstr(PhoneScreen, 8, 14, Temp);
 PasToChar(Entry->Comment1, Temp);
 mvwaddstr(PhoneScreen, 9, 14, Temp);
 PasToChar(Entry->Comment2, Temp);
 mvwaddstr(PhoneScreen, 10, 14, Temp);
 sprintf(Temp, "%lu", Entry->DownloadKb);
 mvwaddstr(PhoneScreen, 11, 14, Temp);
 sprintf(Temp, "%lu", Entry->UploadKb);
 mvwaddstr(PhoneScreen, 12, 14, Temp);
 Key = 0;
 linestatus();
 while (charwaiting() == TRUE){
  c = mgetchar();
  if (c != 13){ 
   waddch(DialWin, c);
   wrefresh(DialWin);
  }
  linestatus();
 }
 time(&t);
 Time = localtime(&t);
 Closed = Entry->Closed;
 if (Entry->Closed <= Entry->Open) Closed += 24*60;
 CurrentTime = Time->tm_hour * 60 + Time->tm_min;
 if (CurrentTime < Entry->Open || CurrentTime > Closed){ 
  SystemNotOpen();
  if (chwait() == TRUE) Key = getEscChar();
 }
 else{
  strcpy(Temp, Strings[Prefix1+Entry->DialPrefix-1]);
  ReplaceM(Temp);
  mwriteblock(Temp, strlen(Temp));
  PasToChar(Entry->Number, Temp);
  mwriteblock(Temp, strlen(Temp));
  strcpy(Temp, Strings[Suffix1+Entry->DialSuffix-1]);
  ReplaceM(Temp);
  mwriteblock(Temp, strlen(Temp));
  BufCount = 0;
  Buffer[0]=0;
  ConnectMatch = 0;
  while (current-start<= dialTime && Key != '\e' && Key != ' ' && Key != '\n' && !CAR && !ConnectMatch){
   time(&current);
   textAttr(PhoneScreen, Integers[cMenuText]);
   strcpy(Temp, ctime(&current));
   Temp[strlen(Temp)-1]=0;
   mvwaddstr(PhoneScreen, 2, 8, Temp);
   mvwaddstr(PhoneScreen, 2, 35, "Retries: ");
   sprintf(Temp, "%d", DialRetries);
   textAttr(PhoneScreen, Integers[cMenuTextBold]);
   mvwaddstr(PhoneScreen, 2, 45, Temp);
   textAttr(PhoneScreen, Integers[cMenuText]);
   mvwaddstr(PhoneScreen, 2, 50, "Countdown");
   textAttr(PhoneScreen, Integers[cMenuTextBold]);
   sprintf(Temp, "%03lu", dialTime - (current-start));
   Temp[4] = 0;
   mvwaddstr(PhoneScreen, 2, 60, Temp);
   if (charwaiting() == TRUE){
    c = mgetchar();
    if (c != 13) waddch(DialWin, c);
     Buffer[BufCount++]=c;
     Buffer[BufCount]=0;
    if (c == '\r' || c == '\n')
     BufCount=0;
    linestatus();
   }
   wrefresh(PhoneScreen);
   redrawwin(DialWin);
   wrefresh(DialWin);
   if (chwait() == TRUE){ 
    Key = getEscChar();
    switch(Key){
    case 'a':
    case 'A':
      dialTime += 15;
      break;
    case 'u':
    case 'U':
      Entry->Tag = 0;
      break;
    default:break;
    }
   }
   if (Key == ' ' || Key == '\e' || Key == '\n'){
    strcpy(Temp, Strings[DialCancel]);
    ReplaceM(Temp);
    mwriteblock(Temp, strlen(Temp));
   }
   for (c = NoConnect1; c <= NoConnect5; c++)
    if (strcasecmp(Buffer, Strings[c]) == 0 && Buffer[0] != 0)
     dialTime = 0;
  }
 }
 if (strcasecmp(Buffer, Strings[ConnectStr]) == 0 && Buffer[0] != 0)
  ConnectMatch = 1;
 delwin(DialWin);
 return Key;
}


void Dialer(int TopOfList)
{
 tTermPhoneRec *Tmp;
 int i,j, Tags;
 char Temp[50], TempStr[100];
 time_t t;
 tm *Time;
 
 nl();
 DialRetries = 0;
 Tags = 1;
 Tmp = &CurrentTerm;
 while (Tags && !CAR && !ConnectMatch){
  Tags = 0;
  if (!CAR && !ConnectMatch && Integers[LoopDelay] > 0){
   j = Integers[LoopDelay];
   textAttr(PhoneScreen, Integers[cMenuText]);
   mvwaddstr(PhoneScreen, 2, 50, "Loop delay ");
   while (j-->0){
   sprintf(Temp, "%d  ", j);
   textAttr(PhoneScreen, Integers[cMenuTextBold]);
   mvwaddstr(PhoneScreen, 2, 61, Temp);
   wrefresh(PhoneScreen);
   if (chwait() == TRUE) j=0;
   sleep(1);
   }
  }
  Tmp = (tTermPhoneRec *)PhoneBook->Base;
  for (i=0;i<=TermHeader.Num && !CAR && !ConnectMatch && i <= TopOfList;i++){
   if (Tmp->Tag){
    Tags = 1;
    DialRetries++;
    j=DialEntry(Tmp);
    if (j == '\e'){
     hangup();
     i = TermHeader.Num;
     Tags = 0;
    }else    
    if (j == '\n'){ 
     i = TermHeader.Num;
     Tags = 0;
    }else
    if (j == ' ') hangup();
    else
    {
     if (!CAR && !ConnectMatch && Integers[DialDelay] > 0){
      j = Integers[DialDelay];
      textAttr(PhoneScreen, Integers[cMenuText]);
      mvwaddstr(PhoneScreen, 2, 50, "Delay ");
      while (j-->0){
      sprintf(Temp, "%d       ", j);
      textAttr(PhoneScreen, Integers[cMenuTextBold]);
      mvwaddstr(PhoneScreen, 2, 56, Temp);
      wrefresh(PhoneScreen);
      if (chwait() == TRUE) j=0;
      sleep(1);
     }
     }
    }
   }
   if (i != TermHeader.Num+1){
    if (Tmp->Next == NULL) i = TermHeader.Num + 1;
    else
     Tmp = (tTermPhoneRec *)Tmp->Next;
   }
  }
 }
 ShowTerm();
 if (CAR || ConnectMatch){ 
  DialerConnect = 1;
  if (Tmp->Prev != NULL) Tmp = (tTermPhoneRec *)Tmp->Prev;
  CurrentTerm = *Tmp;
  CurrentEntry = Tmp;
  Tmp->Connects++;
  CurrentTerm.Stopbits--;
  if (CurrentTerm.Device == 0) CurrentTerm.Device = Integers[DefaultDevice];
  if (CurrentTerm.Device > 4) CurrentTerm.Device = Integers[DefaultDevice];
  if (WhichBook == 0)
   CurrentTerm.Terminal = TranslateToTerminate[Tmp->Terminal];
  if (WhichBook == 1)
   CurrentTerm.Terminal = TranslateToTelix[Tmp->Terminal];
  strcpy(TempStr,"Phonebook: ");
  PasToChar(Tmp->Name, Temp);
  strcat(TempStr,Temp);
  Printlogln(TempStr);
  strcpy(TempStr,"Phone number: ");
  PasToChar(Tmp->Number, Temp);
  strcat(TempStr,Temp);
  Printlogln(TempStr);
  PasToChar(Tmp->Capture, Temp);
  if (strlen(Temp) > 0 && Integers[AutoOpenCapture])
   OpenCaptureFile(PhoneScreen, &Temp[0]);
/*  if (Whichbook == 1){
   time(&t);
   Time = localtime(&t);
   sprintf(Tmp, "%02d%02d%02d", Time->tm_mday, Time->tm_mon, Time->tm_year);
  }*/
  SavePhonebook();
 }
 nonl();
}

void ManualDial()
{
 tWindow *Win;
 int Center, Exit, i;
 char Temp[20];
 tTermPhoneRec *Tmp;

 Tmp = (tTermPhoneRec *)PhoneBook->Base;
 EditEntry(Tmp);
 Tmp->Tag = 1;
 Dialer(0);
 Tmp->Tag = 0;
}

void CommandLineDialer()
{
 tTermPhoneRec *Tmp;
 char Temp[50], i;
 
 Tmp = (tTermPhoneRec *)PhoneBook->Base->Next;
 for (i = 0; i < strlen(NameOfDialEntry); i++)
  *(NameOfDialEntry+i) = tolower(*(NameOfDialEntry+i));
 while (Tmp != NULL){
  for (i = 0; i < Tmp->Name[0]; i++)
   Temp[i] = tolower(Tmp->Name[i+1]);
  Temp[i] = 0;
  if (strstr(Temp, NameOfDialEntry) != NULL)
   Tmp->Tag = 1;
  Tmp = (tTermPhoneRec *)Tmp->Next;
 }
}

void CommandLineIndexDialer()
{
 tTermPhoneRec *Tmp;
 int i;
 
 Tmp = (tTermPhoneRec *)PhoneBook->Base->Next;
 for (i = 1; i < DialIndex && Tmp != NULL; i++)
  Tmp = (tTermPhoneRec *)Tmp->Next;
 if (Tmp != NULL) Tmp->Tag = 1;
}

void MakeDefaultPhonebook()
{
 nl();
 if (ChooseYesno(PhoneScreen, "Make this the default phonebook?")){
   Strings[Phonebook] = (char *)realloc(Strings[Phonebook], strlen(CurrentPhonebook)+1);
   strcpy(Strings[Phonebook], CurrentPhonebook);
   Integers[PhoneType] = WhichBook;
 }
 nonl();
}

void ChangePhone()
{
 char Temp[256], CurrentDir[256], *FileName;
 int Key, Which, Center, y, x, Attr;
 tWindow *Win;
 tMenu *Menu;
 tTermPhoneRec *Tmp;
 
 FileMgr(&FileName, Strings[PhonePath], 0);
 curs_set(0);
 
 if (strlen(FileName) > 0) {
 Attr = PhoneScreen->_attrs;
 getyx(PhoneScreen, y, x);
 Center = findCenter(0, COLS, 16);
 
 Win = new tWindow(PhoneScreen, Center, (LINES-1)/2-1, Center+19,(LINES-1)/2+3, Integers[cMenu] >> 4, 
           Integers[cMenu] % 16);
 Win->Frame(1, Integers[cMenu]);
 Win->Headline(" Which phonebook? ", Integers[cMenuTitle]);
 Menu = new tMenu(PhoneScreen, Integers[cMenu], Integers[cMenuHot], Integers[cMenuBar], Integers[cMenuText],              ALIGNMID);
 Menu->Add("~T~erminate", Center+1, Center+19, (LINES-1)/2);
 Menu->Add("T~e~lix", Center+1, Center+19, (LINES-1)/2+1);
 Menu->Add("~C~ancel", Center+1, Center+19, (LINES-1)/2+2);
 Menu->Focus = 0;
 Menu->Show();
 wrefresh(PhoneScreen);

 Key = 0;
 nl();
 
 while (Key != '\n'){
  Key = getEscChar();
  if (Menu->GetInput(Key) > 127) Key = '\n';
  wrefresh(PhoneScreen);
 }
 
 nonl();
 Which = Menu->Focus;
 
 delete Menu;
 delete Win;
 
 wmove(PhoneScreen, y, x);
 PhoneScreen->_attrs = Attr;
 clearok(PhoneScreen, TRUE);
 redrawwin(PhoneScreen);
 
 getcwd(CurrentDir, 255);
 strcat(CurrentDir, "/");
 nl();
 switch(Which){
 case 0:
   delete PhoneBook;
   PhoneBook = NULL;
   WhichBook = 0;
   CurrentPhonebook = (char *)realloc(CurrentPhonebook, strlen(CurrentDir)+strlen(FileName)+1);
   strcpy(CurrentPhonebook, CurrentDir);
   strcat(CurrentPhonebook, FileName);
   if (ReadTerminate(CurrentPhonebook, PhoneScreen) < 0) WindowError(PhoneScreen, "Unable to open phonebook");
   else if (Integers[AskCurrentPhone]) MakeDefaultPhonebook();
   break;
 case 1:
   delete PhoneBook;
   PhoneBook = NULL;
   WhichBook = 1;
   CurrentPhonebook = (char *)realloc(CurrentPhonebook, strlen(CurrentDir)+strlen(FileName)+1);
   strcpy(CurrentPhonebook, CurrentDir);
   strcat(CurrentPhonebook, FileName);
   if (ReadTelix(CurrentPhonebook) < 0) WindowError(PhoneScreen, "Unable to open phonebook");
   else if (Integers[AskCurrentPhone]) MakeDefaultPhonebook();
   break;
 default:break;
 }
 free(FileName);
 if (PhoneBook == NULL){
   PhoneBook = new tList;
   Strings[Phonebook] = (char *)realloc(Strings[Phonebook], 12);
   strcpy(Strings[Phonebook], "termite.fon");
   CurrentPhonebook = (char *)malloc(strlen(Strings[Phonebook])+1);
   strcpy(CurrentPhonebook, Strings[Phonebook]);
   Tmp = new tTermPhoneRec;
   CreateClearEntry(Tmp);
   strncpy(Tmp->Name+1,"Manual Mode", 11);
   Tmp->Name[0] = 11;
   PhoneBook->Add(Tmp);
   Tmp = new tTermPhoneRec;
   memcpy(Tmp, PhoneBook->Base, sizeof(tTermPhoneRec));
   strncpy(Tmp->Name+1,"123", 3);
   Tmp->Name[0] = 3;
   PhoneBook->Add(Tmp);
   TermHeader.Num = 1;
   TermHeader.RangeStart = 1;
   TermHeader.RangeStop = 1;
   TermHeader.ScrPos = 1;
   TermHeader.PhonePos = 1; 
   TermHeader.WritePos = 1;
   TermHeader.PhonePos = 1;
   TermCurrentPos = TermLastPos = (tTermPhoneRec *)PhoneBook->Base->Next;
   TermCurrentNumber = 1;
   TermHeader.ScrPos = 0;
   TermLastScrPos = 0;
   WhichBook = 0;
 }
 }
 nonl();
}

void TermPhoneKey(int ch)
{
 int Refresh = 0, i, j;
 tListObj *ListTmp;
 tTermPhoneRec *Tmp;

 DialerConnect = 0;
 switch(ch){
 // ^I
 case 9:
   ListTmp = TermCurrentPos;
   for (i=0;i<TermHeader.ScrPos;i++)
    ListTmp = ListTmp->Next;
   Tmp = new tTermPhoneRec;
   CreateClearEntry(Tmp);
   Tmp->Next = NULL;
   Tmp->Prev = NULL;
   PhoneBook->Insert(ListTmp, (tListObj *)Tmp);
   TermHeader.Num++;
   Refresh = 1;
   break;
 case KEY_DC:
   Tmp = (tTermPhoneRec *)TermCurrentPos;
   for (i=0;i<TermHeader.ScrPos;i++)
     if (Tmp != NULL) Tmp = (tTermPhoneRec *)Tmp->Next;
   if (Tmp != NULL && TermHeader.Num > 1){
     if (Tmp == TermCurrentPos) TermCurrentPos = (tTermPhoneRec *)Tmp->Next;
     PhoneBook->Del(Tmp);
     TermHeader.Num--;
   }
   Refresh = 1;
   break;
 case KEY_DOWN: 
 KEYDOWN:
   if (TermCurrentNumber+TermHeader.ScrPos<TermHeader.Num)
   {
    TermHeader.ScrPos++;
    Refresh = 2;
    if (TermHeader.ScrPos == 19){
     TermCurrentPos=(tTermPhoneRec *)TermCurrentPos->Next;
     TermHeader.ScrPos = 18;
     TermCurrentNumber++;
     Refresh = 1;
    }
   }
   break;
 case KEY_UP:
    TermHeader.ScrPos--;
    Refresh = 2;
    if (TermHeader.ScrPos == -1){
     if (TermCurrentNumber > 1){
      TermCurrentPos=(tTermPhoneRec *)TermCurrentPos->Prev;
      TermCurrentNumber--;
      Refresh = 1;
     }
     TermHeader.ScrPos = 0;
   }
   break;
 case KEY_LEFT:
   if (TermHeader.WritePos>1)
    TermHeader.WritePos--;
   else TermHeader.WritePos = 9;
   Refresh = 1;
   break;
 case KEY_RIGHT:
   if (TermHeader.WritePos<9)
    TermHeader.WritePos++;
   else TermHeader.WritePos = 1;
   Refresh = 1;
   break; 
 case KEY_HOME:
   TermCurrentPos = (tTermPhoneRec *)PhoneBook->Base->Next;
   TermCurrentNumber = 1;
   TermHeader.ScrPos = 0;
   Refresh = 1;
   break;
 case KEY_END:
 KEYEND:
   if (TermHeader.Num > 17){
    TermCurrentPos = (tTermPhoneRec *)PhoneBook->Last;
    for (i=0;i<18;i++)
     TermCurrentPos = (tTermPhoneRec *)TermCurrentPos->Prev;
    TermCurrentNumber = TermHeader.Num-18;
    TermHeader.ScrPos = 18;
   }
   else{
    TermCurrentPos = (tTermPhoneRec *)PhoneBook->Base->Next;
    TermCurrentNumber = 1;
    TermHeader.ScrPos = TermHeader.Num-1;
   }
   Refresh = 1;
   break;
 case KEY_NPAGE:
   if (TermCurrentNumber + 18 < TermHeader.Num){
     TermCurrentNumber += 18;
     for (i=0;i<18;i++)
      TermCurrentPos = (tTermPhoneRec *)TermCurrentPos->Next;
   }
   else goto KEYEND;
   Refresh = 1;
   break;
 case KEY_PPAGE:
   if (TermCurrentNumber - 18 > 1){
     TermCurrentNumber -= 18;
     for (i=0;i<18;i++)
      TermCurrentPos = (tTermPhoneRec *)TermCurrentPos->Prev;
   }
   else {
     TermCurrentPos = (tTermPhoneRec *)PhoneBook->Base->Next;
     TermCurrentNumber = 1;
     TermHeader.ScrPos = 0;
   }
   Refresh = 1;
   break;
 case 'e':
 case 'E':
   Tmp = TermCurrentPos;
   for (i=0;i<TermHeader.ScrPos;i++)
    Tmp = (tTermPhoneRec *)Tmp->Next;
   if (Tmp != NULL){ 
    EditEntry(Tmp);
    ShowTerm();
    Refresh = 1;
   }
   break;
 case 'f':
 case 'F':
   SearchTerm();
   break;
 case 'v':
 case 'V':
   SavePhonebook();
   break;
 case 'g':
 case 'G':
   TermGlobalDefs();
   break;
 case 's':
 case 'S':
   Sort();
   TermHeader.PhonePos = 1;
   TermCurrentPos = TermLastPos = (tTermPhoneRec *)PhoneBook->Base->Next;
   TermCurrentNumber = 1;
   TermHeader.ScrPos = 0;
   TermLastScrPos = 0;
   Refresh = 1;
   break;
 case '\r':
 case '\n':
   j = 0;
   Tmp = (tTermPhoneRec *)PhoneBook->Base->Next;
   for (i=0;i<TermHeader.Num && j == 0;i++)
   {
    if (Tmp->Tag == 1) j = 1;
    Tmp = (tTermPhoneRec *)Tmp->Next;
   }
   if (j == 0){
     Tmp = TermCurrentPos;
     for (i=0;i<TermHeader.ScrPos;i++)
      Tmp = (tTermPhoneRec *)Tmp->Next;
     if (Tmp != NULL) Tmp->Tag = 1;
   }
   nonl();
   Dialer(TermHeader.Num);
   nl();
   if (j == 0){
     Tmp = TermCurrentPos;
     for (i=0;i<TermHeader.ScrPos;i++)
      Tmp = (tTermPhoneRec *)Tmp->Next;
     if (Tmp != NULL) Tmp->Tag = 0;
   }
   Refresh = 1;
   break;  
 case 'd':
 case 'D':
   nonl();
   Dialer(TermHeader.Num);
   nl();
   Refresh = 1;
   break;
 case 'm':
 case 'M':
   ManualDial();
   ShowTerm();
   Refresh = 1;
   break;
 case 'p':
 case 'P':
   ChangePhone();
   ShowTerm();
   Refresh = 1;
   break;
 case 'a':
 case 'A':
   MakeDefaultPhonebook();
   Refresh = 1;
   break;
 case ' ':
   Tmp = (tTermPhoneRec *)TermCurrentPos;
   for (i=0;i<TermHeader.ScrPos;i++)
    Tmp = (tTermPhoneRec *)Tmp->Next;
   Tmp->Tag = Tmp->Tag ^ 1;
   Refresh = 2;
   if (Integers[TagAdvance]) goto KEYDOWN;
   break;
 case '+':
   Tmp = (tTermPhoneRec *)PhoneBook->Base->Next;
   for (i=0;i<TermHeader.Num;i++)
   {
    Tmp->Tag = 1;
    Tmp = (tTermPhoneRec *)Tmp->Next;
   }
   Refresh = 1;
   break;
 case '-':
   Tmp = (tTermPhoneRec *)PhoneBook->Base->Next;
   for (i=0;i<TermHeader.Num;i++)
   {
    Tmp->Tag = 0;
    Tmp = (tTermPhoneRec *)Tmp->Next;
   }
   Refresh = 1;
   break;
 case '*':
   Tmp = (tTermPhoneRec *)PhoneBook->Base->Next;
   for (i=0;i<TermHeader.Num;i++)
   {
    Tmp->Tag = Tmp->Tag ^ 1;
    Tmp = (tTermPhoneRec *)Tmp->Next;
   }
   Refresh = 1;
   break;
 default:break;
 }
 if (Refresh != 0) ShowTermBook(Refresh);
}
