/*
    modem.h -- Header file for modem routines
    Copyright (C) 1996  Nadav Cohen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#ifndef __MODEM_H_
#define __MODEM_H_

#include <termios.h>

#define NOSAVE 0
#define SEND 1
#define DUMP 2
#define SAVE 3

extern int Ansi, Avatar, vt100;
extern int DTR, RTS, DSR, CTS, ST, SR, CAR, RNG;
extern unsigned char CurrentBuffer[128], CurrentBufferFilled;
extern int BufferCounter, UsedGetChar, BytesRead, Hand;

extern char Emu[20];
extern int Emupos;
extern int islocked(char *device);
extern int unlock(char *device);
extern int initModem(char *device, int baud);
extern void resetModem();
extern void closeModem();
extern void setparms(int baud, char Parity, char Databit, char Stopbit, char Flow);
extern void sethup(int which);
extern int charwaiting();
extern int canwritechar();
extern int mgetchar();
extern int msendchar(char ch);
extern int mreadblock(char *buf, int len);
extern void mwriteblock(char *buf, int len);
extern int linestatus();
extern void hangup();
extern void sbreak();
extern unsigned char BufferGetChar();
extern void CopyBuffer();

#endif
