/*
    menu.c -- Menus in OOP.
    Copyright (C) 1996  Nadav Cohen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "menu.h"
#include "screen.h"
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <ncurses.h>

tMenu::tMenu(WINDOW *Win, int Color, int hColor, int hiColor,int tColor, int Alignment)
{
 Window = Win;
 bgColor = Color >> 4;
 fgColor = Color % 16;
 hotColor = hColor;
 hotbgColor = hiColor >> 4;
 hotfgColor = hiColor % 16;
 TextColor = tColor;
 Align = Alignment;
 Base = Last = NULL;
 Focus = 0;
 Total = 0;
}

tMenu::~tMenu()
{
 menuItem *Tmp, *Next;
 
 Tmp = Base;
 while (Tmp != NULL) {
   Next = Tmp->Next;
   free(Tmp->Text);
   Tmp = Next;
 }
}

void tMenu::Add(char *text, int x1, int x2, int y)
{
 char *ptr, *tptr;
 
 Total++;
 
 if (Last == NULL) {
  Last = new menuItem;
  Last->Prev = NULL;
  Last->Next = NULL;
 }
 else
 { 
  Last->Next = new menuItem;
  Last->Next->Prev = Last;
  Last = Last->Next;
  Last->Next = NULL;
 }
 if (strchr(text, '~') != 0)
  Last->Text = (char *)malloc(strlen(text)-2+1);
 else   Last->Text = (char *)malloc(strlen(text)+1);
 
 ptr = text;
 tptr = Last->Text;

 Last->HotPos = 0; 
 while (*ptr != '~' && *ptr != '\0') *tptr++ = *ptr++;
 if (*ptr != '\0') {
   ptr++;
   *tptr++ = *ptr;
   Last->HotPos = ptr-text;
   ptr+=2;
   while (*ptr != 0) *tptr++ = *ptr++;
 }
 *tptr = 0;
 
 Last->X1 = x1;
 Last->Y  = y;
 Last->X2 = x2;
 if (Base == NULL) {
  Base = Last;
 }
}

void tMenu::Show()
{
 int fcol, bcol, i, j, sx, sy;
 menuItem *Tmp;
 
 fcol = fgCol;
 bcol = bgCol;
 getyx(Window, sy, sx);
 
 textAttr(Window, TextColor);
 
 Tmp = Base;
 j = 0;
 
 while (Tmp != NULL) {
   if (j==Focus) {
    textColor(Window, hotfgColor);
    textBkgd(Window, hotbgColor);
   }
   wmove(Window, Tmp->Y, Tmp->X1);
   whline(Window, ' ', Tmp->X2-Tmp->X1);
   if (Align == ALIGNLEFT) wmove(Window, Tmp->Y, Tmp->X1);
   if (Align == ALIGNMID) wmove(Window, Tmp->Y, findCenter(Tmp->X1, Tmp->X2-1, strlen(Tmp->Text)));
   for (i=1;i<=(int)strlen(Tmp->Text);i++)
   {
    if (i != Tmp->HotPos) waddch(Window,*(Tmp->Text+i-1));
    else
    {
     textColor(Window, hotColor % 16);
     textBkgd(Window, hotColor >> 4);
     if (j==Focus){ 
      textColor(Window, hotfgColor);
      textBkgd(Window, hotbgColor);
     }
     waddch(Window, *(Tmp->Text+i-1));
     if (j==Focus){ 
      textColor(Window, hotfgColor);
      textBkgd(Window, hotbgColor);
     }
     else
     { 
       textAttr(Window, TextColor);
     }
    } /* End if */
   }/* End for */
   if (j==Focus) {
    textAttr(Window, TextColor);
   }
   j++;
   Tmp = Tmp->Next;
 }/*End while */
 textColor(Window, fcol);
 textBkgd(Window, bcol);
 wmove(Window, sy, sx);
}

int tMenu::GetInput(int ch)
{
 int Refresh, i, CurFocus;
 menuItem *Tmp;
 
 Refresh = 0;
 CurFocus = Focus;
 
 switch(ch) {
 case KEY_DOWN:
   if (CurFocus != Total-1) CurFocus++;
   Refresh = 1;
   break;
 case KEY_UP:
   if (CurFocus != 0) CurFocus--;
   Refresh = 1;
   break;
 case KEY_PPAGE:
 case KEY_HOME:
   CurFocus = 0;
   Refresh = 1;
   break;
 case KEY_NPAGE:
 case KEY_END:
   CurFocus = Total-1;
   Refresh = 1;
   break;
 default:break;
 }
 Tmp = Base;
 for (i=0;i<Total;i++)
 {
  if (toupper(*(Tmp->Text+Tmp->HotPos-1))==toupper(ch)){
   CurFocus = i + 128;
   Refresh = 1;
  }
  Tmp = Tmp->Next;
 }
 Focus = CurFocus & 127;
 if (Refresh == 1) {
  Show();
  wrefresh(Window);
 }
 return CurFocus;
}
