/*
    main.c -- Main code of program
    Copyright (C) 1996  Nadav Cohen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include "screen.h"
#include "window.h"
#include "menu.h"
#include "modem.h"
#include "ansi.h"
#include "avatar.h"
#include "phone.h"
#include "config.h"
#include "setup.h"
#include <sys/time.h>
#include <termios.h>
#include "terminal.h"
#include "filemgr.h"
#include "utils.h"
#include "error.h"
#include <stdlib.h>
#include <string.h>


int main(int argc, char **argv)
{
 char Temp[50];
 int Device, i, j, NewBaud;
 tTermPhoneRec *Tmp;
 char Configured = 0, Configure = 0, ForcedDevice = 0; 
 char *endptr;
 
 ConfigName = NULL;
 for (i = 1; i < argc; i++)
  if (strcmp(*(argv+i), "-other") == 0){
   ConfigName = (char *)malloc(strlen(*(argv+i+1))+1);
   strcpy(ConfigName, *(argv+i+1));
   i = argc;
  }
 SetDefault();
 if (ReadConfig() == -1){
   initScreen();
   Setup();
   curs_set(1);
   Configured = 1;
 }
 else
   initScreen();

 NameOfDialEntry = NULL;
 for (i=1; i < argc; i++)
 {
  if (strcmp(*(argv+i), "-config") == 0 && !Configured)
   Configure = 1;
  else if (strcmp(*(argv+i), "-dial") == 0)
  {
   i++;
   NameOfDialEntry = (char *)malloc(strlen(*(argv+i))+1);
   strcpy(NameOfDialEntry, *(argv+i));
  }
  else if (strcmp(*(argv+i), "-dialindex") == 0)
  {
   i++;
   j = strtol(*(argv+i), &endptr, 10);
   if (endptr == NULL || *endptr == '\0')
    DialIndex = j;
  }
  else if (strcmp(*(argv+i), "-device") == 0)
  {
   i++;
   j = strtol(*(argv+i), &endptr, 10);
   if (endptr == NULL || *endptr == '\0'){
    ForcedDevice = 1;
    Integers[DefaultDevice] = j;
   }
  }
  else if (strcmp(*(argv+i), "-dev") == 0)
  {
   i++;
   Strings[Device1] = (char *)realloc(Strings[Device1], strlen(*(argv+i))+1);
   strcpy(Strings[Device1], *(argv+i));
   ForcedDevice = 1;
   Integers[DefaultDevice] = 1;
  }
  else if (strcmp(*(argv+i), "-baud") == 0)
  {
   i++;
   j = strtol(*(argv+i), &endptr, 10);
   if (endptr == NULL || *endptr == '\0')
    NewBaud = j;
  }
 }
 if (NewBaud != 0) Integers[Bauds1+Integers[DefaultDevice]] = NewBaud;
 if (Configure){
  Setup();
  curs_set(1);
  closeScreen();
  exit(0);
 }
 if (Integers[AskDevice] && !ForcedDevice){
  nl();
  Device = ChooseDevice(Screen, Integers[DefaultDevice], 1);
  clearok(Screen, TRUE);
  if (Device == 0) Device = Integers[DefaultDevice];
  if (Device > 4) Device = Integers[DefaultDevice];
 }
 else
  Device = Integers[DefaultDevice];
 if (initModem(Strings[Device1+Device-1], Integers[Bauds1+Device-1]) != 0){
   unlock(Strings[Device1+Device-1]);
   FatalWindowError(Screen, "Unable to open device");
 }
 setparms(Integers[Bauds1+Device-1], Integers[Parities1+Device-1], Integers[Databits1+Device-1], 
          Integers[Stopbits1+Device-1], Integers[FlowCtrl1+Device-1]);
 PhoneBook = NULL;
 switch(Integers[PhoneType]){
 case 0:
   if (ReadTerminate(Strings[Phonebook], Screen) < 0) WindowError(Screen, "Unable to open phonebook");
   break;
 case 1:
   if (ReadTelix(Strings[Phonebook]) < 0) WindowError(Screen, "Unable to open phonebook");
   break;
 default:break;
 }
 if (PhoneBook == NULL){
   PhoneBook = new tList;
   Strings[Phonebook] = (char *)realloc(Strings[Phonebook], 12);
   strcpy(Strings[Phonebook], "termite.fon");
   CurrentPhonebook = (char *)malloc(strlen(Strings[Phonebook])+1);
   strcpy(CurrentPhonebook, Strings[Phonebook]);
   Tmp = new tTermPhoneRec;
   CreateClearEntry(Tmp);
   strncpy(Tmp->Name+1,"Manual Mode", 11);
   Tmp->Name[0] = 11;
   PhoneBook->Add(Tmp);
   Tmp = new tTermPhoneRec;
   memcpy(Tmp, PhoneBook->Base, sizeof(tTermPhoneRec));
   strncpy(Tmp->Name+1,"123", 3);
   Tmp->Name[0] = 3;
   PhoneBook->Add(Tmp);
   TermHeader.Num = 1;
   TermHeader.RangeStart = 1;
   TermHeader.RangeStop = 1;
   TermHeader.PhonePos = 1;
   TermHeader.WritePos = 1;
   TermCurrentPos = TermLastPos = (tTermPhoneRec *)PhoneBook->Base->Next;
   TermCurrentNumber = 1;
   TermHeader.ScrPos = 0;
   TermLastScrPos = 0;
 }
 DoTerminal(Device);

 if (ClosePort){ 
   strcpy(Temp, Strings[ExitStr]);
   ReplaceM(Temp);
   mwriteblock(Temp, strlen(Temp));
   resetModem();
 }
 closeModem();
 unlock(Strings[Device1+Device-1]);
 clear();
 addstr("\n\n\n Quitter!");
 refresh();
 closeScreen();
 return 0;
}
