/*
    config.c -- Configuration parser
    Copyright (C) 1996  Nadav Cohen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#include "config.h"
#include "error.h"
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

/* Lock dir per device? No 
   Callin/callout per device? Yes
   Options menu? Yes
   piping? minicom
   dcd? 
   man pages?
*/
char IntegerNames[] = "cPhoneText cPhoneBar cStatus cStatusBold cTerminal \
cRemote cLocal cInfo cInfoBold cHelp cHelpBold cEdit cMenu cMenuText \
cMenuTextBold cMenuOptions cMenuTitle cMenuHot cMenuBar ScrollBackSize \
LoopDelay TagChar EditBack OnlineWarn StatusStartOff StatusStartOn \
StatusEndOff StatusEndOn AskDevice StartInPhone StartInTop AskCurrentPhone \
PhoneBookOnDrop OpenLog AutoOpenCapture AppendCapture SaveControl CaptureKeys \
HidePwds AskOnExit AskOnHang TagAdvance SendAllInit DialTime DialDelay \
AutoAnswer ForceInit LocalEcho StripHigh FileMgrSort BSdest Dump \
DefaultDevice Parities1 Parities2 Parities3 Parities4 Stopbits1 Stopbits2 \
Stopbits3 Stopbits4 Databits1 Databits2 Databits3 Databits4 FlowCtrl1 \
FlowCtrl2 FlowCtrl3 FlowCtrl4 Bauds1 Bauds2 Bauds3 Bauds4 ProtocolAsk1 \
ProtocolAsk2 ProtocolAsk3 ProtocolAsk4 ProtocolAsk5 ChangeDl1 ChangeDl2 \
ChangeDl3 ChangeDl4 ChangeDl5 ChangeUl1 ChangeUl2 ChangeUl3 ChangeUl4 \
ChangeUl5 Phonetype EscType \0";

char StringNames[] = "DownloadPath UploadPath CapturePath ScriptPath PhonePath \
LogName Macro1 Macro2 Macro3 Macro4 Macro5 Macro6 Macro7 Macro8 Macro9 Macro10 \
ProtocolName1 ProtocolName2 ProtocolName3 ProtocolName4 ProtocolName5 \
ProtocolInfo1 ProtocolInfo2 ProtocolInfo3 ProtocolInfo4 ProtocolInfo5 \
ProtocolDlExec1 ProtocolDlExec2 ProtocolDlExec3 ProtocolDlExec4 \
ProtocolDlExec5 ProtocolUlExec1 ProtocolUlExec2 ProtocolUlExec3 \
ProtocolUlExec4 ProtocolUlExec5 InitStr1 InitStr2 InitStr3 InitStr4 InitStr5 \
InitStr6 InitStr7 InitStr8 InitStr9 InitStr10 Prefix1 Prefix2 Prefix3 Prefix4 \
Prefix5 Prefix6 Suffix1 Suffix2 Suffix3 Suffix4 Suffix5 ExitStr Ring \
DialCancel AutoAnswerStr Device1 Device2 Device3 Device4 User1 User2 User3 \
User4 User5 User6 User7 User8 User9 User10 LockPath ConnectStr NoConnect1 \
NoConnect2 NoConnect3 NoConnect4 NoConnect5 Signature1 Signature2 Signature3 \
Signature4 Signature5 DeviceInit1 DeviceInit2 DeviceInit3 DeviceInit4 \
Phonebook \0";

char Signature[5][10], DeviceInit[4][10];
char *TermEmu[5];

char Var[30], Value[30], Comment, LineBuffer[256], LineLn;
int ConfigHandle;
char *ConfigName;

int Integers[TotalIntegers+1];
char *Strings[TotalStrings+1];

int OpenConfig()
{
 char Temp[256], *Env;
 int i;
 
 if (ConfigName != NULL){
  strcpy(Temp, ConfigName);
 }
 else{
  Env = getenv("HOME");
  strcpy(Temp, Env);
  strcat(Temp, "/.termite");
 }
 
 if ((ConfigHandle = open(Temp, O_RDWR)) < 0) {
  TextError("Unable to open config file");
  return -1;
 }
 return 0;
}

void TruncConfig()
{
 char Temp[256], *Env;
 
 if (ConfigName != NULL){
  strcpy(Temp, ConfigName);
 }
 else{
  Env = getenv("HOME");
  strcpy(Temp, Env);
  strcat(Temp, "/.termite");
 }
 
 if ((ConfigHandle = open(Temp, O_RDWR | O_TRUNC | O_CREAT,  S_IFREG | S_IRUSR | S_IWUSR)) < 0) {
  FatalTextError("Unable to open config file");
 }
}

void CloseConfig()
{
 close(ConfigHandle);
}

int GetLine()
{
 int i;
 char ch;
 
 i = 0;
 Comment = 0;
 LineLn = 0;
 ch = 0;
 while (ch != '=' && ch != '\n') { 
  if (read(ConfigHandle, &ch, 1) <= 0) return -1;
  if (ch == '#'){ 
   ch = 1;
   memset(LineBuffer, 0, 255);
   LineBuffer[0] = '#';
   while (LineBuffer[ch-1] != '\n') read(ConfigHandle, &LineBuffer[ch++], 1);
   LineLn = ch;
   Comment = 1;
   return 0;
  }
  LineBuffer[i]=ch;
  Var[i++]=ch;
 }
 LineLn = i;
 if (ch != '\n'){
  Var[i-1] = 0;
  i = 0;
  while (ch != '\n') {
   if (read(ConfigHandle, &ch, 1) < 0) return -1;
   Value[i++] = ch;
  }
  Value[i-1] = 0;
 }
 else
 {
  Var[1]=0;
  Value[0]=0;
 }
 return 0;
}

int Yesno()
{
 if (strcmp(Value, "yes") == 0) return 1;
 return 0;
}

int Number(int len)
{
 return (atoi(Var + len)-1);
}

int FindName(char *Haystack, char *Needle)
{
 int i, j, spaceCounter = 0, len = strlen(Haystack), Result;
 char Temp[50];

 i = 0;
 Temp[0] = 0;
 Result = 1;
 
 while (i < len && Result != 0){
  j = 0;
  while (*(Haystack+i) != ' '){
   Temp[j++] = *(Haystack+i);
   i++;
  }
  i++;
  Temp[j] = 0;
  spaceCounter++;
  Result = strcmp(Temp, Needle);
 }
 if (Result == 0) return spaceCounter;
 else return -1;
}

void FindName(char *Haystack, int Number, char *Putin)
{
 int i, j, spaceCounter = 0, len = strlen(Haystack), Result;
 char Temp[50];

 i = 0;
 Temp[0] = 0;
 Result = 1;
 
 while (i < len && spaceCounter < Number){
  j = 0;
  while (*(Haystack+i) != ' '){
   Temp[j++] = *(Haystack+i);
   i++;
  }
  i++;
  Temp[j] = 0;
  spaceCounter++;
 }
 strcpy(Putin, Temp);
}

int ReadConfig()
{
 int i, j;
 char Temp[3];
 
 if (OpenConfig() == -1)
   return -1;
   
 Integers[DumpVar] = 0;
  
 while (GetLine() == 0)
 if (Comment == 0 && Var[0] != '\n'){
  if ((i = FindName(IntegerNames, Var)) != -1){
   Integers[i] = atoi(Value);
  }
  else if ((i = FindName(StringNames, Var)) != -1){
   if (Strings[i] == NULL)
    Strings[i] = (char *)malloc(strlen(Value)+1);
   else
    Strings[i] = (char *)realloc(Strings[i], strlen(Value)+1);
   strcpy(Strings[i], Value);
  }
 }
 for (i = Signature1; i <= Signature5; i++)
 {
  for (j=0; j < (int)strlen(Strings[i])/2 && j < 10;j++){
   strncpy(Temp, Strings[i]+j*2, 2);
   Temp[2]=0;
   Signature[i-Signature1][j+2] = strtol(Temp, NULL, 16);
  }
  Signature[i-Signature1][0]=j;
  Signature[i-Signature1][1]=0;
 }
 for (i = DeviceInit1; i <= DeviceInit4; i++){
  memset(&DeviceInit[i-DeviceInit1][0], 255, 10);
  for (j=0;j<(int)strlen(Strings[i]) && j<10;j++){
   DeviceInit[i-DeviceInit1][j]=*(Strings[i]+j)-48;
  }
 }
 for (i = Stopbits1; i <= Stopbits4; i++)
  if (Integers[i] != 0) Integers[i]--;
 for (i=0;i<5;i++)
  TermEmu[i] = (char *)malloc(20);
 strcpy(TermEmu[0], "Avatar/ANSI");
 strcpy(TermEmu[1], "Avatar");
 strcpy(TermEmu[2], "ANSI");
 strcpy(TermEmu[3], "VT-100");
 strcpy(TermEmu[4], "TTY");
 CloseConfig();
 return 0;
}

void BackupConfig()
{
 int i, BackHandle;
 char buf[256];
 
 OpenConfig();
 strcpy(buf, getenv("HOME"));
 strcat(buf, "/.termite.bak");
 if ((BackHandle = open(buf, O_CREAT | O_RDWR | O_TRUNC, S_IFREG | S_IRUSR | S_IWUSR)) < 0)
  TextError("Unable to open backup file");
 else{
 i = 256;
 while (i == 256){
  i = read(ConfigHandle, buf, 256);
  write(BackHandle, buf, i);
 }
 close(BackHandle);
 CloseConfig();
 }
}

void RewriteConfig()
{
 int i, BackHandle;
 char buf[256];
 
 TruncConfig();
 strcpy(buf, getenv("HOME"));
 strcat(buf, "/.termitebackup");
 if ((BackHandle = open(buf, O_RDWR | O_CREAT, S_IFREG | S_IRUSR | S_IWUSR)) < 0)
  TextError("Unable to open backup file");
 else{
 i = 256;
 while (i == 256){
  i = read(BackHandle, buf, 256);
  write(ConfigHandle, buf, i);
 }
 close(BackHandle);
 CloseConfig();
 }
}

void WriteNumber(int Handle, char *Text, int Number)
{
 char Temp[30];
 
 write(Handle,Text, strlen(Text));
 write(Handle, (char *)"=",1);
 sprintf(Temp, "%d", Number);
 write(Handle, Temp, strlen(Temp));
 write(Handle, (char *)"\n",1);
}

void WriteString(int Handle, char *Text, char *Str)
{
 write(Handle, Text, strlen(Text));
 write(Handle, (char *)"=",1);
 if (Str != NULL)
  write(Handle, Str, strlen(Str));
 write(Handle, (char *)"\n",1);
}

void WriteConfig()
{
 int i, j, Handle;
 char Temp[30], TempString[50];

 BackupConfig(); 
 OpenConfig();
 strcpy(Temp, getenv("HOME"));
 strcat(Temp, "/.termitebackup");
 Handle = open(Temp, O_CREAT | O_RDWR | O_TRUNC, S_IFREG | S_IRUSR | S_IWUSR);
 for (i = Signature1; i <= Signature5; i++){
  TempString[0] = 0;
  for (j = 0; j < Signature[i-Signature1][0]; j++){
   sprintf(Temp, "%02X", Signature[i-Signature1][j+2]);
   strcat(TempString, Temp);
  }
  Strings[i] = (char *)realloc(Strings[i], strlen(TempString)+1);
  strcpy(Strings[i], TempString);
 }
 for (i = DeviceInit1; i <= DeviceInit4; i++){
  TempString[0] = 0;
  for (j = 0; j < 10; j++)
   if (DeviceInit[i-DeviceInit1][j] >=0){
     sprintf(Temp, "%d", DeviceInit[i-DeviceInit1][j]);
     strcat(TempString, Temp);
   }
  Strings[i] = (char *)realloc(Strings[i], strlen(TempString)+1);
  strcpy(Strings[i], TempString);
 }
 for (i = Stopbits1; i <= Stopbits4; i++)
  Integers[i]++;
 while (GetLine() == 0)
 if (!Comment){
  if (Var[0] == '\n')
   write(Handle, &Var[0],1);
  else if ((i = FindName(IntegerNames, Var)) != -1){
   WriteNumber(Handle, Var, Integers[i]);
  }
  else if ((i = FindName(StringNames, Var)) != -1){
   WriteString(Handle, Var, Strings[i]);
  }
 }
 else
 {
  write(Handle, LineBuffer, LineLn);
 }
 close(Handle);
 CloseConfig();
 RewriteConfig();
}

void DumpConfig()
{
 int i, j, Handle;
 char Temp[30], TempString[50];
 
 strcpy(Temp, getenv("HOME"));
 strcat(Temp, "/.termitebackup");

 Handle = open(Temp, O_CREAT | O_RDWR | O_TRUNC,  S_IFREG | S_IRUSR | S_IWUSR);
 
 for (i = Signature1; i <= Signature5; i++){
  TempString[0] = 0;
  for (j = 0; j < Signature[i-Signature1][0]; j++){
   sprintf(Temp, "%02X", Signature[i-Signature1][j+2]);
   strcat(TempString, Temp);
  }
  Strings[i] = (char *)realloc(Strings[i], strlen(TempString)+1);
  strcpy(Strings[i], TempString);
 }
 for (i = DeviceInit1; i <= DeviceInit4; i++){
  TempString[0] = 0;
  for (j = 0; j < 10; j++)
   if (DeviceInit[i-DeviceInit1][j] >=0){
     sprintf(Temp, "%d", DeviceInit[i-DeviceInit1][j]);
     strcat(TempString, Temp);
   }
  Strings[i] = (char *)realloc(Strings[i], strlen(TempString)+1);
  strcpy(Strings[i], TempString);
 }
 for (i = Stopbits1; i <= Stopbits4; i++)
  Integers[i]++;

 for (i = 1; i <= TotalIntegers; i++){
  FindName(IntegerNames, i, Temp);
  WriteNumber(Handle, Temp, Integers[i]);
 }
 
 for (i = 1; i <= TotalStrings; i++){
  FindName(StringNames, i, Temp);
  WriteString(Handle, Temp, Strings[i]);
 }
 
 close(Handle);
 RewriteConfig();
 Integers[DumpVar] = 0;
}

void SetDefault()
{
 int i;
 
 for (i = 1; i <= TotalStrings; i++)
  Strings[i] = NULL;
  
 Strings[DownloadPath] = (char *)malloc(1);
 *Strings[DownloadPath] = 0;
 Strings[UploadPath] = (char *)malloc(1);
 *Strings[UploadPath] = 0;
 Strings[CapturePath] = (char *)malloc(1);
 *Strings[CapturePath] = 0; 
 Strings[ScriptPath] = (char *)malloc(1);
 *Strings[ScriptPath] = 0;
 Strings[PhonePath] = (char *)malloc(1);
 *Strings[PhonePath] = 0;
 Strings[LogName] = (char *)malloc(1);
 *Strings[LogName] = 0;
 for (i = Macro1; i <= Macro0; i++){
   Strings[i] = (char *)malloc(1);
   *Strings[i] = 0;
 }
 for (i = Signature1; i <= Signature5; i++){
   Strings[i] = (char *)malloc(1);
   *Strings[i] = 0;
 }
 for (i = DeviceInit1; i <= DeviceInit4; i++){
   Strings[i] = (char *)malloc(1);
   *Strings[i] = 0;
 }
 for (i = ProtocolName1; i <= ProtocolName5; i++){
   Strings[i] = (char *)malloc(1);
   *Strings[i] = 0;
 }
 for (i = ProtocolInfo1; i <= ProtocolInfo5; i++){
   Strings[i] = (char *)malloc(1);
   *Strings[i] = 0;
 }
 for (i = ProtocolDlExec1; i <= ProtocolDlExec5; i++){
   Strings[i] = (char *)malloc(1);
   *Strings[i] = 0;
 }
 for (i = ProtocolUlExec1; i <= ProtocolUlExec5; i++){
   Strings[i] = (char *)malloc(1);
   *Strings[i] = 0;
 }
 for (i = ProtocolName1; i <= ProtocolName5; i++){
   Strings[i] = (char *)malloc(1);
   *Strings[i] = 0;
 }
 for (i = ProtocolAsk1;i <= ProtocolAsk5; i++){
   Integers[i] = 0;
 }
 for (i = ChangeDl1; i <= ChangeDl5; i++){
   Integers[i] = 0;
 }
 for (i = ChangeUl1; i <= ChangeUl5; i++){
   Integers[i] = 0;
 }
 for (i = InitStr1;i <= InitStr0; i++){
   Strings[i] = (char *)malloc(1);
   *Strings[i] = 0;
 }
 for (i = Prefix1; i <= Prefix6; i++){
   Strings[i] = (char *)malloc(1);
   *Strings[i] = 0;
 }
 for (i = Suffix1; i <= Suffix5; i++){
   Strings[i] = (char *)malloc(1);
   *Strings[i] = 0;
 }
 Strings[ExitStr] = (char *)malloc(1);
 *Strings[ExitStr] = 0;
 Strings[Ring] = (char *)malloc(6);
 strcpy(Strings[Ring], "RING^M");
 Strings[DialCancel] = (char *)malloc(1);
 *Strings[DialCancel] = 0;
 Strings[AutoAnswerStr] = (char *)malloc(1);
 *Strings[AutoAnswerStr] = 0;
 for (i = Device2; i <= Device4; i++){
   Strings[i] = (char *)malloc(1);
   *Strings[i] = 0;
 }
 Strings[Device1] = (char *)malloc(11);
 strcpy(Strings[Device1], "/dev/modem");
 Integers[DefaultDevice] = 1;
 for (i = User1;i <= User0; i++){
   Strings[i] = (char *)malloc(1);
   *Strings[i] = 0;
 }
 for (i=0;i<5;i++)
  TermEmu[i] = (char *)malloc(20);
 strcpy(TermEmu[0], "Avatar/ANSI");
 strcpy(TermEmu[1], "Avatar");
 strcpy(TermEmu[2], "ANSI");
 strcpy(TermEmu[3], "VT-100");
 strcpy(TermEmu[4], "TTY");
 Strings[LockPath] = (char *)malloc(1);
 *Strings[LockPath] = 0;
 Strings[ConnectStr] = (char *)malloc(1);
 *Strings[ConnectStr] = 0;
 for (i = NoConnect1; i <= NoConnect5; i++){
   Strings[i] = (char *)malloc(1);
   *Strings[i] = 0;
 }
 for (i =0; i<5; i++){
   memset(Signature[i], 0, 22);
 }
 for (i=0; i<5; i++){
   memset(DeviceInit[i], 0, 22);
 }
 for (i = Parities1; i <= Parities4; i++)
  Integers[i] = 78;
 for (i = Databits1; i <= Databits4; i++)
  Integers[i] = 8;
 for (i = Stopbits1; i <= Stopbits4; i++)
  Integers[i] = 0;
 for (i = Bauds1; i <= Bauds4; i++)
  Integers[i] = 2400;
 Strings[Phonebook] = (char *)malloc(1);
 *Strings[Phonebook] = 0;
 Strings[LockPath] = (char *)malloc(16);
 strcpy(Strings[LockPath], "/var/spool/uucp");
 Integers[PhoneType] = 1;
 Integers[cPhoneText]=31;
 Integers[cPhoneBar]=79;
 Integers[cMenu]=3;
 Integers[cMenuOptions]=3;
 Integers[cMenuBar]=113;
 Integers[cMenuTitle]=14;
 Integers[cMenuHot]=14;
 Integers[cMenuTextBold]=14;
 Integers[cEdit]=3;
 Integers[cInfo]=25;
 Integers[cInfoBold]=30;
 Integers[cHelp]=48;
 Integers[cHelpBold]=59;
 Integers[cStatus]=23;
 Integers[cTerminal]=7;
 Integers[cRemote]=113;
 Integers[cLocal]=112;
 Integers[EditBack]=176;
 Integers[TagChar]=254;
 Integers[ScrollBackSize] = 250;
 Integers[BSdest] = 1;
 Integers[DumpVar] = 1;
 Integers[OnlineWarn] = 15;
}
