/*
    avatar.c -- AVATAR emulation routines
    Copyright (C) 1996  Nadav Cohen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <ncurses.h>
#include "avatar.h"
#include "screen.h"
#include "modem.h"
#include <string.h>
#include <stdlib.h>
#include <sys/types.h>
#include <unistd.h>


int AVATAR(int ch)
{
 int i, j, t, x1, y1, x2, y2, num, fcol, bcol;
 chtype c;
 char pattern[256];
 int Avtcode;
 
 Avtcode = 0;
 
 switch(ch) {
  // ^L
  case 12: 
    textColor(Screen, A_DEFAULTCOLOR);
    textBkgd(Screen, BLACK);
    swclear(Screen);
    Avtcode = 1;
    break;
  // ^Y
  case 25: 
    i = BufferGetChar();
    j = BufferGetChar();
    for (;j>0;j--)
      swaddch(Screen, (unsigned char)i);
    Avtcode = 1;
    break;
  // ^V
  case 22: 
    switch(BufferGetChar() && 0xFF) {
    // ^A
    case 1: 
      i = BufferGetChar() && 0x7F;
      textColor(Screen, i && 0xF);
      textBkgd(Screen, i>>4);
      break;
    // ^B
    case 2:
      textColor(Screen, fgCol);
      textBkgd(Screen, bgCol+8);
      break;
    // ^C
    case 3:
      getyx(Screen, i, j);
      if (i>0) swmove(Screen, i-1, j);
      break;
    // ^D
    case 4:
      getyx(Screen, i ,j);
      if (i<LINES) swmove(Screen, i+1, j);
      break;
    // ^E
    case 5:
      getyx(Screen, i, j);
      if (j>0) swmove(Screen, i, j-1);
      break;
    // ^F
    case 6:
      getyx(Screen, i, j);
      if (j<COLS) swmove(Screen, i, j+1);
      break;
    // ^G
    case 7:
      swclrtoeol(Screen);
      break;
    // ^H
    case 8:
      i = BufferGetChar()-1;
      j = BufferGetChar()-1;
      swmove(Screen,(unsigned char)i, (unsigned char)j);
      break;
    // ^J
    case 10:
      num = BufferGetChar();
      y1 = BufferGetChar()-1;
      x1 = BufferGetChar()-1;
      y2 = BufferGetChar()-1;
      x2 = BufferGetChar()-1;
      if (num == 0 || y2-y1<num)
      for (i=y1;i<=y2;i++)
       for (j=x1;j<=x2;j++)
        smvwaddch(Screen, i, j, ' ');
      else
      for (i=y1+1;i<=y1+1+num;i++)
       for (j=x1;j<=x2;j++)
       {
        c = mvwinch(Screen, i, j);
        smvwaddch(Screen, i-1, j, c);
       }
      break;
    // ^K
    case 11:
      num = BufferGetChar();
      y1 = BufferGetChar()-1;
      x1 = BufferGetChar()-1;
      y2 = BufferGetChar()-1;
      x2 = BufferGetChar()-1;
      if (num == 0 || y2-y1<num)
      for (i=y1;i<=y2;i++)
       for (j=x1;j<=x2;j++)
        smvwaddch(Screen, i, j, ' ');
      else
      for (i=y2-1;i>=y2-1-num;i--)
       for (j=x1;j<=x2;j++)
       {
        c = mvwinch(Screen, i, j);
        smvwaddch(Screen, i+1, j, c);
       }
      break;
    // ^L
    case 12:
    getyx(Screen, y1, x1);
    fcol = fgCol;
    bcol = bgCol;
    i = BufferGetChar() && 0x7F;
    textColor(Screen, i && 0xF);
    textBkgd(Screen, i>>4);
    y2 = BufferGetChar()+y1;
    x2 = BufferGetChar()+x1;
    for (i=y1;i<=y2;i++)
     for (j=x1;j<=x2;j++)
      smvwaddch(Screen, i, j, ' ');
    textColor(Screen, fcol);
    textBkgd(Screen, bcol);
    break;
  // ^M
  case 13:
    getyx(Screen, y1, x1);
    fcol = fgCol;
    bcol = bgCol;
    i = BufferGetChar() && 0x7F;
    textColor(Screen, i && 0xF);
    textBkgd(Screen, i>>4);
    c = BufferGetChar();
    y2 = BufferGetChar()+y1;
    x2 = BufferGetChar()+x1;
    for (i=y1;i<=y2;i++)
     for (j=x1;j<=x2;j++)
      smvwaddch(Screen, i, j, c);
    textColor(Screen, fcol);
    textBkgd(Screen, bcol);
    break;
  // ^N
  case 14:
    getyx(Screen, y1, x1);
    for (i=x1+1;i<COLS;i++)
    {
     c = mvwinch(Screen, y1, i);
     smvwaddch(Screen, y1, i-1, c);
    }
    break;
  // ^Y
  case 25:
    num = BufferGetChar();
    for (i=0;i<num;i++)
     pattern[i]=BufferGetChar();
    t = BufferGetChar();
    for (i=0;i<num;i++)
    for (j=0;j<t;j++)
     swaddch(Screen, pattern[j]);
    break;
  default:break;
  }
  Avtcode = 1;
  break;
  default:break;
  }
  if (!Avtcode) return SEND;
  return NOSAVE;
}
