/* CHK=0x83DE */
/*+-------------------------------------------------------------------------
    naptest3.c - nap test suite
    wht@n4hgf.Mt-Park.GA.US

This test attempts to see if small naps nap even though return value is 0,
thus partially complying with the man page:
"The current process is suspended from execution for at least
the number of milliseconds specified by period ...." ^^^^^^^^

--------------------------------------------------------------------------*/
/*+:EDITS:*/
/*:09-10-1992-14:00-wht@n4hgf-ECU release 3.20 */
/*:08-22-1992-15:39-wht@n4hgf-ECU release 3.20 BETA */
/*:09-03-1991-20:30-wht@n4hgf-creation */

#include <stdio.h>
#include <sys/param.h>

main(argc,argv)
int argc;
char **argv;
{
    int itmp,hz,expected;
    char *cptr,*getenv(),*ctime();
    long hzmsec,then,now,actual;

    /* learn tick period */
    if((cptr = getenv("HZ")) && *cptr)
        hz = atoi(cptr);
    else
        hz = HZ;
    hzmsec = (1000 / hz) + 1; /* prevent damaged nap from not napping */

    itmp = 1000;
    expected = (int)(hzmsec * itmp / 1000L);
    printf("This should sleep about %d seconds, %ld+ msec at a time\n",
		expected, hzmsec - 1);
    time(&then);
    printf("Nap started at %s",ctime(&then));
    while(itmp--)
        nap(hzmsec - 1);
    time(&now);
    printf("Nap ended   at %s",ctime(&now));
    printf("Napped about %ld second(s)",actual = now - then);
	if(!actual)
		printf(", not at all!");
	else if(actual == 1)
		printf(". Must be a lucky epoch tick.  Try it again!");
	printf("\n",stdout);

    exit(0);
}   /* end of main */
