#if defined(SHARE_DEBUG)
#define LOG_UNGETTY
#define LOG_HDBDIAL
#endif

/* #define CHOOSE_DEBUG */

/*+-------------------------------------------------------------------------
	hdbintf.c - HDB UUCP database and /etc/utmp interface routines
	wht@n4hgf.Mt-Park.GA.US

  Defined functions:
	_ungetty_return_line(line)
	add_to_ungetty_list(line)
	dialcodes_translate(phone)
	dialstr_translate(translate_list,to_translate)
	display_ungetty_list()
	dvtype_match(typespec,dvtype)
	enddlent()
	enddvent()
	getdlent()
	getdlentname(name)
	getdvbaud(baud)
	getdvent()
	getdvline(line)
	getdvtype(type)
	hdb_choose_Any(baud)
	hdb_choose_Device(type,baud)
	hdb_dial(presult)
	hdb_dial_error_text(errcode)
	hdb_init()
	in_ungetty_list(line)
	malformed_Devices_entry(text,ntokens,tokens)
	remove_from_ungetty_list(line)
	reserve_line(line)
	strip_phone_num(sptr)
	ugstat_text(ugstat)
	ungetty_get_line(line)
	ungetty_return_all_but(line)
	ungetty_return_line(line)

Date: Fri, 23 Aug 91 18:30:06 +0300 (MSD)
From: emory!hq.demos.su!ache (Andrew A. Chernov, canton Uri's citizen)
1) HDB dialers may return connect speed as return code (!= 0)
2) Using HDB Dialcodes file for phone numbers translation now
   (\D,\T escape sequence)

--------------------------------------------------------------------------*/
/*+:EDITS:*/
/*:09-14-1992-04:05-wht@n4hgf-rcvr process was not going away reliably */
/*:09-10-1992-13:59-wht@n4hgf-ECU release 3.20 */
/*:09-10-1992-03:35-wht@n4hgf-change the way we flunk a line=="-" */
/*:09-04-1992-19:08-wht@n4hgf-harden Devices parsing */
/*:08-29-1992-15:37-wht@n4hgf-absolutely prohibit /dev/tty fed to ecuungetty */
/*:08-22-1992-15:39-wht@n4hgf-ECU release 3.20 BETA */
/*:07-21-1992-17:20-wht@n4hgf-hdb_dial of "/=" type bug fixed */
/*:07-19-1992-22:12-wht@n4hgf-move old check_utmp here+call it reserve_line */
/*:07-19-1992-10:07-wht@n4hgf-add ungetty_return_all_but */
/*:07-19-1992-09:11-wht@n4hgf-validate tty line name before ungetty get */
/*:06-07-1992-17:05-wht@n4hgf-lock tty before ungetty get */
/*:05-13-1992-13:27-wht@n4hgf-active_pde use */
/*:05-13-1992-10:30-cma@ifsbd-Add baud rate checking to hdb_dial function */
/*:05-04-1992-04:45-wht@n4hgf-wrong sense of strcmp in ,M test for SVR4 */
/*:04-28-1992-03:29-wht@n4hgf-more fixes for abend due to line problems */
/*:04-27-1992-20:02-wht@n4hgf-add ecuungetty error reporting */
/*:04-25-1992-13:02-wht@n4hgf-some exits from hdb_choose_Any omitted enddvent */
/*:04-24-1992-21:59-wht@n4hgf-more SCO tty name normalizing */
/*:04-19-1992-03:21-jhpb@sarto.budd-lake.nj.us-3.18.37 has ESIX SVR4 */
/*:01-18-1992-13:29-root@n4hgf-use proctrace value for expresp_verbosity */
/*:11-15-1991-04:02-wht@n4hgf-SCO tty naming now observed in getdvline */
/*:09-01-1991-16:20-wht@n4hgf2-generalize HDB configuration files location */
/*:09-01-1991-02:27-wht@n4hgf2-dialer gets file name instead of "ECUdial" */
/*:08-25-1991-13:07-wht@n4hgf-apply ache@hq.demos.su patches */
/*:08-10-1991-17:39-wht@n4hgf-US_WEGOTIT handling */
/*:07-25-1991-12:58-wht@n4hgf-ECU release 3.10 */
/*:06-02-1991-17:42-wht@n4hgf-add getdvtype */
/*:06-02-1991-17:27-wht@n4hgf-hdb_choose_Device + move hdb_choose_Any here */
/*:10-16-1990-20:43-wht@n4hgf-add SHARE_DEBUG */
/*:09-19-1990-19:36-wht@n4hgf-ecu_log_event now gets pid for log from caller */
/*:08-14-1990-20:40-wht@n4hgf-ecu3.00-flush old edit history */

#include "ecu.h"
#include "ecupde.h"
#include "esd.h"
#include "var.h"
#include "termecu.h"
#include "utmpstatus.h"
#include "ecuungetty.h"
#include "dvent.h"
#include "dlent.h"
#include "dialprog.h"
#include <errno.h>
#include <utmp.h>

char *arg_token();
char *skip_ld_break();
char *dialcodes_translate();
char *strip_phone_num();

extern char kbdintr;		/* current input INTR */
extern ulong colors_current;
extern int proctrace;
extern int expresp_verbosity;

int there_is_hdb_on_this_machine = 0;
static FILE *fpdv = (FILE *)0;
static FILE *fpdl = (FILE *)0;
char *Devices_file = "/usr/lib/uucp/Devices";
char *Dialers_file = "/usr/lib/uucp/Dialers";
char *Dialcodes_file = "/usr/lib/uucp/Dialcodes";
uchar last_ugstat = 0;

#define UNGETTY_LIST_MAX	3
char *ungetty_list[UNGETTY_LIST_MAX];

/*+-------------------------------------------------------------------------
	display_ungetty_list() - display ungetty list with pputs()
--------------------------------------------------------------------------*/
#if defined(USE_ECUUNGETTY)
void
display_ungetty_list()
{
	int itmp;
	int found_one = 0;

	for(itmp = 0; itmp < UNGETTY_LIST_MAX; itmp++)
	{
		if(*ungetty_list[itmp])
		{
			found_one = 1;
			break;
		}
	}

	if(!found_one)
	{
		pputs("No lines acquired by ecuungetty\n");
		return;
	}

	pputs("Acquired by ecuungetty: ");
	for(itmp = 0; itmp < UNGETTY_LIST_MAX; itmp++)
	{
		if(*ungetty_list[itmp])
		{
			pputs(ungetty_list[itmp]);
			pputs(" ");
		}
	}
	pputs("\n");

}	/* end of display_ungetty_list */
#endif /* defined(USE_ECUUNGETTY) */

/*+-------------------------------------------------------------------------
	in_ungetty_list(line) - check for line present in ungetty list
--------------------------------------------------------------------------*/
#if defined(USE_ECUUNGETTY)
int
in_ungetty_list(line)
char *line;
{
	int itmp;

	for(itmp = 0; itmp < UNGETTY_LIST_MAX; itmp++)
	{
		if(!strcmp(line,ungetty_list[itmp]))
			return(1);
	}
	return(0);

}	/* end of in_ungetty_list */
#endif /* defined(USE_ECUUNGETTY) */

/*+-------------------------------------------------------------------------
	add_to_ungetty_list(line) - add line to ungetty list
--------------------------------------------------------------------------*/
#if defined(USE_ECUUNGETTY)
void
add_to_ungetty_list(line)
char *line;
{
	int itmp;
	char *lptr;

	if(in_ungetty_list(line))
		return;

	for(itmp = 0; itmp < UNGETTY_LIST_MAX; itmp++)
	{
		if(!*(lptr = ungetty_list[itmp]))
		{
			strcpy(lptr,line);
			return;
		}
	}
	ecu_log_event(getpid(),"ungetty_list overflow");
	termecu(TERMECU_LOGIC_ERROR);
	/*NOTREACHED*/

}	/* end of add_to_ungetty_list */
#endif /* defined(USE_ECUUNGETTY) */

/*+-------------------------------------------------------------------------
	remove_from_ungetty_list(line) - remove line from ungetty list
--------------------------------------------------------------------------*/
#if defined(USE_ECUUNGETTY)
void
remove_from_ungetty_list(line)
char *line;
{
	int itmp;
	char *lptr;

	for(itmp = 0; itmp < UNGETTY_LIST_MAX; itmp++)
	{
		if(!strcmp((lptr = ungetty_list[itmp]),line))
		{
			*lptr = 0;
			return;
		}
	}

#ifdef CHOOSE_DEBUG
	{
		char s128[128];
		sprintf(s128,"remove_from_ungetty_list failed for %s",line);
		ecu_log_event(getpid(),s128);
	}
#endif

}	/* end of remove_from_ungetty_list */
#endif /* defined(USE_ECUUNGETTY) */

/*+-------------------------------------------------------------------------
	ugstat_text(ugstat) - text for ecuungetty code
--------------------------------------------------------------------------*/
char *
ugstat_text(ugstat)
int ugstat;
{
	static char errant[32];

	switch(ugstat)
	{
		case UG_NOTENAB:
			return("line not enabled");
			break;
		case UG_RESTART:
			return("restart needed");
			break;
		case UG_FAIL:
			return("line in use");
			break;
		case UGE_T_LOGIN:
			return("-t found US_LOGIN");
			break;
		case UGE_T_LOGGEDIN:
			return("-t found US_LOGGGEDIN");
			break;
		case UGE_T_NOTFOUND:
			return("not found");
			break;
		case UGE_BADSWITCH:
			return("usage: bad switch");
			break;
		case UGE_BADARGC:
			return("usage: bad arg count");
			break;
		case UGE_BADARGV:
			return("this a valid tty??");
			break;
		case UGE_NOTROOT:
			return("not setuid root");
			break;
		case UGE_CALLER:
			return("invalid caller");
			break;
		case UGE_NOUUCP:
			return("cannot find uucp passwd entry");
			break;
		case UGE_LOGIC:
			return("logic error");
			break;
		case UGE_BOMB:
			return("core dumped or killed");
			break;
		case UGE_DNE:
			return("did not execute");
			break;
	}
	sprintf(errant,"error %u",ugstat);
	return(errant);
}	/* end of ugstat_text */

/*+-------------------------------------------------------------------------
	ungetty_get_line(line) - acquire a line through ecuungetty protocol
--------------------------------------------------------------------------*/
int
ungetty_get_line(line)
char *line;
{
#if !defined(USE_ECUUNGETTY)
	return(0);
#else
	int itmp;
	int rtn = 0;
	int we_locked = 0;
	int ungetty_pid;
	SIGTYPE (*original_sighdlr)();
	int wait_status;
	char ungetty[128];
	char ungetty_log[80];
	char bamboozlement[20];
	struct stat st;
	char *bamboozle();

	/*
	 * quick check - ecuungetty does a much better job
	 */
	if(!strcmp(line,"/dev/tty")) /* some keep getting /dev/tty chown'd! */
		return(LINST_INVALID);
	if(stat(line,&st))
	{
		if(errno == ENOENT)
			return(LINST_NODEV);
		return(LINST_OPNFAIL);
	}
	if((st.st_mode & S_IFMT) != S_IFCHR)
		return(LINST_NOTCHR);
	if(!there_is_hdb_on_this_machine)
		return(0);
	if(in_ungetty_list(line))
		return(0);

	/*
	 * lock line before ecuungetty call
	 */
	if((itmp = lock_tty(line)) && (itmp != LINST_WEGOTIT))
		return(itmp);
	we_locked = (!itmp);

	sprintf(ungetty,"%s/ecuungetty",ECULIBDIR);
	strcpy(bamboozlement,bamboozle(getpid()));
	if(access(ungetty,1))
	{
		pperror(ungetty);
		rtn = LINST_ENABLED;
		goto RETURN;
	}
	original_sighdlr = signal(SIGCLD,SIG_DFL);
	if((ungetty_pid = smart_fork()) == 0)
	{
		execl(ungetty,"ungetty",line,bamboozlement,(char *)0);
		_exit(UGE_DNE);	/* did not execute */
	}
	while(((itmp = wait(&wait_status)) != ungetty_pid) && (itmp != -1))
		;
	signal(SIGCLD,original_sighdlr);

	if(wait_status & 0xFF)
		last_ugstat = UGE_BOMB;
	else
		last_ugstat = (uchar)(wait_status >> 8);
	switch(last_ugstat)
	{
		case UG_NOTENAB:	/* line acquired: not enabled */
			break;

		case UG_RESTART:	/* line acquired: need ungetty -r when done */
#if defined(LOG_UNGETTY)
			sprintf(ungetty_log,"UNGETTY acquired %s",shm->Lline);
			ecu_log_event(getpid(),ungetty_log);
#endif
			add_to_ungetty_list(line);
			break;

		case UG_FAIL:		/* line in use */
			rtn = LINST_ENABLED_IN_USE;
			break;

		default:
			sprintf(ungetty_log,"UNGETTY status 0x%04x: %s",
				wait_status,ugstat_text(last_ugstat));
			ecu_log_event(getpid(),ungetty_log);
			rtn = (last_ugstat == UGE_BOMB)
				? LINST_ECUUNGETTY2 : LINST_ECUUNGETTY;
			break;
	}

RETURN: ;
	if(rtn && we_locked)
		unlock_tty(line);
	return(rtn);

#endif /* !defined(USE_ECUUNGETTY) */
}	/* end of ungetty_get_line */

/*+-------------------------------------------------------------------------
    reserve_line(line)
return 0 if line reserved, else LINST code
--------------------------------------------------------------------------*/
int
reserve_line(line)
char *line;
{
register utstatus;
register status = 0;

    switch(utstatus = utmp_status(line))
    {
        case US_DIALOUT:    /* enabled for login, currently dialout */
            status = LINST_DIALOUT_IN_USE;
            break;
        case US_LOGGEDIN:   /* enabled for login, in use */
            status = LINST_ENABLED_IN_USE;
            break;
        case US_NOTFOUND:   /* not in utmp, or getty dead */
            break;
        case US_WEGOTIT:    /* we own the line */
            status = LINST_WEGOTIT;   /* not really an error */
            break;
        case US_LOGIN:      /* enabled for login, idle */
            status = ungetty_get_line(line);
            break;
    }

#if defined(LOG_LOCKS)
    {
        char s64[64];
        sprintf(s64,"UTMPCHK %s st=%d ut=%d",line,status,utstatus);
        ecu_log_event(getpid(),s64);
    }
#endif

    return(status);

}   /* end of reserve_line */

/*+-------------------------------------------------------------------------
	_ungetty_return_line(line) - return line to "getty" status
--------------------------------------------------------------------------*/
void
_ungetty_return_line(line)
char *line;
{
#if !defined(USE_ECUUNGETTY)
	return;
#else
	int ungetty_pid;
	int itmp;
	SIGTYPE (*original_sighdlr)();
	int wait_status = 0xDEAD;
	char ungetty[128];
#if defined(LOG_UNGETTY)
	char ungetty_log[80];
#endif
	char bamboozlement[20];
	char *bamboozle();

	if(!there_is_hdb_on_this_machine)
		return;
	if(!in_ungetty_list(line))
		return;

	sprintf(ungetty,"%s/ecuungetty",ECULIBDIR);
	strcpy(bamboozlement,bamboozle(getpid()));

	/* call ungetty to see if we need to switch to dialin */
#if 0 /* if in_ungetty_list, trust we need to -r */
	if(access(ungetty,1))
	{
		pperror(ungetty);
		return;
	}
	original_sighdlr = signal(SIGCLD,SIG_DFL);
	if((ungetty_pid = smart_fork()) == 0)
	{
		execl(ungetty,"ungetty","-t",line,bamboozlement,(char *)0);
		ecu_log_event(getpid(),"could not exec ecuungetty -t");
		_exit(UGE_DNE);	/* did not execute */
	}
	while(((itmp = wait(&wait_status)) != ungetty_pid) &&
			(itmp != -1) )
		;
	signal(SIGCLD,original_sighdlr);

#if defined(LOG_UNGETTY)
	sprintf(ungetty_log,"UNGETTY -t %s status %04x",line,wait_status);
	ecu_log_event(getpid(),ungetty_log);
#endif
	switch((uchar)(wait_status >> 8))
	{
		case UG_RESTART:
			break;

		default:
			remove_from_ungetty_list(line);
			return;
	}
#endif

	original_sighdlr = signal(SIGCLD,SIG_DFL);
	if((ungetty_pid = smart_fork()) == 0)
	{
		execl(ungetty,"ungetty","-r",line,bamboozlement,(char *)0);
		ecu_log_event(getpid(),"could not exec ecuungetty -r");
		_exit(UGE_DNE);	/* did not execute */
	}

	while(((itmp = wait(&wait_status)) != ungetty_pid) &&
			(itmp != -1))
		;

#if defined(LOG_UNGETTY)
	if(wait_status)
	{
		sprintf(ungetty_log,"UNGETTY -r %s status 0x%04x",
			line,wait_status);
	}
	else
		sprintf(ungetty_log,"UNGETTY returned %s",line);
	ecu_log_event(getpid(),ungetty_log);
#endif

	remove_from_ungetty_list(line);

#endif /* !defined(USE_ECUUNGETTY) */
}	/* end of _ungetty_return_line */

/*+-------------------------------------------------------------------------
	ungetty_return_line(line) - return one or all lines to "getty" status
--------------------------------------------------------------------------*/
void
ungetty_return_line(line)
char *line;
{
#if !defined(USE_ECUUNGETTY)
	return;
#else
	int itmp;

	if(line)
		_ungetty_return_line(line);
	else
	{
		for(itmp = 0; itmp < UNGETTY_LIST_MAX; itmp++)
		{
			if(*(line = ungetty_list[itmp]))
				_ungetty_return_line(line);
		}
	}

#endif /* !defined(USE_ECUUNGETTY) */
}	/* end of ungetty_return_line */

/*+-------------------------------------------------------------------------
	ungetty_return_all_but(line) - return all lines but 'line'
--------------------------------------------------------------------------*/
void
ungetty_return_all_but(line)
char *line;
{
#if !defined(USE_ECUUNGETTY)
	return;
#else
	int itmp;

	for(itmp = 0; itmp < UNGETTY_LIST_MAX; itmp++)
	{
		if(ungetty_list[itmp][0] && strcmp(line,ungetty_list[itmp]))
			_ungetty_return_line(line);
	}

#endif /* !defined(USE_ECUUNGETTY) */
}	/* end of ungetty_return_all_but */

/*+-------------------------------------------------------------------------
	malformed_Devices_entry(text,ntokens,tokens)
--------------------------------------------------------------------------*/
void
malformed_Devices_entry(text,ntokens,tokens)
char *text;
int ntokens;
char **tokens;
{
	char s512[512];
	char *cptr;
	char *nlptr;
	static already = 0;
	extern int tty_not_char_special;

	sprintf(s512,"malformed Devices entry (%s):\n",text);
	cptr = s512 + strlen(s512);
	nlptr = cptr - 1;

	while(ntokens--)
	{
		if(((cptr - s512) + strlen(*tokens) + 2) > sizeof(s512))
			break;
		sprintf(cptr,"%s ",*tokens++);
		cptr += strlen(cptr);
	}

	if(!already && !tty_not_char_special)
	{
		pputs("\7\n");
		pputs(s512);
		pputs("\nFurther Devices errors will not be displayed,\n");
		pputs("but are logged in ~/.ecu/log.  Press any key to continue.\7");
		ttyflush(0);
		ttygetc(1);
		pputs("\n");
	}
	already = 1;

	memcpy(s512,"MALFORMED",9);		/* mod for log file */
	*nlptr = ' ';
	ecu_log_event(xmtr_pid,s512);

}	/* end of malformed_Devices_entry */

/*+-------------------------------------------------------------------------
	getdvent() - get first or next Devices entry (a la getpwent)
--------------------------------------------------------------------------*/
DVE *
getdvent()
{
	int itmp;
#define MAX_DV_TOKENS 9
	char *tokens[MAX_DV_TOKENS];
	int ntokens;
#if 0
	int itokens;
#endif
	char *cptr;
	static DVE dve;
	static char dvstr[256];
	char *strchr();
	char *skip_ld_break();

	if(!there_is_hdb_on_this_machine)
		goto RETURN_NULL;

	if(!fpdv)
	{
		if(!(fpdv = fopen(Devices_file,"r")))
		{
			pperror(Devices_file);
			goto RETURN_NULL;
		}
	}

	while(1)
	{
		/*
		 * read a Devices line
		 */
		if(!fgets(dvstr,sizeof(dvstr),fpdv))
		{
RETURN_NULL:
#ifdef CHOOSE_DEBUG
			ecu_log_event(xmtr_pid,"getdvent returning NULL");
#endif
			return((DVE *)0);
		}

		/*
		 * weed out comments and blank lines
		 */
		if(strlen(dvstr) <= 1)					/* blank line */
			continue;
		cptr = skip_ld_break(dvstr);			/* first non-blank */
		if(!*cptr || strchr("#\n",*cptr))		/* comment or all white space */
			continue;

		/*
		 * tokenize
		 */
		build_arg_array(dvstr,tokens,MAX_DV_TOKENS,&ntokens);

		/*
		 * honor '#' whever it occurs
		 */
#if 0
		for(itokens = 0; itokens < ntokens; itokens++)
		{
			if(!tokens[itokens])
				tokens[itokens] = "";
			if(cptr = strchr(tokens[itokens],'#'))
			{
				*cptr = 0;
				ntokens = itokens + 1;
				break;
			}
		}
#endif

		/*
		 * a bit of validation
		 */
		if(ntokens < 4)
		{
			malformed_Devices_entry("too few fields",ntokens,tokens);
			continue;
		}

		/*
		 * TCP,et - - Any TCP - 
		 * found in Sun Devices (UUCP over TCP)
		 */
#if 0	/* leave this generic; handle in getdvbaud and getdvtype */
		if(!strcmp(tokens[1],"-"))
		{
			malformed_Devices_entry("bad tty specified",ntokens,tokens);
			continue;
		}
#endif

		break;
	}

	/*
	 * we have a good entry
	 */
	dve.type = tokens[0];
	dve.line = tokens[1];

	/*
	 * get rid of possible SVR4 ",M" modem control suffix
	 */
	itmp = strlen(dve.line);
	if((itmp > 2) && !strcmp(dve.line + itmp - 2,",M"))
	  dve.line[itmp - 2] = 0;

	dve.dialer = tokens[2];
	if(!strcmpi(tokens[3],"Any"))
	{
		dve.low_baud = 1;
		dve.high_baud = 65535;
	}
	else
	{
		dve.low_baud = atoi(tokens[3]);
		if(!(cptr = strchr(tokens[3],'-')))
			dve.high_baud = dve.low_baud;
		else
			dve.high_baud = atoi(cptr + 1);
	}
	dve.dialprog = tokens[4];
	dve.token = tokens[5];
#ifdef CHOOSE_DEBUG
	{
		char s256[256];
		sprintf(s256,"getdvent returning '%s' type='%s'",dve.line,dve.type);
		ecu_log_event(xmtr_pid,s256);
	}
#endif
	return(&dve);

}	/* end of getdvent */

/*+-------------------------------------------------------------------------
	enddvent() - close Devices file
--------------------------------------------------------------------------*/
void
enddvent()
{
	if(fpdv)
	{
		fclose(fpdv);
		fpdv = (FILE *)0;
	}
}	/* end of enddvent */

/*+-------------------------------------------------------------------------
	getdvbaud(baud) - get Devices entry matching baud rate
--------------------------------------------------------------------------*/
DVE *
getdvbaud(baud)
uint baud;
{
	DVE *tdve;

#ifdef CHOOSE_DEBUG
	char s128[128];

	sprintf(s128,"getdvbaud looking for %u baud",baud);
	ecu_log_event(getpid(),s128);
#endif

	while(1)
	{
		if((tdve = getdvent()) == (DVE *)0)
			return(tdve);
#ifdef CHOOSE_DEBUG
		sprintf(s128,"getdvbaud found %s type '%s' baud lo=%d hi=%d",
			tdve->line,tdve->type,tdve->low_baud,tdve->high_baud);
		
		ecu_log_event(getpid(),s128);
#endif
		if(!strcmp(tdve->line,"-"))	/* neo-entries like TCP have "-" line */
			continue;
		if((tdve->low_baud <= baud) && (baud <= tdve->high_baud))
		{
#ifdef CHOOSE_DEBUG
			sprintf(s128,"getdvbaud returning %s",tdve->line);
			ecu_log_event(getpid(),s128);
#endif
			return(tdve);
		}
	}
	/*NOTREACHED*/

}	/* end of getdvbaud */

/*+-------------------------------------------------------------------------
	getdvline(line) - get Devices entry matching line
calling argument 'line's is string AFTER "/dev/"
--------------------------------------------------------------------------*/
DVE *
getdvline(line)
char *line;
{
	DVE *tdve;

#ifdef CHOOSE_DEBUG
	char s128[128];

	sprintf(s128,"getdvline looking for %s",line);
	ecu_log_event(getpid(),s128);
#endif

	while(1)
	{
		if((tdve = getdvent()) == (DVE *)0)
			return(tdve);
#ifdef CHOOSE_DEBUG
		sprintf(s128,"getdvline %s found baud lo=%d hi=%d",tdve->line,
			tdve->low_baud, tdve->high_baud);
		ecu_log_event(getpid(),s128);
#endif
		if(!TTYNAME_STRCMP(tdve->line,line))
			return(tdve);
	}
	/*NOTREACHED*/

}	/* end of getdvline */

/*+-------------------------------------------------------------------------
	dvtype_match(typespec,dvtype) - match between pde typespec and dvtype

returns 1 if pde type specification 'typespec' matches Devices device 'type'
--------------------------------------------------------------------------*/
int
dvtype_match(typespec,dvtype)
char *typespec;
char *dvtype;
{
	char *emsg;
	char *match;
	int matchlen;
	int re_match = 1;
	char cmpbuf[128];

	if(*typespec == '=')
		typespec++;
	else if(*typespec == '/')
	{
		re_match = 0;
		typespec++;
	}

	if(re_match)
	{
		if(!strcmp(dvtype,typespec))
			return(1);
	}
	else
	{
		if(regexp_compile(typespec,cmpbuf,sizeof(cmpbuf),&emsg))
			return(0);
		if(regexp_scan(cmpbuf,dvtype,&match,&matchlen))
			return(1);
	}
	return(0);

}	/* end of dvtype_match */

/*+-------------------------------------------------------------------------
	getdvtype(type) - get Devices entry matching type

type is either 'Device_type'   search for exact match on Device_type
               '=Device_type'  search for exact match on Device_type
               '/regexp'       search for match with regular expression

you must make sure any supplied regexp is a valid one, for regexp
compilation errors are indistinguishable from other seach failures

uses optimized implementation of dvtype_match functionality
--------------------------------------------------------------------------*/
DVE *
getdvtype(type)
char *type;
{
	DVE *tdve;
	char *emsg;
	char *match;
	int matchlen;
	int re_match = 0;	/* regular expression match */
	char cmpbuf[128];

	if(*type == '=')
		type++;
	else if(*type == '/')
	{
		re_match = 1;
		type++;
		if(regexp_compile(type,cmpbuf,sizeof(cmpbuf),&emsg))
			return((DVE *)0);
	}

	while(tdve = getdvent())
	{
		if(!strcmp(tdve->line,"-"))	/* neo-entries like TCP have "-" line */
			continue;
		if(re_match)
		{
			if(regexp_scan(cmpbuf,tdve->type,&match,&matchlen))
				break;
		}
		else
		{
			if(!strcmp(tdve->type,type))
				break;
		}
	}
	return(tdve);

}	/* end of getdvtype */

/*+-------------------------------------------------------------------------
	dialstr_translate(translate_list,to_translate) - translate dial strings
--------------------------------------------------------------------------*/
#if 0
void
dialstr_translate(translate_list,to_translate)
register char *translate_list;
char *to_translate;
{
	register char *cptr;

	while(*translate_list && *(translate_list + 1))
	{
		for(cptr=to_translate; *cptr; cptr++)
		{
			if(*translate_list == *cptr)
				*cptr = *(translate_list + 1);
		}
		translate_list += 2;
	}
}	/* end of dialstr_translate */
#endif

/*+-------------------------------------------------------------------------
	getdlent() - get first or next Dialers entry (a la getpwent)
--------------------------------------------------------------------------*/
struct dlent *
getdlent()
{
	int itmp;
#define MAX_DL_TOKENS 3
	char *tokens[MAX_DL_TOKENS];
	static struct dlent dle;
	static char dlstr[128];
	char *strchr();

	if(!there_is_hdb_on_this_machine)
		return((struct dlent *)0);

	if(!fpdl)
	{
		if(!(fpdl = fopen(Dialers_file,"r")))
		{
			pperror(Dialers_file);
			return((struct dlent *)0);
		}
	}

	while(1)
	{
		if(!fgets(dlstr,sizeof(dlstr),fpdl))
			return((struct dlent *)0);
		if(((itmp = strlen(dlstr)) <= 1) || (dlstr[0] == '#') ||
			(dlstr[0] == ' '))
		{
			continue;
		}
		dlstr[--itmp] = 0;
		for(itmp = 0; itmp < MAX_DL_TOKENS; itmp++)
			tokens[itmp] = "";
		if(tokens[0] = arg_token(dlstr," \t\r\n"))
		{
			if(tokens[1] = arg_token((char *)0," \t\r\n"))
			{
			extern char *str_token_static;
				tokens[2] = skip_ld_break(str_token_static);
			}
		}
		break;
	}

	dle.name = tokens[0];
	dle.tlate = tokens[1];
	dle.script = tokens[2];
	return(&dle);

}	/* end of getdlent */

/*+-------------------------------------------------------------------------
	enddlent() - close Dialers file
--------------------------------------------------------------------------*/
void
enddlent()
{
	if(fpdl)
	{
		fclose(fpdl);
		fpdl = (FILE *)0;
	}
}	/* end of enddlent */

/*+-------------------------------------------------------------------------
	getdlentname(name) - get Dialers entry by name
--------------------------------------------------------------------------*/
struct dlent *
getdlentname(name)
char *name;
{
	register DLE *tdle;

	while(tdle = getdlent())
	{
		if(!strcmp(name,tdle->name))
			break;
	}
	return(tdle);

}	/* end of getdlentname */

/*+-------------------------------------------------------------------------
	hdb_choose_Any(baud) - user will take 'Any' line

give preference to current line
--------------------------------------------------------------------------*/
DVE *
hdb_choose_Any(baud)
uint baud;
{
	DVE *tdve = (DVE *)0;
	char newtty[sizeof(shm->Lline)];
	int lerr = 0;
	int utmpst = 0;
#if defined(LOG_HDBDIAL) || defined(CHOOSE_DEBUG)
	char s128[128];
#endif

#ifdef CHOOSE_DEBUG
	sprintf(s128,"hdb_choose_Any baud=%u current line='%s'",baud,shm->Lline);
	ecu_log_event(getpid(),s128);
#endif

	enddvent();	/* krock but safe */

/*
 * see if shm->Lline in use by someone else; if not and baud rate ok, no further
 */

	if(shm->Lline[0])
	{
		while(tdve = getdvline(shm->Lline + 5))
		{
			if((tdve->low_baud <= baud) && (baud <= tdve->high_baud))
				break;
		}

		if(tdve)
		{
			switch(utmpst = utmp_status(shm->Lline))
			{
			case US_WEGOTIT:
				goto RETURN;
			case US_NOTFOUND:	/* not in utmp, or getty dead */
#if 0
				if(access(shm->Lline,6))
					break;
#endif
				if((lerr = line_lock_status(shm->Lline)) &&
					(lerr != LINST_WEGOTIT))
				{
					break;
				}
				goto RETURN;
			case US_LOGIN:		/* enabled for login, idle */
				goto RETURN;
			}
		}

		enddvent();
	}

	/*
	 * we've got to pick a new line
	 */

#ifdef CHOOSE_DEBUG
	sprintf(s128,"must pick new line utmpst=%u lerr=%u",utmpst,lerr);
	ecu_log_event(getpid(),s128);
#endif

	lerr = 0;
	while(1)
	{
		if(!(tdve = getdvbaud(baud)))
			break;

		/* by now, we know shm->Lline wont work */
		if(!TTYNAME_STRCMP(tdve->line,shm->Lline + 5))
			continue;

		/* if not acu, dont use it */
		if(ulindex(tdve->type,"ACU") < 0)
			continue;

		sprintf(newtty,"/dev/%s",tdve->line);
		switch(utmpst = utmp_status(newtty))
		{
			case US_NOTFOUND:	/* not in utmp, or getty dead */
#if 0
				if(access(newtty,6)) /* ecuungetty won't be able to help us */
					break;
#endif
				if((lerr = line_lock_status(newtty)) &&
					(lerr != LINST_WEGOTIT))
				{
					break;
				}
				goto RETURN;

			case US_LOGIN:		/* enabled for login, idle */
				goto RETURN;

			case US_WEGOTIT:
				goto RETURN;
		}
	}

RETURN:
	enddvent();
#ifdef LOG_HDBDIAL
	sprintf(s128,"CHOOSEANY lerr=%d chose %s",
		lerr,(tdve) ? tdve->line : "<none>");
	ecu_log_event(getpid(),s128);
#endif
	return(tdve);

}	/* end of hdb_choose_Any */

/*+-------------------------------------------------------------------------
	hdb_choose_Device(type,baud) - need line with 'type' and 'baud'

return DVE pointer if line chosen, 0 if failed to find a line
Priority is given to retaining the current line
--------------------------------------------------------------------------*/
DVE *
hdb_choose_Device(type,baud)
char *type;
uint baud;
{
	DVE *tdve = (DVE *)0;
	char s32[32];
	int itmp = 0;
	int lerr = 0;
	int utmpst = 0;
	int done;

#ifdef CHOOSE_DEBUG
	char s128[128];
	sprintf(s128,"hdb_choose_Device type='%s' baud=%u curr line='%s'",
	    type,baud,shm->Lline);
	ecu_log_event(getpid(),s128);
#endif

	/*
	 * check current line
	 */
	if(shm->Lline[0])
	{
		while(tdve = getdvline(shm->Lline + 5))
		{
			if(dvtype_match(type,tdve->type) &&
				(tdve->low_baud <= baud) && (baud <= tdve->high_baud))
			{
				break;
			}
		}
		enddvent();

		if(tdve)
		{
			switch(utmpst = utmp_status(shm->Lline))
			{
				case US_WEGOTIT:
					goto RETURN;

				case US_NOTFOUND:	/* not in utmp, or getty dead */
#if 0
					if(access(shm->Lline,6))
						break;
#endif
					if((lerr = line_lock_status(shm->Lline)) &&
						(lerr != LINST_WEGOTIT))
					{
						break;
					}
					goto RETURN;

				case US_LOGIN:		/* enabled for login, idle */
					goto RETURN;
			}
		}
	}

	/*
	 * we've got to pick a new line
	 */

#ifdef CHOOSE_DEBUG
	sprintf(s128,"must pick new line utmpst=%u lerr=%u",utmpst,lerr);
	ecu_log_event(getpid(),s128);
#endif

	done = 0;
	lerr = 0;
	while(!done)
	{
		/*
		 * get Devices entry matching type
		 */
		if(!(tdve = getdvtype(type)))
		{
#ifdef CHOOSE_DEBUG
			sprintf(s128,"no line matches type '%s'",type);
			ecu_log_event(getpid(),s128);
#endif
			break;
		}

		/*
		 * does baud rate match?
		 */
		if((tdve->low_baud > baud) || (baud > tdve->high_baud))
			continue;

		sprintf(s32,"/dev/%s",tdve->line);
		itmp = utmp_status(s32);
#ifdef CHOOSE_DEBUG
		sprintf(s128,"%s: utmp_status = %d  lock status=%d",s32,itmp,
				line_lock_status(s32));
		ecu_log_event(getpid(),s128);
#endif
		switch(itmp)
		{
			case US_NOTFOUND:	/* not in utmp, or getty dead */
#if 0
				if(access(s32,6))	/* ecuungetty won't be able to help us */
					break;
#endif
				if(!(itmp = line_lock_status(s32)) || (itmp == LINST_WEGOTIT))
					done = 1;
				break;

			case US_WEGOTIT:	/* we own the line */
				/* this would be a curious case to succeed */
				done = 1;
				break;

			case US_LOGIN:		/* enabled for login, idle */
				done = 1;
				break;

			default:
				break;
		}
	}

RETURN:
	enddvent();
	return(tdve);

}	/* end of hdb_choose_Device */

/*+-------------------------------------------------------------------------
	hdb_dial_error(errcode) - dialer program error code to text

also sets iv[0] to dial command status
--------------------------------------------------------------------------*/
char *
hdb_dial_error_text(errcode)
int errcode;
{
	static char errant[64];

	iv[0] = 1;
	switch(errcode &= 0x7F)
	{
		case RCE_INUSE:
			return("!Line in use");
		case RCE_SIG:
			iv[0] = 2;
			return("!Interrupted");
		case RCE_ARGS:
			return("!Invalid arguments");
		case RCE_PHNO:
			return("!Invalid phone number");
		case RCE_SPEED:
			return("!Bad baud rate");
		case RCE_OPEN:
			return("!Line open error");
		case RCE_IOCTL:
			return("!Ioctl error");
		case RCE_TIMOUT:
			iv[0] = 3;
			return("!Modem Error");
		case RCE_NOTONE:
			return("NO DIAL TONE");
		case RCE_BUSY:
			return("BUSY");
		case RCE_NOCARR:
			return("NO CARRIER");
		case RCE_ANSWER:
			return("NO ANSWER");
		default:
		case RCE_NULL:
			sprintf(errant,"unknown dialer error code %d",errcode);
			return(errant);
	}
	/*NOTREACHED*/
}	/* end of hdb_dial_error */

/*+-------------------------------------------------------------------------
	hdb_dial(presult) - dial with uucp dialer if we can

return 0 if connected
       1 if dial failed
       2 if interrupted
       3 if modem error
       4 if use ecu DCE dialer
--------------------------------------------------------------------------*/
int
hdb_dial(presult)
char **presult;
{
	int itmp;
	PID_T dial_pid;
	int wait_status;
	int old_ttymode = get_ttymode();
	SIGTYPE (*original_sighdlr)();
	DVE *tdve;
	struct dlent *tdle = (struct dlent *)0;
	char baudstr[16];
	char dbgstr[16];
	char dial_log[100];
	char *stripped_num;
	char *sptr;
	char *dptr;
	static char stat_s64[64];
	ulong colors_at_entry = colors_current;
	extern char *make_char_graphic();
	char token[128];        /* translated dialer token */
	FILE *fp;
	char credit_file[128];
	char *error_name = "";
	int error_baud = 0;
	int rcvr_restart = need_rcvr_restart();

	/*
	 * we may do nothing
	 */
	if(sigint)	/* don't even start if console interrupt posted */
	{
		sigint = 0;
		return(2);
	}

	if(!there_is_hdb_on_this_machine)
		return(4);

	/*
	 * kill receiver if it is active
	 */
	if(rcvr_restart)
		kill_rcvr_process(SIGUSR1);

#if defined(CHOOSE_DEBUG)
	sprintf(dial_log,"HDB_DIAL Lline=%s Lbaud=%d",
		shm->Lline,shm->Lbaud);
	ecu_log_event(getpid(),dial_log);
#endif

	/*
	 * get a Devices entry appropriate for dialing on the line;
	 */
	enddvent();
	while(tdve = getdvline(shm->Lline + 5))
	{
		if((tdve->low_baud <= shm->Lbaud) &&
			(shm->Lbaud <= tdve->high_baud)) 
		{
			break;
		}
	}
	error_name = shm->Lline + 5;
	error_baud = shm->Lbaud;
	enddvent();

	if(!tdve)
	{
		pprintf("no Devices entry for %s at %u baud ... trying ecu dialer\n",
			error_name,error_baud);
		return(4);
	}

	dial_log[0] = 0;
	if(*tdve->dialprog != '/')
	{
		tdle = getdlentname(tdve->dialprog);
		enddlent();
		if(!tdle)
		{
			sprintf(dial_log,
				"UUCPDIAL Devices entry %s: '%s' not found in Dialers",
				shm->Lline + 5,tdve->dialprog);
		}
	}
	else if(access(tdve->dialprog,1))
	{
		sprintf(dial_log,"UUCPDIAL Devices entry %s: (%s) %s",
			shm->Lline + 5,tdve->dialprog,errno_text(errno));
	}

	if(dial_log[0])
	{
#if defined(LOG_HDBDIAL)
		ecu_log_event(getpid(),dial_log);
#endif
		pputs(dial_log + 9);
		pputs("\n");
		return(4);
	}

	stripped_num = strip_phone_num(shm->Ltelno);

	/*
	 * if trailing '$', read and append ~/.ecu/.credit
	 */
	dptr = stripped_num;
	if(*(dptr - 1) == '$')
	{
		*--dptr = 0;
		get_home_dir(credit_file);
		strcat(credit_file,"/.ecu/.credit");
		chmod(credit_file,0400);	/* let's keep this one quiet */
		if(fp = fopen(credit_file,"r"))
		{
			fgets(dptr,30,fp);
			fclose(fp);
		}
		if(!fp || !(*dptr))
		{
			strcpy(sv[0]->pb,"!CREDIT CARD ERROR");
			sv[0]->cb = strlen(sv[0]->pb);
			pputs("\ncredit card error\n");
			iv[0] = 1;
			return(1);
		}
		if(*(dptr + strlen(dptr) - 1) == 0x0A)
			*(dptr + strlen(dptr) - 1) = 0; /* kill NL */
	}

  /* Translate Token now (thanks to ache@hq.demos.su) */

	if (tdve->token == (char *)0 || !tdve->token[0])
		strcpy(token, stripped_num);
	else {
		dptr = token;
		for (sptr = tdve->token; *sptr; sptr++)
			if (*sptr != '\\')
				*dptr++ = *sptr;
			else {
				char *s, *t;

				switch (*(sptr + 1)) {

				/* Direct */
				case 'D':
					sptr++;
					s = stripped_num;
					while (*s)
						*dptr++ = *s++;
					break;

				/* Dialcodes Translate */
				case 'T':
					sptr++;
					s = stripped_num;
					t = dialcodes_translate(&s);
					while(*t)
						*dptr++ = *t++;
					while (*s)
						*dptr++ = *s++;
					break;

				default:
					*dptr++ = '\\';
					break;
				}
			}
		*dptr = 0;
	}

	pprintf("Type %s to abort ... ",
		(kbdintr == 0x7F) ? "DEL" : make_char_graphic(kbdintr,0));
	setcolor(colors_normal);

	if(Ldial_debug_level)
	{
		ttymode(0);
		pputs("\n");
	}
	else
		ttymode(2);

	if(!tdle)
	{
		if(access(tdve->dialprog,1))
		{
			pperror(tdve->dialprog);
			pputs("trying ecu dialer\n");
			return(4);
		}
		sprintf(baudstr,"%u",shm->Lbaud);
		sprintf(dbgstr,"-x%d",Ldial_debug_level);
		original_sighdlr = signal(SIGCLD,SIG_DFL);
		if((dial_pid = smart_fork()) == 0)
		{
			signal(SIGINT,SIG_DFL);
			execl(tdve->dialprog,
#if defined(WHT) || defined(ECUdial)
				"ECUdial",		/* tell dialer ECU is calling */
#else
				tdve->dialprog,
#endif
				dbgstr, shm->Lline,token,baudstr,(char *)0);
			_exit(0xFF);	/* did not execute */
		}

		wait_status = (RC_FAIL | RCE_SIG) << 8;
		while(((itmp = wait(&wait_status)) != dial_pid) && (itmp != -1))
			;
		signal(SIGCLD,original_sighdlr);
		ttymode(old_ttymode);
		ttyflush(0);

		if(sigint)	/* keyboard interrupt? */
		{
			kill(dial_pid,9);	/* kill dialer */
			lflash_dtr();		/* drop line */
			sigint = 0;			/* reset SIGINT indication */
		}
		lreset_ksr(); /* uucp dialers are nice guys, but lets use our termio */

#if defined(LOG_HDBDIAL)
		if(wait_status)
		{
			sprintf(dial_log,"UUCPDIAL %s %s exit status0x%04x",
				tdve->dialprog,token,wait_status & 0xFFFF);
			ecu_log_event(getpid(),dial_log);
		}
#endif

		/*
		 * if system reports interrupt, fake dial-reported status
		 */
		if(wait_status & 0xFF)
			wait_status = (RC_FAIL | RCE_SIG) << 8;

		if((wait_status & 0xFF00) == 0xFF00)
		{
			pprintf("%s failed  ... trying ecu dialer\n",tdve->dialprog);
			return(4);
		}

		wait_status = (wait_status >> 8) & 0xFF;

		if(!(wait_status & ~RC_BAUD))
		{
			char *cptr;

			wait_status &= RC_BAUD;
			switch (wait_status) 
			{
			case 0:         cptr = baudstr; break;  /* SAME */
			case B50:       cptr = "50"; break;
			case B75:       cptr = "75"; break;
			case B110:      cptr = "110"; break;
			case B134:      cptr = "134.5"; break;
			case B150:      cptr = "150"; break;
			case B200:      cptr = "200"; break;
			case B300:      cptr = "300"; break;
			case B600:      cptr = "600"; break;
			case B1200:     cptr = "1200"; break;
			case B1800:     cptr = "1800"; break;
			case B2400:     cptr = "2400"; break;
			case B4800:     cptr = "4800"; break;
			case B9600:     cptr = "9600"; break;
#if defined(B19200)
			case B19200:    cptr = "19200"; break;
#endif
#if defined(B38400)
			case B38400:    cptr = "38400"; break;
#endif
			default:
				switch (wait_status) {
				case EXTA:      cptr = "EXTA"; break;
				case EXTB:      cptr = "EXTB"; break;
				default:        cptr = "????"; break;
				}
			}

			sprintf(stat_s64,"CONNECT %s",cptr);
			*presult = stat_s64;    /* DCE_dial will report result code */
			return(0);
		}

		*presult = hdb_dial_error_text(wait_status);
		setcolor(colors_error);
		pputs(*presult);
		setcolor(colors_at_entry);
		pputc('\n');
		lflash_dtr();
	}
	else
	{
		pprintf("using Dialers entry '%s'\n",tdle->name);
		expresp_verbosity = (proc_level & proctrace) ? proctrace : 0;
		if(execute_expresp(tdle->script))
		{
			*presult = "DIALER SCRIPT FAILED";
			setcolor(colors_error);
			pputs(*presult);
			setcolor(colors_at_entry);
			pputc('\n');
			iv[0] = 1;
		}
		else
		{
			extern char last_Speed_result[];
			if(last_Speed_result[0])
				*presult = last_Speed_result;
			else
			{
				sprintf(stat_s64,"CONNECT %u",shm->Lbaud);
				*presult = stat_s64;	/* DCE_dial will report result code */
			}
			setcolor(colors_at_entry);
			iv[0] = 0;
		}
	}

	/*
	 * restart receiver if we killed it
	 */
	if(rcvr_restart)
		start_rcvr_process(1);

	return((int)iv[0]);

}	/* end of hdb_dial */

/*+-------------------------------------------------------------------------
	hdb_init() - initialize HoneyDanBerInterface
--------------------------------------------------------------------------*/
void
hdb_init()
{
	char *hdblibdir = HDBLIBDIR;		/* system independent location */
	int itmp;
	int buflen = strlen(hdblibdir) + 64;
	char *emsg = "hdb_init memory allocation failed!\n";

	if(!(Devices_file = malloc(buflen)))
	{
		pputs(emsg);
		termecu(TERMECU_MALLOC);
	}
	strcpy(Devices_file,hdblibdir);
	strcat(Devices_file,"/Devices");

	if(!(Dialers_file = malloc(buflen)))
	{
		pputs(emsg);
		termecu(TERMECU_MALLOC);
	}
	for(itmp = 0; itmp < UNGETTY_LIST_MAX; itmp++)
	{
		if(!(ungetty_list[itmp] = malloc(64)))
		{
			pputs(emsg);
			termecu(TERMECU_MALLOC);
		}
	}
	strcpy(Dialers_file,hdblibdir);
	strcat(Dialers_file,"/Dialers");

	if(!(Dialcodes_file = malloc(buflen)))
	{
		pputs(emsg);
		termecu(TERMECU_MALLOC);
	}
	strcpy(Dialcodes_file,hdblibdir);
	strcat(Dialcodes_file,"/Dialcodes");

	there_is_hdb_on_this_machine = !access(Devices_file,4);

}	/* end of hdb_init */

/*+-------------------------------------------------------------------------
dialcodes_translate(phone)  -  translate first part of phone using Dialcodes
--------------------------------------------------------------------------*/
char *
dialcodes_translate(phone)
char **phone;
{
	FILE *f;
	int itmp;
#define MAX_DLC_TOKENS 2
	char *tokens[MAX_DLC_TOKENS];
	static char dlstr[128];

	if(!(f = fopen(Dialcodes_file, "r")))
		return("");

	while(fgets(dlstr,sizeof(dlstr),f))
	{
		if(((itmp = strlen(dlstr)) > 0) && (dlstr[itmp - 1] == '\n'))
			dlstr[--itmp] = 0;
		if((dlstr[0] == '#') || (dlstr[0] == ' ') || (!itmp))
			continue;
		if(tokens[0] = arg_token(dlstr," \t\r\n"))
		{
			if (!(tokens[1] = arg_token((char *)0," \t\r\n")))
				tokens[1] = "";
			itmp = strlen(tokens[0]);
			if (strncmp(*phone, tokens[0], itmp))
				continue;
			fclose(f);
			*phone += itmp;
			fclose(f);
			return(tokens[1]);
		}
		break;
	}

	fclose(f);
	return("");
}

/*+-------------------------------------------------------------------------
      strip_phone_num(sptr) - remove junk characters from phone
--------------------------------------------------------------------------*/
char *
strip_phone_num(sptr)
char *sptr;
{
	static char stripped_num[64];
	char *dptr;

	dptr = stripped_num;
	while(*sptr)
	{
		if((*sptr == '(') || (*sptr == ')')
#if defined(WHT) || defined(STRIP_TELNO_HYPHENS)
			|| (*sptr == '-')	/* some want '-' for pauses; I use ',' */
#endif
			)
		{
			sptr++;
			continue;
		}
		*dptr++ = *sptr++;
	}
	*dptr = 0;

	return(stripped_num);
}

/* vi: set tabstop=4 shiftwidth=4: */
/* end of hdbintf.c */
