/*+-------------------------------------------------------------------------
    gint.c - ecu get integer parameter functions
	wht@n4hgf.Mt-Park.GA.US

  Defined functions:
	gcol_range(param,col1,col2)
	gint(param,int_returned)
	gint_base(param,value)
	gint_constant(param,value)
	gintop(param,intop)

--------------------------------------------------------------------------*/
/*+:EDITS:*/
/*:09-10-1992-13:59-wht@n4hgf-ECU release 3.20 */
/*:08-22-1992-15:39-wht@n4hgf-ECU release 3.20 BETA */
/*:07-25-1991-12:58-wht@n4hgf-ECU release 3.10 */
/*:01-31-1991-16:50-wht@n4hgf-reinstate octal with 0o prefix */
/*:01-09-1991-22:31-wht@n4hgf-ISC port */
/*:08-14-1990-20:40-wht@n4hgf-ecu3.00-flush old edit history */

#include "ecu.h"
#include "ecuerror.h"
#include "esd.h"
#include "var.h"

#define OP_ADD      1
#define OP_SUB      2
#define OP_MUL      3
#define OP_DIV      4
#define OP_XOR      5
#define OP_MOD      6
#define OP_OR       7
#define OP_AND      8

#define BASE_DEC	1
#define BASE_OCT	2
#define BASE_HEX  	3


/*+-------------------------------------------------------------------------
    gint_constant(param,int_returned) - evaluate integer constant
--------------------------------------------------------------------------*/
int
gint_constant(param,value)
ESD *param;
long *value;
{
register itmp;
int base = BASE_DEC;
int erc;
long new_value;

	if(erc = skip_cmd_break(param))
		return(erc);
	esd_null_terminate(param);

/* get integer from string */
	if((!strncmp(param->pb + param->index,"0x",2)) ||
		(!strncmp(param->pb + param->index,"0X",2)))
	{
		base = BASE_HEX;
		param->index += 2;
	}
	else if((!strncmp(param->pb + param->index,"0o",2)) ||
		(!strncmp(param->pb + param->index,"0O",2)))
	{
		base = BASE_OCT;
		param->index += 2;
	}

	param->old_index = param->index;
	switch(base)
	{
		case BASE_HEX:
			sscanf(param->pb + param->index,"%lx",&new_value);
			itmp = param->index + strspn(param->pb + param->index,
				"0123456789ABCDEFabcdef");
			erc = eInvalidHexNumber;
			break;
		case BASE_DEC:
			sscanf(param->pb + param->index,"%ld",&new_value);
			itmp = param->index + strspn(param->pb + param->index,"0123456789");
			erc = eInvalidDecNumber;
			break;
		case BASE_OCT:
			sscanf(param->pb + param->index,"%lo",&new_value);
			itmp = param->index + strspn(param->pb + param->index,"01234567");
			erc = eInvalidOctNumber;
			break;
		default:
			return(eInternalLogicError);
	}

	param->index = itmp;
	if(isalnum(*(param->pb + itmp)))
		param->old_index = itmp;

	if(param->old_index != param->index)
	{
		*value = new_value;
		return(0);
	}
	return(erc);

}   /* end of gint_constant */

/*+-------------------------------------------------------------------------
    gint_base(param,value) - evaluate integer constant, variable or function
--------------------------------------------------------------------------*/
int
gint_base(param,value)
ESD *param;
long *value;
{
register erc;
long *varptr;

	if(erc = skip_cmd_break(param))
		return(erc);

	switch(param->pb[param->index])		/* look at first character */
	{
		case '$':		/* '$i...' variable reference? */
			if(param->index >= param->cb-2)
				return(eSyntaxError);
			param->old_index = ++param->index;
			if(to_lower(param->pb[param->index++]) != 'i')
				return(eIllegalVarType);
			if(erc = get_ivptr(param,&varptr,0))
				return(erc);
			*value = *varptr;	
			return(0);

		case '%':		/* '%...' function reference? */
			param->index++;
			if(erc = feval_int(param,value))
				return(erc);
			return(0);

		default:
			break;
	}   /* end of switch statement */

/* we did not catch any special cases with the switch statement must
be numeric integer */

	return(gint_constant(param,value));

}   /* end of gint_base() */

/*+-------------------------------------------------------------------------
    gintop(param,intop) - evaluate integer operator
--------------------------------------------------------------------------*/
int
gintop(param,intop)
ESD *param;
int *intop;
{
	register erc;

	if(erc = skip_cmd_break(param))
		return(erc);
	switch(param->pb[param->index])
	{
		case '+':
			param->index++;
			*intop = OP_ADD;
			break;

		case '-':
			param->index++;
			*intop = OP_SUB;
			break;

		case '*':
			param->index++;
			*intop = OP_MUL;
			break;

		case '/':
			param->index++;
			*intop = OP_DIV;
			break;

		case '|':
			if(*(param->pb + param->index + 1) == '|')
				return(eInvalidIntOp);
			param->index++;
			*intop = OP_OR;
			break;

		case '@':
			param->index++;
			*intop = OP_MOD;
			break;

		case '^':
			param->index++;
			*intop = OP_XOR;
			break;

		case '&':
			if(*(param->pb + param->index + 1) == '&')
				return(eInvalidIntOp);
			param->index++;
			*intop = OP_AND;
			break;

		default:
			return(eInvalidIntOp);
	}   /* end of switch statement */

	return(0);

}   /* end of gintop() */

/*+-------------------------------------------------------------------------
    gint(param,int_returned) - evaluate integer expression
--------------------------------------------------------------------------*/
int
gint(param,int_returned)
ESD *param;
long *int_returned;
{
register erc;
long int1;
long int_accum = 0;
int intop;
int unary_minus = 0;

	if(erc = skip_cmd_break(param))
		return(erc);
	if(param->pb[param->index] == '-')
		unary_minus++,param->index++;

	if(erc = gint_base(param,&int1))
		return(erc);
	int_accum = (unary_minus) ? -int1 : int1;

	while((erc = gintop(param,&intop)) == 0)
	{
		if(erc = gint_base(param,&int1))
			return(erc);
		switch(intop)
		{
			case OP_ADD:
				int_accum += int1;
				break;
			case OP_SUB:
				int_accum -= int1;
				break;
			case OP_MUL:
				int_accum *= int1;
				break;
			case OP_DIV:
				int_accum /= int1;
				break;
			case OP_MOD:
				int_accum %= int1;
				break;
			case OP_XOR:
				int_accum ^= (unsigned)int1;
				break;
			case OP_AND:
				int_accum &= (unsigned)int1;
				break;
			case OP_OR:
				int_accum |= (unsigned)int1;
				break;
			default:
				return(eInvalidIntOp);
		}
	}
	param->index = param->old_index;

	*int_returned = int_accum;
	return(0);
}   /* end of gint() */

/*+-------------------------------------------------------------------------
    col_range(param,col1,col2) - get a column range
:$i0[-$i1]
argument may be integer constant, function or variable, but not expression
--------------------------------------------------------------------------*/
int
gcol_range(param,col1,col2)
ESD *param;
ulong *col1;
ulong *col2;
{
	register erc;

	if(skip_cmd_char(param,':') == 0)
	{
		if(erc = gint_base(param,col1))
			return(erc);

		if(skip_cmd_char(param,'-') == 0)     /* if hyphen found, range */
		{
			if(erc = gint_base(param,col2))
				return(erc);
		}
		else
			*col2 = *col1;		/* otherwise, first and last columns same */

		if(*col1 > *col2)
		{
			pputs("Invalid column range: column 1 greater than column 2\n");
			return(eFATAL_ALREADY);
		}
	}
	else
		erc = eBadParameter;

	return(erc);
}   /* end of gcol_range() */

/* vi: set tabstop=4 shiftwidth=4: */
/* end of gint.c */
