/*+-------------------------------------------------------------------------
	ecuxkey.h -- function key single char value mapping
	wht@n4hgf.Mt-Park.GA.US

NOTE: all of these codes must be in the range 0x80 <= c <= 0xFD
International considerations make changing the ALT+[a-z] codes
unadvisable.
--------------------------------------------------------------------------*/
/*+:EDITS:*/
/*:09-17-1992-05:16-wht@n4hgf-finally, 0xE1-0xFA as promised in 3.10  */
/*:09-10-1992-13:59-wht@n4hgf-ECU release 3.20 */
/*:08-22-1992-15:38-wht@n4hgf-ECU release 3.20 BETA */
/*:03-27-1992-16:21-wht@n4hgf-re-include protection for all .h files */
/*:09-03-1991-23:16-wht@n4hgf2-alt-[a-z] starts w/0xE1: crisp compatibility */
/*:08-28-1991-14:07-wht@n4hgf2-SVR4 cleanup by aega84!lh */
/*:07-25-1991-12:57-wht@n4hgf-ECU release 3.10 */
/*:05-02-1991-01:57-r@n4hgf-alt-[a-z] range moved from 0x80-0x99 to 0xE0-0xF9 */
/*:08-14-1990-20:40-wht@n4hgf-ecu3.00-flush old edit history */

#ifndef _ecuxkey_h
#define _ecuxkey_h

/*
 * these are not changeable: they map to the last character in
 * an AT/"ANSI" function key sequence
 */

#define XFcurup		(0x80 | 'A')	/* 0xC1 */
#define XFcurdn		(0x80 | 'B')	/* 0xC2 */
#define XFcurrt		(0x80 | 'C')	/* 0xC3 */
#define XFcurlf		(0x80 | 'D')	/* 0xC4 */
#define XFcur5		(0x80 | 'E')	/* 0xC5 */
#define XFend		(0x80 | 'F')	/* 0xC6 */
#define XFpgdn		(0x80 | 'G')	/* 0xC7 */
#define XFhome		(0x80 | 'H')	/* 0xC8 */
#define XFpgup		(0x80 | 'I')	/* 0xC9 */
#define XFins		(0x80 | 'L')	/* 0xCA */
#define XF1			(0x80 | 'M')	/* 0xCB */
#define XF2			(0x80 | 'N')	/* 0xCC */
#define XF3			(0x80 | 'O')	/* 0xCD */
#define XF4			(0x80 | 'P')	/* 0xCE */
#define XF5			(0x80 | 'Q')	/* 0xCF */
#define XF6			(0x80 | 'R')	/* 0xD0 */
#define XF7			(0x80 | 'S')	/* 0xD1 */
#define XF8			(0x80 | 'T')	/* 0xD2 */
#define XF9			(0x80 | 'U')	/* 0xD3 */
#define XF10		(0x80 | 'V')	/* 0xD4 */
#define XF11		(0x80 | 'W')	/* 0xD5 */
#define XF12		(0x80 | 'X')	/* 0xD6 */
#define XFbktab		(0x80 | 'Z')	/* 0xD7 */

/*
 * special codes for non-ANSI keyboard support
 * These are really cleverly disguised magic numbers:
 * they HAVE to have the values used below.
 */
#define XF_no_way	0xFE
#define XF_not_yet	0xFF

/*
 * extended ALT+[a-z] codes
 */
#define XF_ALTA	0xE1			/* depends on /usr/lib/keyboard keys ... */
#define XF_ALTZ	((unsigned)(0xE1+'z'-'a'))	/* ... mapping ALT-a to 0xE0, etc */

#endif /* _ecuxkey_h */

/* vi: set tabstop=4 shiftwidth=4: */
/* end of ecuxkey.h */
