/*+-------------------------------------------------------------------------
	ecutcap.c -- termcap stuff
	wht@n4hgf.Mt-Park.GA.US

  Defined functions:
	tcap_blink_off()
	tcap_blink_on()
	tcap_bold_off()
	tcap_bold_on()
	tcap_clear_area_char(count,clrch)
	tcap_clear_screen()
	tcap_curbotleft()
	tcap_curleft(count)
	tcap_curright(count)
	tcap_cursor(y,x)
	tcap_delete_chars(count)
	tcap_delete_lines(count)
	tcap_draw_box(y,x,height,width,title,title_x)
	tcap_draw_box_primitive(y,x,height,width)
	tcap_eeod()
	tcap_eeol()
	tcap_gets(buf,bufsize,delim,wait_for_key)
	tcap_horiz_rule(count)
	tcap_init()
	tcap_insert_chars(count)
	tcap_insert_lines(count)
	tcap_putc(character)
	tcap_stand_end()
	tcap_stand_out()
	tcap_underscore_off()
	tcap_underscore_on()
	tcap_vbell()
	tcap_vertical_rule(y,x,count)

--------------------------------------------------------------------------*/
/*+:EDITS:*/
/*:09-10-1992-13:59-wht@n4hgf-ECU release 3.20 */
/*:08-22-1992-15:38-wht@n4hgf-ECU release 3.20 BETA */
/*:03-10-1992-13:25-wht@n4hgf2-quick sanity check on ttype features */
/*:02-24-1992-06:50-root@n4hgf-getenv COLUMNS not COLS */
/*:07-25-1991-12:56-wht@n4hgf-ECU release 3.10 */
/*:05-01-1991-04:05-wht@n4hgf-try to catch tbetz tc= infinite loop early */
/*:03-20-1991-16:25-root@n4hgf-environment LINES/COLS overrides termcap li/co */
/*:11-28-1990-14:52-wht@n4hgf-tcap support for non-ansi console */
/*:08-14-1990-20:40-wht@n4hgf-ecu3.00-flush old edit history */

#include "ecu.h"
#include "ecukey.h"
#include "pc_scr.h"

uint tcap_LINES;
uint tcap_COLS;

static char *tc_blink_on = "";
static char *tc_blink_off = "";
static char *tc_bold_on = "";
static char *tc_bold_off = "";
static char *tc_clear = "";
static char *tc_curleft = "";
static char *tc_curright = "";
static char *tc_delchar = "";
static char *tc_delline = "";
static char *tc_eeod = "";
static char *tc_eeol = "";
static char *tc_inschar = "";
static char *tc_insline = "";
static char *tc_move = "";
static char *tc_standout = "";
static char *tc_standend = "";
static char *tc_underscore_on = "";
static char *tc_underscore_off = "";
static char *tc_vbell = "";
static char *tc_lastline = "";
static char tc_strbuf[768];		/* absolutely blunderous overkill */
static int tc_standout_width;

char *tgetstr();
char *tgoto();
char *getenv();

void tcap_cursor();
void tcap_stand_out();
void tcap_stand_end();

/*+-------------------------------------------------------------------------
	tcap_init() - get termcap variables
--------------------------------------------------------------------------*/
void
tcap_init()
{
	char termbuf[1024];
	char *cptr;

	if(!ttype || !*ttype)
	{
		fprintf(stderr,"invalid or missing TERM environment variable\r\n");
		termecu(TERMECU_CURSES_ERROR);
	}

	if(tgetent(termbuf,ttype) > 0)
	{
		tcap_LINES = tgetnum("li");
		tcap_COLS = tgetnum("co");
#ifdef linux
		if((tcap_LINES == 25) && (strcmp(ttype,"console")==0))
			tcap_LINES = 24;
#endif
		if(cptr = getenv("LINES"))			/* environment override ... */
			tcap_LINES = atoi(cptr);		/* ... for termcap systems */
		if(cptr = getenv("COLUMNS"))
			tcap_COLS = atoi(cptr);
		if((tc_standout_width = tgetnum("sg")) < 0)
			tc_standout_width = 0;
		cptr = tc_strbuf;
		tc_standout         = tgetstr("so",&cptr);
		tc_standend         = tgetstr("se",&cptr);
		tc_clear            = tgetstr("cl",&cptr);
		tc_curleft          = tgetstr("kl",&cptr);
		tc_curright         = tgetstr("kr",&cptr);
		tc_delchar 			= tgetstr("dc",&cptr);
		tc_delline          = tgetstr("dl",&cptr);
		tc_eeod             = tgetstr("cd",&cptr);
		tc_eeol             = tgetstr("ce",&cptr);
		tc_inschar 			= tgetstr("ic",&cptr);
		tc_insline          = tgetstr("al",&cptr);
		tc_move             = tgetstr("cm",&cptr);
		tc_vbell            = tgetstr("vb",&cptr);
		tc_lastline         = tgetstr("ll",&cptr);
		tc_underscore_on    = tgetstr("us",&cptr);
		tc_underscore_off   = tgetstr("ue",&cptr);
		if(!tc_underscore_on || !tc_underscore_off)
		{
			tc_underscore_on = tc_standout;
			tc_underscore_off = tc_standend;
		}
		tc_bold_on          = tc_standout;			/* for now */
		tc_bold_off         = tc_standend;			/* for now */
		if(!tc_bold_on || !tc_bold_off)
		{
			tc_bold_on = tc_standout;
			tc_bold_off = tc_standend;
		}
		tc_blink_on         = tgetstr("mb",&cptr);	/* "XENIX extension" */
		tc_blink_off        = tgetstr("me",&cptr);	/* "XENIX extension" */
		if(!*tc_clear || !*tc_move)
		{
			fprintf(stderr,"Terminal type '%s' does not have the beef.\r\n",
				ttype);
			fprintf(stderr,"Try again with a screen-oriented terminal.\n");
			termecu(TERMECU_CURSES_ERROR);
		}
		return;
	}


	fprintf(stderr,"Cannot find terminal type '%s' or entry in error\r\n",
		ttype);
	termecu(TERMECU_CURSES_ERROR);

}	/* end of tcap_init */

/*+-------------------------------------------------------------------------
	tcap_putc(character) - utility rotuine for tputs
--------------------------------------------------------------------------*/
void
tcap_putc(character)
char character;
{
	rcvrdisp(&character,1);
}	/* end of tcap_putc */

/*+-------------------------------------------------------------------------
	tcap_horiz_rule(count) - horizontal rule starting at current position
--------------------------------------------------------------------------*/
void
tcap_horiz_rule(count)
register count;
{
	while(count--)
		tcap_putc(sHR);
	rcvrdisp_actual2();
}	/* end of tcap_horiz_rule */

/*+-------------------------------------------------------------------------
	tcap_vertical_rule(y,x,count) - vertical rule starting at y,x
--------------------------------------------------------------------------*/
void
tcap_vertical_rule(y,x,count)
int y;
register x;
register count;
{

	while(count--)
	{
		tcap_cursor(y++,x);
		tcap_putc(sVR);
	}
	rcvrdisp_actual2();
		
}	/* end of tcap_vertical_rule */

/*+-------------------------------------------------------------------------
	tcap_draw_box_primitive(y,x,height,width) - ruled box
--------------------------------------------------------------------------*/
void
tcap_draw_box_primitive(y,x,height,width)
register y;
int x;
int height;
int width;
{
	register i;

	tcap_cursor(y,x);
	tcap_putc(sTL);
	if((i = width - 2) > 0)
		tcap_horiz_rule(i);
	tcap_putc(sTR);
	if((i = height - 2) > 0)
	{
		tcap_vertical_rule(y + 1,x + width - 1,i);
		tcap_vertical_rule(y + 1,x,i);
	}
	tcap_cursor(y + height - 1,x);
	tcap_putc(sBL);
	if((i = width - 2) > 0)
		tcap_horiz_rule(i);
	tcap_putc(sBR);
	rcvrdisp_actual2();

}	/* end of tcap_draw_box_primitive */

/*+-------------------------------------------------------------------------
	tcap_draw_box(y,x,height,width,title,title_x)
--------------------------------------------------------------------------*/
void
tcap_draw_box(y,x,height,width,title,title_x)
int y;
int x;
int height;
int width;
char *title;
int title_x;
{
	register stand = (title_x < 0);

	if(stand)
		title_x = -title_x;

	tcap_draw_box_primitive(y,x,height,width);
	tcap_cursor(y,x + title_x);
	tcap_putc('[');
	if(stand)
		tcap_stand_out();
	ff(se," %s ",title);
	if(stand)
		tcap_stand_end();
	tcap_putc(']');
	rcvrdisp_actual2();

}	/* end of tcap_draw_box */

/*+-------------------------------------------------------------------------
	tcap_cursor(y,x)
--------------------------------------------------------------------------*/
void
tcap_cursor(y,x)
uint y;
uint x;
{
	if(y >= tcap_LINES)
		y = tcap_LINES - 1;
	if(x >= tcap_COLS)
		x = tcap_COLS - 1;
	tputs(tgoto(tc_move,x,y),1,tcap_putc);
	rcvrdisp_actual2();

}	/* end of tcap_cursor */

/*+-------------------------------------------------------------------------
	tcap_curleft(count) - move cursor left
--------------------------------------------------------------------------*/
void
tcap_curleft(count)
register count;
{
	while(count--)
		tputs(tc_curleft);
	rcvrdisp_actual2();
}	/* end of tcap_curleft */

/*+-------------------------------------------------------------------------
	tcap_curright(count) - move cursor right
--------------------------------------------------------------------------*/
void
tcap_curright(count)
register count;
{
	while(count--)
		tputs(tc_curright);
	rcvrdisp_actual2();
}	/* end of tcap_curright */

/*+-------------------------------------------------------------------------
	tcap_curbotleft()
--------------------------------------------------------------------------*/
void
tcap_curbotleft()
{
	tcap_cursor(tcap_LINES - 1,0);
}	/* end of tcap_curbotleft */

/*+-------------------------------------------------------------------------
	tcap_insert_lines(count)
--------------------------------------------------------------------------*/
void
tcap_insert_lines(count)
register count;
{
	if(count && *tc_insline)
	{
		while(count--)
			tputs(tc_insline,1,tcap_putc);
		rcvrdisp_actual2();
	}
}	/* end of tcap_insert_lines */

/*+-------------------------------------------------------------------------
	tcap_delete_lines(count)
--------------------------------------------------------------------------*/
void
tcap_delete_lines(count)
register count;
{
	if(count && *tc_delline)
	{
		while(count--)
			tputs(tc_delline,1,tcap_putc);
		rcvrdisp_actual2();
	}
}	/* end of tcap_delete_lines */

/*+-------------------------------------------------------------------------
	tcap_insert_chars(count)
--------------------------------------------------------------------------*/
void
tcap_insert_chars(count)
register count;
{
	if(count && *tc_inschar)
	{
		while(count--)
			tputs(tc_inschar,1,tcap_putc);
		rcvrdisp_actual2();
	}
}	/* end of tcap_insert_chars */

/*+-------------------------------------------------------------------------
	tcap_delete_chars(count)
--------------------------------------------------------------------------*/
void
tcap_delete_chars(count)
register count;
{
	if(count && *tc_delchar)
	{
		while(count--)
			tputs(tc_delchar,1,tcap_putc);
		rcvrdisp_actual2();
	}
}	/* end of tcap_delete_chars */

/*+-------------------------------------------------------------------------
	tcap_vbell() - output visual bell
--------------------------------------------------------------------------*/
void
tcap_vbell()
{
	if(*tc_vbell)
	{
		tputs(tc_vbell,1,tcap_putc);
		rcvrdisp_actual2();
	}
}	/* end of tcap_vbell */

/*+-------------------------------------------------------------------------
	tcap_clear_screen()
--------------------------------------------------------------------------*/
void
tcap_clear_screen()
{
	if(*tc_clear)
	{
		tputs(tc_clear,1,tcap_putc);
		rcvrdisp_actual2();
	}
}	/* end of tcap_clear_screen */

/*+-------------------------------------------------------------------------
	tcap_eeol() - erase to end of line
--------------------------------------------------------------------------*/
void
tcap_eeol()
{
	if(*tc_eeol)
	{
		tputs(tc_eeol,1,tcap_putc);
		rcvrdisp_actual2();
	}
}	/* end of tcap_eeol */

/*+-------------------------------------------------------------------------
	tcap_eeod() - erase to end of display
--------------------------------------------------------------------------*/
void
tcap_eeod()
{
	if(*tc_eeod)
	{
		tputs(tc_eeod,1,tcap_putc);
		rcvrdisp_actual2();
	}
}	/* end of tcap_eeod */

/*+-------------------------------------------------------------------------
	tcap_stand_out()
--------------------------------------------------------------------------*/
void
tcap_stand_out()
{
	if(*tc_standout) /*  && (tc_standout_width == 0)) */
	{
		tputs(tc_standout,1,tcap_putc);
		rcvrdisp_actual2();
	}
}	/* end of tcap_stand_out */

/*+-------------------------------------------------------------------------
	tcap_stand_end()
--------------------------------------------------------------------------*/
void
tcap_stand_end()
{
	if(*tc_standend) /* && (tc_standout_width == 0)) */
	{
		tputs(tc_standend,1,tcap_putc);
		rcvrdisp_actual2();
	}
}	/* end of tcap_stand_end */

/*+-------------------------------------------------------------------------
	tcap_bold_on()
--------------------------------------------------------------------------*/
void
tcap_bold_on()
{
	if(*tc_bold_on)
		tputs(tc_bold_on,1,tcap_putc);
	else if(*tc_standout) /*  && (tc_standout_width == 0)) */
		tputs(tc_standout,1,tcap_putc);
	rcvrdisp_actual2();
}	/* end of tcap_bold_on */

/*+-------------------------------------------------------------------------
	tcap_bold_off()
--------------------------------------------------------------------------*/
void
tcap_bold_off()
{
	if(*tc_bold_off)
		tputs(tc_bold_off,1,tcap_putc);
	else if(*tc_standend) /* && (tc_standout_width == 0)) */
		tputs(tc_standend,1,tcap_putc);
	rcvrdisp_actual2();
}	/* end of tcap_bold_off */

/*+-------------------------------------------------------------------------
	tcap_underscore_on()
--------------------------------------------------------------------------*/
void
tcap_underscore_on()
{
	if(*tc_underscore_on)
		tputs(tc_underscore_on,1,tcap_putc);
	else if(*tc_standout) /*  && (tc_standout_width == 0)) */
		tputs(tc_standout,1,tcap_putc);
	rcvrdisp_actual2();
}	/* end of tcap_underscore_on */

/*+-------------------------------------------------------------------------
	tcap_underscore_off()
--------------------------------------------------------------------------*/
void
tcap_underscore_off()
{
	if(*tc_underscore_off)
		tputs(tc_underscore_off,1,tcap_putc);
	else if(*tc_standend) /* && (tc_standout_width == 0)) */
		tputs(tc_standend,1,tcap_putc);
	rcvrdisp_actual2();
}	/* end of tcap_underscore_off */

/*+-------------------------------------------------------------------------
	tcap_blink_on()
--------------------------------------------------------------------------*/
void
tcap_blink_on()
{
	if(*tc_blink_on)
		tputs(tc_blink_on,1,tcap_putc);
	else if(*tc_standout) /*  && (tc_standout_width == 0)) */
		tputs(tc_standout,1,tcap_putc);
	rcvrdisp_actual2();
}	/* end of tcap_blink_on */

/*+-------------------------------------------------------------------------
	tcap_blink_off()
--------------------------------------------------------------------------*/
void
tcap_blink_off()
{
	if(*tc_blink_off)
		tputs(tc_blink_off,1,tcap_putc);
	else if(*tc_standend) /* && (tc_standout_width == 0)) */
		tputs(tc_standend,1,tcap_putc);
	rcvrdisp_actual2();
}	/* end of tcap_blink_off */

/*+-------------------------------------------------------------------------
	tcap_clear_area_char(count,clrch)
--------------------------------------------------------------------------*/
void
tcap_clear_area_char(count,clrch)
register count;
register clrch;
{
	register itmp = count;

	while(itmp--)
		tcap_putc(clrch);
	itmp = count;
	while(itmp--)
		tputs(tc_curleft);
	rcvrdisp_actual2();

}	/* end of tcap_clear_area_char */

#ifdef linux
/*+-------------------------------------------------------------------------
   tcap_restore_con()
   Linux normally has a screen size of 25, this does not work with ecu's
   vt100 emulation, so the init sequence esc [1;24r must be in the funckeymap
   file.  However this needs to be changed back before we leave, or else the
   system doesn't work.  The lastline (ll) termcap entry includes this
   sequence, so we do not need to check terminal type.  Going to the last
   line will not hurt on other terminal types.
--------------------------------------------------------------------------*/
void
tcap_restore_con()
{
	if(*tc_lastline) 
		fputs(tc_lastline,stderr);
}	/* end of tcap_restore_con */
#endif /* Linux */

/* end of ecutcap.c */
/* vi: set tabstop=4 shiftwidth=4: */
