/*+-----------------------------------------------------------------------
	ecupde.h - phone directory entry definition
	wht@n4hgf.Mt-Park.GA.US
------------------------------------------------------------------------*/
/*+:EDITS:*/
/*:09-10-1992-13:58-wht@n4hgf-ECU release 3.20 */
/*:08-22-1992-15:38-wht@n4hgf-ECU release 3.20 BETA */
/*:03-27-1992-16:21-wht@n4hgf-re-include protection for all .h files */
/*:11-28-1991-14:56-wht@n4hgf-add dcdwatch */
/*:07-25-1991-12:56-wht@n4hgf-ECU release 3.10 */
/*:06-01-1991-23:53-wht@n4hgf-use PDE_..._LEN identifiers */
/*:08-14-1990-20:40-wht@n4hgf-ecu3.00-flush old edit history */

#ifndef _ecupde_h
#define _ecupde_h

#define PDE_TTY_LEN			15
#define PDE_DESCR_LEN		40

#ifdef futures
#define PDE_FC_NONE			0	/* no FAS: none   FAS: RTS/CTS */
#define PDE_FC_XON_XOFF		1	/* XON/XOFF */
#define PDE_FC_RTS_CTS		2	/* no FAS: SCO RTS/CTS */
#endif

typedef struct phone_directory_entry
{
	struct phone_directory_entry *next;
	struct phone_directory_entry *prev;
	uint baud;				
	short parity;						/* 0,'e','o', maybe 'm','s' */
	ushort redial;						/* if non-zero, marked for redial */
	char logical[DESTREF_LEN + 1];	/* logical name of remote */
	char telno[DESTREF_LEN + 1];		/* telno for remote or null */
	char tty[PDE_TTY_LEN + 1];			/* ttyname for access */
	char descr[PDE_DESCR_LEN + 1];		/* description of remote */
#ifdef futures
	uint zwindw_size;					/* default ZMODEM window size */
	uchar flow_control;					/* PDE_FC_... flow control */
#endif
	uchar debug_level;					/* -x debug level for dialer */
	uchar dcdwatch;			/*
							 * how to set shm->Ldcdwatch on successful connect
							 * '0': off
							 * '1': on
							 * 't': terminate
							 * 'n': no change
							 */
}	PDE;

#endif /* _ecupde_h */

/* vi: set tabstop=4 shiftwidth=4: */
/* end of ecupde.h */
