/*
# $Header: /home/ralph/progs/worktimer-1.3/RCS/worktimer.h,v 1.2 1997/08/24 18:38:18 ralph Exp ralph $
# $Date: 1997/08/24 18:38:18 $
# $Author: ralph $
# $Log: worktimer.h,v $
# Revision 1.2  1997/08/24 18:38:18  ralph
# Added information to UNIX usage directions.
#
# Revision 1.1  1997/08/24 18:29:48  ralph
# Initial revision
#
*/

/************************************************************
* File: worktimer.h 08-24-97 14:32:56.77
* Copyright (C) 1997 Ralph L. Meyer - R & R Computing Services
* 39 Nelson Ave. Spotswood, NJ 08884
* 
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or (at your option) any later version.
*   
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* 
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
*   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
* 
* Send bug reports or suggestions to:
* meyer@princeton.edu OR
* R. L. Meyer, 39 Nelson Ave., Spotswood, NJ 08884 
**************************************************************/
 

#ifndef WORKTIMERHDR
#define WORKTIMERHDR

 /* Filenames, paths, for files worklog.C uses: */
 /* Unix filenames: */
#ifdef	OS_UNIX
#define HOMEDIR "HOME"
#define PROJECTFILENAME "worktimer.projects"	    //presently unused
#define TMPFILENAME  "worktimer.temp"
#define TIMESHEETNAME "worktimer.timesheet"      //user readable timesheet file
#define SSTIMESHEETNAME "worktimer.spreadsheet"  //spreadsheet filename-file for importation to spreadsheets- comma and quoteation mark delimited fields
#define FILENMLEN 120			/* Length of allowable filename path */
char TMPFILE[FILENMLEN];		/* Path to $HOME/temporary file, etc.: */
char TIMESHEET[FILENMLEN];		/* Use these names with home directory concatenated to them */
char SSTIMESHEET[FILENMLEN];
#endif

 //DOS filenames:
#ifdef	OS_DOS
#define PROJECTFILE "c:\\worklog.prj"	//presently unused
#define TMPFILE  "c:\\worklog.tmp"
#define TIMESHEET "c:\\worklog.tms"    //user readable timesheet file
#define SSTIMESHEET "c:\\worklog.sst"  //spreadsheet filename-file for importation to spreadsheets- comma and quoteation mark delimited fields

/*the filenames only, without path: */
#define PROJFILENAME "worklog.prj"
#define TIMESHTNAME "worklog.tms"
#endif

//#defines:- various time relationships:
const unsigned long SECSINMIN = 60;
const unsigned long SECSINHOUR = 3600; /* number of seconds in an hour */
const unsigned long SECSINDAY = 86400; /* number of seconds in a day */
const unsigned long SECSINYEAR = 31536000; /* number of seconds in normal year */
const unsigned long SECSINLEAPYEAR = 31622400; /* number of seconds in a leap year */
#define MINSINHOUR	60 /* number of minutes in an hour */
#define HOURSINYEAR 8760 /* number of hours in a year */
#define HOURSINLEAPYEAR 8784 /* number of hours in a leap year */
#define HOURSINDAY	24 // number of hours in a day
#define DAYSINYEAR	365 //number of days in a year
#define DAYSINLEAPYEAR	366 /* number of days in a leap year*/

 /* LEAP YEARS:  (1972 + n) % 4 */
#define STARTYEAR 1970 /* Year second counting begins */
#define LEAPYEAR1 1972 /* first leap year in year range */

/* VARIOUS DEFINES: */
#define INBFRSZ	120 /* size of the read-in buffer for lines in the project file - longest lines permitted*/
#define TIMESTRSZ 9	//size of the string to hold an input time string of the form HH:MM:SS
#define USENEWNAME	1	//return for user instructions to indicate to use new name
#define DONE		1	//indicate something is completed

/* My Standard boolean type definition */
typedef enum {NO=0,YES=1,NOTOK=0,OK=1,FAIL=0,FAILURE=0,SUCCESS=1,SUCCEED=1,INVALID=0,VALID=1,UNLOCKED=2,LOCKED=3,UNPOSTED=0,POSTED=1,UNAUDITED=0,AUDITED=1} Bool;


#ifdef OS_UNIX
#define USAGE "Usage:\n\
  worktimer ActivityName[Enter]  worktimer -on[Enter]\n\
  worktimer -off[Enter]		      worktimer -off ActivityName[Enter]\n\
  worktimer -c[Enter]            worktimer -i[Enter]\n\
  worktimer -t HH:MM:SS ActivityName[Enter]   worktimer -h[Enter]\n\
\'ActivityName\' names the activity you wish to time.  Worktimer appends the\n\
date, time, and time elapsed of an activity timed to a file in the user's $HOME\n\
directory named worktimer.timesheet.	It creates this file if none is present.\n\
\'worktimer -on\' starts timing without an \'ActivityName\', but an \'ActivityName\'\n\
must be supplied to turn worktimer off, recording the activity. \'worktimer -off\'\n\
turns timing off and records the activity named when worktimer was turned on.\n\
\'worktimer -off ActivityName\' is used when turning off timing if \'worktimer -on\'\n\
was used to start timing. \'worktimer ActivityName\' will work as well in this\n\
case.  \'worktimer -c Comment\' puts a comment in the record. \'worktimer -i\' puts\n\
on screen information on the activity that is presently being timed.\n\
\'worktimer -t HH:MM:SS ActivityName\' considers the time HH:MM:SS the length of\n\
time spent working on the activity named, and records that.\n\
  Note that an \'ActivityName\' can contain blanks and up to 120 characters.\n\
  Worktimer is not a daemon, but operates by saving start time, date, and activity\n\
information in the file $HOME/worktimer.temp which it creates on startup and\n\
deletes when \'turned off\'.  If one activity is being timed and worktimer is\n\
called with another \'ActivityName\', Worktimer records the activity already being\n\
timed and resets itself, starting to time the new activity named.\n\
  Worktimer also creates a spreadsheet/database importable file:\n\
\'worktimer.spreadsheet\' in which fields are separated by quotation marks\n\
and commas: \"field\",\"field\", etc.\n"
#endif

#ifdef OS_DOS
#define USAGE "Usage:\n\
  WORKLOG ActivityName[Enter]  WORKLOG /on[Enter]\n\
  WORKLOG /off[Enter]          WORKLOG /off ActivityName[Enter]\n\
  WORKLOG /c[Enter]            WORKLOG /i[Enter]\n\
  WORKLOG /t HH:MM:SS ActivityName[Enter\n\
\'ActivityName\' names the activity you wish to time.  WORKLOG appends the\n\
date, time, and time elapsed of an activity timed to a file in the C:\\\n\
directory named WORKLOG.TMS.  It creates this file if none is present.\n\
\'WORKLOG on\' starts timing without an \'ActivityName\', but an \'ActivityName\'\n\
must be supplied to turn worklog off, recording the activity. \'WORKLOG off\'\n\
turns timing off and records the activity named when worklog was turned on.\n\
\'WORKLOG off ActivityName\' is used when turning off timing if \'WORKLOG on\'\n\
was used to start timing. \'WORKLOG ActivityName\' will work as well in this\n\
case.  \'WORKLOG comment\' puts a comment in the record. \'WORKLOG info\' puts\n\
on screen information on the activity that is presently being timed.\n\
\'WORKLOG /t HH:MM:SS ActivityName\' considers the time HH:MM:SS the length of\n\
time spent working on the activity named, and records that.\n\
  Note that an \'ActivityName\' can contain blanks and up to 120 characters.\n\
  WORKLOG is not a TSR, but operates by saving start time, date, and activity\n\
information in the file C:\\WORKLOG.TMP which it creates on startup and\n\
deletes when \'turned off\'.  If one activity is being timed and WORKLOG is\n\
called with another \'ActivityName\', Worklog records the activity already being\n\
timed and resets itself, starting to time the new activity named.\n\
  WORKLOG also creates a spreadsheet/database importable file: WORKLOG.SST in\n\
which fields are separated by quotation marks and commas: \"field\",\"field\".\n\
etc.\n"
#endif


/*enumeration to indicate nature of temporary file */
enum tempFilNature {
	NOTEMPFIL,		/* timer is not turned on */
	REGTEMPFIL,		/* regular temporary file with a project/activity name */
	ONTEMPFIL		/*temporary file containing only the word `on' */
};

/* String Tables: */

// Error String table:
enum ERRORS { //names of errors to use to call up error strings from following table:
	NOPROJECTFILE,
	INVALIDPROJFILE,
	INVALIDENTRY,
	NOCOMMENTPRESENT,
	TIMERALREADYON,
	OFFNOPROJNAMED,
	TIMERNOTSTARTED,
	TIMEROFFFORCOMMENT,
	TIMERONALREADY,
	TIMEBUTNOACTIVITY,
	INVALIDTIMESTRING,
	INVALIDTIMECALLPARAMS,
	INVALIDTIMECALLTIMERON,
	INVALIDINFOCALL,
   FILEERROR
};

#ifdef OS_UNIX
char *errString[] = { //error strings program uses:
	"ERROR: No worktimer.projects file was found.\n\rPlease create the worktimer.projects file before running worktimer.\n\r",
	"ERROR: Invalid or empty project file.",
	"Invalid choice made.  Please enter the letter of the project chosen.\n\r",
	"ERROR: Cannot add a comment without a comment to add!\n",
	"ERROR: Timer is already on. To record an activity,\n   try again, naming the activity.\n\r",
	"ERROR: Timer on with no activity named. Turn timer off naming activity.\n\r",
	"ERROR: Timer not started. Timer must be started to turn timer off.\n\r",
	"ERROR: Timer is off.  Timer must be running to add comment.\n",
	"ERROR: Timer is on already.  Check activity being timed with \'WORKTIMER /i\'.\n\
		To add time for a different activity, turn timer off first (\'WORKTIMER /off\').\n",
	"ERROR: No activity named for time spent.  To record, state both time\n\
		and activity. (\'WORKTIMER /t HH:MM:SS activity to record\')\n",
	"ERROR: Invalid time string.  Please reenter with a valid time string.\n\
		(\'HH:MM:SS\')\n",
	"ERROR: Invalid /t switch use: Too few parameters.\nUSAGE: \'WORKTIMER /t HH:MM:SS ActivityName\'\n",
	"ERROR: Invalid /t switch use: Timer already on.\n       Turn timer off and try again.\n",
	"ERROR: Cannot call for information with a comment. Use \'WORKTIMER /i\' alone.\n",
   "ERROR: File error. Could not open file.\n"
};
#endif

#ifdef OS_DOS
char *errString[] = { //error strings program uses:
   "ERROR: No worklog.projects file was found.\n\rPlease create the worklog.projects file before running worklog.\n\r",
   "ERROR: Invalid or empty project file.",
   "Invalid choice made.  Please enter the letter of the project chosen.\n\r",
   "ERROR: Cannot add a comment without a comment to add!\n",
   "ERROR: Timer is already on. To record an activity,\n   try again, naming the activity.\n\r",
   "ERROR: Timer on with no activity named. Turn timer off naming activity.\n\r",
   "ERROR: Timer not started. Timer must be started to turn timer off.\n\r",
   "ERROR: Timer is off.  Timer must be running to add comment.\n",
   "ERROR: Timer is on already.  Check activity being timed with \'WORKLOG /i\'.\n\
      To add time for a different activity, turn timer off first (\'WORKLOG /off\').\n",
   "ERROR: No activity named for time spent.  To record, state both time\n\
      and activity. (\'WORKLOG /t HH:MM:SS activity to record\')\n",
   "ERROR: Invalid time string.  Please reenter with a valid time string.\n\
      (\'HH:MM:SS\')\n",
   "ERROR: Invalid /t switch use: Too few parameters.\nUSAGE: \'WORKLOG /t HH:MM:SS ActivityName\'\n",
   "ERROR: Invalid /t switch use: Timer already on.\n       Turn timer off and try again.\n",
   "ERROR: Cannot call for information with a comment. Use \'WORKLOG /i\' alone.\n",
   "ERROR: File error. Could not open file.\n"
};
#endif

// Direction/Instruction String table:
enum DIRECTIONS { //names of instructions to use to call up instruction strings from the following table:
	COPYRIGHT,
	TIMERNOTON,
	TIMERONNOPROJNAME,
	PRESPROJNAME,
	GETPROJNAMECHOICE,
	PROJNAMETURNONINFO,
	PROJNAMETURNOFFINFO,
	PROJNAMETURNBACKONINFO
};

#ifdef OS_UNIX
char *instrStrings[] = {
	"\nWORKTIMER Version 1.3, Copyright (C) 1996 Ralph L. Meyer
	R & R Computing Services, 39 Nelson, Spotswood, NJ 08884
   WORKTIMER comes with ABSOLUTELY NO WARRANTY; for details
   see the GNU General Public License.  This is free software, 
   and you are welcome to redistribute it under certain
   conditions; See the GNU General Public License for details.",
	"Information:  The worktimer timer is not on.",
	"The timer is now on, but no activity has been named.  When you turn the timer\n\
	 off, you will have to name the activity timed.\n",
	"The timer is already timing the following activity:\n",
	"If instead you want the name you just input recorded in the\n\
	 timesheet, press \'Y\'.\nTo use the name of the activity already being timed,\n\
	 press any other key.\n",
	"The timer is now turned on and timing the following activity :",
	"The time for the project you named when you turned the timer on has\n\
	been recorded in the timesheet files.  Timer is now off.\n",
	"The timer was on.  The activity previously being timed is now recorded.\n\
	Timer is reset and now timing the activity just entered.\n",
};
#endif

#ifdef OS_DOS
char *instrStrings[] = {
   "\nWORKLOG V1.3 (c) 1995 R & R Computing Services, 39 Nelson, Spotswood, NJ 08884\n",
   "Information:  The worklog timer is not on.",
   "The timer is now on, but no activity has been named.  When you turn the timer\n\
    off, you will have to name the activity timed.\n",
   "The timer is already timing the following activity:\n",
   "If instead you want the name you just input recorded in the\n\
    timesheet, press \'Y\'.\nTo use the name of the activity already being timed,\n\
    press any other key.\n",
   "The timer is now turned on and timing the activity you just named.\n",
   "The time for the project you named when you turned the timer on has\n\
   been recorded in the timesheet files.  Timer is now off.\n",
   "The timer was on.  The activity previously being timed is now recorded.\n\
   Timer is reset and now timing the activity just entered.\n",
};
#endif

/* The following portion is unused at present.
// Printout String Table:
enum POSTRINGS { //names of print out strings to use to call printout strings from following table:
	PROJINTRO,
	STARTTASK,
	COMMENT,
	INTERIMTIME,
	ENDTASK,
	PROJTOTTIME
};

char *POStrings[] = { //printout strings table for timesheet file
	"\nWork on Project: ",  //use this string to begin STARTASK, ENDTASK strings
	" - began at (date and time): ", //use this string at start of project in timesheet file
	"\n\rAbove comment added at: ",  //string for use with interim comments - changes of work within a project
	"\n\rTime from previous comment/start: ",
	" - ended at (date and time): ",
	"Total time spent on project: "
};

FILE *pPROJFILE, *pTEMPFILE, *pTIMESHEETFILE; //File pointers for the 3 files used

char ChosenProjName[120]; //buffer to hold the project name chosen by the user for timing work

struct ProjectNm { //structure for holding list of projects and selector characters as linked list.
	char selector; //single letter for selector in menu of projects
	char *Project; //name of the project for use in menu of projects and for copying to worktimer file
	struct ProjectNm *prv; //pointer to previous member of menu
	struct ProjectNm *nxt; //pointer to next member of menu
} *top;
*/

#endif
