/*
# $Header: /home/ralph/progs/worktimer-1.3/RCS/worktimer.C,v 1.2 1997/08/24 18:37:05 ralph Exp ralph $
# $Date: 1997/08/24 18:37:05 $
# $Author: ralph $
# $Log: worktimer.C,v $
# Revision 1.2  1997/08/24 18:37:05  ralph
# Added comments and made some small cosmetic changes.
#
# Revision 1.1  1997/08/24 18:30:17  ralph
# Initial revision
#
*/

/************************************************************
* File: worktimer.C 08-24-97 14:32:36.92
* Copyright (C) 1996 Ralph L. Meyer - R & R Computing Services
* 39 Nelson Ave. Spotswood, NJ 08884
* 
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or (at your option) any later version.
*   
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* 
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
*   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
* 
* Send bug reports or suggestions to:
* meyer@princeton.edu OR
* R. L. Meyer, 39 Nelson Ave., Spotswood, NJ 08884 
**************************************************************/
 
/*
 *  NOTES:
 *  BUGS, PROBLEMS, OR IMPROVEMENTS:
 *  UNDER CONSTRUCTION 10/31/95
 *  OK math not correct on short times - line 0 seconds
 *  OK Also when off put in without a file present, strange things. because of no
 * 		 temporary file!
 *  OK Also, check out math in the get time for elapsed time file
 *  OK Put in copyright notice
 *  OK Put in the name of the project being timed in the readouts for the user.
 *  OK Put in putting in comments (will have to change writing of .TMS file from
 * 	 end of timing to start and end
 * 	  also will have to change some messages and USAGE
 * 	  will have to change parsing command line
 * OK Find out why when a single parameter is put in that could be a job name to time
 *	the timer gives an "ERROR: Cannot add a comment without a comment to add!" error message 2/18/96
 *
 *
 *  OK DOS Version 1_2:
 * 	  Enable the addition of a time for amount of time past in the form HH:MM:ss
 * 			using the switch /t - see timer.txt
 * NOTES:
 *  OK Problem: timesheet is in local directory rather than root. Correct
 *  OK Problem: timestheet in and out times the same. Correct
 *  Put in safety matters.  check for file present on 'off' etc.
 *
 * Version 1_3:
 *  Enable both /off and off, /i & info, /on and on
 *
 * UNIX/Linux Version 1.1:
 *  OK Access $HOME variable to use in filepaths for files instead of putting everything
 *     at root.
 *
 * THINGS TO DO:
 * Enable operator to start the timer with a starting time if he forgot to start the timer when he started
 *      some activity.
 */

//define the operating system for which this program will be compiled:
//#define OS_DOS
#define OS_UNIX

/* define for debugging */
// #define DEBUG

#ifdef OS_DOS
#include <time.h>
#include <stdio.h>
#include <dos.h>
#include <iostream.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#endif

#ifdef OS_UNIX
#include <sys/time.h>
#include <unistd.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>

/*
 * The following 2 structures are defined in time.h for DOS but
 * are unavailable for UNIX.	They are used throughout the program
 * which was originally written for DOS, andd are defined here with
 * instances being filled by the function
 * timeparser() when ported to UNIX(s).
 */
struct time {
	unsigned char ti_min;
	unsigned char ti_hour;
	unsigned char ti_hund;
	unsigned char ti_sec;
};

struct date {
	int  da_year;
	char da_day;
	char da_mon;
};
#endif


#include "worktimer.h"


//Advance declarations:

void createFilepaths(void);
int  getTempFile(char *comment, struct date *d, struct time *ts, time_t *t);
int  putTempFile(char *comment, struct date *d, struct time *ts, time_t *t);
int  appendStartTime(char *comment, struct date *d, struct time *ts);
int  appendComment(char *comment, struct date *d, struct time *ts);
int  appendTotalTimes(char *comment, struct date *d, struct time *ts, time_t *t);
int  appendGivenTime(char *comment, struct date *d, struct time *ts, struct time *elt, time_t *t);
int  testForTempFile(void);
void removeTempFile(void);
void timeparser(struct date *d, struct time *ts, time_t *t);
//void parseDateTimeString(char *dateString, char *timestring, struct date *d, struct time *ts); //in the works
void getElapsedTime(time_t begt,time_t endt,int *hours,int *mins, int *secs,float *hoursdec);
int  timeStrToTimeStruct(char *timeStr,struct time *timestruct);
void Usage(void);
int  getUserDirections(char *projstr);
void putInstruction(enum DIRECTIONS instrName);
char *lowerCaseString(char *stringToLc);

/*
 * This function receives arguments on the command line, parses them
 * and responds according to the commands and information given there.
 * On an invalid command, help, or no command, puts up information
 * on functionality
 */
	int
main(
	 int argc,
	 char **argv
)
{
	time_t startt;
	int year, month, day, cmtlen=0, ct, offPresent=0;
	int timePresent=0, commentPresent=0;
	char projstr[INBFRSZ], tempstr[INBFRSZ], tmrprojstr[INBFRSZ]; // name of the project being timed, and temp buffers for same
	char chkstr[INBFRSZ];
	char timestr[TIMESTRSZ];
	struct time timenow, elapsedtime;
	struct date datenow;
	int tempFile=0;  //test for presence of temporary file, and its nature
						  //0=no tempfile, 1=tempfile w/ proj string 2=tempfile w/ 'on'

	putInstruction(COPYRIGHT); //put copyright on screen

	//if there is only the program name on the command line,
	//or if the user typed a ?, or help, or -help, or -h, provide usage:
	if(argc<2||!strcmp(argv[1],"?")||!strcmp(lowerCaseString(argv[1]),"help")||!strcmp(lowerCaseString(argv[1]),"-help")||!strcmp(lowerCaseString(argv[1]),"-h")){
		Usage();
		return 1;
	}

	//initialize:
#ifdef OS_UNIX
	createFilepaths();
#endif
	strcpy(projstr,argv[1]);
	//get rid of a switch parameter in projstr:
	if(projstr[0]=='/'){
		for(ct=0;projstr[ct]>0;ct++){
			projstr[ct]=projstr[ct+1];
		}
	}
	strcpy(chkstr,lowerCaseString(argv[1])); //get first word of parameter string
	tempFile=testForTempFile(); //get: if & nature of temporary file
	timeparser(&datenow, &timenow, &startt);

	//if there is only 1 command line parameter beside the program name:
	if(argc==2) {
	    //If only timer command line parameter is '/on'
	   if (strcmp(chkstr,"/on")==0 || strcmp(chkstr,"on")==0 || strcmp(chkstr,"-on")==0){
		  if (tempFile==ONTEMPFIL){
			 puts(errString[TIMERALREADYON]);
			 return 1;
		  }
		  else if(tempFile==NOTEMPFIL){
			 putInstruction(TIMERONNOPROJNAME);
			 putTempFile(projstr, &datenow, &timenow, &startt);
			 return 0;
		  }
		  else{
			 puts(errString[TIMERALREADYON]);
			 return 1;
		  }
		}

	   //if only timer command line parameter is '/off'
	   else if(strcmp(chkstr,"/off")==0 || strcmp(chkstr,"off")==0 || strcmp(chkstr,"-off")==0){
		  if (tempFile==ONTEMPFIL){
		    puts(errString[OFFNOPROJNAMED]);
		    return 1;
		  }
		  else if (tempFile==NOTEMPFIL){
			 puts(errString[TIMERNOTSTARTED]);
			 puts(USAGE);
			 return 1;
		  }
		  else{
		    getTempFile(projstr, &datenow, &timenow, &startt);
		    appendTotalTimes(projstr, &datenow, &timenow , &startt);
		    removeTempFile();
		    putInstruction(PROJNAMETURNOFFINFO);
		    return 0;
		  }
	   }
		
		//if only timer command line parameter is /i for 'info' or 'info'
		else if(strcmp(chkstr,"/i")==0 || strcmp(chkstr,"-i")==0 || strcmp(chkstr,"info")==0){
		  if (tempFile==NOTEMPFIL){
		    putInstruction(TIMERNOTON);
		    return 0;
		  }
		  else{
		    getTempFile(projstr, &datenow, &timenow, &startt);
		    puts("Information on present activity being timed:");
		    printf("Project/Activity: %s\n",projstr);
		    printf("Time in:  %02d/%02d/%02d @ %02d:%02d:%02d.\n",datenow.da_mon,datenow.da_day,datenow.da_year,timenow.ti_hour,timenow.ti_min,timenow.ti_sec);
		    return 0;
		  }
		}
		
		// if only timer command line parameter is /c for 'comment' or 'comment'
		else if(strcmp(lowerCaseString(chkstr),"/c")==0 || strcmp(lowerCaseString(chkstr),"-c")==0 || strcmp(lowerCaseString(chkstr),"comment")==0){
		  puts(errString[NOCOMMENTPRESENT]);
		  return 1;
		}
		
		// if only timer command line parameter is '/t' or 'time' for time worked
		else if(strcmp(lowerCaseString(chkstr),"/t")==0 || strcmp(lowerCaseString(chkstr),"-t")==0 || strcmp(lowerCaseString(chkstr),"time")==0){
		  puts(errString[INVALIDTIMECALLPARAMS]);
		  return 1;
		}
		
		// otherwise take parameter as a one-word describable activity:
		else{
		  // if there's a temporary file only containing the information 'timer is on'
		  if (tempFile==ONTEMPFIL){
		    getTempFile(tmrprojstr, &datenow, &timenow, &startt);
		    appendTotalTimes(projstr, &datenow, &timenow , &startt);
		    removeTempFile();
		    putInstruction(PROJNAMETURNOFFINFO);
		    return 0;
		  }
		  // if there is no temporary file:
		  else if (tempFile==NOTEMPFIL){
		    if(putTempFile(projstr, &datenow, &timenow, &startt)){
				putInstruction(PROJNAMETURNONINFO);
				printf("%s\n\n",projstr);		  // added 6/21/97
				return 0;
		    }
		    else{
				puts(errString[FILEERROR]);
				return 1;
		    }
		  }
		  // if there is a temporary file with something being timed already:
		  else{
		    getTempFile(tmrprojstr, &datenow, &timenow, &startt);
		    appendTotalTimes(tmrprojstr, &datenow, &timenow , &startt);
		    removeTempFile();
		    putTempFile(projstr,&datenow,&timenow,&startt);
		    putInstruction(PROJNAMETURNBACKONINFO);
		    return 0;
		  }
		}
	}

	//if timer command line is longer than single word....
	if(argc>2){
	  
	  //get the project name string or entire timer command
	  for(ct=1;ct<argc&&cmtlen<INBFRSZ;ct++){
		 //if first parameter is 'off' store it only in chkstr
		 if (ct==1 && (!strcmp(lowerCaseString(argv[ct]),"/off") || !strcmp(lowerCaseString(argv[ct]),"-off"))){
			strcpy(chkstr,lowerCaseString(argv[ct]));
			offPresent=1;
		 }
		 //if first parameter is 'comment' store it only in chkstr
		 else if (ct==1 && (!strcmp(lowerCaseString(argv[ct]),"/c") || !strcmp(lowerCaseString(argv[ct]),"-c"))){
			strcpy(chkstr,lowerCaseString(argv[ct]));
			commentPresent=1;
		 }
		 //if first parameter is 'info... /i' this is an error:
		 else if (ct==1 && (!strcmp(lowerCaseString(argv[ct]),"/i") || !strcmp(lowerCaseString(argv[ct]),"-i"))){
			puts(errString[INVALIDINFOCALL]);
			return 1;
		 }
		 //if first parameter is 'time... /t'
		 else if (ct==1 && (!strcmp(lowerCaseString(argv[ct]),"/t") || !strcmp(lowerCaseString(argv[ct]),"-t"))){
			//if there are only 2 parameters, this is an error:
			if(argc==3){
			  puts(errString[INVALIDTIMECALLPARAMS]);
			  return 1;
			}
			//if an activity is already being timed, its an error:
			else if (tempFile){
			  puts(errString[INVALIDTIMECALLTIMERON]);
			  return 1;
			}
			//Otherwise treat the call as valid for the moment
			else{
			  strcpy(chkstr,lowerCaseString(argv[ct]));
			  timePresent=1;
			  strcpy(timestr,argv[++ct]);
			}
		 }
		 //otherwise store first word of parameter in projstr as part of proj name
		 else if (ct==1){
			strcpy(projstr,argv[ct]);
			cmtlen=strlen(argv[ct]);
		 }
		 //then continue loading proj name string:
		 else{
			if (((offPresent || commentPresent) && ct==2) || (timePresent && ct==3)){
			  cmtlen+=strlen(argv[ct]);
			  if(cmtlen<INBFRSZ)strcpy(projstr,argv[ct]);
			}
			else{
			  cmtlen+=strlen(argv[ct])+1;
			  if(cmtlen<INBFRSZ)strcat(projstr," ");
			  if(cmtlen<INBFRSZ)strcat(projstr,argv[ct]);
			}
		 }
	  }//end of getting project name string
	  
	  //if timer command line is "timer off project/activityname":
	  if(offPresent){
		 //if the temporary file has 'on' as its project name
		 if(tempFile==NOTEMPFIL){
			puts(errString[TIMERNOTSTARTED]);
			return 1;
		 }
		 else if (tempFile==ONTEMPFIL){
			getTempFile(tmrprojstr, &datenow, &timenow, &startt);
			appendTotalTimes(projstr, &datenow, &timenow, &startt);
			removeTempFile();
		 }
		 //if temp file already has a project name message:
		 else{
			getTempFile(tmrprojstr, &datenow, &timenow, &startt);
			//get user directions, and if present project name is chosen save it as activity
			if (getUserDirections(tmrprojstr)==USENEWNAME){
			  getTempFile(tmrprojstr, &datenow, &timenow, &startt);
			  appendTotalTimes(projstr, &datenow, &timenow, &startt);
			  removeTempFile();
			}
			//otherwise save the activity in the temp file as recorded activity
			else{
			  getTempFile(tmrprojstr, &datenow, &timenow, &startt);
			  appendTotalTimes(tmrprojstr, &datenow, &timenow, &startt);
			  removeTempFile();
			}
		 }
	  }//end of what to do if 'off' is present in timer temporary file
	  
	  //if timer command line is "timer /c someComment" or "timer -c someComment":
	  else if(commentPresent){
		 //timer is on with project name as 'on'
		 if (tempFile==ONTEMPFIL){
			getTempFile(tmrprojstr, &datenow, &timenow, &startt);
			appendStartTime("See below for activity commented", &datenow, &timenow);
			timeparser(&datenow, &timenow, &startt);
			appendComment(projstr,&datenow,&timenow);
			printf("Comment \"%s\" appended to record.\n",projstr);
		 }
		 //timer is on with activity name.  record activity and restart with new activity:
		 else if(tempFile==REGTEMPFIL){
			getTempFile(tmrprojstr, &datenow, &timenow, &startt);
			appendStartTime(tmrprojstr, &datenow, &timenow);
			timeparser(&datenow, &timenow, &startt);
			appendComment(projstr,&datenow,&timenow);
			printf("Comment \"%s\" appended to record.\n",projstr);
		 }
		 //timer is off: Put error message:
		 else{
			puts(errString[TIMEROFFFORCOMMENT]);
		 }
	  }
	  
	  /* if timer command line is "timer /t HH:MM:SS:HS activityname: */
	  else if(timePresent){
		 if(!timeStrToTimeStruct(timestr,&elapsedtime)){ //if there is an error in the time string
			puts(errString[INVALIDTIMESTRING]); 	 //if valid, timenow contains starting time in time structure!
			return 1;
		 }
		 else{
			appendGivenTime(projstr,&datenow,&timenow,&elapsedtime,&startt);
			return 0;
		 }
	  }
	  
	  //if timer command line is "timer project/activityname":
	  else{
		 //timer is on with project name as 'on'
		 if (tempFile==ONTEMPFIL){
			getTempFile(tmrprojstr, &datenow, &timenow, &startt);
			appendTotalTimes(projstr, &datenow, &timenow, &startt);
			removeTempFile();
			putInstruction(PROJNAMETURNOFFINFO);
		 }
		 //timer is on with activity name.  record activity and restart with new activity:
		 else if(tempFile==REGTEMPFIL){
			getTempFile(tmrprojstr, &datenow, &timenow, &startt);
			appendTotalTimes(tmrprojstr, &datenow, &timenow, &startt);
			removeTempFile();
			timeparser(&datenow, &timenow, &startt);
			putTempFile(projstr,&datenow,&timenow,&startt);
			putInstruction(PROJNAMETURNBACKONINFO);
		 }
		 //timer is off: start timer and put temp file with activity name given:
		 else{
			putTempFile(projstr,&datenow,&timenow,&startt);
			putInstruction(PROJNAMETURNONINFO);
			printf("%s\n\n",projstr);		  // added 6/21/97
		 }
	  }
	}
	
	return 0;
	
} // end of main()



/*
 * Both the following structures are defined in  dos.h
 * for DOS OS:
 *
 * struct time {
 * 	unsigned char	ti_min;
 * 	unsigned char	ti_hour;
 * 	unsigned char	ti_hund;
 * 	unsigned char	ti_sec;
 * };
 *
 * struct date {
 * 	int da_year;
 * 	char	da_day;
 * 	char	da_mon;
 * };
 *
 * This is an ANSI structure usable both in DOS and UNIX:
 * struct tm {
 * 	int  tm_sec,  tm_min,  tm_hour;
 * 	int  tm_mday, tm_mon, tm_year;
 * 	int  tm_wday, tm_yday;
 * 	int  tm_isdst;
 * };
 *
 * Defined in	time.h
 */


/*
 * This function gets the various time items needed by main() et al.
 * It takes empty structures, time_t variable so as to fill them with the time and date the system understands.
 */
void
timeparser(
			  struct date *d,	// [output] present date
			  struct time *ts,       // [output] present time
			  time_t *t		// [output] time in seconds after 1/1/1970
			  )
{
#ifdef OS_UNIX
  struct tm *ti;
#endif
  
  time(t);
  
#ifdef OS_DOS
  /* These functions are DOS specific library functions only:
	* they are defined differently in and unuseable here for UNIX
	*/
  gettime(ts);
  getdate(d);
#endif
  
#ifdef OS_UNIX
  /* This uses ANSI functions and other stuff to replicate DOS's
	* gettime(struct time *ts) and getdate(struct date *d)
	* for UNIX:
	*/
  
  /* get the local time */
  ti=localtime(t);
  
  /* transfer tm fields to date, time structures */
  d->da_year=ti->tm_year+1900;  /* localtime() returns year as yy, so add 1900 */
  d->da_mon=(char)ti->tm_mon+1; /* localtime() returns Jan as \x0 so add 1 */
  d->da_day=(char)ti->tm_mday;
  
  ts->ti_hour=(unsigned char)ti->tm_hour;
  ts->ti_min=(unsigned char)ti->tm_min;
  ts->ti_sec=(unsigned char)ti->tm_sec;
  ts->ti_hund=0;
#endif
  
  return;
}


/*
 * This function, given a date and time string, parses them and puts the results into a date and time structure and returns the same.
 * the following are the structures involved:
struct time {
	unsigned char ti_min;
	unsigned char ti_hour;
	unsigned char ti_hund;
	unsigned char ti_sec;
};

struct date {
	int  da_year;
	char da_day;
	char da_mon;
};

 */
Bool 
parseDateTimeString(
						  char *dateString, 
						  char *timestring, 
						  struct date *d, 
						  struct time *ts
						  )
{
  //If date string is empty, enter current date into the date struct
  //if time string is empty, return an error.
  return FAIL;
}

/*
 * This function given beginning time & ending time
 * determines elapsed time in hours, minutes, and seconds
 * and returns the same at its parameter pointer locations:
 */
void
getElapsedTime(
					time_t begt,	 // [input]  beginning time in seconds after 1/1/1970
					time_t endt,	 // [input]  ending time in seconds after 1/1/1970
					int *hours, 	 // [output] elapsed hours part of elapsed time
					int *mins,		 // [output] elapsed minutes part part of elapsed time
					int *secs,		 // [output] elapsed seconds part part of elapsed time
					float *hoursdec // [output] elapsed time in hours with decimal fraction
					)
{
  time_t elapst; 	//endingtime,elapsed time
  ldiv_t breakdown; //breakdown of time segments
  
  
  elapst=endt-begt;
  
  breakdown = ldiv(elapst,(long)SECSINHOUR);
  *hours = int(breakdown.quot);
  breakdown = ldiv(breakdown.rem,(long)SECSINMIN);
  *mins = int(breakdown.quot);
  *secs = int(breakdown.rem);
  
  *hoursdec=0.0;
  *hoursdec+=(float)*secs/(float)SECSINHOUR;
  *hoursdec+=(float)*mins/(float)MINSINHOUR;
  *hoursdec+=(float)*hours;
}


/*
 * given a time structure containing an elapsed time,
 * and the present time in seconds since 1/1/1970, this function
 * returns the starting time seconds since 1/1/1970.
 * This function dovetails with getElapsedTime
 */
void
getStartSeconds(
					 struct time *elapsedTime,	 // [input] time spent (enclosed in time structure)
					 time_t *presentSecs, 		 // [input] present time (ending time)
					 time_t *startSecs 			 // [output]	starting time in seconds since Jan 1, 1970
					 )
{
  time_t secsUsed=0;
  
  secsUsed+=(unsigned long)elapsedTime->ti_hour * SECSINHOUR;
  secsUsed+=(unsigned long)elapsedTime->ti_min * SECSINMIN;
  secsUsed+=(unsigned long)elapsedTime->ti_sec;
  
  *startSecs = *presentSecs - secsUsed;
}


/*
 * Given a time character string of the form HH:MM:SS:HS, and a time structure as above
 * This function parses the timestring into a structure of type time.
 * If the time string is invalid, it returns 0 and the material in the
 * time structure is undefined.
 */
int							  // [output]: 1 if successful, 0 if failure
timeStrToTimeStruct(
						  char *timeStr,			  // [input]  time string in form "HH:MM:SS:HS\0"
						  struct time *timestruct  // [output] time structure to be filled from timeStr
						  )
{
  char holdstr[6];				//string to hold numeric pieces
  //   const int timeStrLen=12;	//longest length of a string "HH:MM:SS:HN" with NULL ending
  int ct, cts;					//counters
  int hrs=0, ms=0, ss=0;		//flags
  
  //initialize:
  for (ct=0;ct<6;ct++){
	 holdstr[ct]=0;
  }
  
  timestruct->ti_hour=0;
  timestruct->ti_min=0;
  timestruct->ti_sec=0;
  timestruct->ti_hund=0;
  
  //parse the string into timeparts:
  for(ct=0,cts=0;timeStr[ct]!=0;ct++,cts++){
	 //set flags at existence of a colon:
	 if(timeStr[ct]==':'){
		holdstr[cts]=0;	  //null end holdstr and reset holdstr counter
		cts=0;
		if (!hrs){
		  timestruct->ti_hour=(char)atoi(holdstr);
		  hrs=DONE;		//first : indicates hours are done
		}
		else if(!ms){
		  timestruct->ti_min=(char)atoi(holdstr);
		  ms=DONE; //second : indicates minutes are done
		}
		else if(!ss){
		  timestruct->ti_sec=(char)atoi(holdstr);
		  ss=DONE; //third : indicates seconds are done
		}
		else{
		  timestruct->ti_hund=(char)atoi(holdstr);
		}
		ct++; //advance to the next character in timeStr
	 }
	 if(!isdigit(timeStr[ct]))return 0;
	 holdstr[cts]=timeStr[ct];
  }
  holdstr[cts]=0;
  
  if (!hrs){
	 timestruct->ti_hour=(char)atoi(holdstr);
  }
  else if(!ms){
	 timestruct->ti_min=(char)atoi(holdstr);
  }
  else if(!ss){
	 timestruct->ti_sec=(char)atoi(holdstr);
  }
  else{
	 timestruct->ti_hund=(char)atoi(holdstr);
  }
  
  return 1;
}

/*
 * The following are filing functions:
 */

/*
 * This function creates the paths needed for filing by all functions that
 * do filing:
 * NOTE:  It is only used for compiling the UNIX port of the program, not
 * the MS-DOS port.
 */

#ifdef OS_UNIX
void
createFilepaths(
					 void
					 )
{
  char *retVal;
  
  retVal=getenv(HOMEDIR);
  
  strcpy(TMPFILE,retVal);
  strcat(TMPFILE,"/");
  strcat(TMPFILE,TMPFILENAME);
#ifdef DEBUG
  printf("\nTMPFILE is: %s\n",TMPFILE);
#endif
  
  strcpy(TIMESHEET,retVal);
  strcat(TIMESHEET,"/");
  strcat(TIMESHEET,TIMESHEETNAME);
#ifdef DEBUG
  printf("\nTIMESHEET is: %s\n",TIMESHEET);
#endif
  
  strcpy(SSTIMESHEET,retVal);
  strcat(SSTIMESHEET,"/");
  strcat(SSTIMESHEET,SSTIMESHEETNAME);
#ifdef DEBUG
  printf("\nSSTIMESHEET is: %s\n",SSTIMESHEETNAME);
#endif
}

#endif /*end of #ifdef OS_UNIX */
/*
 * this function is for use when operator gives a /t HH:MM:SS comment
 * set of parameters.  It figures back from the present system time
 * the amount of time given in the time string to the beginning time
 * and appends the information to the timesheet file.
 */
int						// [output] 0 on failure, 1 on success
appendGivenTime(
					 char *comment,		// [input] activity name
					 struct date *endd,	// [input] date structure containing ending date
					 struct time *endt,	// [input] time structure containin ending time
					 struct time *elapsedTime,  // [input] time structure containing elapsed time
					 time_t *endsecs		// [input] ending seconds after 1/1/70
					 )
{
  FILE *timfil, *sstimfil; //information archive files
  int hours, mins, secs;
  float hoursdec;			 //decimal hours spent on job
  struct tm *startt;		 //structure containing start date, time
  time_t et;
  time_t startSecs; 		 //seconds after 1/1/70 at start
  
  //initialization:
  //get starting time in seconds after 1/1/70:
  getStartSeconds (elapsedTime, endsecs, &startSecs);
  
  startt = localtime(&startSecs);	//get starting time in time structure
  startt->tm_year += 1900;	/* Adjust time to give long year date. added: 2/10/96 */
  
  //note: localtime() returns January as month '0'
  //so add 1 to month readout in printf() and fprintf() below.
  
  if((timfil=fopen(TIMESHEET,"a"))==NULL){
#ifdef DEBUG
	 printf(TIMESHEET);
	 perror("In appendGivenTime - Could not open TIMESHEET");
#endif
	 return 0;
  }
  else if((sstimfil=fopen(SSTIMESHEET,"a"))==NULL){
#ifdef DEBUG
	 printf(SSTIMESHEET);
	 perror("In appendGivenTime - Could not open SSTIMESHEET");
#endif
	 fclose(timfil);
	 return 0;
  }
  else{
	 printf("Project/Activity: %s\n",comment);
	 printf("Time in:  %02d/%02d/%02d @ %02d:%02d:%02d.\n",startt->tm_mon+1,startt->tm_mday,startt->tm_year,startt->tm_hour,startt->tm_min,startt->tm_sec);
	 fprintf(timfil,"Project/Activity: %s\n",comment);
	 fprintf(timfil,"Time in:  %02d/%02d/%02d @ %02d:%02d:%02d.\n",startt->tm_mon+1,startt->tm_mday,startt->tm_year,startt->tm_hour,startt->tm_min,startt->tm_sec);
	 fprintf(sstimfil,"\"%s\",\"%02d/%02d/%02d\",\"%02d:%02d:%02d\",",comment,startt->tm_mon+1,startt->tm_mday,startt->tm_year,startt->tm_hour,startt->tm_min,startt->tm_sec);
	 
	 timeparser(endd,endt,&et);
	 //00/00/00, 00:00:00.
	 printf("Time out: %02d/%02d/%02d @ %02d:%02d:%02d.  ",endd->da_mon,endd->da_day,endd->da_year,endt->ti_hour,endt->ti_min,endt->ti_sec);
	 fprintf(timfil,"Time out: %02d/%02d/%02d @ %02d:%02d:%02d.  ",endd->da_mon,endd->da_day,endd->da_year,endt->ti_hour,endt->ti_min,endt->ti_sec);
	 fprintf(sstimfil,"\"%02d/%02d/%02d\",\"%02d:%02d:%02d\",",endd->da_mon,endd->da_day,endd->da_year,endt->ti_hour,endt->ti_min,endt->ti_sec);
	 
	 getElapsedTime(startSecs,*endsecs,&hours,&mins,&secs,&hoursdec);
	 
	 printf("Elapsed time: %02d:%02d:%02d or %.3f hours.\n\n",hours,mins,secs,hoursdec);
	 fprintf(timfil,"Elapsed time: %02d:%02d:%02d or %.3f hours.\n\n",hours,mins,secs,hoursdec);
	 fprintf(sstimfil,"\"%02d:%02d:%02d\",\"%.3f\"\n",hours,mins,secs,hoursdec);
	 fclose(timfil);
	 fclose(sstimfil);
	 return 1;
  }
}


/*
 * This function appends the time information to the
 * timesheet files and puts information on screen.
 */
int					 // [output] success: 1, failure: 0
appendTotalTimes(
					  char *comment,	 // [input] activity name
					  struct date *d,	 // [input] date started
					  struct time *ts,  // [input] time started
					  time_t *t			 // [input] seconds since 1/1/70 for start time
					  )
{
  FILE *timfil, *sstimfil;  //readable time file, time for for importation to spreadsheet-comma and quotation delimited
  int hours, mins, secs;
  float hoursdec;
  struct time endt;
  struct date endd;
  time_t et;
  
  if((timfil=fopen(TIMESHEET,"a"))==NULL){
#ifdef DEBUG
	 printf(TIMESHEET);
	 perror("In appendTotalTimes - Could not open TIMESHEET");
#endif
	 return 0;
  }
  if((sstimfil=fopen(SSTIMESHEET,"a"))==NULL){
#ifdef DEBUG
	 printf(SSTIMESHEET);
	 perror("In appendTotalTimes -Could not open SSTIMESHEET");
#endif
	 fclose(timfil);
	 return 0;
  }
  else{
	 printf("Project/Activity: %s\n",comment);
	 printf("Time in:  %02d/%02d/%02d @ %02d:%02d:%02d.\n",d->da_mon,d->da_day,d->da_year,ts->ti_hour,ts->ti_min,ts->ti_sec);
	 fprintf(timfil,"Project/Activity: %s\n",comment);
	 fprintf(sstimfil,"\"%s\",",comment);
	 fprintf(timfil,"Time in:  %02d/%02d/%02d @ %02d:%02d:%02d.\n",d->da_mon,d->da_day,d->da_year,ts->ti_hour,ts->ti_min,ts->ti_sec);
	 fprintf(sstimfil,"\"%02d/%02d/%02d\",\"%02d:%02d:%02d\",",d->da_mon,d->da_day,d->da_year,ts->ti_hour,ts->ti_min,ts->ti_sec);
	 
	 timeparser(&endd,&endt,&et);
	 //00/00/00, 00:00:00.
	 printf("Time out: %02d/%02d/%02d @ %02d:%02d:%02d.  ",endd.da_mon,endd.da_day,endd.da_year,endt.ti_hour,endt.ti_min,endt.ti_sec);
	 fprintf(timfil,"Time out: %02d/%02d/%02d @ %02d:%02d:%02d.  ",endd.da_mon,endd.da_day,endd.da_year,endt.ti_hour,endt.ti_min,endt.ti_sec);
	 fprintf(sstimfil,"\"%02d/%02d/%02d\",\"%02d:%02d:%02d\",",endd.da_mon,endd.da_day,endd.da_year,endt.ti_hour,endt.ti_min,endt.ti_sec);
	 
	 getElapsedTime(*t,et,&hours,&mins,&secs,&hoursdec);
	 
	 printf("Elapsed time: %02d:%02d:%02d or %.3f hours.\n\n",hours,mins,secs,hoursdec);
	 fprintf(timfil,"Elapsed time: %02d:%02d:%02d or %.3f hours.\n\n",hours,mins,secs,hoursdec);
	 fprintf(sstimfil,"\"%02d:%02d:%02d\",\"%.3f\"\n",hours,mins,secs,hoursdec);
	 fclose(timfil);
	 fclose(sstimfil);
	 return 1;
  }
}


/*
 * This function appends the starting time of a timed activity
 */
int					// [output] failure: 0, success: 1
appendStartTime(
					 char *comment,	// [input] activity to be recorded
					 struct date *d,	// [input] date activity started
					 struct time *ts	// [input] time activity started
					 )
{
  FILE *timfil,*sstimfil;
  
  if((timfil=fopen(TIMESHEET,"a"))==NULL){
#ifdef DEBUG
	 printf(TIMESHEET);
	 perror("In appendStartTime - Could not open TIMESHEET");
#endif
	 return 0;
  }
  if((sstimfil=fopen(SSTIMESHEET,"a"))==NULL){
#ifdef DEBUG
	 printf(SSTIMESHEET);
	 perror("In appendStartTime - Could not open SSTIMESHEET");
#endif
	 fclose(timfil);
	 return 0;
  }
  else{
	 printf("Project/Activity: %s\n",comment);
	 printf("Time in:  %02d/%02d/%02d @ %02d:%02d:%02d.\n",d->da_mon,d->da_day,d->da_year,ts->ti_hour,ts->ti_min,ts->ti_sec);
	 fprintf(timfil,"Project/Activity: %s\n",comment);
	 fprintf(sstimfil,"\"%s\",",comment);
	 fprintf(timfil,"Time in:  %02d/%02d/%02d @ %02d:%02d:%02d.\n",d->da_mon,d->da_day,d->da_year,ts->ti_hour,ts->ti_min,ts->ti_sec);
	 fprintf(sstimfil,"\"%02d/%02d/%02d\",\"%02d:%02d:%02d\"\n",d->da_mon,d->da_day,d->da_year,ts->ti_hour,ts->ti_min,ts->ti_sec);
	 fclose(timfil);
	 fclose(sstimfil);
	 return 1;
  }
}


/*
 * This function appends a comment to the timesheet file
 */
int				  // [output] failure: 0, success: 1
appendComment(
				  char *comment,  // [input] comment to be appended
				  struct date *d, // [input] starting date of activity
				  struct time *ts // [input] starting time of the activity
				  )
{
  FILE *timfil,*sstimfil;
  
  if((timfil=fopen(TIMESHEET,"a"))==NULL){
#ifdef DEBUG
	 printf(TIMESHEET);
	 perror("In appendComment - Could not open TIMESHEET");
#endif
	 return 0;
  }
  if((sstimfil=fopen(SSTIMESHEET,"a"))==NULL){
#ifdef DEBUG
	 printf(SSTIMESHEET);
	 perror("In appendComment - Could not open SSTIMESHEET");
#endif
	 fclose(timfil);
	 return 0;
  }
  else{
	 printf("   Comment at %02d/%02d/%02d, %02d:%02d:%02d: ",d->da_mon,d->da_day,d->da_year,ts->ti_hour,ts->ti_min,ts->ti_sec);
	 printf("%s\n",comment);
	 fprintf(timfil,"   Comment at %02d/%02d/%02d, %02d:%02d:%02d: ",d->da_mon,d->da_day,d->da_year,ts->ti_hour,ts->ti_min,ts->ti_sec);
	 fprintf(timfil,"%s\n",comment);
	 fprintf(sstimfil,"\"   Comment: %s\",",comment);
	 fprintf(sstimfil,"\"%02d/%02d/%02d\",\"%02d:%02d:%02d\"\n",d->da_mon,d->da_day,d->da_year,ts->ti_hour,ts->ti_min,ts->ti_sec);
	 fclose(timfil);
	 fclose(sstimfil);
	 return 1;
  }
}


/*
 * This function creates and loads the temporary file
 */
int			// [output] failure: 0, success: 1
putTempFile(
				char *comment,		// [input] activity being timed
				struct date *d,		// [input] date of activity start
				struct time *ts, 	// [input] time of activity start
				time_t *t		// [input] time in seconds after 1970
				)
{
  FILE *tmpfil;
  size_t commlen;
  
  commlen=strlen(comment);
  
  if((tmpfil=fopen(TMPFILE,"wb"))==NULL){
#ifdef DEBUG
	 printf(TMPFILE);
	 perror("In putTempFile -Could not open TMPFILE");
#endif
	 return 0;
  }
  else{
	 
	 /* write the comment length and the comment: */
	 fwrite(&commlen,sizeof(commlen),1,tmpfil);
	 fwrite(comment,commlen,1,tmpfil);
	 
	 /* write the time in secs to the file: */
	 fwrite(t,sizeof(*t),1,tmpfil);
	 
	 /* write the date struct: */
	 fwrite(d,sizeof(*d),1,tmpfil);
	 
	 /* write the time struct length and the time structure: */
	 fwrite(ts,sizeof(*ts),1,tmpfil);
	 
	 fclose(tmpfil);
	 
	 return 1;
  }	
}


/*
 * This function reads the temporary file back in
 * It should also erase the temp file.
 */
int		//[output] Check: returns 1 if successful, 0 if failure
getTempFile(
				char *comment,		//[output] activity recorded in temp file
				struct date *d,		//[output] date recorded in temp file
				struct time *ts, 	//[output] time recorded in temp file
				time_t *t				//[output] time recorded in temp file
				)
{
  FILE *tmpfil;
  size_t commlen; //length of the comment string
  
  if((tmpfil=fopen(TMPFILE,"rb"))==NULL){
#ifdef DEBUG
	 printf(TMPFILE);
	 perror("In getTempFile - Could not open TMPFILE");
#endif
	 return 0;
  }
  else{
	 
	 //read the comment length and the comment:
	 fread(&commlen,sizeof(commlen),1,tmpfil);
	 fread(comment,commlen,1,tmpfil);
	 comment[commlen]='\0';
	 
	 //read the start time:
	 fread(t,sizeof(*t),1,tmpfil);
	 
	 //read the date structure
	 fread(d,sizeof(*d),1,tmpfil);
	 
	 //read the time structure:
	 fread(ts,sizeof(*ts),1,tmpfil);
	 
	 fclose(tmpfil);
	 
	 return 1;
  }
}


/*
 * This function deletes the temporary file from disk:
 * This functionmay have to be changed for UNIX  - check system();
 */
void
removeTempFile(
					void
					)
{
  char delit[40];
#ifdef OS_DOS
  strcpy (delit,"Erase ");
#endif
#ifdef OS_UNIX
  strcpy (delit,"rm ");
#endif
  strcat (delit,TMPFILE);
  system(delit);
  return;
}


/*
 * This function prints the usage of the program to screen:
 */
void
Usage(
		void
		)
{
  // puts("\n\n\r");
  puts(USAGE);
}


/*
 * This function tests whether a temporary file is present and whether
 * the string in the temporary file is the word "-on".  It returns 1 if
 * the file is present with a project comment but 2 if "-on" is the only
 * word in the project comment string in the file.
 * If the file is not present, it returns 0.
 */
int //[output] 1 if temp file present with activity named, 2 if comment is 'on', 0 if no file present
testForTempFile(
					 void
					 )
{
  FILE *tmpfil;
  size_t commlen; //length of the comment string
  char comment[INBFRSZ];
  
  // if there is no temporary file, the timer isn't running.  Indicate this with return of 0.
  if((tmpfil=fopen(TMPFILE,"r"))==NULL){
#ifdef DEBUG
	 printf(TMPFILE);
	 perror("In testForTempFile - Could not open TMPFILE");
#endif
	 return 0;
  }
  else{
	 
	 // read the comment length and the comment:
	 fread(&commlen,sizeof(commlen),1,tmpfil);
	 fread(comment,commlen,1,tmpfil);
	 comment[commlen]='\0';
	 // if the temporary file only has the message "on," indicate this:
	 if(strcmp(lowerCaseString(comment),"on")== 0 || strcmp(lowerCaseString(comment),"/on") == 0 || strcmp(lowerCaseString(comment),"-on") == 0){
		fclose(tmpfil);
		return 2;
	 }
	 // if the temporary file is timing something named, indicate this:
	 else{
		fclose(tmpfil);
		return 1;
	 }
  }
}


//get instructions from user:
int
getUserDirections(
						char *projstr
						)
{
  puts(instrStrings[PRESPROJNAME]);
  puts(projstr);
  puts(instrStrings[GETPROJNAMECHOICE]);
  if(strchr("Yy",getchar())==0)return 0;
  else return USENEWNAME;
}


/*
 * this function puts an information/instruction message to the user:
 * directions used and the enumeration of the same are in worklog3.h
 */
void
putInstruction(
					enum DIRECTIONS instrName // [input] the enumerated name of the string to be put on screen
					)
{
  puts(instrStrings[instrName]);
}


/*
 * this function lower cases a null ended c string
 * Note that the string send to the function via its pointer
 * WILL be altered.	Temporary strings should be sent this function
 * if the original string's upper and lower casing should be left
 * intact!
 */
char *				// [output] the string that has been lowercased
lowerCaseString(
					 char *stringToLc // [input-output] string to be lower cased
					 )
{
  for (int n=0;*(stringToLc+n)!='\0';n++){
	 *(stringToLc+n)=tolower(*(stringToLc+n));
  }
  return stringToLc;
}
