/* view_dialog.c
 * $Id: view_dialog.c,v 0.17 1999/03/11 07:15:55 joseph Exp $
 */

/* kibble
 * Copyright (C) 1999, Joseph Turian
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "all.h"

static void on_button_view_okay_clicked (GtkButton *button, gpointer user_data)
{
	GtkWidget *dialog_view;
	GtkWidget *current_tree_item;
	node *tree_node;

	debug_msg ("view okay button clicked\n");

	dialog_view = user_data;
	g_assert (GTK_IS_WINDOW (dialog_view) != 0);

	current_tree_item = GTK_WIDGET (gtk_object_get_data (GTK_OBJECT 
				(dialog_view), "tree item"));
	g_assert (current_tree_item != NULL);
	if (GTK_IS_TREE_ITEM (current_tree_item) != 1) {
		show_message_box (_("Error!\n\n"
				"Tree item no longer exists?\n"
				"Aborting view operation\n"));
		gtk_object_destroy (GTK_OBJECT (dialog_view));
		return;
	}

	tree_node = gtk_object_get_data (GTK_OBJECT
			(current_tree_item), "node");

	(void) g_string_assign (tree_node->name, TEXT_DATA ("name",
							    dialog_view));

	/* Yuk. Clean up! */
	(void) g_string_assign (tree_node->description,
				gtk_editable_get_chars (
					GTK_EDITABLE (DATA ("description",
							dialog_view)), 0,
					gtk_text_get_length (GTK_TEXT
						(DATA ("description",
						       dialog_view)))));

	(void) g_string_assign (tree_node->filename, TEXT_DATA
				("filename", dialog_view));

	/* There must be a better way to modify the label: */
	gtk_label_set (GTK_LABEL (GTK_TREE_ITEM (current_tree_item)
				->item.bin.child), TEXT_DATA ("name",
					dialog_view));

	gtk_object_destroy (GTK_OBJECT (dialog_view));
}

void create_dialog_view ()
{
	GtkWidget *current_tree_item;
	GtkWidget *dialog_view;
	GtkWidget *vbox;
	GtkWidget *vbox2;
	GtkWidget *hbox;
	GtkWidget *label;
	GtkWidget *entry_name;
	GtkWidget *text_description;
	GtkWidget *frame;
	GtkWidget *button_view;
	GtkWidget *button_browse;
	GtkWidget *action_area;
	GtkWidget *button_okay;
	GtkWidget *button_cancel;

	node *tree_node;
	
	current_tree_item = GTK_WIDGET (KB_ITEM_SELECTED);
	g_assert (current_tree_item != NULL);
	if (GTK_IS_TREE_ITEM (current_tree_item) != 1) {
		show_message_box (_("Error!\n\n"
				"Tree item no longer exists?\n"
				"Aborting view operation\n"));
		return;
	}

	tree_node = gtk_object_get_data (GTK_OBJECT
			(current_tree_item), "node");

	debug_msg ("creating viewdialog\n");
	dialog_view = gtk_dialog_new ();
	gtk_object_set_data (GTK_OBJECT (dialog_view), "tree item",
			current_tree_item);
	debug_msg ("dialog_view = 0x%x\n" __ (gint)dialog_view);
	gtk_window_set_title (GTK_WINDOW (dialog_view), _("View"));
	gtk_window_set_policy (GTK_WINDOW (dialog_view), TRUE, TRUE, FALSE);

	vbox = GTK_DIALOG (dialog_view)->vbox;

	vbox2 = gtk_vbox_new (FALSE, 0);
	gtk_box_pack_start (GTK_BOX (vbox), vbox2, TRUE, TRUE, 0);
	gtk_container_border_width (GTK_CONTAINER (vbox2), 10);

	hbox = gtk_hbox_new (FALSE, 0);
	gtk_box_pack_start (GTK_BOX (vbox2), hbox, TRUE, TRUE, 0);

	label = gtk_label_new (_("Name:"));
	gtk_box_pack_start (GTK_BOX (hbox), label, TRUE, TRUE, 3);
	gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_LEFT);

	entry_name = gtk_entry_new_with_max_length (MAX_STR_LEN);
	gtk_entry_set_text (GTK_ENTRY (entry_name), tree_node->name->str);
	gtk_object_set_data (GTK_OBJECT (dialog_view), "name", entry_name);
	gtk_box_pack_start (GTK_BOX (hbox), entry_name, TRUE, TRUE, 5);
	GTK_WIDGET_SET_FLAGS (entry_name, GTK_CAN_DEFAULT);
	gtk_widget_grab_default (entry_name);

	label = gtk_label_new (_("Description:"));
	gtk_box_pack_start (GTK_BOX (vbox2), label, TRUE, TRUE, 3);
	gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_LEFT);

	text_description = gtk_text_new (NULL, NULL);
	gtk_box_pack_start (GTK_BOX (vbox2), text_description, TRUE, TRUE, 5);
#ifndef GTK_HAVE_FEATURES_1_1_0
	/* This is such a weird hack. I have no idea why it works. */
	gtk_widget_realize (GTK_WIDGET (text_description));
#endif
	gtk_text_insert (GTK_TEXT (text_description), NULL, NULL, NULL,
			tree_node->description->str,
			-1);
	gtk_object_set_data (GTK_OBJECT (dialog_view), "description", text_description);
	GTK_WIDGET_SET_FLAGS (text_description, GTK_CAN_DEFAULT);
	gtk_text_set_editable (GTK_TEXT(text_description), 1);
	/* What is the difference? */
	gtk_text_set_line_wrap (GTK_TEXT(text_description), 1);
	gtk_text_set_word_wrap (GTK_TEXT(text_description), 1);

	frame = gtk_frame_new (NULL);
	gtk_box_pack_start (GTK_BOX (vbox2), frame, TRUE, TRUE, 3);

	vbox = gtk_vbox_new (FALSE, 0);
	gtk_container_add (GTK_CONTAINER (frame), vbox);

	hbox = gtk_hbox_new (FALSE, 5);
	gtk_box_pack_start (GTK_BOX (vbox), hbox, TRUE, TRUE, 0);
	gtk_container_border_width (GTK_CONTAINER (hbox), 5);

	label = gtk_label_new (_("Filename:"));
	gtk_box_pack_start (GTK_BOX (hbox), label, TRUE, TRUE, 0);

        entry_filename = gtk_entry_new_with_max_length (MAX_STR_LEN);
	gtk_entry_set_text (GTK_ENTRY (entry_filename), tree_node->filename->str);
	gtk_object_set_data (GTK_OBJECT (dialog_view), "filename", entry_filename);
	gtk_box_pack_start (GTK_BOX (hbox), entry_filename, TRUE, TRUE, 0);

	hbox = gtk_hbox_new (FALSE, 5);
	gtk_box_pack_start (GTK_BOX (vbox), hbox, TRUE, TRUE, 0);

	button_view = gtk_button_new_with_label (_("View"));
	gtk_box_pack_start (GTK_BOX (hbox), button_view, TRUE, FALSE, 0);
	GTK_WIDGET_SET_FLAGS (button_view, GTK_CAN_DEFAULT);
	(void) gtk_signal_connect (GTK_OBJECT (button_view), "clicked",
				   GTK_SIGNAL_FUNC
				   (not_implemented), NULL);

	button_browse = gtk_button_new_with_label (_("Browse"));
	gtk_box_pack_start (GTK_BOX (hbox), button_browse, TRUE, FALSE, 0);
	GTK_WIDGET_SET_FLAGS (button_browse, GTK_CAN_DEFAULT);
	(void) gtk_signal_connect (GTK_OBJECT (button_browse), "clicked",
				   GTK_SIGNAL_FUNC
				   (on_button_browse_clicked), NULL);

	action_area = GTK_DIALOG (dialog_view)->action_area;
	gtk_container_border_width (GTK_CONTAINER (action_area), 10);

	hbox = gtk_hbox_new (FALSE, 0);
	gtk_box_pack_start (GTK_BOX (action_area), hbox, TRUE, TRUE, 0);

	button_okay = gtk_button_new_with_label (_("Okay"));
	gtk_box_pack_start (GTK_BOX (hbox), button_okay, TRUE, FALSE, 5);
	GTK_WIDGET_SET_FLAGS (button_okay, GTK_CAN_DEFAULT);
	gtk_widget_grab_focus (button_okay);
	gtk_widget_grab_default (button_okay);
	(void) gtk_signal_connect (GTK_OBJECT (button_okay), "clicked",
				   GTK_SIGNAL_FUNC
				   (on_button_view_okay_clicked),
				   GTK_OBJECT (dialog_view));

	button_cancel = gtk_button_new_with_label (_("Cancel"));
	gtk_box_pack_start (GTK_BOX (hbox), button_cancel, TRUE, FALSE, 5);
	gtk_container_border_width (GTK_CONTAINER (button_cancel), 1);
	GTK_WIDGET_SET_FLAGS (button_cancel, GTK_CAN_DEFAULT);
	(void) gtk_signal_connect_object (GTK_OBJECT (button_cancel),
					  "clicked", GTK_SIGNAL_FUNC
					  (gtk_object_destroy), GTK_OBJECT
					  (dialog_view));
	gtk_widget_show_all (dialog_view);
}
