/* main_window.c
 * $Id: main_window.c,v 0.16 1999/03/11 20:04:40 joseph Exp $
 */

/* kibble
 * Copyright (C) 1999, Joseph Turian
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "all.h"

GtkWidget* create_window_main ()
{
	GtkWidget *window_main;
	GtkWidget *vbox;
	GtkWidget *scrolledwindow;

	window_main = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	debug_msg ("window_main = 0x%x created\n" __ (gint)window_main);
	gtk_window_set_title (GTK_WINDOW (window_main), "Kibble");
	gtk_window_position (GTK_WINDOW (window_main), GTK_WIN_POS_CENTER);
	gtk_window_set_policy (GTK_WINDOW (window_main), TRUE, TRUE, TRUE);
	gtk_widget_set_usize (GTK_WIDGET (window_main), 300, 300);
        (void) gtk_signal_connect (GTK_OBJECT (window_main), "destroy",
				   GTK_SIGNAL_FUNC (destroy_program), NULL);

	vbox = gtk_vbox_new (FALSE, 0);
	gtk_container_add (GTK_CONTAINER (window_main), vbox);

	create_menu_main (window_main, vbox);

	scrolledwindow = gtk_scrolled_window_new (NULL, NULL);
	/* Grrr... this should work with GTK 1.[02].x, I don't know why it
	 * keeps snapping back to the original size. */
	/* debug_msg ("scrolled_policy = automatic\n");
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow),
			GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC); */
	debug_msg ("SCROLLED_POLICY =/= AUTOMATIC\n");
	gtk_box_pack_start (GTK_BOX (vbox), scrolledwindow, TRUE, TRUE, 10);

	tree_kb = gtk_tree_new ();
	if (tree_kb == NULL) {
		g_assert (0);
		return NULL;
	}
	/* Check for CVS/very new GTK+ code */
#ifdef HAVE_GTK_SCROLLED_WINDOW_ADD_WITH_VIEWPORT
	debug_msg ("have gtk_scrolled_window_add_with_viewport\n");
	gtk_scrolled_window_add_with_viewport (GTK_SCROLLED_WINDOW
			(scrolledwindow), tree_kb);
#else
	debug_msg ("don't have gtk_scrolled_window_add_with_viewport\n"
			"(using gtk_container_add)\n");
	gtk_container_add (GTK_CONTAINER (scrolledwindow), tree_kb);
#endif
	gtk_container_border_width (GTK_CONTAINER (tree_kb), 10);
	GTK_WIDGET_SET_FLAGS (tree_kb, GTK_CAN_FOCUS);
	GTK_WIDGET_SET_FLAGS (tree_kb, GTK_CAN_DEFAULT);
	gtk_tree_set_selection_mode (GTK_TREE (tree_kb), GTK_SELECTION_SINGLE);

	return window_main;
}
