/* main_menu.c
 * $Id: main_menu.c,v 0.21 1999/03/11 07:17:58 joseph Exp $
 */

/* kibble
 * Copyright (C) 1999, Joseph Turian
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "all.h"

static GtkItemFactoryEntry *translate_entries (const GtkItemFactoryEntry
		*, gint);
static void free_translated_entries(GtkItemFactoryEntry *, gint);

void on_save_activate (GtkMenuItem *menuitem, gpointer user_data)
{
        debug_msg("saving kb\n");
	write_kbfile();
	show_message_box (_("Save completed\nsuccessfully.\n"));
}

void on_add_activate (GtkMenuItem *menuitem, gpointer user_data)
{
	/* Grab tree data, display error message if none selected */
        debug_msg("add activated\n");
	/* If no tree item is currently selected */
	if((tree_kb == NULL || GTK_TREE(tree_kb)->selection == NULL) ||
			KB_ITEM_SELECTED == NULL){
		debug_msg("no tree item selected\n");
		show_message_box(_("No tree item is\ncurrently selected\n"));
	} else {
		debug_msg("parent tree item = 0x%x\n" _
				(gint)KB_ITEM_SELECTED);
		create_dialog_add ();
	}
}

void on_view_activate (GtkMenuItem *menuitem, gpointer user_data)
{
	/* Grab tree data, display error message if none selected */
        debug_msg("view activated\n");
	/* If no tree item is currently selected */
	if((tree_kb == NULL || GTK_TREE(tree_kb)->selection == NULL) ||
			KB_ITEM_SELECTED == NULL){
		debug_msg("no tree item selected\n");
		show_message_box(_("No tree item is\ncurrently selected\n"));
	} else {
		debug_msg("tree item = 0x%x\n" _
				(gint)KB_ITEM_SELECTED);
		create_dialog_view ();
	}
}

void on_delete_activate (GtkMenuItem *menuitem, gpointer user_data)
{
	/* Grab tree data, display error message if none selected */
        debug_msg("delete activated\n");
	/* If no tree item is currently selected */
	if((tree_kb == NULL || GTK_TREE(tree_kb)->selection == NULL) ||
			KB_ITEM_SELECTED == NULL){
		debug_msg("no tree item selected\n");
		show_message_box(_("No tree item is\ncurrently selected\n"));
	} else {
		debug_msg("tree item = 0x%x\n" _
				(gint)KB_ITEM_SELECTED);
		create_dialog_delete ();
	}
}

void on_contents_activate (GtkMenuItem *menuitem, gpointer user_data)
{
        debug_msg("contents activated\n");
        not_implemented();
}

void on_index_activate (GtkMenuItem *menuitem, gpointer user_data)
{
        debug_msg("index activated\n");
        not_implemented();
}

void on_about_activate (GtkMenuItem *menuitem, gpointer user_data)
{
	/* Code idea borrowed from Glade */
	/* I hope the translations don't overflow the buffer! */
	gchar buf[1024];

        debug_msg("about activated\n");
	g_snprintf (buf, MAX_STR_LEN,
			(_("Kibble\n\n"
			"A Knowledge Base program.\n\n"
			"Version %s\n\n"
			"By Joseph Turian\n\n"
			"Email: kibble@wish.student.harvard.edu\n"
			"Web: http://wish.student.harvard.edu/kibble/\n")),
			VERSION);
	show_message_box (buf);
}

/* How the hell do I do F1 in this? */
#define GMC	(GtkItemFactoryCallback)
#define ON	0, NULL
static GtkItemFactoryEntry menu_items[] =
{
	{N_("/_File"),		NULL,		NULL,	0, "<Branch>"},
	{N_("/File/_Save"),	"<control>S",	GMC on_save_activate,	ON},
	{N_("/File/sep1"),	NULL,		NULL,	0, "<Separator>"},
	{N_("/File/E_xit"),	"<control>Q",	GMC destroy_program,	ON},
	{N_("/_Edit"),		NULL,		NULL,	0, "<Branch>"},
	{N_("/Edit/_Add"),	"<control>A",	GMC on_add_activate,	ON},
	{N_("/Edit/_View"),	"<control>V",	GMC on_view_activate,	ON},
	{N_("/Edit/_Delete"),	"<control>D",	GMC on_delete_activate,	ON},
	{N_("/_Help"),		NULL,		NULL,	0, "<LastBranch>"},
	{N_("/Help/_Contents"),	NULL,		GMC on_contents_activate, ON},
	{N_("/Help/_Index"),	NULL,		GMC on_index_activate,	ON},
	{N_("/Help/sep2"),	NULL,		NULL,	0, "<Separator>"},
	{N_("/Help/_About..."),	NULL,		GMC on_about_activate,	ON},
};

void create_menu_main (GtkWidget *window_main, GtkWidget *vbox)
{
	guint		nmenu_items = (guint) (sizeof (menu_items) /
			sizeof (menu_items[0]));
	GtkAccelGroup	*accel_group;
	GtkItemFactory	*factory;
	GtkItemFactoryEntry *translated_entries;

	debug_msg("creating main menu with item_factory\n");

	accel_group = gtk_accel_group_new ();
	factory = gtk_item_factory_new (GTK_TYPE_MENU_BAR, "<Main>",
			accel_group);
	translated_entries = translate_entries (menu_items, nmenu_items);
	gtk_item_factory_create_items (factory, nmenu_items,
			translated_entries, NULL);
	free_translated_entries (translated_entries, nmenu_items);
	gtk_accel_group_attach (accel_group, GTK_OBJECT (window_main));

	gtk_box_pack_start (GTK_BOX (vbox),  gtk_item_factory_get_widget
			(factory, "<Main>"), FALSE, FALSE, 0);

	gtk_widget_show (gtk_item_factory_get_widget (factory, "<Main>"));
}

/* Stolen from Gimp's menus.c ;) */
static GtkItemFactoryEntry *translate_entries (const GtkItemFactoryEntry
		*entries, gint n) {
	gint i;
	GtkItemFactoryEntry *ret;

	ret=g_malloc (sizeof(GtkItemFactoryEntry) * n);
	for (i=0; i<n; i++) {
		/* Translation. Note the explicit use of gettext(). */
		ret[i].path=g_strdup (gettext(entries[i].path));
		/* accelerator and item_type are not duped, only referenced */
		ret[i].accelerator=entries[i].accelerator;
		ret[i].callback=entries[i].callback;
		ret[i].callback_action=entries[i].callback_action;
		ret[i].item_type=entries[i].item_type;
	}
	return ret;
}

/* As before */
static void free_translated_entries(GtkItemFactoryEntry *entries, gint
		n) {
	gint i;

	for (i=0; i<n; i++)
		g_free(entries[i].path);
	g_free(entries);
}
