/* main.c
 * $Id: main.c,v 0.21 1999/03/11 07:15:55 joseph Exp $
 */

/* kibble
 * Copyright (C) 1999, Joseph Turian
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "all.h"

void not_implemented (void)
{
        /* Code idea borrowed from Glade */
        /* I hope the translations don't overflow the buffer! */
        gchar buf[1024];
	debug_msg ("not implemented\n");
        g_snprintf (buf, MAX_STR_LEN, (_("Feature not yet implemented\n"
			"Check http://wish.student.harvard.edu/kibble/\n"
			"for a potentially newer version\n"
			"or read the FAQ for help:\n"
			"http://wish.student.harvard.edu/kibble/faq/")));
        show_message_box (buf);
}

/*
 * Shows a simple message box with a label and an 'OK' button.
 * e.g. show_message_box ("Error saving file");
 * Code taken from Glade's util.c
 */
void show_message_box (gchar *message)
{
	GtkWidget *dialog, *label, *button_okay;

	dialog = gtk_dialog_new ();
	debug_msg ("message box = 0x%x\n" __ (gint)dialog);
	gtk_window_position (GTK_WINDOW (dialog), GTK_WIN_POS_CENTER);
	gtk_container_border_width (GTK_CONTAINER (dialog), 5);

	label = gtk_label_new (message);
	/* gtk_misc_set_padding (GTK_MISC (label), 20, 20); */
	gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->vbox), label,
			TRUE, TRUE, 0);

	button_okay = gtk_button_new_with_label (_("Okay"));
	gtk_widget_set_usize (button_okay, 80, -1);
	gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->action_area), button_okay,
			FALSE, FALSE, 14);
	GTK_WIDGET_SET_FLAGS (button_okay, GTK_CAN_DEFAULT);
	/* Added this focus line */
        gtk_widget_grab_focus (button_okay);
	gtk_widget_grab_default (button_okay);

	(void) gtk_signal_connect_object (GTK_OBJECT (button_okay),
					  "clicked", GTK_SIGNAL_FUNC
					  (gtk_object_destroy), GTK_OBJECT
					  (dialog));

	gtk_widget_show_all (dialog);
}

void destroy_program (GtkMenuItem *menuitem, gpointer user_data)
{
	debug_msg ("destroy_program called\n");
	/* Write unsaved data */
	write_kbfile();

	/* Walk through the tree and g_free() the alloc'ed data */

	gtk_main_quit ();
}

int main (int argc, char *argv[])
{
	GtkWidget	*window_main;

#ifdef DEBUG
	debug_msg ("Locale = %s\n" __ gtk_set_locale ());
#else
	gtk_set_locale ();
#endif

	setlocale(LC_ALL, "");
	bindtextdomain(PACKAGE, LOCALEDIR);
	textdomain(PACKAGE);

	gtk_init (&argc, &argv);

	window_main		= create_window_main ();
	debug_msg ("window_main = 0x%x\n" __ (gint)window_main);

	read_kbfile ();
	gtk_widget_show_all (window_main);

	gtk_main ();
	return 0;
}
